'
'	shell.vbśAUNIXVF͕킵[eBeB֐񋟂܂B
'

Public Const SHELL_MODULE_NAME = "Shell"
Public Const SHELL_ERR_NUM_INVALID_ARGUMENT = 1000
Public Const SHELL_ERR_MSG_INVALID_ARGUMENT = "invalid argument. "
Private Const SHELL_OPTIONS_PROCESS_WAIT_CHECK_INTERVAL = "process_wait_check_interval"
Private Const SHELL_OPTIONS_PROCESS_STDFILE_PEEK_INTERVAL = "process_stdfile_peek_interval"

Private shell_
Private fso_
Private directory_stack_
Private shell_options_


Private Function shell_get_option( key )
	If IsEmpty(shell_options_) Then
		set shell_options_ = shell_create_dictionary()
		shell_options_(SHELL_OPTIONS_PROCESS_WAIT_CHECK_INTERVAL) = 20
		shell_options_(SHELL_OPTIONS_PROCESS_STDFILE_PEEK_INTERVAL) = 1
	End If

	shell_get_option = shell_options_(key)
End Function




'
'	vtBbNX菜Cu֐ƃTuvV[W񋟂܂B
'	&nbsp;
'	̃vV[W𗘗pƁAUnixVFɋ߂oŃXNvgLq邱Ƃ\ɂȂ܂B
'	Ⴆ΁Ashell_cd́AvtBbNX菜AcdƂ̂̃vV[Wpł܂B
'	̊֐ƃTuvV[W͂̂܂ܗpł܂B
'	&nbsp;
'	example)
'	cd "c:\"
'	mkdir "test"
'	for each f in ls("./")
'		echo f.name
'	next
'	&nbsp;
'
Public Sub shell_unprefix()
	ExecuteGlobal "Function env(): set env = shell_env() : End Function"
	ExecuteGlobal "Function setenv( name, value ): setenv = shell_setenv( name, value ) : End Function"
	ExecuteGlobal "Function argv(): argv = shell_argv() : End Function"
	ExecuteGlobal "Sub quit( exit_code ): Call shell_quit( exit_code ) : End Sub"
	ExecuteGlobal "Sub sleep( milliseconds ): Call shell_sleep( milliseconds ) : End Sub"
	ExecuteGlobal "Sub echo( message ): Call shell_echo( message ) : End Sub"
	ExecuteGlobal "Sub print( stream, message ): Call shell_print( stream, message ) : End Sub"
	ExecuteGlobal "Sub println( stream, message ): Call shell_println( stream, message ) : End Sub"
	ExecuteGlobal "Sub perror( message ): Call shell_perror( message ) : End Sub"
	ExecuteGlobal "Function readline(): readline = shell_readline() : End Function"
	ExecuteGlobal "Function cd( destination ): cd = shell_cd( destination ) : End Function"
	ExecuteGlobal "Function pwd(): pwd = shell_pwd() : End Function"
	ExecuteGlobal "Function system( command ): system = shell_system( command ) : End Function"
	ExecuteGlobal "Function exec( command ): Set exec = shell_exec( command ) : End Function"
	ExecuteGlobal "Function redirect( command, outstream, errstream ): redirect = shell_redirect( command, outstream, errstream ) : End Function"
	ExecuteGlobal "Sub kill( process ): Call shell_kill( process ) : End Sub"
	ExecuteGlobal "Function wait_for( process ): wait_for = shell_wait_for( process ) : End Function"
	ExecuteGlobal "Function wait( processes ): Set wait = shell_wait( processes ) : End Function"
	ExecuteGlobal "Sub xargs( ary, stmt, opt ): Call shell_xargs( ary, stmt, opt ) : End Sub"
	ExecuteGlobal "Function ls( path ): ls = shell_ls( path ) : End Function"
	ExecuteGlobal "Function lsr( path ): lsr = shell_lsr( path ) : End Function"
	ExecuteGlobal "Function test( op, file ): test = shell_test( op, file ) : End Function"
	ExecuteGlobal "Function touch( timestamp, file ): set touch = shell_touch( timestamp, file ) : End Function"
	ExecuteGlobal "Function cat( files, destination ): cat = shell_cat( files, destination ) : End Function"
	ExecuteGlobal "Sub tcat( files, destination ): Call shell_tcat( files, destination ) : End Sub"
	ExecuteGlobal "Sub bcat( files, destination ): Call shell_bcat( files, destination ) : End Sub"
	ExecuteGlobal "Sub cp( source, destination ): Call shell_cp( source, destination ) : End Sub"
	ExecuteGlobal "Sub mv( source, destination ): Call shell_mv( source, destination ) : End Sub"
	ExecuteGlobal "Function mkdir( folder ): mkdir = shell_mkdir( folder ) : End Function"
	ExecuteGlobal "Function mkdirs( folder ): mkdirs = shell_mkdirs( folder ) : End Function"
	ExecuteGlobal "Sub rmdir( folder, force ): Call shell_rmdir( folder, force ) : End Sub"
	ExecuteGlobal "Sub rm( source, force ): Call shell_rm( source, force ) : End Sub"
	ExecuteGlobal "Function pushd( destination ): pushd = shell_pushd( destination ) : End Function"
	ExecuteGlobal "Function popd(): popd = shell_popd() : End Function"
	ExecuteGlobal "Function stdout(): set stdout = shell_stdout() : End Function"
	ExecuteGlobal "Function stderr(): set stderr = shell_stderr() : End Function"
	ExecuteGlobal "Function stdin(): set stdin = shell_stdin() : End Function"
End Sub

'
'	ϐ̃RNVԂ܂B
'	&nbsp;
'	@return WScript.EnvironmentIuWFNg
'
Public Function shell_env()
	set shell = shell_get_shell()
	set shell_env = shell.Environment
End Function



'
'	ϐݒ肵܂B
'	&nbsp;
'	@param name ϐ̖O
'	@param value ϐ̒l
'	@return ϐ̒l
'
Public Function shell_setenv( name, value )
	shell_setenv = shell_env()(name)
	shell_env()(name) = value
End Function



'
'	XNvgɑ΂zŎ擾܂B
'	&nbsp;
'	@return ̔z
'
Public Function shell_argv()
	Dim arg
	shell_argv = Array()
	For Each arg In WScript.Arguments
		push shell_argv, arg
	Next
End Function



'
'	XNvgI܂B
'	&nbsp;
'	@param exit_code IR[h
'
Public Sub shell_quit( exit_code )
	WScript.Quit exit_code
End Sub



'
'	w肳ꂽ~bX[v܂B
'	&nbsp;
'	@param milliseconds ~b
'
Public Sub shell_sleep( milliseconds )
	WScript.Sleep seconds
End Sub



'
'	Wo͂ɕo͂܂B
'	&nbsp;
'	@param message o͂镶
'
Public Sub shell_echo( message )
	shell_stdout().WriteLine message
End Sub



'
'	w肳ꂽTextStreamɕo͂܂B
'	&nbsp;
'	@param stream o͐TextStream
'	@param message o͂郁bZ[W
'
Public Sub shell_print( stream, message )
	Const PROC_NAME = "shell_print"

	If Not typename_of(stream, "TextStream") Then
		raise_error SHELL_ERR_NUM_INVALID_ARGUMENT, PROC_NAME, "stream is not TextStream object. Type=" & TypeName(stream)
	End If

	stream.Write message
End Sub



'
'	w肳ꂽTextStreamɕo͂܂B
'	&nbsp;
'	@param stream o͐TextStream
'	@param message o͂郁bZ[W
'
Public Sub shell_println( stream, message )
	Const PROC_NAME = "shell_println"
	Dim msg

	If Not typename_of(stream, "TextStream") Then
		raise_error SHELL_ERR_NUM_INVALID_ARGUMENT, PROC_NAME, "stream is not TextStream object. Type=" & TypeName(stream)
	End If

	stream.WriteLine message
End Sub



'
'	WG[ɕo͂܂B
'	&nbsp;
'	@param message o͂镶
'
Public Sub shell_perror( message )
	shell_stderr().WriteLine message
End Sub

'
'	W͂1sǂݎ܂B
'
'	&nbsp;
'
'	@return ǂݎꂽs̕BXg[̏I[̏ꍇAEmptyB
'
Public Function shell_readline()
	set stdin = shell_stdin()
	If stdin.AtEndOfStream Then
		Exit Function
	End If

	shell_readline = stdin.ReadLine()
End Function



'
'	݂̃[LOfBNgύX܂B
'
'	&nbsp;
'
'	@param destination ύX̃fBNg\A܂́AFolderIuWFNg
'	@return ύXÕ[LOfBNg̃pX\
'
Public Function shell_cd( destination )
	Const PROC_NAME = "shell_cd"

	If VarType(destination) <> 8 Then
		raise_error SHELL_ERR_NUM_INVALID_ARGUMENT, PROC_NAME, "destination is not String. Type=" & TypeName(destination)
	End If
	If Len(destination) = 0 Then
		raise_error SHELL_ERR_NUM_INVALID_ARGUMENT, PROC_NAME, "destination is empty."
	End If

	Dim shell
	set shell = shell_get_shell()
	shell_cd = shell.CurrentDirectory
	shell.CurrentDirectory = to_path(destination)
End Function



'
'	݂̃[LOfBNgԂ܂B
'
'	&nbsp;
'
'	@return ݂̃fBNgpX\
'
Public Function shell_pwd()
	Dim shell
	set shell = shell_get_shell()
	shell_pwd = shell.CurrentDirectory
End Function



'
'	w肳ꂽR}hs܂B
'
'	&nbsp;
'
'	@return R}h̏IR[h
'
Public Function shell_system( command )
	Const PROC_NAME = "shell_system"
	Dim cmd
	cmd = trim(command)

	If VarType(cmd) <> 8 Then
		raise_error SHELL_ERR_NUM_INVALID_ARGUMENT, PROC_NAME, "command is not String. Type=" & TypeName(command)
	End If
	If len(cmd) = 0 Then
		raise_error SHELL_ERR_NUM_INVALID_ARGUMENT, PROC_NAME, "command is empty."
	End If

	Dim shell
	set shell = shell_get_shell()
	shell_system = shell.run(command, , True)
End Function



'
'	w肳ꂽR}hs܂B̊֐́Ashell_system̔񓯊so[WłB
'
'	&nbsp;
'
'	@return ꂽvZX\WshExecIuWFNg
'
Public Function shell_exec( command )
	Const PROC_NAME = "shell_exec"
	Dim cmd
	cmd = trim(command)

	If VarType(cmd) <> 8 Then
		raise_error SHELL_ERR_NUM_INVALID_ARGUMENT, PROC_NAME, "command is not String. Type=" & TypeName(command)
	End If
	If len(cmd) = 0 Then
		raise_error SHELL_ERR_NUM_INVALID_ARGUMENT, PROC_NAME, "command is empty."
	End If

	Dim shell
	set shell = shell_get_shell()
	set shell_exec = shell.exec(cmd)
End Function



'
'	svZXA܂́Aw肳ꂽR}h̕Wo͂ƃG[o͐Ƀ_CNg܂B
'	&nbsp;
'	o͐ɂ́ATextStream܂́ANothingw\łB
'	Nothingw肳ꂽꍇAe͔j܂B
'	&nbsp;
'	@param command sR}h̕A܂́AWshExecIuWFNg
'	@param outstream Wo͂_CNgTextStreamIuWFNg
'	@param errstream WG[_CNgTextStreamIuWFNg
'	@return R}h̏IR[h
'
Public Function shell_redirect( command, outstream, errstream )
	Const PROC_NAME = "shell_redirect"

	Dim process
	Select Case TypeName(command)
	Case "String"
		Dim cmd
		cmd = trim(command)

		If VarType(cmd) <> 8 Then
			raise_error SHELL_ERR_NUM_INVALID_ARGUMENT, PROC_NAME, "command is not String. Type=" & TypeName(command)
		End If

		If len(cmd) = 0 Then
			raise_error SHELL_ERR_NUM_INVALID_ARGUMENT, PROC_NAME, "command is empty."
		End If

		set process = shell_exec(cmd)

	Case "WshExec"
		set process = command

	Case Else
		raise_error SHELL_ERR_NUM_INVALID_ARGUMENT, PROC_NAME, "process is not WshExec object. Type=" & TypeName(process)
	End Select

	If Not typename_of(outstream, "TextStream") Then
		If Not (outstream is nothing) Then
			raise_error SHELL_ERR_NUM_INVALID_ARGUMENT, PROC_NAME, "outstream is not TextStream object. Type=" & TypeName(outstream)
		End if
	End If

	If Not typename_of(errstream, "TextStream") Then
		If Not (errstream is nothing) Then
			raise_error SHELL_ERR_NUM_INVALID_ARGUMENT, PROC_NAME, "errstream is not TextStream object. Type=" & TypeName(errstream)
		End if
	End If

	Dim peek_interval
	peek_interval = shell_get_option(SHELL_OPTIONS_PROCESS_STDFILE_PEEK_INTERVAL)

	Dim line	
	Do While True
		shell_sleep peek_interval

		If process.StdOut.AtEndOfStream = False Then
			buf = process.StdOut.Read(1024)
			If outstream is nothing Then
			Else
				outstream.Write buf
			End If
		End If
		
		If process.StdErr.AtEndOfStream = False Then
			buf = process.StdErr.Read(1024)
			If errstream is nothing Then
			Else
				errstream.Write buf
			End If
		End If

		If process.Status <> 0 Then
			shell_redirect = process.ExitCode
			Exit Do
		End If
	Loop
End Function



'
'	w肳ꂽvZXI܂B
'
'	&nbsp;
'	@param process IWshExecIuWFNg
'
Public Sub shell_kill( process )
	Const PROC_NAME = "shell_kill"

	If Not typename_of(process, "WshExec") Then
		raise_error SHELL_ERR_NUM_INVALID_ARGUMENT, PROC_NAME, "process is not WshExec object. Type=" & TypeName(process)
	End If

	If process.Status = 0 Then
		process.Terminate
	End If
End Sub



'
'	w肳ꂽvZX̏Iҋ@܂B
'
'	&nbsp;
'	@param processes WshExecIuWFNg܂́A̔zyуRNV
'	@return vZX̏IR[hi[ꂽDicrtionaryIuWFNg(L[:vZXID)
'
Public Function shell_wait( ByVal processes )
	Const PROC_NAME = "shell_wait"

	If typename_of(processes, "WshExec") Then
		processes = Array( processes )
	End If

	set runnings = shell_create_dictionary()
	For Each process In processes
		If Not typename_of(process, "WshExec") Then
			raise_error SHELL_ERR_NUM_INVALID_ARGUMENT, PROC_NAME, "process is not WshExec object. Type=" & TypeName(process)
		End If

		set runnings(process.ProcessId) = process
	Next

	Dim check_interval
	check_interval = shell_get_option(SHELL_OPTIONS_PROCESS_WAIT_CHECK_INTERVAL)
	
	set dic = shell_create_dictionary()
	Do While runnings.Count > 0
		For Each process In runnings.Items()
			If process.Status <> 0 Then
				dic(process.ProcessId) = process.ExitCode
				runnings.Remove process.ProcessId
			End If
		Next
		shell_sleep check_interval
	Loop
	
	set shell_wait = dic
End Function



'
'	w肳ꂽz܂̓RNV̊evfɎw肳ꂽstmt(VBScriptXe[gg)s܂B
'	RNV̊evf́AvalueŎQƂ邱Ƃł܂B
'	vf̒gTextStreamIuWFNgł΁Axargs͍XTextStreamsstmtKp܂B
'	̎eśAlineϐƂĎQƂ邱Ƃł܂B
'	<strong></strong>: ǂݏITextStreamClose܂B
'	&nbsp;
'	opt͔Cӂ̃p[^nƂł܂B̕ϐ̓Xe[gg̒ŗp邱Ƃł܂B
'	&nbsp;
'	examples)
'	shell_xargs shell_ls("./"), "shell_echo opt.Replace(value.name,""***"")", re
'
'	&nbsp;
'	@param ary Xe[ggKpCollection܂́Az
'	@param stmt KpVBScriptXe[gg
'
Public Sub shell_xargs( ary, stmt, opt )
	Const PROC_NAME = "shell_xargs"

	If Not (IsArray(ary) or typename_of(ary, "Collection") ) Then
		raise_error SHELL_ERR_NUM_INVALID_ARGUMENT, PROC_NAME, "ary is not Array|Collection object. Type=" & TypeName(ary)
	End If

	Dim value, line
	for each value in ary
		If typename_of(value, "TextStream") Then
			Do While Not value.AtEndOfStream
				line = value.ReadLine()
				Execute stmt
			Loop
			value.Close
		Else
			Execute stmt
		End If
	next
End Sub



'
'	w肳ꂽpXz̃tH_[уt@CԂ܂B
'
'	&nbsp;
'
'	@param path fBNg[pX\񖔂́AFolderIuWFNg
'	@return FileFolderIuWFNgi[ꂽz
'
Public Function shell_ls( path )
	Const PROC_NAME = "shell_ls"

	If VarType(path) <> 8 Then
		raise_error SHELL_ERR_NUM_INVALID_ARGUMENT, PROC_NAME, "path is not String. Type=" & TypeName(path)
	End If
	If Len(path) = 0 Then
		raise_error SHELL_ERR_NUM_INVALID_ARGUMENT, PROC_NAME, "path is empty."
	End If

	Dim files
	files = Array()

	set fso = shell_get_fso()
	p = normalize_path( to_path(path) )	
	set folder = fso.getfolder( p )

	call shell_ls_( files, folder, false )

	shell_ls = files
End Function



'
'	w肳ꂽpXz̃tH_[уt@CԂ܂B̊֐̓TutH_[T܂B
'
'	&nbsp;
'
'	@param path fBNg[pX\񖔂́AFolderIuWFNg
'	@return FileFolderIuWFNgi[ꂽz
'
Public Function shell_lsr( path )
	Const PROC_NAME = "shell_lsr"

	If VarType(path) <> 8 Then
		raise_error SHELL_ERR_NUM_INVALID_ARGUMENT, PROC_NAME, "path is not String. Type=" & TypeName(path)
	End If
	If Len(path) = 0 Then
		raise_error SHELL_ERR_NUM_INVALID_ARGUMENT, PROC_NAME, "path is empty."
	End If

	Dim files
	files = Array()

	set fso = shell_get_fso()
	p = normalize_path( to_path(path) )
	set folder = fso.getfolder( p )

	call shell_ls_( files, folder, true )

	shell_lsr = files
End Function



'
'
'
Private Sub shell_ls_( files, folder, recursive )
	Dim subfolders, subfiles, file_count
	set subfolders = folder.subfolders
	set subfiles = folder.files
	file_count = subfolders.count + subfiles.count
	If file_count = 0 Then
		Exit Sub
	End If

	For Each f in subfolders
		push files, f
	Next
	For Each f in subfiles
		push files, f
	Next
	If recursive Then
		For Each f in subfolders
			shell_ls_ files, f, recursive
		Next
	End If
End Sub



'
'	t@C̃`FbNs܂B
'	&nbsp;
'	̊֐́Aop̒lɂāAfileɎw肳ꂽt@C̃eXgsAvĂ΁ATrueԂ܂B
'	&nbsp;
'	-e t@C̓tH_[݂΁ATrue
'	-f t@C݂΁ATrue
'	-d tH_[݂΁ATrue
'	&nbsp;
'	@param op eXgZq
'	@param file eXgΏۂ\t@C
'	@return TrueFalse̕]
'
Public Function shell_test( ByVal op, ByVal file )
	Const PROC_NAME = "shell_test"

	shell_test = False

	If Not( typename_of(op, "String") ) Then
		raise_error SHELL_ERR_NUM_INVALID_ARGUMENT, PROC_NAME, "op is not String. Type=" & TypeName(op) 
	End If

	If Not( typename_of(file, "String") ) Then
		raise_error SHELL_ERR_NUM_INVALID_ARGUMENT, PROC_NAME, "file is not String. Type=" & TypeName(file) 
	End If
	
	op = LCase(Trim(op))
	
	set fso = shell_get_fso()
	Select Case op
	Case "-e"
		shell_test = ( fso.FolderExists(file) or fso.FileExists(file) )
	Case "-f"
		shell_test = ( fso.FileExists(file) )
	Case "-d"
		shell_test = ( fso.FolderExists(file) )
	Case Else
		raise_error SHELL_ERR_NUM_INVALID_ARGUMENT, PROC_NAME, "invalid op value. op=" & op
	End Select
End Function



'
'	t@C̃^CX^vXV܂B
'	&nbsp;
'	t@CȂ΁Ãt@C쐬܂B
'	&nbsp;
'	ȉ̗ł́AΏۂ̃t@C̃^CX^vݎɐݒ肵܂B
'	echo "timestamp is " & shell_touch(empty, "test.dat").DataLastModified
'	&nbsp;
'	@param timestamp Date^^CX^v
'	@param file Ώۃt@C\t@CFileIuWFNg
'	@return FileIuWFNg
'
Public Function shell_touch( ByVal timestamp, ByVal file )
	Const PROC_NAME = "shell_touch"

	set shell_touch = Nothing

	If Not( typename_of(timestamp, "Date") Or typename_of(timestamp, "Empty")) Then
		raise_error SHELL_ERR_NUM_INVALID_ARGUMENT, PROC_NAME, "path is not Date or Empty. Type=" & TypeName(path) 
	End If

	If Not( typename_of(file, "String") Or typename_of(timestamp, "File")) Then
		raise_error SHELL_ERR_NUM_INVALID_ARGUMENT, PROC_NAME, "path is not String or File. Type=" & TypeName(path) 
	End If
	
	set fso = shell_get_fso()
	If typename_of(file, "String") Then
		If Not fso.FileExists(file) Then
			fso.CreateTextFile(file)
		End If
		
		set shell_touch = fso.GetFile(file)
	Else
		set shell_touch = file
	End If

	If isEmpty(timestamp) Then
		timestamp = Now()
	End If

	set shapi_shell = CreateObject("Shell.Application")
    set shapi_folder = shapi_shell.NameSpace(shell_touch.ParentFolder.Path)
    set shapi_item = shapi_folder.ParseName(shell_touch.Name)
    shapi_item.ModifyDate = timestamp
End Function



'
'	̓t@CAw肳ꂽo͐ɏ݂܂B
'	&nbsp;
'	̓t@Cɂ́At@CFileIuWFNgAz܂͒P̂Ŏwł܂B
'	o͐ɂ́Ao͐t@C𕶎Ŏw肷邱Ƃł܂B
'	w肳ĂꍇAdestinationI[vA̓t@C̑SĂ̍s݂܂B
'	̓́Ashell_tcat̓łB
'	o͐悪w肳ĂȂꍇAshell_cat͌s킸Ae̓t@CTextStreamIuWFNgzŕԂďI܂B
'	TextStreamźAshell_xargsȂǂŗpł܂B
'	&nbsp;
'	ȉ̗ł́AJgfBNg[̑SẴt@CǂݎAK\p^[Ɉvs***Ƀ}XNāAWo͂ɏo܂B
'	<code>
'		shell_xargs shell_cat(shell_ls("./"),nothing), "shell_echo re.Replace(line,""***"")", re
'	</code>
'	&nbsp;
'	@param files ̓t@CƂAt@CFileIuWFNg̔z
'	@return TextStream̔z
'
Public Function shell_cat( ByVal files, ByVal destination )
	Const PROC_NAME = "shell_cat"

	shell_cat = Array()

	If typename_of(files, "String") or typename_of(files, "File") Then
		files = Array(files)
	End If

	mode = 0
	If typename_of(destination, "String") then
		destination = Trim(destination)
		If destination <> "" Then
			mode = 1
		End If
		
	ElseIf typename_of(destination, "TextStream") Then
		mode = 1
	End If
	
	If mode = 1 Then
		Call shell_tcat(files, destination)

	Else
		For Each f in files
			path = to_path(f)

			set fso = shell_get_fso()
			push shell_cat, fso.opentextfile( path )
		Next
	End If
End Function



'
'	̓t@CAw肳ꂽo͐ɏ݂܂B
'	&nbsp;
'	̓t@Cɂ́At@CFileIuWFNgAz܂͒P̂Ŏwł܂B
'	ꂽt@ĆAw肳ꂽo݂͐̌̃|WVȍ~ɏ܂܂B
'	o͐ɂ́At@CÁATextStreamwł܂B
'	o͐̎w肪t@Cłꍇɂ́Ãt@C̏I[ȍ~ɏ܂܂B
'	&nbsp;
'	ȉ̗ł́AJgfBNg[̃t@CSČAmerge.txtt@Cɏo͂܂B
'	<code>
'		shell_tcat shell_ls("./"), "merge.txt"
'	</code>
'	&nbsp;
'	@param files ̓t@CƂAt@CFileIuWFNg̔z
'	@param destination o͐̃t@CA܂́ATextStreamIuWFNg
'
Public Sub shell_tcat( ByVal files, ByVal destination )
	Const PROC_NAME = "shell_tcat"

	if typename_of(files, "String") or typename_of(files, "File") then
		files = Array(files)
	end if

	Dim fso, ts, its, is_new_open
	set fso = shell_get_fso()
	If typename_of(destination, "String") Then
		set ts = fso.opentextfile(destination,8,true)
		is_new_open = true
	Else
		set ts = destination
		is_new_open = false
	End If

	for each file in files
		path = to_path(file)
		echo path
		set its = fso.opentextfile(path)
		do while not its.atendofstream
			ts.write its.read(1024)
		loop
		its.close
		ts.Write vbNewLine
	next
	
	If is_new_open Then
		ts.Close
	End If
End Sub



'
'	w肳ꂽt@CAADODB.Streamɏ݂܂B
'	&nbsp;
'	ADODB.StreamTypeɂāAeLXg̓oCi؂ւ܂B
'	&nbsp;
'	ȉ̗ł́Asplit1.dmpƁAsplit2.dmpoCiāAmerge.dmpt@Cɏo͂܂B
'	<code>
'		set out = createobject("ADODB.Stream")
'		out.open
'		out.type = 2
'		shell_bcat Array("split1.dmp","split2.dmp"), out
'		out.savetofile "merge.dmp"
'	</code>
'	&nbsp;
'	@param files ̓t@CƂAt@CFileIuWFNg̔z
'	@param destination o͐ADODB.StreamIuWFNg
'
Public Sub shell_bcat( ByVal files, destination )
	Const PROC_NAME = "shell_bcat"

	if typename_of(files, "String") then
		files = Array(files)
	end if

	set in_stream = createobject("ADODB.Stream")

	for each file in files
		path = to_path(file)
		in_stream.open
		in_stream.loadfromfile path
		in_stream.type = to_ado_stream.type
		in_stream.mode = 1
		do while not stream.eos
			select case to_ado_stream.type
			case 1
				to_ado_stream.write in_stream.read(1024)
			case 2
				to_ado_stream.writetext in_stream.readtext(1024)
			case else
				raise_error SHELL_ERR_NUM_INVALID_ARGUMENT, PROC_NAME, "unkwnon type. adodb.stream.type=" & to_ado_stream.type
			end select
		loop
		stream.close
	next
End Sub



'
'	w肳ꂽt@CRs[܂B
'	&nbsp;
'	Rs[ɓ̃t@CA܂́AtH_[݂ꍇA㏑܂B
'	sourceɔzFilesRNVw肳ꂽꍇAi[ĂvfSăRs[܂B
'	̏ꍇAdestination̓fBNg[ĂKv܂B
'	&nbsp;
'	@param source t@CAFileIuWFNgAFolderIuWFNgA܂́A̔z
'	@param destination t@C܂̓tH_[A܂FolderIuWFNg
'
Public Sub shell_cp( source, destination )
	Const PROC_NAME = "shell_cp"

	set fso = shell_get_fso()

	Select Case TypeName(source)
	Case "String", "File"
		call shell_cp_one( source, destination )
	Case IsArray(source)
		For Each f In source
			call shell_cp( f, destination )
		Next
	Case Else
		raise_error SHELL_ERR_NUM_INVALID_ARGUMENT, PROC_NAME, "source is not supported type. Type=" & TypeName(source)
	End Select
End Sub



'
'	w肳ꂽt@CA܂́AtH_[Rs[܂B
'
Private Sub shell_cp_one( file, destination )
	set fso = shell_get_fso()

	If typename_of(f, "Folder") Then
		fso.copyfolder to_path(file), destination
	Else
		fso.copyfile to_path(file), destination
	End If
End Sub



'
'	w肳ꂽt@Cړ܂B
'	&nbsp;
'	sourceɔz񂪎w肳ꂽꍇAi[ĂvfSĈړ܂B
'	̏ꍇAdestinatiońAfBNgĂKv܂B
'	&nbsp;
'	@param source t@CAFileIuWFNgAFolderIuWFNgA܂́A̔z
'	@param destination t@C܂̓tH_[A܂FolderIuWFNg
'
Public Sub shell_mv( source, destination )
	Const PROC_NAME = "shell_mv"

	set fso = shell_get_fso()

	Select Case TypeName(source)
	Case "String"
		If fso.FolderExists(source) Then
			call shell_mv( fso.GetFolder(source), destination )
		Else
			call shell_mv( fso.GetFile(source), destination )
		End If

	Case "File"
		fso.movefile to_path(source), destination

	Case "Folder"
		fso.movefolder to_path(source), destination

	Case InStr(TypeName(source), "()") > 0
		For Each f In source
			call shell_mv( f, destination )
		Next
		
	Case Else
		raise_error SHELL_ERR_NUM_INVALID_ARGUMENT, PROC_NAME, "source is not supported type. Type=" & TypeName(source)
	End Select
End Sub



'
'	tH_[쐬܂B
'	&nbsp;
'	tH_[ɑ݂ĂꍇÅ֐̓G[ԍ58̎sG[𔭐ďI܂B
'	&nbsp;
'	@param folder 쐬tH_[̕
'	@return 쐬ꂽtH_[FolderIuWFNg
'
Public Function shell_mkdir( folder )
	Const PROC_NAME = "shell_mkdir"

	If VarType(folder) <> 8 Then
		raise_error SHELL_ERR_NUM_INVALID_ARGUMENT, PROC_NAME, "folder is not String. Type=" & TypeName(folder)
	End If
	If Len(folder) = 0 Then
		raise_error SHELL_ERR_NUM_INVALID_ARGUMENT, PROC_NAME, "folder is empty."
	End If

	set fso = shell_get_fso()
	set shell_mkdir = fso.createfolder(folder)
End Function



'
'	tH_[쐬܂B̊֐́AsĂ钆ԃtH_[쐬܂B
'	&nbsp;
'	tH_[ɑ݂ĂꍇÅ֐̓G[ԍ58̎sG[𔭐ďI܂B
'	&nbsp;
'	@param folder 쐬tH_[̕
'	@return w肳ꂽtH_[FolderIuWFNg
'
Public Function shell_mkdirs( folder )
	Const PROC_NAME = "shell_mkdirs"

	If VarType(folder) <> 8 Then
		raise_error SHELL_ERR_NUM_INVALID_ARGUMENT, PROC_NAME, "folder is not String. Type=" & TypeName(folder)
	End If
	If Len(folder) = 0 Then
		raise_error SHELL_ERR_NUM_INVALID_ARGUMENT, PROC_NAME, "folder is empty."
	End If

	set fso = shell_get_fso()

	parts = split_path( normalize_path(folder) )
	path = ""
	For i = 0 To UBound(parts)
		path = path & parts(i) & "\"

		If Not fso.folderexists(path) Then
			on error resume next
			set shell_mkdirs = shell_mkdir(path)
			if Err.Number > 0 Then
				raise_error Err.Number, PROC_NAME, Err.Description & "path=" & path
			End If
		End If

	Next
End Function



'
'	w肳ꂽtH_[폜܂B
'	&nbsp;
'	@param folder 쐬tH_[̕
'	@param force Iɍ폜ꍇATrueȂ̏ꍇFalse	
'
Public Sub shell_rmdir( folder, force )
	Const PROC_NAME = "shell_rmdir"

	If VarType(folder) <> 8 Then
		raise_error SHELL_ERR_NUM_INVALID_ARGUMENT, PROC_NAME, "folder is not String. Type=" & TypeName(folder)
	End If
	If Len(folder) = 0 Then
		raise_error SHELL_ERR_NUM_INVALID_ARGUMENT, PROC_NAME, "folder is empty."
	End If

	set fso = shell_get_fso()
	fso.deletefolder folder, force
End Sub



'
'	w肳ꂽt@C폜܂B
'	&nbsp;
'	sourceɔz񂪎w肳ꂽꍇAi[ĂvfSč폜܂B
'	&nbsp;
'	@param source t@CtH_[AFileIuWFNgAFolderIuWFNgA܂́A̔z
'	@param force Iɍ폜ꍇATrueB̑̏ꍇAFalseB
'
Public Sub shell_rm( source, force )
	Const PROC_NAME = "shell_rm"

	set fso = shell_get_fso()

	Select Case TypeName(source)
	Case "String", "File"
		call shell_rm_one( source, force )

	Case IsArray(source)
		For Each f In source
			call shell_rm( f, force )
		Next

	Case Else
		raise_error SHELL_ERR_NUM_INVALID_ARGUMENT, PROC_NAME, "source is not supported type. Type=" & TypeName(source)
	End Select
End Sub



'
'	w肳ꂽt@CA܂́AtH_[폜܂B
'
Private Sub shell_rm_one( file, force )
	set fso = shell_get_fso()

	p = to_path(file)
	If fso.FolderExists(p) Then
		fso.deletefolder p, force
	Else
		fso.deletefile p, force
	End If
End Sub



'
'	݂̃[LOfBNg[fBNg[X^bNɐς񂾌Aw肳ꂽfBNgɕύX܂B
'	&nbsp;
'	@param	destination	VfBNg
'	@return ύXÕJgfBNg
'
Public Function shell_pushd( destination )
	Const PROC_NAME = "shell_pushd"

	If VarType(destination) <> 8 Then
		raise_error SHELL_ERR_NUM_INVALID_ARGUMENT, PROC_NAME, "destination is not String. Type=" & TypeName(destination)
	End If
	If Len(destination) = 0 Then
		raise_error SHELL_ERR_NUM_INVALID_ARGUMENT, PROC_NAME, "destination is empty."
	End If

	If IsEmpty(directory_stack_) Then
		set directory_stack_ = shell_create_dictionary()
	End If

	set shell = shell_get_shell()
	shell_pushd = shell.currentdirectory
	shell.currentdirectory = destination

	directory_stack_.add directory_stack_.Count, shell_pushd
End Function



'
'	fBNg[X^bNɐς܂ꂽŌ̃fBNg[oāÃ݂[LOfBNg[ƂĐݒ肵܂B
'	&nbsp;
'	@return ύXÕJgfBNg
'
Public Function shell_popd()
	Const PROC_NAME = "shell_popd"

	If IsEmpty(directory_stack_) Then
		raise_error SHELL_ERR_NUM_INVALID_ARGUMENT, PROC_NAME, "directory stack is empty."
	End If

	prev_key = directory_stack_.Count-1
	If prev_key = -1 Then
		raise_error SHELL_ERR_NUM_INVALID_ARGUMENT, PROC_NAME, "directory stack is empty."
	End If

	set shell = shell_get_shell()
	shell_popd = shell.currentdirectory
	shell.currentdirectory = directory_stack_(prev_key)

	directory_stack_.remove prev_key
End Function



'
'	Wo͂ւTextStreamIuWFNgԂ܂B
'	&nbsp;
'	@return W͂ւTextStreamIuWFNg
'
Public Function shell_stdout()
	set shell_stdout = wscript.stdout
End Function



'
'	WG[ւTextStreamIuWFNgԂ܂B
'	&nbsp;
'	@return WG[ւTextStreamIuWFNg
'
Public Function shell_stderr()
	set shell_stderr = wscript.stderr
End Function



'
'	W͂ւTextStreamIuWFNgԂ܂B
'	&nbsp;
'	@return W͂ւTextStreamIuWFNg
'
Public Function shell_stdin()
	set shell_stdin = wscript.stdin
End Function



Private Function shell_create_dictionary()
	set shell_create_dictionary = createobject("Scripting.Dictionary")
End Function



Private Function shell_get_fso()
	If IsEmpty(fso_) Then
		set fso_ = createobject("Scripting.FileSystemObject")
	End If

	set shell_get_fso = fso_
End Function



Private Function shell_get_shell()
	If IsEmpty(shell_) then
		set shell_ = createobject("WScript.Shell")
	End If

	set shell_get_shell = shell_
End Function



Private Sub push( ary, value )
	Redim Preserve ary(UBound(ary)+1)

	If IsObject(value) Then
		set ary(UBound(ary)) = value
	Else
		ary(UBound(ary)) = value
	End If
End Sub



Private Function to_absolute_url( path )
	to_absolute_url = "URL=file://" & to_absolute_path(path)
End Function



Private Function to_absolute_path( path )
	path = replace(path,"\", ",")
	If len(path) > 2 then
		if mid(path,2,1) = ":" then
			to_absolute_path = path
			exit function
		end if
	end if
	to_absolute_path = Replace(shell_pwd() & "/" & path, "//", "/")
End Function



Private Function to_path( target )
	If VarType(target) = 8 Then
		to_path = target
	Else
		Select Case TypeName(target)
		Case "Folder", "File"
			to_path = target.Path
		Case Else
			Err.Raise 13
		End Select
	End If
End Function



Private Function split_path( byval path )
	split_path = split( path, "\" )
End Function



Private Function is_absolute( byval path )
	is_absolute = ( InStr(path,":") > 0 )
End Function



Private Function normalize_path( byval path )
	normalize_path = Trim(Replace( path, "/", "\" ))
	
	if not is_absolute(path) then
		parts = split_path(normalize_path)
		parts(0) = shell_get_shell().CurrentDirectory
		normalize_path = ""
		for each part in parts
			if normalize_path = "" then
				normalize_path = part
			else
				normalize_path = normalize_path & "\" & part
			end if
		next
	end if
End Function



Private Function last_folder_path( byval path )
	parts = split_path( path )
	if parts(0) = "" then
		parts(0) = "."
	end if

	set fso = shell_get_fso()
	for i = 0 to ubound(parts)
		if i = 0 then
			tmp = parts(i)
		else
			tmp = last_folder_path & "\" & parts(i)
		end if
		if fso.folderexists(tmp) then
			last_folder_path = tmp
		end if
	next

	if last_folder_path = "" then
		last_folder_path = parts(0)
	end if
End Function



Private Function typename_of( v, type_name )
	typename_of = ( TypeName(v) = type_name )
End Function



Private Sub raise_error( num, src, desc )
	Err.Raise num, SHELL_MODULE_NAME & "." & src, src & " - " & desc
End Sub
