'
'	logging.vbśAMOt[[N񋟂܂B
'	&nbsp;
'	MOt[[Nł́Alog4ĵ悤ɁAK[ƁAAy_[̊TO񋟂܂B
'	&nbsp;
'	<strong style="text-decoration: underline;">K[</strong>
'	K[̓t[[N̊{IȃCX^XłB
'	K[̖́AAy_[qK[ƂCX^XǗAAvP[ṼOo͗vRg[邱ƂłB
'	K[́Ao̗͂v󂯕tƂ̃OxK[ɐݒ肳ꂽOo̓xȏł΃Ay_[ɃbZ[WfBXpb`܂B
'	&nbsp;
'	Ȍo̓x͈ȉ̎ނpӂĂAEɍsقǍxƂĒ`Ă܂B
'		TRACE < DEBUG < INFO < WARN < ERROR < FATAL
'	&nbsp;
'	K[͎qK[Ƃ\łB
'	eK[ɎwꂽOo͖߂́AqK[ɓ`dAqK[͂̃Ay_[ݒɏ]ďo͂s܂B
'	K[̎Ă郍Oo̓x͎qK[ɂe^Ae̐񂪎qɂ`d܂B
'	Ⴆ΁AeK[INFOxȏo͉\ƂĂꍇAqK[ǂ̂悤ȐݒĂĂDEBUGx̏o͂͂ł܂B
'	qK[͕Ƃ\łB
'	bZ[W͑SĂ̎qK[ɏԂɈn܂B
'	&nbsp;
'	<strong style="text-decoration: underline;">Ay_[</strong>
'	Ay_[́Aw肳ꂽ^[QbgɃObZ[W̏o͂s܂B
'	Ay_[΁AK[̓bZ[Wj܂B
'	&nbsp;
'	Ay_[ɂ͈ȉ̎ނpӂĂAꂼʁX̃^[QbgɃObZ[W݂܂B
'	<strong style="text-decoration: underline;">FileAppender</strong>
'	FileAppendeŕAt@CɃbZ[W݂܂B
'	Ώۂ̃t@ĆAfilenamevpeBɎw肵܂B
'	&nbsp;
'	<strong style="text-decoration: underline;">TextStreamAppender</strong>
'	TextStreamAppendeŕATextStreamIuWFNgɃbZ[W݂܂B
'	ΏۂTextStreaḿAtextstreamvpeBɎw肵܂B
'	&nbsp;
'	<strong style="text-decoration: underline;">NTEventLogAppender</strong>
'	NTEventLogAppendeŕAWindowsEventLogɃbZ[W݂܂B
'	NTEventLogAppenderł́AOxƂɎ̂悤ȃCxg^Cvŏ܂܂B
'	<ul>
'	<li>TRACE ... INFORMATION
'	<li>DEBUG ... INFORMATION
'	<li>INFO ... INFORMATION
'	<li>WARN ... WARNING
'	<li>ERROR ... ERROR
'	<li>FATAL ... ERROR
'	</ul>
'	<strong style="text-decoration: underline;">łȒPȎgp</strong>
'	łȒPȗp`Ԃ́AFileAppenderɂ郍MOłB
'	ȉ̗ĂBł́Aapp.logINFOx̃bZ[W"logging test."ł܂B
'	&nbsp;
'	<code>set logger = log_create_simple( "simple_logger", "app.log", LOG_LEVEL_INFO )
'	log_info logger, "logging test."
'	log_close logger
'	</code>
'	
'
Public Const LOG_MODULE_NAME = "Logging.vbs"

Public Const LOG_ERR_INVALID_ARGUMENT = 1000
Public Const LOG_ERR_INVALID_STATE = 1001

Public Const LOG_LEVEL_TRACE = 1
Public Const LOG_LEVEL_DEBUG = 2
Public Const LOG_LEVEL_INFO = 3
Public Const LOG_LEVEL_WARN = 4
Public Const LOG_LEVEL_ERROR = 5
Public Const LOG_LEVEL_FATAL = 6

Public Const LOG_APPENDER_FILE = 1
Public Const LOG_APPENDER_TEXTSTREAM = 2
Public Const LOG_APPENDER_NTEVENTLOG = 3

Private level_labels_

'
'	K[\z܂B
'	&nbsp;
'	\zꂽ΂̃CX^X́AAy_[Ă܂B
'	̂߃Oo͊֐̓bZ[Wj܂B
'	Ay_[쐬RtsĂB
'	ڍׂ́Alog_appender_createQƂĂB
'	&nbsp;
'	@param name K[̖O
'	@param theshold Oo͂s臒l
'	@return \zꂽK[IuWFNg
'
Public Function log_create( name, threshold )
	If IsEmpty(labels_) then
		level_labels_ = Array("", "TRACE", "DEBUG","INFO","WARN","ERROR","FATAL")
	End If

	Dim logger, appenders, children
	set appenders = createobject("Scripting.Dictionary")
	set children = createobject("Scripting.Dictionary")
	set logger = createobject("Scripting.Dictionary")
	logger.add "_class", "Logger"
	logger.add "name", name
	logger.add "parent", Nothing
	logger.add "children", children
	logger.add "appenders", appenders
	logger.add "threshold", threshold
	logger.add "format", "%d\t%p\t%m"

	set log_create = logger
End Function

'
'	t@CɃMOVvȃK[\z܂B
'	&nbsp;
'	̃CX^X́AFileAppenderĂ܂B
'	o͕@JX^}CYꍇɂ́ÃAy_[̃vpeBύXĂB
'	&nbsp;
'	@param name K[̖O
'	@param filename o͐̃t@C
'	@param theshold Oo͂s臒l
'	@return \zꂽK[IuWFNg
'
Public Function log_create_simple( name, filename, threshold )
	Dim logger
	set logger = log_create( name, threshold )
	set appender = log_appender_create( "_appender" & Clng(Now()), LOG_APPENDER_FILE )
	call log_appender_set_property( appender, "filename", filename )
	call log_set_appender( logger, appender )

	set log_create_simple = logger
End Function



'
'	K[̖O擾܂B
'	&nbsp;
'	@param logger K[IuWFNg
'	@return K[̖O
'
Public Function log_get_name( logger )
	log_get_name = logger("name")
End Function



'
'	K[Ay_[JĂe탊\[XN[Y܂B
'	&nbsp;
'	̊֐́AqK[ɂKp܂B
'	&nbsp;
'	@param logger K[IuWFNg
'
Public Sub log_close( logger )
	Dim appenders, appender
	set appenders = log_get_appenders_internal( logger )

	For Each appender In appenders.Items
		Call log_appender_close( logger, appender )
	Next

	set children = log_get_children_internal( logger )
	For Each child In children.Items
		Call log_close( child )
	Next
End Sub



'
'	K[ĂqK[̃RNV擾܂B
'	&nbsp;
'	@param logger K[IuWFNg
'	@return qƂȂ郍K[IuWFNg̃RNViqK[̖OL[AqK[IuWFNglƂScripting.DictionaryIuWFNg)
'
Public Function log_get_children( logger )
	Dim dic
	set dic = createobject("Scripting.Dictionary")

	Dim children, name
	set chidren = log_get_children_internal(logger)
	for each name in chilren.keys
		dic.add name, children(name)
	next

	set log_get_children = dic
End Function



'
'	K[ĂqK[̃RNV擾܂B
'	&nbsp;
'	@param logger K[IuWFNg
'	@return qƂȂ郍K[IuWFNg̃RNV
'
Private Function log_get_children_internal( logger )
	set log_get_children_internal = logger("children")
End Function



'
'	K[ɑ΂āAqK[ݒ肵܂B
'	&nbsp;
'	@param logger eƂȂ郍K[
'	@param name qƂȂ郍K[ɕt^閼O
'	@param child qƂȂ郍K[
'	@return Ŋɐݒ肳ĂqK[
'
Public Function log_set_child( logger, child )
	Dim children
	set children = log_get_children_internal( logger )

	Dim name
	name = log_get_name( child )
	If children.Exists(name) Then
		set log_set_child = children(name)
	Else
		set log_set_child = Nothing
	End If
	
	set children(name) = child
	set child("parent") = logger
End Function



'
'	K[ĂAy_[̃RNV擾܂B
'	&nbsp;
'	@param logger Ay_[Ă郍K[
'	@return Ay_[̃RNV(Scripting.Dictionary)
'
Public Function log_get_appenders( logger )
	Dim dic
	set dic = createobject("Scripting.Dictionary")

	Dim appenders, name
	set appenders = log_get_appenders_internal( logger )
	for each name in appenders.keys
		dic.add name, appenders(name)
	next

	set log_get_appenders = dic
End Function



'
'	K[ĂAy_[̃RNV擾܂B
'	&nbsp;
'	@return Ay_[̃RNV(Scripting.Dictionary)
'
Private Function log_get_appenders_internal( logger )
	set log_get_appenders_internal = logger("appenders")
End Function



'
'	K[ɃAy_[ݒ肵܂B
'	&nbsp;
'	@param logger Ay_[Ă郍K[
'	@return Ŋɐݒ肳ĂAy_[
'
Public Function log_set_appender( logger, appender )
	Dim appenders, name
	set appenders = log_get_appenders_internal( logger )

	name = log_appender_get_name( appender )

	If appenders.Exists(name) Then
		set log_set_appender = appenders(name)
	Else
		set log_set_appender = Nothing
	End If
	
	set appenders(name) = appender
End Function



'
'	Ay_[\z܂B
'	&nbsp;
'	Ay_[̎ނɂ͎̂ꂩwł܂B
'	<ul>
'	<li>LOG_APPENDER_FILE
'	<li>LOG_APPENDER_TEXTSTREAM
'	<li>LOG_APPENDER_NTEVENTLOG
'	</ul>
'	&nbsp;
'	@param name Ay_[̖O
'	@param appender_type Ay_[̎
'	@return \zꂽAy_[
'
Public Function log_appender_create( name, appender_type )
	Dim appender
	set appender = createobject("Scripting.Dictionary")
	set properties = createobject("Scripting.Dictionary")

	Select Case appender_type
	Case LOG_APPENDER_FILE
		appender.add "_class", "Appender"
		appender.add "_type", appender_type
		appender.add "_name", name
		appender.add "_ts", Nothing
		appender.add "_properties", properties
		properties.add "filename", ""

	Case LOG_APPENDER_TEXTSTREAM
		appender.add "_class", "Appender"
		appender.add "_type", appender_type
		appender.add "_name", name
		appender.add "_properties", properties
		properties.add "textstream", Nothing

	Case LOG_APPENDER_NTEVENTLOG
		appender.add "_class", "Appender"
		appender.add "_type", appender_type
		appender.add "_name", name
		appender.add "_shell", CreateObject("WScript.Shell")
		appender.add "_properties", properties

	Case Else
		raise_error LOG_ERR_INVALID_ARGUMENT, "log_appender_create", "invalid argument1. appender_type is invalid. appender_type=" & appender_type
	End Select

	set log_appender_create = appender
End Function



'
'	Ay_[̎Ă郊\[X܂B
'	&nbsp;
'	@param appender Ay_[
'
Private Sub log_appender_close( logger, appender )
	Dim appender_type
	appender_type = log_appender_get_type( appender )

	Select Case appender_type
	Case LOG_APPENDER_FILE
		call log_file_appender_close( logger, appender )

	Case LOG_APPENDER_TEXTSTREAM
		call log_textstream_appender_close( logger, appender )

	Case LOG_APPENDER_NTEVENTLOG
		call log_eventlog_appender_close( logger, appender )

	Case Else
		raise_error LOG_ERR_INVALID_ARGUMENT, "log_appender_close", "invalid argument1. appender_type is invalid. appender_type=" & appender_type
	End Select
End Sub



'
'	Ay_[̖O擾܂B
'	&nbsp;
'	@param appender Ay_[
'	@return Ay_[̖O
'
Public Function log_appender_get_name( appender )
	log_appender_get_name = appender("_name")
End Function



'
'	Ay_[̎ނ擾܂B
'	&nbsp;
'	@param appender Ay_[
'	@return Ay_[̎
'
Public Function log_appender_get_type( appender )
	log_appender_get_type = appender("_type")
End Function



'
'	Ay_[̃vpeBݒ肵܂B
'	&nbsp;
'	@param appender Ώۂ̃Ay_[
'	@param name vpeB̖
'	@param value ݒl
'	@return ݒ肳Ăl
'
Public Function log_appender_set_property( appender, name, value )
	Dim appender_type
	appender_type = log_appender_get_type( appender )

	If log_appender_is_public_writable(appender, name) Then

		Dim properties
		set properties = log_appender_get_properties_internal( appender )

		log_set_item log_appender_set_property, properties(name)

		If IsObject(value) Then
			set properties(name) = value
		Else
			properties(name) = value
		End If

	Else
		raise_error LOG_ERR_INVALID_ARGUMENT, "log_appender_set_property", "invalid argument2. can not access. name=" & name
	End If
End Function



'
'	Ay_[̃vpeBɐݒ肳Ăl擾܂B
'	&nbsp;
'	@param appender Ώۂ̃Ay_[
'	@param name vpeB̖
'	@return ݒ肳Ăl
'
Public Function log_appender_get_property( appender, name )
	Dim appender_type
	appender_type = log_appender_get_type( appender )

	If log_appender_is_public_readable( appender, name ) Then
		Dim properties
		set properties = log_appender_get_properties_internal( appender )

		log_set_item log_appender_get_property, properties(name)
	Else
		raise_error LOG_ERR_INVALID_ARGUMENT, "log_appender_get_property", "invalid argument2. can not access. name=" & name
	End If
End Function



'
'	Ay_[ĂvpeB擾܂B
'	&nbsp;
'	@param appender Ώۂ̃Ay_[
'	@return vpeB̖OL[AvpeBlƂĎDictionaryIuWFNg
'
Public Function log_appender_get_properties( appender )
	Dim dic
	dic = createobject("scripting.dictionary")

	Dim properties
	set properties = log_appender_get_properties_internal( appender )
	For Each name in properties.keys
		If log_appender_is_public_readable(name) Then
			dic.add name, properties(name)
		End If
	Next

	set log_appender_get_properties = dic
End Function



'
'	Ay_[ĂvpeB擾܂B
'	&nbsp;
'	@param appender Ώۂ̃Ay_[
'	@return vpeB̖OL[AvpeBlƂĎDictionaryIuWFNg
'
Private Function log_appender_get_properties_internal( appender )
	set log_appender_get_properties_internal = appender("_properties")
End Function



Private Function log_appender_is_public_readable( appender, name )
	Dim appender_type
	appender_type = log_appender_get_type( appender )

	Select Case appender_type
	Case LOG_APPENDER_FILE
		log_appender_is_public_readable = log_file_appender_is_public_property( appender, name )

	Case LOG_APPENDER_TEXTSTREAM
		log_appender_is_public_readable = log_textstream_appender_is_public_property( appender, name )

	Case LOG_APPENDER_NTEVENTLOG
		log_appender_is_public_readable = log_eventlog_appender_is_public_property( appender, name )

	Case Else
		raise_error LOG_ERR_INVALID_ARGUMENT, "log_appender_is_public_readable", "invalid argument1. appender_type is invalid. appender_type=" & appender_type
	End Select
End Function



Private Function log_appender_is_public_writable( appender, name )
	Dim appender_type
	appender_type = log_appender_get_type( appender )

	Select Case appender_type
	Case LOG_APPENDER_FILE
		log_appender_is_public_writable = log_file_appender_is_public_property( appender, name )

	Case LOG_APPENDER_TEXTSTREAM
		log_appender_is_public_writable = log_textstream_appender_is_public_property( appender, name )

	Case LOG_APPENDER_NTEVENTLOG
		log_appender_is_public_writable = log_eventlog_appender_is_public_property( appender, name )

	Case Else
		raise_error LOG_ERR_INVALID_ARGUMENT, "log_appender_is_public_readable", "invalid argument1. appender_type is invalid. appender_type=" & appender_type
	End Select
End Function



Private Function log_get_level_label(level)
	log_get_level_label = level_labels_(level)
End Function



'
'	TRACEx̃Oo͂܂B
'	&nbsp;
'	@param logger MOCX^X
'	@param message o̓bZ[W
'
Public Sub log_trace( logger, message )
	log_print logger, LOG_LEVEL_TRACE, message
End Sub


'
'	DEBUGx̃Oo͂܂B
'	&nbsp;
'	@param logger MOCX^X
'	@param message o̓bZ[W
'
Public Sub log_debug( logger, message )
	log_print logger, LOG_LEVEL_DEBUG, message
End Sub



'
'	INFOx̃Oo͂܂B
'	&nbsp;
'	@param logger MOCX^X
'	@param message o̓bZ[W
'
Public Sub log_info( logger, message )
	log_print logger, LOG_LEVEL_INFO, message
End Sub



'
'	WARNx̃Oo͂܂B
'	&nbsp;
'	@param logger MOCX^X
'	@param message o̓bZ[W
'
Public Sub log_warn( logger, message )
	log_print logger, LOG_LEVEL_WARN, message
End Sub



'
'	ERRORx̃Oo͂܂B
'	&nbsp;
'	@param logger MOCX^X
'	@param message o̓bZ[W
'
Public Sub log_error( logger, message )
	log_print logger, LOG_LEVEL_ERROR, message
End Sub



'
'	FATALx̃Oo͂܂B
'	&nbsp;
'	@param logger MOCX^X
'	@param message o̓bZ[W
'
Public Sub log_fatal( logger, message )
	log_print logger, LOG_LEVEL_FATAL, message
End Sub



'
'	w肳ꂽx̃Oo͂܂B
'	&nbsp;
'	@param logger MOCX^X
'	@param level Ox
'	@param message o̓bZ[W
'
Public Sub log_print( logger, level, message )
	If Not log_is_loggable(logger, level, message) Then
		Exit Sub
	End If

	Dim appenders, appender
	set appenders = log_get_appenders_internal( logger )

	For Each appender In appenders.Items
		Select Case log_appender_get_type( appender )
		Case LOG_APPENDER_FILE
			call log_file_appender_print( logger, appender, level, message )

		Case LOG_APPENDER_TEXTSTREAM
			call log_textstream_appender_print( logger, appender, level, message )

		Case LOG_APPENDER_NTEVENTLOG
			call log_eventlog_appender_print( logger, appender, level, message )

		Case Else
			raise_error LOG_ERR_INVALID_ARGUMENT, "log_trace", "invalid argument1. appender_type is invalid. appender_type=" & appender_type
		End Select
	Next

	set children = log_get_children_internal( logger )
	For Each child In children.Items
		call log_print( child, level, message )
	Next
End Sub



'
'	FileAppenderɂĎw肳ꂽx̃Ot@Co͂܂B
'
Private Sub log_file_appender_print( logger, appender, level, message )
	Dim ts

	set ts = appender("_ts")
	If ts is nothing Then
		Dim properties
		set properties = log_appender_get_properties_internal( appender )

		If not properties.Exists("filename") Then
			raise_error LOG_ERR_INVALID_STATE, "log_file_appender_print", "filename property is empty."
		End If

		Dim filename
		filename = trim(properties("filename"))
		If len(filename) = 0 Then
			raise_error LOG_ERR_INVALID_STATE, "log_file_appender_print", "filename property is empty."
		End If

		Dim fso
		set fso = CreateObject("Scripting.FileSystemObject")
		set ts = fso.OpenTextFile( filename, 8, True )
		set appender("_ts") = ts
	End If

	ts.WriteLine log_format( logger, level, message )
End Sub



'
'	FileAppenderJĂt@CN[Y܂B
'
Private Sub log_file_appender_close( logger, appender )
	Dim ts

	set ts = appender("_ts")
	If ts is nothing Then
		raise_error LOG_ERR_INVALID_STATE, "log_file_appender_close", "logger is already closed."
	Else
		ts.Close
		set appender("_ts") = Nothing
	End If

End Sub



'
'	FileAppenderĂvpeB̓ApublicȃvpeBł邩𔻒肵܂B
'
Private Function log_file_appender_is_public_property( appender, name  )
	select case LCase(name)
	case "filename"
		log_file_appender_is_public_property = true

	case else
		raise_error LOG_ERR_INVALID_ARGUMENT, "log_file_appender_is_public_property", "invalid argument2. property not exists."
	End Select
End Function



'
'	TextStreamAppenderɂĎw肳ꂽx̃Ot@Co͂܂B
'
Private Sub log_textstream_appender_print( logger, appender, level, message )
	Dim properties
	set properties = log_appender_get_properties_internal( appender )

	Dim ts
	set ts = properties("textstream")
	If ts is nothing Then
		raise_error LOG_ERR_INVALID_STATE, "log_textstream_appender_print", "logger is already closed."
	End If

	ts.WriteLine log_format( logger, level, message )
End Sub



'
'	TextStreamAppenderJĂt@CN[Y܂B
'
Private Sub log_textstream_appender_close( logger, appender )
	Dim properties
	set properties = log_appender_get_properties_internal( appender )

	Dim ts
	set ts = properties("textstream")
	If ts is nothing Then
		raise_error LOG_ERR_INVALID_STATE, "log_textstream_appender_close", "logger is already closed."
	Else
		ts.Close
		set properties("textstream") = Nothing
	End If

End Sub



'
'	TextStreamĂvpeB̓ApublicȃvpeBł邩𔻒肵܂B
'
Private Function log_textstream_appender_is_public_property( name )
	select case LCase(name)
	case "textstream"
		log_textstream_appender_is_public_property = true
	case else
		raise_error LOG_ERR_INVALID_ARGUMENT, "log_textstream_appender_is_public_property", "invalid argument2."
	End Select
End Function



'
'	EventLogAppenderɂĎw肳ꂽx̃Ot@Co͂܂B
'
Private Sub log_eventlog_appender_print( logger, appender, level, message )
	Dim shell

	set shell = appender("_shell")
	If shell Is Nothing Then
		raise_error LOG_ERR_INVALID_STATE, "log_eventlog_appender_print", "logger is already closed."
	End if

	eventType = Array(4, 4, 4, 4, 2, 1, 1)( level )
	shell.LogEvent eventType, log_format( logger, level, message )
End Sub



'
'	EventLogAppenderJĂt@CN[Y܂B
'
Private Sub log_eventlog_appender_close( logger, appender )
	Dim shell

	set shell = appender("_shell")
	If shell is nothing Then
		raise_error LOG_ERR_INVALID_STATE, "log_eventlog_appender_close", "logger is already closed."
	Else
		set appender("_shell") = nothing
	End If
End Sub



'
'	EventLogAppenderĂvpeB̓ApublicȃvpeBł邩𔻒肵܂B
'
Private Function log_textstream_appender_is_public_property( appender, name )
	select case LCase(name)
	case else
		raise_error LOG_ERR_INVALID_ARGUMENT, "log_textstream_appender_is_public_property", "invalid argument2."
	End Select
End Function



'
'	MO\ȃbZ[W肵܂B
'
Private Function log_is_loggable( logger, level, message )
	log_is_loggable = ( logger("threshold") <= level )
	If log_is_loggable = False Then
		Exit Function
	End If

	set parent = logger("parent")
	If parent is nothing then
	else
		log_is_loggable = ( log_is_loggable( parent, level, message ) and log_is_loggable )
	end if
End Function



'
'	bZ[WtH[}bg܂B
'
Private Function log_format( logger, level, message )
	log_format = logger("format")
	log_format = Replace(log_format, "\t", vbTab )
	log_format = Replace(log_format, "%d", Now() )
	log_format = Replace(log_format, "%p", log_get_level_label(level) )
	log_format = Replace(log_format, "%m", message )
End Function



'
'	CX^X̃NX擾܂B
'
Private Function log_get_class( instance )
	If instance.Exists("_class") Then
		log_get_class = instance("_class")
	End If
End Function



'
'	w肳ꂽvariableɁAvalue܂B
'	valuéAQƌ^Al^ǂw\łB
'
Private Sub log_set_item( variable, value )
	If IsObject(value) Then
		set variable = value
	Else
		variable = value
	End If
End Sub



Private Sub raise_error( num, src, desc )
	Err.Raise num, LOG_MODULE_NAME & "." & src, src & " - " & desc
End Sub
