#ifdef  __cplusplus 
 extern "C" {
#endif

enum { Error4_Err_Base = 0x00000400 };
enum { Error4_Err_Mask = 0xFFFFFF00 };
enum { Err_Others = 1 };
enum { Err_Original = 0x101 };
enum { Err_GetLastError = Error4_Err_Base | 0x01 };
enum { Err_HResult =      Error4_Err_Base | 0x02 };
enum { Err_Errno =        Error4_Err_Base | 0x03 };
enum { Err_Unknown =      Error4_Err_Base | 0x04 };
enum { Err_InError =      Error4_Err_Base | 0x05 };
enum { Err_InFinally =    Error4_Err_Base | 0x06 };
enum { Err_InvalidValue = Error4_Err_Base | 0x07 };
enum { Err_NotImplementYet = Error4_Err_Base | 0x09 };
enum { Err_FewMemory =       Error4_Err_Base | 0x10 };
enum { Err_FewArray =        Error4_Err_Base | 0x11 };
enum { Err_CannotOpenFile =  Error4_Err_Base | 0x12 };
enum { Err_NotFoundDllFunc = Error4_Err_Base | 0x13 };
enum { Err_BadCmdID =        Error4_Err_Base | 0x14 };


int   Error4_raise( int err_num );
void  Error4_clear( int err_num );
int   Error4_getErrCount(void);
void  Error4_getErrStr( int err_num, TCHAR* msg, int msg_size );
void  Error4_printf( const TCHAR* format, ... );


#ifndef NDEBUG
  #define  IF(x)   if((x)&&(DebugBreak(),1))
#else
  #define  IF(x)   if(x)
#endif

#ifndef NDEBUG
  #define  IF_D(x)   if((x)&&(DebugBreak(),1))
#else
  #define  IF_D(x)   if(0)
#endif


#ifdef  __cplusplus
 }
#endif


 
