#include  "include_c.h"
#pragma hdrstop


int  txt2bintxt( const char* src_path, const char* dst_path );

/***********************************************************************
  <<< [_tmain] >>> 
************************************************************************/
int _tmain(int argc, _TCHAR* argv[])
{
  int  e;
  char*  src_path = ( argc > 1 ? argv[1] : "" );
  char*  dst_path = ( argc > 2 ? argv[2] : "" );

  if ( src_path[0] == '\0' || dst_path[0] == '\0' )  return  1;
  e= txt2bintxt( src_path, dst_path );
  return  e;
}


/***********************************************************************
  <<< [txt2bintxt] >>> 
************************************************************************/
int  txt2bintxt( const char* src_path, const char* dst_path )
{
  int    e,ee;
  errno_t  et;
  FILE*  f  = NULL;
  FILE*  wf = NULL;
  unsigned char* p;
  unsigned char  c;
  unsigned char  wc;
  unsigned char  line[4096];

  et = _tfopen_s( &f,  src_path, _T("rb") ); IF(et)goto err_no;
  et = _tfopen_s( &wf, dst_path, _T("wb") ); IF(et)goto err_no;
  for (;;) {
    line[0] = '\0';
    fgets( line, sizeof(line), f );
    if ( line[0] == '\0' )  break;
    if ( line[0] == 0xFF ) {
      for ( p = line + 1;  *p != '\0';  ) {
        c = *p;  p++;
        wc = 1;
        if ( c >= '0' && c <= '9' )  wc = ( c - '0' ) << 4;
        if ( c >= 'A' && c <= 'F' )  wc = ( c - 'A' + 0xA ) << 4;
        if ( c >= 'a' && c <= 'f' )  wc = ( c - 'a' + 0xA ) << 4;
        if ( wc != 1 ) {
          c = *p;  p++;
          if ( c >= '0' && c <= '9' )  wc |= ( c - '0' );
          if ( c >= 'A' && c <= 'F' )  wc |= ( c - 'A' + 0xA );
          if ( c >= 'a' && c <= 'f' )  wc |= ( c - 'a' + 0xA );
          fputc( wc, wf );
        }
      }
    }
    else {
      fputs( line, wf );
    }
    if ( feof( f ) )  break;
  }
  e=0;
fin:
  if(f!=NULL) {ee= fclose( f );  IF(ee&&!e)e=Err_Errno;}
  if(wf!=NULL){ee= fclose( wf ); IF(ee&&!e)e=Err_Errno;}
  return  e;
err_no: e= Err_Errno; goto fin;
}
