#include <include_c.h> 
#pragma hdrstop


int    g_Error4_ErrCount = 0;
TCHAR  g_Error4_Msg_forOriginal[4096];
#ifdef  USES_PRINT2
 int  stprintf_r( TCHAR* s, size_t s_size, const TCHAR* format, ... );
 int  vstprintf_r( TCHAR* s, size_t s_size, const TCHAR* format, va_list va );
#endif

 
/***********************************************************************
  <<< [Error4_raise] >>> 
************************************************************************/
int  Error4_raise( int err_num )
{
  g_Error4_ErrCount++;

  return  err_num;
}

 
/***********************************************************************
  <<< [Error4_clear] >>> 
************************************************************************/
void  Error4_clear( int err_num )
{
  switch ( err_num ) {

    case  Err_GetLastError:
      SetLastError( 0 );
      break;

    default:
      g_Error4_Msg_forOriginal[0] = '\0';
      break;
  }
}



 
/***********************************************************************
  <<< [Error4_getErrCount] >>> 
************************************************************************/
int  Error4_getErrCount()
{
  return  g_Error4_ErrCount;
}



 
/***********************************************************************
  <<< [Error4_getErrStr] >>> 
************************************************************************/
void  Error4_getErrStr( int err_num, TCHAR* msg, int msg_size )
{
  switch ( err_num ) {

   #ifdef  USES_PRINT2
    case  0:
      stprintf_r( msg, msg_size, _T("no error") );
      break;

    case  Err_GetLastError:
      stprintf_r( msg, msg_size, _T("[ERROR] GetLastError = 0x%08X"), GetLastError() );
      break;

    default:
      if ( g_Error4_Msg_forOriginal[0] != '\0' )
        stprintf_r( msg, msg_size, _T("%s"), g_Error4_Msg_forOriginal );
      else
        stprintf_r( msg, msg_size, _T("[ERROR] %d"), err_num );
      break;
   #else
    if ( msg_size > 6 * sizeof(TCHAR) ) {
      msg[0] = _T('E');  msg[1] = _T('R');  msg[2] = _T('R');
      msg[3] = _T('O');  msg[4] = _T('R');  msg[5] = _T('\0');
    }
   #endif
  }
}



 
/***********************************************************************
  <<< [Error4_printf] >>> 
************************************************************************/
void  Error4_printf( const TCHAR* format, ... )
{
  #define  _s  g_Error4_Msg_forOriginal
  #ifdef  USES_PRINT2
    va_list  va;
    va_start( va, format );
    vstprintf_r( _s, sizeof(_s), format, va );
    va_end( va );
  #else
    _s[0] = _T('E');  _s[1] = _T('R');  _s[2] = _T('R');
    _s[3] = _T('O');  _s[4] = _T('R');  _s[5] = _T('\0');
  #endif
  #undef  _s
}


