/* The header file was composed by module mixer */ 
#ifdef _MSC_VER
 #if  showIncludes
  #pragma message( "start of #include  \"" __FILE__ "\"" )
 #endif
#endif

#ifndef  __CLIB_H
#define  __CLIB_H


 
/*=================================================================*/
/* <<< [CRT/CRT.h] >>> */ 
/*=================================================================*/
 
#include  <stdio.h> 
#ifdef  __linux__
	#define  _tfopen_s( out_File, Path, Mode ) \
		( *(out_File) = fopen( Path, Mode ),  (*(out_File) == NULL) ? (1) : (0) )
#endif
 
#include  <string.h> 
 
#include  <stdarg.h> 
#ifdef  __linux__
	#define  _vsnprintf  vsnprintf
#endif
 
#include  <crtdbg.h> 
 
#ifndef  __linux__
	#include  <tchar.h> 
#else
	#define  _T(x)  x
	typedef  char  TCHAR;
	#define  _tcschr   strchr
	#define  _tprintf  printf
#endif
 
#include  <locale.h> 

#if UNDER_CE
  #define  setlocale( x, y )
#endif
 
#include  <errno.h> 
#ifdef  __linux__
	typedef  int  errno_t;  // CERT DCL09-C
#endif
 
#include  <assert.h> 
 
#include  <direct.h> 
 
/*=================================================================*/
/* <<< [CRT_plus/CRT_plus.h] >>> */ 
/*=================================================================*/
 
/***********************************************************************
  <<< [fopen_ccs] >>> 
************************************************************************/
#if defined(_UNICODE) 
  #define  fopen_ccs  ",ccs=UNICODE"
#else
  #define  fopen_ccs  "t"
#endif


 
/***********************************************************************
  <<< [C99Type] >>> 
************************************************************************/
typedef  signed int    int32_t;  /* for 32bit compiler */
typedef  signed short  int16_t;
typedef  signed char   int8_t;
typedef  unsigned int    uint_t;
typedef  unsigned int    uint32_t;  /* for 32bit compiler */
typedef  unsigned short  uint16_t;
typedef  unsigned char   uint8_t;
typedef  float   float32_t;
typedef  double  float64_t;
typedef  char    bool_t;  /* this is not C99 */


 
/***********************************************************************
  <<< [bool type] >>> 
************************************************************************/
#ifndef  __cplusplus
 #ifndef  BOOL_DEFINED
  typedef unsigned char   bool;
  enum  { true = 1, false = 0 };
 #define  BOOL_DEFINED
 #endif
#endif


 
/*********************************************************************************************
  <<< [BitField] [BIT_FIELD_ENDIAN] [BIT_FIELD_LITTLE_ENDIAN] [BIT_FIELD_BIG_ENDIAN] >>> 
**********************************************************************************************/
typedef  unsigned int  BitField; 
typedef  uint32_t      BitField32;
#define  BIT_FIELD_ENDIAN           BIT_FIELD_LITTLE_ENDIAN
#define  BIT_FIELD_LITTLE_ENDIAN    1
#define  BIT_FIELD_BIG_ENDIAN       2


 
/***********************************************************************
  <<< [inline] [SUPPORT_INLINE_C_FUNC] [NOT_USE_INLINE_MACRO] >>> 
************************************************************************/
#ifndef  SUPPORT_INLINE_C_FUNC
  #define  SUPPORT_INLINE_C_FUNC  1
#endif
#ifndef  INLINE
  #if ! __cplusplus
    #if SUPPORT_INLINE_C_FUNC
      #define  inline  _inline     /* inline is specified under C99 */
    #endif
  #endif
#endif

#ifndef  NOT_USE_INLINE_MACRO
  #define  NOT_USE_INLINE_MACRO  0
#endif


 
/***********************************************************************
  <<< [FuncType] [FinishFuncType] >>> 
************************************************************************/
typedef  int (*FuncType)( void* Param ); 
typedef  int (*FinishFuncType)( void* m, int e );


 
/*=================================================================*/
/* <<< [Error4/Error4.h] >>> */ 
/*=================================================================*/
 
#if  __cplusplus
 extern "C" {  /* Start of C Symbol */ 
#endif


/***********************************************************************
  <<< [errnum_t] >>> 
************************************************************************/
typedef  int  errnum_t;  /* 0=no error */
enum { NoError = 0 };
enum { Error4_Err_Base = 0x00000400 };  /* 0x001, 0x400 .. 0x4FF : Reseved meaning by clib */
enum { Error4_Err_Mask = 0xFFFFFF00 };
enum { E_Others          = 0x001 }; /*    1 */
enum { E_Original        = 0x101 }; /*  257 */
enum { E_GetLastError    = 0x401 }; /* 1025 */
enum { E_HResult         = 0x402 }; /* 1026 */
enum { E_Errno           = 0x403 }; /* 1027 */
enum { E_Unknown         = 0x404 }; /* 1028 */
enum { E_InError         = 0x405 }; /* 1029 */
enum { E_InFinally       = 0x406 }; /* 1030 */
enum { E_InvalidValue    = 0x407 }; /* 1031 */
enum { E_NotImplementYet = 0x409 }; /* 1033 */
enum { E_Limitation      = 0x40F }; /* 1039 */
enum { E_FewMemory       = 0x410 }; /* 1040 */
enum { E_FewArray        = 0x411 }; /* 1041 */
enum { E_CannotOpenFile  = 0x412 }; /* 1042 */
enum { E_NotFoundDllFunc = 0x413 }; /* 1043 */
enum { E_BadCmdID        = 0x414 }; /* 1044 */
enum { E_NotFoundSymbol  = 0x415 }; /* 1045 */
enum { E_NoNext          = 0x416 }; /* 1046 */
enum { E_AccessDenied    = 0x417 }; /* 1047 */
enum { E_PathNotFound    = 0x418 }; /* 1048 */
enum { E_OutOfWritable   = 0x425 }; /* 1061 */
enum { E_NotInitGlobal   = 0x46B }; /* 1131 */
enum { E_DebugBreak      = 0x4DB }; /* 1243 */
enum { E_ExitTest        = 0x4E7 }; /* 1255 */


 
/***********************************************************************
  <<< [Err2_setBreakErrID] >>> 
************************************************************************/
#ifndef  ERR2_ENABLE_ERROR_BREAK
	#if ! NDEBUG
		#define  ERR2_ENABLE_ERROR_BREAK  1
	#else
		#define  ERR2_ENABLE_ERROR_BREAK  0
	#endif
#endif

#if ERR2_ENABLE_ERROR_BREAK
	#define  IF(x)    if( (x) && ( TryOnIfTrue_imp() ? (TestableDebugBreak(),1) : (1) ) )
	#define  IF_D(x)  IF(x)

	#define  ASSERT_R( x, goto_err_or_Statement ) \
		__pragma(warning(push)) \
		__pragma(warning(disable:4127)) \
			do{  IF(!(x)) goto_err_or_Statement;  }  while(0)   /* do-while is CERT standard PRE10-C */ \
		__pragma(warning(pop))

	#define  ASSERT_D( x, goto_err_or_Statement )  ASSERT_R( x, goto_err_or_Statement )
#else
	#define  IF(x)  if(x)
	#define  IF_D(x) \
		__pragma(warning(push)) \
		__pragma(warning(disable:4127)) \
			if(0) \
		__pragma(warning(pop))

	#define  ASSERT_R( x, goto_err_or_Statement ) \
		__pragma(warning(push)) \
		__pragma(warning(disable:4127)) \
			do{  if(!(x)) goto_err_or_Statement;  }while(0)   /* do-while is CERT standard PRE10-C */ \
		__pragma(warning(pop))

	#define  ASSERT_D( x, goto_err_or_Statement )
#endif


#if ! ERR2_ENABLE_ERROR_BREAK
	#define  Err2_setBreakErrID( x )
	#define  Err2_clear()
	#define  IfErrThenBreak()
	typedef  int  ErrStackAreaClass;  // dummy type
	#define  PushErr( ErrStackArea )  UNREFERENCED_VARIABLES( ErrStackArea )
	#define  PopErr(  ErrStackArea )  UNREFERENCED_VARIABLES( ErrStackArea )
#else
	void  Err2_setBreakErrID( int ID );
	void  Err2_clear(void);
	void  IfErrThenBreak(void);
	typedef  struct _Err2  ErrStackAreaClass;
	void  PushErr( ErrStackAreaClass* ErrStackArea );
	void  PopErr(  ErrStackAreaClass* ErrStackArea );

	int   TryOnIfTrue_imp(void);

	typedef  struct _Err2  Err2;
	struct _Err2 {
		int  ErrID;
		int  BreakErrID;
		int  IsErr;
	};
	extern  Err2  g_Err2;
#endif


 
/***********************************************************************
  <<< [DEBUG_TRUE, DEBUG_FALSE] >>> 
************************************************************************/
#if ! NDEBUG
 #define  DEBUG_TRUE   1
 #define  DEBUG_FALSE  0
#else
 #define  DEBUG_TRUE   __cut_on_debug =
 #define  DEBUG_FALSE  0
#endif


 
/***********************************************************************
  <<< [DEBUG_CODE] >>> 
************************************************************************/
#if ! NDEBUG
	#define  DEBUG_CODE( expression ) \
		__pragma(warning(push)) \
		__pragma(warning(disable:4127)) \
			do { expression; } while(0)   /* do-while is CERT standard PRE10-C */ \
		__pragma(warning(pop))
#else
	#define  DEBUG_CODE( expression )  /* no execute */
#endif


 
/***********************************************************************
  <<< [CHECK_ARG] >>> 
************************************************************************/
#ifndef  CHECK_ARG
  #define  CHECK_ARG  1
#endif

/*[GetIsCheckArg][SetIsCheckArg]*/
extern bool  g_IsCheckArg;
inline bool  GetIsCheckArg(void)  { return  g_IsCheckArg; }
inline void  SetIsCheckArg( bool IsCheckArg )  { g_IsCheckArg = IsCheckArg; }


 
/***********************************************************************
  <<< [MEMSET_TO_NOT_INIT] >>> 
************************************************************************/
#ifndef  USE_MEMSET_TO_NOT_INIT
 #if ! NDEBUG
  #define  USE_MEMSET_TO_NOT_INIT  1
 #else
  #define  USE_MEMSET_TO_NOT_INIT  0
 #endif
#endif

#if  USE_MEMSET_TO_NOT_INIT
  #define  MEMSET_TO_NOT_INIT( Address, ByteSize )  memset( Address, 0xDE, ByteSize )
#else
  #define  MEMSET_TO_NOT_INIT( Address, ByteSize )
#endif

 
/***********************************************************************
  <<< [NAME_STR] >>> 
************************************************************************/
#ifndef  NAME_STR
 #if ! NDEBUG
  #define  NAME_STR  1
 #else
  #define  NAME_STR  0
 #endif
#endif

 
/***********************************************************************
  <<< [UNREFERENCED_VARIABLES] >>> 
************************************************************************/
#ifdef  __linux__
	#define  UNREFERENCED_VARIABLES( x )
#else
	#define  UNREFERENCED_VARIABLES( x )  x
#endif


 
#if  __cplusplus
 }  /* End of C Symbol */ 
#endif
 
/*=================================================================*/
/* <<< [DebugTools/DebugTools.h] >>> */ 
/*=================================================================*/
 
#if  __cplusplus
 extern "C" {  /* Start of C Symbol */ 
#endif


#ifndef NDEBUG
  #define  NDEBUG_ERROR
#else
  #define  NDEBUG_ERROR  ___cut_NDEBUG_ERROR
#endif

 
#ifndef  dll_global_g_DebugBreakCount
	#define  dll_global_g_DebugBreakCount  /* [dll_global_g_DebugBreakCount_NotDLL] */
#endif
 
/***********************************************************************
  <<< [TestableDebugBreak] >>> 
************************************************************************/
#define  TestableDebugBreak()  ( g_DebugBreakCount++, (TestableDebugBreak_isEnabled() ? (DebugBreak(),0) : 0 ) )
int      TestableDebugBreak_isEnabled(void);
dll_global_g_DebugBreakCount extern  int  g_bTestableDebugBreak_Disable;
dll_global_g_DebugBreakCount extern  int  g_DebugBreakCount;


 
#if  __cplusplus
 }  /* End of C Symbol */ 
#endif


 
/*=================================================================*/
/* <<< [Print/Print2.h] >>> */ 
/*=================================================================*/
 
#if  __cplusplus
 extern "C" {  /* Start of C Symbol */ 
#endif
 
/***********************************************************************
  <<< [USE_printf_to] >>> 
************************************************************************/
#define  USE_printf_to_stdout    1
#define  USE_printf_to_debugger  2
#define  USE_printf_to_file      3


 
/***********************************************************************
  <<< [PrintfCounterClass] >>> 
************************************************************************/
#if USE_PRINTF_COUNTER

typedef struct _PrintfCounterClass  PrintfCounterClass;
struct _PrintfCounterClass {
	int  Count;
	int  BreakCount;
	int  BreakIndent;
};
extern PrintfCounterClass  g_PrintfCounter;

#endif


 
/***********************************************************************
  <<< [printf_to_debugger] >>> 
************************************************************************/
void   printf_to_debugger( const char* fmt, ... );
void  wprintf_to_debugger( const wchar_t* fmt, ... );

#ifndef   USE_printf_to
 #ifdef __linux__
  #define  USE_printf_to  USE_printf_to_stdout
 #else
  #define  USE_printf_to  USE_printf_to_debugger
 #endif
#endif

#if  USE_printf_to == USE_printf_to_debugger
 #define  printf   printf_to_debugger
 #define  wprintf  wprintf_to_debugger

 #undef    _tprintf
 #if UNICODE
  #define  _tprintf  wprintf_to_debugger
 #else
  #define  _tprintf  printf_to_debugger
 #endif
#endif

 
int  vsprintf_r( char* s, size_t s_size, const char* format, va_list va ); 
 
int  vswprintf_r( wchar_t* s, size_t s_size, const wchar_t* format, va_list va ); 
 
/*[vstprintf_r]*/
#if defined(_UNICODE) 
  #define  vstprintf_r  vswprintf_r
#else
  #define  vstprintf_r  vsprintf_r
#endif
 
int  stprintf_r( TCHAR* s, size_t s_size, const TCHAR* format, ... ); 
 
int  stcpy_part_r( TCHAR* s, size_t s_size, TCHAR* s_start, TCHAR** p_s_last, 
                   const TCHAR* src, const TCHAR* src_over );
int  stprintf_part_r( TCHAR* s, size_t s_size, TCHAR* s_start, TCHAR** p_s_last,
                      const TCHAR* format, ... );
 
#if  __cplusplus
 }    /* End of C Symbol */ 
#endif

 
/*=================================================================*/
/* <<< [StrT/StrT.h] >>> */ 
/*=================================================================*/
 
#if  __cplusplus
 extern "C" {  /* Start of C Symbol */ 
#endif

int  StrT_cpy( TCHAR* Dst, size_t DstSize, const TCHAR* Src );
int  StrT_cat( TCHAR* Dst, size_t DstSize, const TCHAR* Src );
#define  StrT_cat( Dst, DstSize, Src ) \
	stcpy_part_r( Dst, sizeof(Dst), _tcschr( Dst, _T('\0') ), NULL, Src, NULL )
TCHAR*  StrT_malloc_cpy( const TCHAR* Src );
TCHAR*  StrT_malloc_cpy_from_char( const char* Src );
TCHAR*  StrT_chrs( const TCHAR* s, const TCHAR* keys );
TCHAR*  StrT_skip( const TCHAR* s, const TCHAR* keys );


 
/***********************************************************************
  <<< [StrT_Path] >>> 
************************************************************************/
enum { StrT_LocalPathMaxSize = 4096 };
TCHAR*  StrT_refFName( const TCHAR* s );
TCHAR*  StrT_refExt( const TCHAR* s );
bool  StrT_isAbsPath( const TCHAR* s );
#define  StrT_getAbsPath( out_AbsPath, AbsPathSize, StepPath, BasePath ) \
	StrT_getAbsPath_part( out_AbsPath, AbsPathSize, out_AbsPath, NULL, StepPath, BasePath )
#define  StrT_getParentAbsPath( Str, StrSize, StepPath, BasePath ) \
	StrT_getParentAbsPath_part( Str, StrSize, Str, NULL, StepPath, BasePath )
int  StrT_getAbsPath_part( TCHAR* Str, size_t StrSize, TCHAR* StrStart,
	TCHAR** out_StrLast, const TCHAR* StepPath, const TCHAR* BasePath );
int  StrT_getParentAbsPath_part( TCHAR* Str, size_t StrSize, TCHAR* StrStart,
	TCHAR** out_StrLast, const TCHAR* StepPath, const TCHAR* BasePath );
int  StrT_getBaseName_part( TCHAR* Str, size_t StrSize, TCHAR* StrStart,
	TCHAR** out_StrLast, const TCHAR* SrcPath );
#define  StrT_getBaseName( Str, StrSize, SrcPath ) \
	StrT_getBaseName_part( Str, StrSize, Str, NULL, SrcPath )
int  StrT_addLastOfFileName( TCHAR* out_Path, size_t PathSize,
                             const TCHAR* BasePath, const TCHAR* AddName );

 
#if  __cplusplus
 }  /* End of C Symbol */ 
#endif

 
/*=================================================================*/
/* <<< [FileT/FileT.h] >>> */ 
/*=================================================================*/
 
#if  __cplusplus
 extern "C" {  /* Start of C Symbol */ 
#endif

#define  FileT_isExistWildcard  1
bool  FileT_isExist( const TCHAR* path );
bool  FileT_isFile( const TCHAR* path );
bool  FileT_isDir( const TCHAR* path );
int   FileT_isDiff( const TCHAR* Path1, const TCHAR* Path2, bool* bDiff );
int   FileT_isSameText( TCHAR* Path1, TCHAR* Path2, int Format1, int Format2, bool* out_bSame );
int   FileT_isSameBinaryFile( const TCHAR* PathA, const TCHAR* PathB, int Flags, bool* out_IsSame );


 
/* FileT_CallByNestFindData */ 
typedef struct {
  void*     CallerArgument;
  TCHAR*    AbsPath;  // abstruct path
  TCHAR*    StepPath;
  TCHAR*    FileName;
  DWORD     FileAttributes;
} FileT_CallByNestFindData;

int  FileT_callByNestFind( const TCHAR* Path, BitField Flags, void* Obj, FuncType Callback );

enum { FileT_FolderBeforeFiles = 1 };
enum { FileT_FolderAfterFiles  = 2 };
enum { FileT_Folder = FILE_ATTRIBUTE_DIRECTORY };

 
/***********************************************************************
  <<< [FileT_Read] >>> 
************************************************************************/
int  FileT_openForRead( FILE** out_pFile, const TCHAR* path );
int  FileT_close( FILE* File, int e );



 
/***********************************************************************
  <<< [FileT_Write] >>> 
************************************************************************/
int  FileT_openForWrite( FILE** out_pFile, const TCHAR* Path, int Flags );

enum { F_Unicode = 1,  F_Append = 2 };

int  FileT_copy( const TCHAR* SrcPath, const TCHAR* DstPath );
int  FileT_mkdir( const TCHAR* Path );
int  FileT_del( const TCHAR* Path );


 
/***********************************************************************
  <<< [Writables] >>> 
************************************************************************/
#ifndef  Uses_AppKey
#define  Uses_AppKey  1
#endif

typedef void*  AppKey;
typedef struct _Writables  Writables;

int  AppKey_newWritable( AppKey** in_out_m,  Writables** out_Writable,  ... );
void AppKey_initGlobal_const(void);
int  AppKey_finishGlobal( int e );
int  AppKey_addNewWritableFolder( const TCHAR* Path );


struct _Writables {
  TCHAR**   m_Paths;  // array of array of TCHAR
  int       m_nPath;  // -1= not inited
};

int   Writables_delete( Writables* m, int e );

int   Writables_add( Writables* m, AppKey* Key, TCHAR* Path );
int   Writables_remove( Writables* m, TCHAR* Path );

int   Writables_enable( Writables* m );
int   Writables_disable( Writables* m, int e );

extern  Writables  g_CurrentWritables;


 
#if  __cplusplus
 }  /* End of C Symbol */ 
#endif
 
/*=================================================================*/
/* <<< [Locale/Locale.h] >>> */ 
/*=================================================================*/
 
#if  __cplusplus
 extern "C" {  /* Start of C Symbol */ 
#endif


 
/***********************************************************************
  <<< [Locale] >>> 
************************************************************************/
extern char*  g_LocaleSymbol;
int  Locale_init(void);
int  Locale_isInited(void);
 
#if  __cplusplus
 }  /* End of C Symbol */ 
#endif


 
/*=================================================================*/
/* <<< [PlatformSDK_plus/PlatformSDK_plus.h] >>> */ 
/*=================================================================*/
 
#if  __cplusplus
 extern "C" {  /* Start of C Symbol */ 
#endif


 
#include  <shlwapi.h> 
#pragma comment(lib, "shlwapi.lib")


 
int  GetCommandLineUnnamed( int Index1, TCHAR* out_AParam, size_t AParamSize ); 
int  GetCommandLineNamed( const TCHAR* Name, bool bCase, TCHAR* out_Value, size_t ValueSize );
int  GetCommandLineNamedC8( const TCHAR* Name, bool bCase, char* out_Value, size_t ValueSize );
int  GetCommandLineNamedI( const TCHAR* Name, bool bCase, int* out_Value );
bool GetCommandLineExist( const TCHAR* Name, bool bCase );

#if ! _UNICODE
  #define  GetCommandLineNamedC8  GetCommandLineNamed
#endif

 
/* [env] */ 
#define  env( Str, StrSize, Input ) \
  env_part( Str, StrSize, Str, NULL, Input )
int  env_part( TCHAR* Str,  unsigned StrSize,  TCHAR* StrStart, TCHAR** out_StrLast,
   const TCHAR* Input );
int  env_malloc( TCHAR** out_Value, size_t* out_ValueLen, const TCHAR* Name );


 
#if  __cplusplus
 }  /* End of C Symbol */ 
#endif
 
/*=================================================================*/
/* <<< [Global0/Global0.h] >>> */ 
/*=================================================================*/
 
#if  __cplusplus
 extern "C" {  /* Start of C Symbol */ 
#endif


 
/***********************************************************************
  <<< [Globals] >>> 
************************************************************************/
#define  USE_GLOBALS  1

void Globals_init_const(void);
int  Globals_init(void);
int  Globals_finish( int e );

#if NDEBUG
  #define  get_InitedObject( m, isInited )  (m)
#else
  #define  get_InitedObject( m, isInited )  ( isInited( m ) ? (m) : (DebugBreak(), (m)) )
#endif


 
#if  __cplusplus
 }  /* End of C Symbol */ 
#endif
 
#endif  // __CLIB_H 

#ifdef _MSC_VER
 #if  showIncludes
  #pragma message( "end of #include  \"" __FILE__ "\"" )
 #endif
#endif
 
