/* The header file was composed by module mixer */ 
#ifdef _MSC_VER
 #if  showIncludes
  #pragma message( "start of #include  \"" __FILE__ "\"" )
 #endif
#endif

#ifndef  __CLIB_H
#define  __CLIB_H


 
/*=================================================================*/
/* <<< [CRT/CRT.h] >>> */ 
/*=================================================================*/
 
#include  <stdio.h> 
#ifdef  __linux__
	#define  _tfopen_s( out_File, Path, Mode ) \
		( *(out_File) = fopen( Path, Mode ),  (*(out_File) == NULL) ? (1) : (0) )
#endif
 
#include  <string.h> 
 
#include  <stdarg.h> 
#ifdef  __linux__
	#define  _vsnprintf  vsnprintf
#endif
 
#ifndef  __linux__
	#include  <tchar.h> 
#else
	#define  _T(x)  x
	typedef  char  TCHAR;
	#define  _tcschr   strchr
	#define  _tprintf  printf
#endif
 
#include  <locale.h> 

#if UNDER_CE
  #define  setlocale( x, y )
#endif
 
#include  <errno.h> 
#ifdef  __linux__
	typedef  int  errno_t;  // CERT DCL09-C
#endif
 
#include  <assert.h> 
 
#include  <direct.h> 
 
/*=================================================================*/
/* <<< [CRT_plus/CRT_plus.h] >>> */ 
/*=================================================================*/
 
/***********************************************************************
  <<< [fopen_ccs] >>> 
************************************************************************/
#if defined(_UNICODE) 
  #define  fopen_ccs  ",ccs=UNICODE"
#else
  #define  fopen_ccs  "t"
#endif


 
/***********************************************************************
  <<< [C99Type] >>> 
************************************************************************/
typedef  signed int    int32_t;  /* for 32bit compiler */
typedef  signed short  int16_t;
typedef  signed char   int8_t;
typedef  unsigned int    uint_t;
typedef  unsigned int    uint32_t;  /* for 32bit compiler */
typedef  unsigned short  uint16_t;
typedef  unsigned char   uint8_t;
typedef  float   float32_t;
typedef  double  float64_t;
typedef  char    bool_t;  /* this is not C99 */


 
/***********************************************************************
  <<< [bool type] >>> 
************************************************************************/
#ifndef  __cplusplus
 #ifndef  BOOL_DEFINED
  typedef unsigned char   bool;
  enum  { true = 1, false = 0 };
 #define  BOOL_DEFINED
 #endif
#endif


 
/*********************************************************************************************
  <<< [BitField] [BIT_FIELD_ENDIAN] [BIT_FIELD_LITTLE_ENDIAN] [BIT_FIELD_BIG_ENDIAN] >>> 
**********************************************************************************************/
typedef  unsigned int  BitField; 
typedef  uint32_t      BitField32;
#define  BIT_FIELD_ENDIAN           BIT_FIELD_LITTLE_ENDIAN
#define  BIT_FIELD_LITTLE_ENDIAN    1
#define  BIT_FIELD_BIG_ENDIAN       2


 
/***********************************************************************
  <<< [inline] [SUPPORT_INLINE_C_FUNC] [NOT_USE_INLINE_MACRO] >>> 
************************************************************************/
#ifndef  SUPPORT_INLINE_C_FUNC
  #define  SUPPORT_INLINE_C_FUNC  1
#endif
#ifndef  INLINE
  #if ! __cplusplus
    #if SUPPORT_INLINE_C_FUNC
      #define  inline  _inline     /* inline is specified under C99 */
    #endif
  #endif
#endif

#ifndef  NOT_USE_INLINE_MACRO
  #define  NOT_USE_INLINE_MACRO  0
#endif


 
/***********************************************************************
  <<< [FuncType] [FinishFuncType] >>> 
************************************************************************/
typedef  int (*FuncType)( void* Param ); 
typedef  int (*FinishFuncType)( void* m, int e );


 
/*=================================================================*/
/* <<< [Error4/Error4.h] >>> */ 
/*=================================================================*/
 
#if  __cplusplus
 extern "C" {  /* Start of C Symbol */ 
#endif


/***********************************************************************
  <<< [errnum_t] >>> 
************************************************************************/
typedef  int  errnum_t;  /* 0=no error */
enum { NoError = 0 };
enum { Error4_Err_Base = 0x00000400 };  /* 0x001, 0x400 .. 0x4FF : Reseved meaning by clib */
enum { Error4_Err_Mask = 0xFFFFFF00 };
enum { E_Others          = 0x001 }; /*    1 */
enum { E_Original        = 0x101 }; /*  257 */
enum { E_GetLastError    = 0x401 }; /* 1025 */
enum { E_HResult         = 0x402 }; /* 1026 */
enum { E_Errno           = 0x403 }; /* 1027 */
enum { E_Unknown         = 0x404 }; /* 1028 */
enum { E_InError         = 0x405 }; /* 1029 */
enum { E_InFinally       = 0x406 }; /* 1030 */
enum { E_InvalidValue    = 0x407 }; /* 1031 */
enum { E_NotImplementYet = 0x409 }; /* 1033 */
enum { E_Limitation      = 0x40F }; /* 1039 */
enum { E_FewMemory       = 0x410 }; /* 1040 */
enum { E_FewArray        = 0x411 }; /* 1041 */
enum { E_CannotOpenFile  = 0x412 }; /* 1042 */
enum { E_NotFoundDllFunc = 0x413 }; /* 1043 */
enum { E_BadCmdID        = 0x414 }; /* 1044 */
enum { E_NotFoundSymbol  = 0x415 }; /* 1045 */
enum { E_NoNext          = 0x416 }; /* 1046 */
enum { E_AccessDenied    = 0x417 }; /* 1047 */
enum { E_PathNotFound    = 0x418 }; /* 1048 */
enum { E_OutOfWritable   = 0x425 }; /* 1061 */
enum { E_NotInitGlobal   = 0x46B }; /* 1131 */
enum { E_DebugBreak      = 0x4DB }; /* 1243 */
enum { E_ExitTest        = 0x4E7 }; /* 1255 */


 
/***********************************************************************
  <<< [Err2_setBreakErrID] >>> 
************************************************************************/
#ifndef  ERR2_ENABLE_ERROR_BREAK
	#if ! NDEBUG
		#define  ERR2_ENABLE_ERROR_BREAK  1
	#else
		#define  ERR2_ENABLE_ERROR_BREAK  0
	#endif
#endif

#if ERR2_ENABLE_ERROR_BREAK
	#define  IF(x)    if( (x) && ( TryOnIfTrue_imp() ? (TestableDebugBreak(),1) : (1) ) )
	#define  IF_D(x)  IF(x)

	#define  ASSERT_R( x, goto_err_or_Statement ) \
		__pragma(warning(push)) \
		__pragma(warning(disable:4127)) \
			do{  IF(!(x)) goto_err_or_Statement;  }  while(0)   /* do-while is CERT standard PRE10-C */ \
		__pragma(warning(pop))

	#define  ASSERT_D( x, goto_err_or_Statement )  ASSERT_R( x, goto_err_or_Statement )
#else
	#define  IF(x)  if(x)
	#define  IF_D(x) \
		__pragma(warning(push)) \
		__pragma(warning(disable:4127)) \
			if(0) \
		__pragma(warning(pop))

	#define  ASSERT_R( x, goto_err_or_Statement ) \
		__pragma(warning(push)) \
		__pragma(warning(disable:4127)) \
			do{  if(!(x)) goto_err_or_Statement;  }while(0)   /* do-while is CERT standard PRE10-C */ \
		__pragma(warning(pop))

	#define  ASSERT_D( x, goto_err_or_Statement )
#endif


#if ! ERR2_ENABLE_ERROR_BREAK
	#define  Err2_setBreakErrID( x )
	#define  Err2_clear()
	#define  IfErrThenBreak()
	typedef  int  ErrStackAreaClass;  // dummy type
	#define  PushErr( ErrStackArea )  UNREFERENCED_VARIABLES( ErrStackArea )
	#define  PopErr(  ErrStackArea )  UNREFERENCED_VARIABLES( ErrStackArea )
#else
	void  Err2_setBreakErrID( int ID );
	void  Err2_clear(void);
	void  IfErrThenBreak(void);
	typedef  struct _Err2  ErrStackAreaClass;
	void  PushErr( ErrStackAreaClass* ErrStackArea );
	void  PopErr(  ErrStackAreaClass* ErrStackArea );

	int   TryOnIfTrue_imp(void);

	typedef  struct _Err2  Err2;
	struct _Err2 {
		int  ErrID;
		int  BreakErrID;
		int  IsErr;
	};
	extern  Err2  g_Err2;
#endif


 
/***********************************************************************
  <<< [ErrorMessage] >>> 
************************************************************************/
void  Error4_printf( const TCHAR* format, ... );
void  Error4_getErrStr( int ErrNum, TCHAR* out_ErrStr, size_t ErrStrSize );
void  Error4_clear( int err_num );


 
/***********************************************************************
  <<< [stdio] >>> 
************************************************************************/
void  Error4_showToStdErr( int err_num );


 
/***********************************************************************
  <<< [errno] >>> 
************************************************************************/
int  Error4_raiseErrno(void);

 
/***********************************************************************
  <<< [DEBUG_TRUE, DEBUG_FALSE] >>> 
************************************************************************/
#if ! NDEBUG
 #define  DEBUG_TRUE   1
 #define  DEBUG_FALSE  0
#else
 #define  DEBUG_TRUE   __cut_on_debug =
 #define  DEBUG_FALSE  0
#endif


 
/***********************************************************************
  <<< [DEBUG_CODE] >>> 
************************************************************************/
#if ! NDEBUG
	#define  DEBUG_CODE( expression ) \
		__pragma(warning(push)) \
		__pragma(warning(disable:4127)) \
			do { expression; } while(0)   /* do-while is CERT standard PRE10-C */ \
		__pragma(warning(pop))
#else
	#define  DEBUG_CODE( expression )  /* no execute */
#endif


 
/***********************************************************************
  <<< [CHECK_ARG] >>> 
************************************************************************/
#ifndef  CHECK_ARG
  #define  CHECK_ARG  1
#endif

/*[GetIsCheckArg][SetIsCheckArg]*/
extern bool  g_IsCheckArg;
inline bool  GetIsCheckArg(void)  { return  g_IsCheckArg; }
inline void  SetIsCheckArg( bool IsCheckArg )  { g_IsCheckArg = IsCheckArg; }


 
/***********************************************************************
  <<< [MEMSET_TO_NOT_INIT] >>> 
************************************************************************/
#ifndef  USE_MEMSET_TO_NOT_INIT
 #if ! NDEBUG
  #define  USE_MEMSET_TO_NOT_INIT  1
 #else
  #define  USE_MEMSET_TO_NOT_INIT  0
 #endif
#endif

#if  USE_MEMSET_TO_NOT_INIT
  #define  MEMSET_TO_NOT_INIT( Address, ByteSize )  memset( Address, 0xDE, ByteSize )
#else
  #define  MEMSET_TO_NOT_INIT( Address, ByteSize )
#endif

 
/***********************************************************************
  <<< [NAME_STR] >>> 
************************************************************************/
#ifndef  NAME_STR
 #if ! NDEBUG
  #define  NAME_STR  1
 #else
  #define  NAME_STR  0
 #endif
#endif

 
/***********************************************************************
  <<< [UNREFERENCED_VARIABLES] >>> 
************************************************************************/
#ifdef  __linux__
	#define  UNREFERENCED_VARIABLES( x )
#else
	#define  UNREFERENCED_VARIABLES( x )  x
#endif


 
#if  __cplusplus
 }  /* End of C Symbol */ 
#endif
 
/*=================================================================*/
/* <<< [DebugTools/DebugTools.h] >>> */ 
/*=================================================================*/
 
#if  __cplusplus
 extern "C" {  /* Start of C Symbol */ 
#endif


#ifndef NDEBUG
  #define  NDEBUG_ERROR
#else
  #define  NDEBUG_ERROR  ___cut_NDEBUG_ERROR
#endif

 
#ifndef  dll_global_g_DebugBreakCount
	#define  dll_global_g_DebugBreakCount  /* [dll_global_g_DebugBreakCount_NotDLL] */
#endif
 
/***********************************************************************
  <<< [TestableDebugBreak] >>> 
************************************************************************/
#define  TestableDebugBreak()  ( g_DebugBreakCount++, (TestableDebugBreak_isEnabled() ? (DebugBreak(),0) : 0 ) )
int      TestableDebugBreak_isEnabled(void);
dll_global_g_DebugBreakCount extern  int  g_bTestableDebugBreak_Disable;
dll_global_g_DebugBreakCount extern  int  g_DebugBreakCount;


 
#if  __cplusplus
 }  /* End of C Symbol */ 
#endif


 
/*=================================================================*/
/* <<< [Print/Print2.h] >>> */ 
/*=================================================================*/
 
#if  __cplusplus
 extern "C" {  /* Start of C Symbol */ 
#endif
 
int  vsprintf_r( char* s, size_t s_size, const char* format, va_list va ); 
 
int  vswprintf_r( wchar_t* s, size_t s_size, const wchar_t* format, va_list va ); 
 
/*[vstprintf_r]*/
#if defined(_UNICODE) 
  #define  vstprintf_r  vswprintf_r
#else
  #define  vstprintf_r  vsprintf_r
#endif
 
int  stprintf_r( TCHAR* s, size_t s_size, const TCHAR* format, ... ); 
 
int  stcpy_part_r( TCHAR* s, size_t s_size, TCHAR* s_start, TCHAR** p_s_last, 
                   const TCHAR* src, const TCHAR* src_over );
int  stprintf_part_r( TCHAR* s, size_t s_size, TCHAR* s_start, TCHAR** p_s_last,
                      const TCHAR* format, ... );
 
#if  __cplusplus
 }    /* End of C Symbol */ 
#endif

 
/*=================================================================*/
/* <<< [SetX/SetX.h] >>> */ 
/*=================================================================*/
 
#ifndef  __SETX_H 
#define  __SETX_H

#if  __cplusplus
 extern "C" {  /* Start of C Symbol */
#endif

 
/***********************************************************************
  <<< [Set2] >>> 
************************************************************************/
typedef  struct _Set2  Set2;
struct _Set2 {
  void*  First;
  void*  Next;
  void*  Over;
};

#define  Set2_initConst( m )  ( (m)->First = NULL, (m)->Next = NULL )
int  Set2_init( Set2* m, int FirstSize );
int  Set2_finish( Set2* m, int e );
#define  Set2_isInited( m )  ( (m)->First != NULL )

#define  Set2_alloc( m, pp, type ) \
  Set2_alloc_imp( m, (void*)(pp), sizeof(type) )

int  Set2_alloc_imp( Set2* m, void* pm, size_t size );

#define  Set2_freeLast( m, p, type, e ) \
  ( ((char*)(m)->Next - sizeof(type) == (char*)(p)) ? \
    (m)->Next = (p), (e) : \
    ((e)?(e):E_Others) )

#define  Set2_toEmpty( m ) \
  ( (m)->Next = (m)->First, 0 )

#define  Set2_expandIfOverByAddr( m, OverAddrBasedOnNowFirst ) \
  ( (void*)(OverAddrBasedOnNowFirst) <= (m)->Over ? 0 : \
    Set2_expandIfOverByAddr_imp( m, OverAddrBasedOnNowFirst ) )

#define  Set2_expandIfOverByOffset( m, Size ) \
  Set2_expandIfOverByAddr( m, (char*)(m)->First + (Size) )
int  Set2_expandIfOverByAddr_imp( Set2* m, void* OverAddrBasedOnNowFirst );

#define  Set2_allocMulti( m, out_pElem, ElemType, nElem ) \
  Set2_allocMulti_sub( m, out_pElem, sizeof(ElemType) * (nElem) )
int  Set2_allocMulti_sub( Set2* m, void* out_pElem, size_t ElemsSize );

#define  Set2_ref( m, iElem, out_pElem, ElemType ) \
  Set2_ref_imp( m, iElem, out_pElem, sizeof(ElemType) )

int  Set2_ref_imp( Set2* m, int iElem, void* out_pElem, size_t ElemSize );

#define  Set2_getCount( m, Type ) \
  ( (Type*)(m)->Next - (Type*)(m)->First )

#define  Set2_checkPtrInArr( m, p ) \
  ( (m)->First <= (p) && (p) < (m)->Over ? 0 : E_NotFoundSymbol )

int  Set2_separate( Set2* m, int NextSize, void** allocate_Array );

 
#if  __cplusplus
 }  /* End of C Symbol */ 
#endif
#endif
 
/*=================================================================*/
/* <<< [StrT/StrT.h] >>> */ 
/*=================================================================*/
 
#if  __cplusplus
 extern "C" {  /* Start of C Symbol */ 
#endif

int  StrT_cpy( TCHAR* Dst, size_t DstSize, const TCHAR* Src );
int  StrT_cat( TCHAR* Dst, size_t DstSize, const TCHAR* Src );
#define  StrT_cat( Dst, DstSize, Src ) \
	stcpy_part_r( Dst, sizeof(Dst), _tcschr( Dst, _T('\0') ), NULL, Src, NULL )
TCHAR*  StrT_malloc_cpy( const TCHAR* Src );
TCHAR*  StrT_malloc_cpy_from_char( const char* Src );
TCHAR*  StrT_chrs( const TCHAR* s, const TCHAR* keys );
TCHAR*  StrT_skip( const TCHAR* s, const TCHAR* keys );


 
/***********************************************************************
  <<< [StrT_Edit] >>> 
************************************************************************/
errnum_t  StrT_trim( TCHAR* out_Str, size_t out_Str_Size, const TCHAR* in_Str );
errnum_t  StrT_cutLastOf( TCHAR* in_out_Str, TCHAR Charactor );
errnum_t  StrT_cutLineComment( TCHAR* out_Str, size_t out_Str_Size, const TCHAR* in_Str, const TCHAR* CommentSign );
errnum_t  StrT_meltCmdLine( TCHAR* out_Str, size_t out_Str_Size, const TCHAR** pLine );
errnum_t  StrT_getExistSymbols( unsigned* out, bool bCase, const TCHAR* Str, const TCHAR* Symbols, ... );


 
/***********************************************************************
  <<< [StrT_Path] >>> 
************************************************************************/
enum { StrT_LocalPathMaxSize = 4096 };
TCHAR*  StrT_refFName( const TCHAR* s );
TCHAR*  StrT_refExt( const TCHAR* s );
bool  StrT_isAbsPath( const TCHAR* s );
#define  StrT_getAbsPath( out_AbsPath, AbsPathSize, StepPath, BasePath ) \
	StrT_getAbsPath_part( out_AbsPath, AbsPathSize, out_AbsPath, NULL, StepPath, BasePath )
#define  StrT_getParentAbsPath( Str, StrSize, StepPath, BasePath ) \
	StrT_getParentAbsPath_part( Str, StrSize, Str, NULL, StepPath, BasePath )
int  StrT_getAbsPath_part( TCHAR* Str, size_t StrSize, TCHAR* StrStart,
	TCHAR** out_StrLast, const TCHAR* StepPath, const TCHAR* BasePath );
int  StrT_getParentAbsPath_part( TCHAR* Str, size_t StrSize, TCHAR* StrStart,
	TCHAR** out_StrLast, const TCHAR* StepPath, const TCHAR* BasePath );
int  StrT_getBaseName_part( TCHAR* Str, size_t StrSize, TCHAR* StrStart,
	TCHAR** out_StrLast, const TCHAR* SrcPath );
#define  StrT_getBaseName( Str, StrSize, SrcPath ) \
	StrT_getBaseName_part( Str, StrSize, Str, NULL, SrcPath )
int  StrT_addLastOfFileName( TCHAR* out_Path, size_t PathSize,
                             const TCHAR* BasePath, const TCHAR* AddName );

 
/**************************************************************************
  <<< [Strs] >>> 
***************************************************************************/
typedef  struct _Strs  Strs;
struct _Strs {
	char*   MemoryAddress;   /* first memory = [ TCHAR* FirstStr | elem[] ],  other memory = [ elem[] ] */
	char*   MemoryOver;
	char*   NextElem;        /* elem = [ TCHAR* NextStr | TCHAR[] ] */
	TCHAR** PointerToNextStrInPrevElem;  /* first = &FirstStr,  other = &NextStr */
	TCHAR** Prev_PointerToNextStrInPrevElem;

	Strs*   FirstOfStrs;
	Strs*   NextStrs;
};

void Strs_initConst( Strs* m );
int  Strs_init( Strs* m );
int  Strs_finish( Strs* m, int e );
int  Strs_toEmpty( Strs* m );
bool Strs_isInited( Strs* m );
int  Strs_add( Strs* m, const TCHAR* Str, const TCHAR** out_pAlloc );
int  Strs_addBinary( Strs* m, const TCHAR* Str, const TCHAR* StrOver, const TCHAR** out_AllocStr );
int  Strs_freeLast( Strs* m, TCHAR* AllocStr );
int  Strs_toEmpty( Strs* m );
/* for ( Strs_forEach( Strs* m, TCHAR** in_out_Str ) ); */
TCHAR*  Strx_getFirst( Strs* m );
TCHAR*  Strx_getNext( Strs* m, TCHAR* Str );


#define  Strs_initConst( m )  ( (m)->MemoryAddress =  NULL )
#define  Strs_isInited( m )    ( (m)->MemoryAddress != NULL )

#define  Strs_forEach( m, pStr ) \
	*(pStr) = Strs_getFirst( m ); \
	*(pStr) != NULL; \
	*(pStr) = Strs_getNext( m, *(pStr) )

#define  Strs_getFirst( m ) \
	( *(TCHAR**) (m)->FirstOfStrs->MemoryAddress )

#define  Strs_getNext( m, p ) \
	( *( (TCHAR**)(p) - 1 ) )

#define  Strs_getFreeAddr( m )  ( (TCHAR*)( (m)->NextElem + sizeof(TCHAR*) ) )
#define  Strs_getFreeSize( m )  ( (m)->MemoryOver - (char*)(m)->NextElem - sizeof(TCHAR*) )
#define  Strs_getFreeCount( m ) ( Strs_getFreeSize( m ) / sizeof(TCHAR) )
#define  Strs_expandCount( m, c )  ( Strs_expandSize( (m), (c) * sizeof(TCHAR) ) )
int  Strs_expandSize( Strs* m, size_t FreeSize );
int  Strs_commit( Strs* m, TCHAR* StrOver );

 
/***********************************************************************
  <<< [StrArr] >>> 
************************************************************************/
typedef struct _StrArr  StrArr;
struct _StrArr {
	Set2  Array;  // array of TCHAR*
	Strs  Chars;
};

int  StrArr_init( StrArr* m );
int  StrArr_finish( StrArr* m, int e );

int  StrArr_add( StrArr* m, const TCHAR* Str, int* out_I );
int  StrArr_commit( StrArr* m );
int  StrArr_fillTo( StrArr* m, int n, const TCHAR* Str );
int  StrArr_toEmpty( StrArr* m );

#define  StrArr_initConst( m )   Set2_initConst( &(m)->Array )
#define  StrArr_getFreeAddr( m )  Strs_getFreeAddr( &(m)->Chars )
#define  StrArr_getFreeSize( m )  Strs_getFreeSize( &(m)->Chars )
#define  StrArr_getFreeCount( m ) Strs_getFreeCount( &(m)->Chars )
#define  StrArr_expandSize( m, sz )  Strs_expandSize( &(m)->Chars, sz )
#define  StrArr_expandCount( m, c )  Strs_expandCount( &(m)->Chars, c )
#define  StrArr_getArray( m )     ((TCHAR**)(m)->Array.First)
#define  StrArr_getN( m )         Set2_getCount( &(m)->Array, TCHAR* )


 
/***********************************************************************
  <<< [CSV] >>> 
************************************************************************/
int  StrT_meltCSV( TCHAR* out_Str, size_t out_Str_Size, const TCHAR** pCSV );
int  StrArr_parseCSV( StrArr* m, const TCHAR* CSVLine );


 
#if  __cplusplus
 }  /* End of C Symbol */ 
#endif

 
/*=================================================================*/
/* <<< [FileT/FileT.h] >>> */ 
/*=================================================================*/
 
#if  __cplusplus
 extern "C" {  /* Start of C Symbol */ 
#endif

#define  FileT_isExistWildcard  1
bool  FileT_isExist( const TCHAR* path );
bool  FileT_isFile( const TCHAR* path );
bool  FileT_isDir( const TCHAR* path );
int   FileT_isDiff( const TCHAR* Path1, const TCHAR* Path2, bool* bDiff );
int   FileT_isSameText( TCHAR* Path1, TCHAR* Path2, int Format1, int Format2, bool* out_bSame );
int   FileT_isSameBinaryFile( const TCHAR* PathA, const TCHAR* PathB, int Flags, bool* out_IsSame );


 
/* FileT_CallByNestFindData */ 
typedef struct {
  void*     CallerArgument;
  TCHAR*    AbsPath;  // abstruct path
  TCHAR*    StepPath;
  TCHAR*    FileName;
  DWORD     FileAttributes;
} FileT_CallByNestFindData;

int  FileT_callByNestFind( const TCHAR* Path, BitField Flags, void* Obj, FuncType Callback );

enum { FileT_FolderBeforeFiles = 1 };
enum { FileT_FolderAfterFiles  = 2 };
enum { FileT_Folder = FILE_ATTRIBUTE_DIRECTORY };

 
/***********************************************************************
  <<< [FileT_Read] >>> 
************************************************************************/
int  FileT_openForRead( FILE** out_pFile, const TCHAR* path );
int  FileT_close( FILE* File, int e );



 
#if  __cplusplus
 }  /* End of C Symbol */ 
#endif
 
/*=================================================================*/
/* <<< [Locale/Locale.h] >>> */ 
/*=================================================================*/
 
#if  __cplusplus
 extern "C" {  /* Start of C Symbol */ 
#endif


 
/***********************************************************************
  <<< [Locale] >>> 
************************************************************************/
extern char*  g_LocaleSymbol;
int  Locale_init(void);
int  Locale_isInited(void);
 
#if  __cplusplus
 }  /* End of C Symbol */ 
#endif


 
/*=================================================================*/
/* <<< [PlatformSDK_plus/PlatformSDK_plus.h] >>> */ 
/*=================================================================*/
 
#include  <shlwapi.h> 
#pragma comment(lib, "shlwapi.lib")


 
int  GetCommandLineUnnamed( int Index1, TCHAR* out_AParam, size_t AParamSize ); 
int  GetCommandLineNamed( const TCHAR* Name, bool bCase, TCHAR* out_Value, size_t ValueSize );
int  GetCommandLineNamedC8( const TCHAR* Name, bool bCase, char* out_Value, size_t ValueSize );
int  GetCommandLineNamedI( const TCHAR* Name, bool bCase, int* out_Value );
bool GetCommandLineExist( const TCHAR* Name, bool bCase );

#if ! _UNICODE
  #define  GetCommandLineNamedC8  GetCommandLineNamed
#endif

 
/*=================================================================*/
/* <<< [Global0/Global0.h] >>> */ 
/*=================================================================*/
 
#if  __cplusplus
 extern "C" {  /* Start of C Symbol */ 
#endif


 
/***********************************************************************
  <<< [Globals] >>> 
************************************************************************/
#define  USE_GLOBALS  1

void Globals_init_const(void);
int  Globals_init(void);
int  Globals_finish( int e );

#if NDEBUG
  #define  get_InitedObject( m, isInited )  (m)
#else
  #define  get_InitedObject( m, isInited )  ( isInited( m ) ? (m) : (DebugBreak(), (m)) )
#endif


 
#if  __cplusplus
 }  /* End of C Symbol */ 
#endif
 
#endif  // __CLIB_H 

#ifdef _MSC_VER
 #if  showIncludes
  #pragma message( "end of #include  \"" __FILE__ "\"" )
 #endif
#endif
 
