/* The header file was composed by module mixer */ 
#if  showIncludes
 #pragma message( "start of #include  \"" __FILE__ "\"" )
#endif

#ifndef  __CLIB_H
#define  __CLIB_H

 
/*=================================================================*/
/* <<< [CRT/CRT.h] >>> */ 
/*=================================================================*/
 
#include  <stdio.h> 
 
#include  <string.h> 
 
#include  <stdarg.h> 
 
#include  <tchar.h> 
 
#include  <locale.h> 

#if UNDER_CE
  #define  setlocale( x, y )
#endif
 
#include  <assert.h> 
 
#include  <direct.h> 
 
/*=================================================================*/
/* <<< [Error4/Error4.h] >>> */ 
/*=================================================================*/
 
#if  __cplusplus
 extern "C" {  /* Start of C Symbol */ 
#endif


typedef  int  ErrCode;
enum { NoError = 0 };
enum { Error4_Err_Base = 0x00000400 };
enum { Error4_Err_Mask = 0xFFFFFF00 };
enum { E_Others          = 0x001 }; /*    1 */
enum { E_Original        = 0x101 }; /*  257 */
enum { E_GetLastError    = 0x401 }; /* 1025 */
enum { E_HResult         = 0x402 }; /* 1026 */
enum { E_Errno           = 0x403 }; /* 1027 */
enum { E_Unknown         = 0x404 }; /* 1028 */
enum { E_InError         = 0x405 }; /* 1029 */
enum { E_InFinally       = 0x406 }; /* 1030 */
enum { E_InvalidValue    = 0x407 }; /* 1031 */
enum { E_NotImplementYet = 0x409 }; /* 1033 */
enum { E_FewMemory       = 0x410 }; /* 1040 */
enum { E_FewArray        = 0x411 }; /* 1041 */
enum { E_CannotOpenFile  = 0x412 }; /* 1042 */
enum { E_NotFoundDllFunc = 0x413 }; /* 1043 */
enum { E_BadCmdID        = 0x414 }; /* 1044 */
enum { E_NotFoundSymbol  = 0x415 }; /* 1045 */
enum { E_NoNext          = 0x416 }; /* 1046 */
enum { E_AccessDenied    = 0x417 }; /* 1047 */
enum { E_PathNotFound    = 0x418 }; /* 1048 */
enum { E_OutOfWritable   = 0x425 }; /* 1061 */
enum { E_NotInitGlobal   = 0x46B }; /* 1131 */
enum { E_DebugBreak      = 0x4DB }; /* 1243 */

 
/***********************************************************************
  <<< [Err2_setBreakErrID] >>> 
************************************************************************/
#ifndef  ERR2_ENABLE_ERROR_BREAK
  #if ! NDEBUG
    #define  ERR2_ENABLE_ERROR_BREAK  1
  #else
    #define  ERR2_ENABLE_ERROR_BREAK  0
  #endif
#endif

#if ERR2_ENABLE_ERROR_BREAK
  #define  IF(x)        if( (x) && ( TryOnIfTrue_imp() ? (TestableDebugBreak(),1) : (1) ) )
  #define  IF_D(x)      IF(x)
  #define  ASSERT_R(x)  IF(!(x)) goto err;
  #define  ASSERT_D(x)  ASSERT_R(x)
#else
  #define  IF(x)        if(x)
  #define  IF_D(x)      if(0)
  #define  ASSERT_R(x)  if(!(x)) goto err;
  #define  ASSERT_D(x)
#endif


#if ! ERR2_ENABLE_ERROR_BREAK
  #define  Err2_setBreakErrID( x )
  #define  Err2_clear()
  #define  IfErrThenBreak()
#else
  void  Err2_setBreakErrID( int ID );
  void  Err2_clear(void);
  void  IfErrThenBreak(void);

  int   TryOnIfTrue_imp(void);

  typedef  struct _Err2  Err2;
  struct _Err2 {
    int  ErrID;
    int  BreakErrID;
    int  IsErr;
  };
  extern  Err2  g_Err2;
#endif



 
/***********************************************************************
  <<< [ErrorMessage] >>> 
************************************************************************/
void  Error4_printf( const TCHAR* format, ... );
void  Error4_getErrStr( int err_num, TCHAR* msg, int msg_size );
void  Error4_clear( int err_num );


 
/***********************************************************************
  <<< [stdio] >>> 
************************************************************************/
void  Error4_showToStdErr( int err_num );


 
/***********************************************************************
  <<< [DEBUG_TRUE, DEBUG_FALSE] >>> 
************************************************************************/
#if ! NDEBUG
 #define  DEBUG_TRUE   1
 #define  DEBUG_FALSE  0
#else
 #define  DEBUG_TRUE   __cut_on_debug =
 #define  DEBUG_FALSE  0
#endif


 
/***********************************************************************
  <<< [CHECK_ARG] >>> 
************************************************************************/
#ifndef  CHECK_ARG
 #if ! NDEBUG
  #define  CHECK_ARG  1
 #else
  #define  CHECK_ARG  0
 #endif
#endif

 
/***********************************************************************
  <<< [MEMSET_TO_NOT_INIT] >>> 
************************************************************************/
#ifndef  USE_MEMSET_TO_NOT_INIT
 #if ! NDEBUG
  #define  USE_MEMSET_TO_NOT_INIT  1
 #else
  #define  USE_MEMSET_TO_NOT_INIT  0
 #endif
#endif

#if  USE_MEMSET_TO_NOT_INIT
  #define  MEMSET_TO_NOT_INIT( Address, ByteSize )  memset( Address, 0xDE, ByteSize )
#else
  #define  MEMSET_TO_NOT_INIT( Address, ByteSize )
#endif

 
/***********************************************************************
  <<< [NAME_STR] >>> 
************************************************************************/
#ifndef  NAME_STR
 #if ! NDEBUG
  #define  NAME_STR  1
 #else
  #define  NAME_STR  0
 #endif
#endif

 
/***********************************************************************
  <<< [USE_MACRO_FUNC] >>> 
************************************************************************/
#ifndef  USE_MACRO_FUNC
 #if ! NDEBUG
  #define  USE_MACRO_FUNC  0
 #else
  #define  USE_MACRO_FUNC  1
 #endif
#endif

 
#if  __cplusplus
 }  /* End of C Symbol */ 
#endif
 
/*=================================================================*/
/* <<< [CRT_plus/CRT_plus.h] >>> */ 
/*=================================================================*/
 
#if defined(_UNICODE) 
  #define  fopen_ccs  ",ccs=UNICODE"
#else
  #define  fopen_ccs  "t"
#endif


 
/* [bool type] */ 
#ifndef  __cplusplus
 #ifndef  BOOL_DEFINED
  typedef unsigned char   bool;
  enum  { true = 1, false = 0 };
 #define  BOOL_DEFINED
 #endif
#endif


 
typedef  unsigned int  BitField; 


 
typedef  int (*FuncType)( void* Param ); 
typedef  int (*FinishFuncType)( void* m, int e );


 
/*=================================================================*/
/* <<< [DebugTools/DebugTools.h] >>> */ 
/*=================================================================*/
 
#if  __cplusplus
 extern "C" {  /* Start of C Symbol */ 
#endif


#ifndef NDEBUG
  #define  NDEBUG_ERROR
#else
  #define  NDEBUG_ERROR  ___cut_NDEBUG_ERROR
#endif

 
/***********************************************************************
  <<< [TestableDebugBreak] >>> 
************************************************************************/
#define  TestableDebugBreak()  ( g_DebugBreakCount++, (g_bTestableDebugBreak_Disable ? 0 : DebugBreak() ) )
extern  int  g_bTestableDebugBreak_Disable;
extern  int  g_DebugBreakCount;


 
#if  __cplusplus
 }  /* End of C Symbol */ 
#endif


 
/*=================================================================*/
/* <<< [Globals_inc_redir_1/Globals_inc_redir_1.h] >>> */ 
/*=================================================================*/
 
#if ! DisableIncludeRedir_for_Globals
 #define  PrototypeRevRedir_to_Globals_Main  1 
  #include  "redir/clib_redir.h"
 #undef   PrototypeRevRedir_to_Globals_Main
#endif


 
/*=================================================================*/
/* <<< [SetX/SetX.h] >>> */ 
/*=================================================================*/
 
#ifndef  __SETX_H 
#define  __SETX_H

#if  __cplusplus
 extern "C" {  /* Start of C Symbol */
#endif

 
/***********************************************************************
  <<< [Set2] >>> 
************************************************************************/
typedef  struct _Set2  Set2;
struct _Set2 {
  void*  First;
  void*  Next;
  void*  Over;
};

#define  Set2_init_const( m )  ( (m)->First = NULL, (m)->Next = NULL )
int  Set2_init( Set2* m, int FirstSize );
int  Set2_finish( Set2* m, int e );
#define  Set2_isInited( m )  ( (m)->First != NULL )

#define  Set2_alloc( m, pp, type ) \
  Set2_alloc_imp( m, (void*)(pp), sizeof(type) )

int  Set2_alloc_imp( Set2* m, void* pm, size_t size );

#define  Set2_freeLast( m, p, type ) \
  ( (char*)(m)->Next - sizeof(type) == (char*)(p) ? (m)->Next = (p), 0 : E_Others )

#define  Set2_toEmpty( m ) \
  ( (m)->Next = (m)->First, 0 )

#define  Set2_expandIfOverByAddr( m, OverAddrBasedOnNowFirst ) \
  ( (void*)(OverAddrBasedOnNowFirst) <= (m)->Over ? 0 : \
    Set2_expandIfOverByAddr_imp( m, OverAddrBasedOnNowFirst ) )

#define  Set2_expandIfOverByOffset( m, Size ) \
  Set2_expandIfOverByAddr( m, (char*)(m)->First + (Size) )
int  Set2_expandIfOverByAddr_imp( Set2* m, void* OverAddrBasedOnNowFirst );

#define  Set2_allocMulti( m, out_pElem, ElemType, nElem ) \
  Set2_allocMulti_sub( m, out_pElem, sizeof(ElemType) * (nElem) )
int  Set2_allocMulti_sub( Set2* m, void* out_pElem, size_t ElemsSize );

#define  Set2_ref( m, iElem, out_pElem, ElemType ) \
  Set2_ref_imp( m, iElem, out_pElem, sizeof(ElemType) )

int  Set2_ref_imp( Set2* m, int iElem, void* out_pElem, size_t ElemSize );

#define  Set2_getCount( m, Type ) \
  ( (Type*)(m)->Next - (Type*)(m)->First )

#define  Set2_checkPtrInArr( m, p ) \
  ( (m)->First <= (p) && (p) < (m)->Over ? 0 : E_NotFoundSymbol )

int  Set2_separate( Set2* m, int NextSize, void** allocate_Array );

 
/***********************************************************************
  <<< [Set2a] >>> 
************************************************************************/
typedef  struct _Set2  Set2a;

void  Set2a_init_const( Set2a* m, void* ArrInStack );
int   Set2a_init( Set2a* m, void* ArrInStack, size_t ArrInStack_Size );
int   Set2a_finish( Set2a* m, void* ArrInStack, int e );
int   Set2a_toEmpty( Set2a* m );
//int Set2a_alloc( Set2a* m, void* ArrInStack, ClassA** out_p, Type ClassA );
int   Set2a_expandIfOverByAddr( Set2a* m, void* OverAddrBasedOnNowFirst );



// for inside

#define  Set2a_init_const( m, ArrInStack ) \
  ( (m)->First = (ArrInStack) )

#if NDEBUG
 #define  Set2a_init( m, ArrInStack, ArrInStack_Size ) \
   ( (m)->Next = (m)->First, \
     (m)->Over = (char*)(m)->First + (ArrInStack_Size), \
     0 )
#else
 #define  Set2a_init( m, ArrInStack, ArrInStack_Size ) \
   ( (m)->Next = (m)->First, \
     (m)->Over = (char*)(m)->First + (ArrInStack_Size), \
     (m)->First != (ArrInStack) )
#endif

#define  Set2a_finish( m, ArrInStack, e ) \
  ( (m)->First == (ArrInStack) ? (e) : ( free( (m)->First ), (e) ) )

#define  Set2a_toEmpty( m ) \
  Set2_toEmpty( m )

#define  Set2a_alloc( m, ArrInStack, out_Pointer, ClassA ) \
  ( (void*)( (ClassA*)((m)->Next) + 1 ) <= (m)->Over ? \
    ( *(out_Pointer) = (ClassA*)(m)->Next,  (m)->Next = (ClassA*)((m)->Next) + 1, 0 ) : \
    Set2a_alloc_imp( m, ArrInStack, out_Pointer, sizeof(ClassA) ) )

int  Set2a_alloc_imp( Set2a* m, void* ArrInStack, void* out_Pointer, size_t ElemSize );

#define  Set2a_expandIfOverByAddr( m, ArrInStack, OverAddrBasedOnNowFirst ) \
  ( (void*)(OverAddrBasedOnNowFirst) <= (m)->Over ? 0 : \
    Set2a_expandIfOverByAddr_imp( m, ArrInStack, OverAddrBasedOnNowFirst ) )

int  Set2a_expandIfOverByAddr_imp( Set2a* m, void* ArrInStack, void* OverAddrBasedOnNowFirst );


 
#if  __cplusplus
 }  /* End of C Symbol */ 
#endif
#endif
 
/*=================================================================*/
/* <<< [StrT/StrT.h] >>> */ 
/*=================================================================*/
 
#if  __cplusplus
 extern "C" {  /* Start of C Symbol */ 
#endif

int  StrT_cpy( TCHAR* Dst, size_t DstSize, const TCHAR* Src );
int  StrT_cat( TCHAR* Dst, size_t DstSize, const TCHAR* Src );
#define  StrT_cat( Dst, DstSize, Src ) \
           stcpy_part_r( Dst, sizeof(Dst), _tcschr( Dst, _T('\0') ), NULL, Src, NULL )
TCHAR*  StrT_malloc_cpy( const TCHAR* Src );
TCHAR*  StrT_malloc_cpy_from_char( const char* Src );
TCHAR*  StrT_chrs( const TCHAR* s, const TCHAR* keys );
TCHAR*  StrT_skip( const TCHAR* s, const TCHAR* keys );


 
/***********************************************************************
  <<< [StrT_Edit] >>> 
************************************************************************/
int  StrT_trim( TCHAR* out_Str, size_t out_Str_Size, const TCHAR* in_Str );
int  StrT_meltCmdLine( TCHAR* out_Str, size_t out_Str_Size, const TCHAR** pLine );
int  StrT_getExistSymbols( unsigned* out, bool bCase, const TCHAR* Str, const TCHAR* Symbols, ... );


 
/***********************************************************************
  <<< [StrT_Edit2] >>> 
************************************************************************/
int  StrT_replace( TCHAR* Out, size_t OutSize, const TCHAR* In,
                   const TCHAR* FromStr, const TCHAR* ToStr, unsigned Opt );
int  StrT_changeToXmlAttr( TCHAR* out_Str, size_t StrSize, const TCHAR* InputStr );

 
/***********************************************************************
  <<< [StrT_Path] >>> 
************************************************************************/
enum { StrT_LocalPathMaxSize = 4096 };
TCHAR*  StrT_refFName( const TCHAR* s );
TCHAR*  StrT_refExt( const TCHAR* s );
#define  StrT_getAbsPath( out_AbsPath, AbsPathSize, StepPath, BasePath ) \
  StrT_getAbsPath_part( out_AbsPath, AbsPathSize, out_AbsPath, NULL, StepPath, BasePath )
#define  StrT_getParentAbsPath( Str, StrSize, StepPath, BasePath ) \
  StrT_getParentAbsPath_part( Str, StrSize, Str, NULL, StepPath, BasePath )
int  StrT_getAbsPath_part( TCHAR* Str, size_t StrSize, TCHAR* StrStart,
  TCHAR** out_StrLast, const TCHAR* StepPath, const TCHAR* BasePath );
int  StrT_getParentAbsPath_part( TCHAR* Str, size_t StrSize, TCHAR* StrStart,
  TCHAR** out_StrLast, const TCHAR* StepPath, const TCHAR* BasePath );
int  StrT_getBaseName_part( TCHAR* Str, size_t StrSize, TCHAR* StrStart,
  TCHAR** out_StrLast, const TCHAR* SrcPath );
#define  StrT_getBaseName( Str, StrSize, SrcPath ) \
  StrT_getBaseName_part( Str, StrSize, Str, NULL, SrcPath )
bool  StrT_isAbsPath( const TCHAR* s );

 
/**************************************************************************
  <<< [StrT_Mul] >>> 
***************************************************************************/
typedef  struct _StrT_Mul  StrT_Mul;
struct _StrT_Mul {
  TCHAR*  First;
  size_t  Size;  /* byte */
  TCHAR*  Next;

  #if ! NDEBUG
    unsigned  BreakOffset;
  #endif
};

#define  StrT_Mul_init_const( m )  ( (m)->First = NULL )
int  StrT_Mul_init( StrT_Mul* m );
#define  StrT_Mul_finish( m, e )  ( (m)->First != NULL ? free( (m)->First ), (e) : (e) )
#define  StrT_Mul_isInited( m )  ( (m)->First != NULL )
int  StrT_Mul_add( StrT_Mul* m, const TCHAR* Str, const TCHAR** out_pAlloc );
int  StrT_Mul_toEmpty( StrT_Mul* m );
#define  StrT_Mul_forEach( m, pStr ) \
   *(pStr) = StrT_Mul_getFirst( m ); \
   *(pStr) != NULL; \
   *(pStr) = StrT_Mul_getNext( m, *(pStr) )
#define  StrT_Mul_getFirst( m )  ((m)->First == (m)->Next ? NULL : (m)->First )
#define  StrT_Mul_getNext( m, p ) \
   ( (p) = _tcschr( p, _T('\0') ) + 1, (p) == (m)->Next ? NULL : (p) )
int  StrT_Mul_freeLast( StrT_Mul* m, TCHAR* AllocStr );

#define  StrT_Mul_getFreeAddr( m )  ((m)->Next)
#define  StrT_Mul_getFreeSize( m )  ( (m)->Size - ((char*)(m)->Next - (char*)(m)->First) - sizeof(TCHAR) )
#define  StrT_Mul_getFreeCount( m ) ( StrT_Mul_getFreeSize( m ) / sizeof(TCHAR) )
#define  StrT_Mul_expandCount( m, c )  ( StrT_Mul_expandSize( (m), (c) * sizeof(TCHAR) ) )
int  StrT_Mul_expandSize( StrT_Mul* m, size_t FreeSize );
int  StrT_Mul_commit( StrT_Mul* m );

 
/***********************************************************************
  <<< [StrArr] >>> 
************************************************************************/
typedef struct _StrArr  StrArr;
struct _StrArr {
  Set2      Array;  // array of TCHAR*
  StrT_Mul  Chars;
};

int  StrArr_init( StrArr* m );
int  StrArr_finish( StrArr* m, int e );

int  StrArr_add( StrArr* m, const TCHAR* Str, int* out_I );
int  StrArr_commit( StrArr* m );
int  StrArr_fillTo( StrArr* m, int n, const TCHAR* Str );
int  StrArr_toEmpty( StrArr* m );

#define  StrArr_init_const( m )   Set2_init_const( &(m)->Array )
#define  StrArr_getFreeAddr( m )  StrT_Mul_getFreeAddr( &(m)->Chars )
#define  StrArr_getFreeSize( m )  StrT_Mul_getFreeSize( &(m)->Chars )
#define  StrArr_getFreeCount( m ) StrT_Mul_getFreeCount( &(m)->Chars )
#define  StrArr_expandSize( m, sz )  StrT_Mul_expandSize( &(m)->Chars, sz )
#define  StrArr_expandCount( m, c )  StrT_Mul_expandCount( &(m)->Chars, c )
#define  StrArr_getArray( m )     ((TCHAR**)(m)->Array.First)
#define  StrArr_getN( m )         Set2_getCount( &(m)->Array, TCHAR* )


 
/***********************************************************************
  <<< [CSV] >>> 
************************************************************************/
int  StrT_meltCSV( TCHAR* out_Str, size_t out_Str_Size, const TCHAR** pCSV );
int  StrArr_parseCSV( StrArr* m, const TCHAR* CSVLine );


 
/***********************************************************************
  <<< [StrMatchKey] >>> 
************************************************************************/
typedef struct _StrMatchKey  StrMatchKey;
struct _StrMatchKey {
  TCHAR*  Keyword;
  TCHAR*  WildcardLeftStr;
  size_t  WildcardLeftLength;
  TCHAR*  WildcardRightStr;
  size_t  WildcardRightLength;
};
void StrMatchKey_init_const( StrMatchKey* m );
int  StrMatchKey_init( StrMatchKey* m, const TCHAR* Keyword );
int  StrMatchKey_finish( StrMatchKey* m, int e );
bool StrMatchKey_isMatch( StrMatchKey* m, const TCHAR* String );


 
#if  __cplusplus
 }  /* End of C Symbol */ 
#endif

 
/*=================================================================*/
/* <<< [IniFile2/IniFile2.h] >>> */ 
/*=================================================================*/
 
#if  __cplusplus
 extern "C" {  /* Start of C Symbol */ 
#endif
 
bool  IniStr_isLeft( const TCHAR* line, const TCHAR* symbol ); 
 
TCHAR*  IniStr_refRight( const TCHAR* line, bool bTrimRight ); 
 
#if  __cplusplus
 }    /* End of C Symbol */ 
#endif

 
/*=================================================================*/
/* <<< [Locale/Locale.h] >>> */ 
/*=================================================================*/
 
#if  __cplusplus
 extern "C" {  /* Start of C Symbol */ 
#endif


 
/***********************************************************************
  <<< [Locale] >>> 
************************************************************************/
extern char*  g_LocaleSymbol;
int  Locale_init(void);
int  Locale_isInited(void);
 
#if  __cplusplus
 }  /* End of C Symbol */ 
#endif


 
/*=================================================================*/
/* <<< [FileT/FileT.h] >>> */ 
/*=================================================================*/
 
#if  __cplusplus
 extern "C" {  /* Start of C Symbol */ 
#endif

#define  FileT_isExistWildcard  1
bool  FileT_isExist( const TCHAR* path );
bool  FileT_isFile( const TCHAR* path );
bool  FileT_isDir( const TCHAR* path );
int   FileT_isDiff( const TCHAR* Path1, const TCHAR* Path2, bool* bDiff );
int   FileT_isSameText( TCHAR* Path1, TCHAR* Path2, int Format1, int Format2, bool* out_bSame );


 
/* FileT_CallByNestFindData */ 
typedef struct {
  void*     CallerArgument;
  TCHAR*    AbsPath;  // abstruct path
  TCHAR*    StepPath;
  TCHAR*    FileName;
  DWORD     FileAttributes;
} FileT_CallByNestFindData;

int  FileT_callByNestFind( const TCHAR* Path, BitField Flags, void* Obj, FuncType Callback );

enum { FileT_FolderBeforeFiles = 1 };
enum { FileT_FolderAfterFiles  = 2 };
enum { FileT_Folder = FILE_ATTRIBUTE_DIRECTORY };

 
/***********************************************************************
  <<< [FileT_Read] >>> 
************************************************************************/
int  FileT_openForRead( FILE** out_pFile, const TCHAR* path );
int  FileT_close( FILE* File, int e );



 
#if  __cplusplus
 }  /* End of C Symbol */ 
#endif
 
/*=================================================================*/
/* <<< [PlatformSDK_plus/PlatformSDK_plus.h] >>> */ 
/*=================================================================*/
 
#include  <shlwapi.h> 
#pragma comment(lib, "shlwapi.lib")


 
int  GetCommandLineUnnamed( int Index1, TCHAR* out_AParam, size_t AParamSize ); 
int  GetCommandLineNamed( const TCHAR* Name, bool bCase, TCHAR* out_Value, size_t ValueSize );
int  GetCommandLineNamedC8( const TCHAR* Name, bool bCase, char* out_Value, size_t ValueSize );
int  GetCommandLineNamedI( const TCHAR* Name, bool bCase, int* out_Value );
bool GetCommandLineExist( const TCHAR* Name, bool bCase );

#if ! _UNICODE
  #define  GetCommandLineNamedC8  GetCommandLineNamed
#endif

 
/*=================================================================*/
/* <<< [Print/Print2.h] >>> */ 
/*=================================================================*/
 
#if  __cplusplus
 extern "C" {  /* Start of C Symbol */ 
#endif
 
int  vsprintf_r( char* s, size_t s_size, const char* format, va_list va ); 
 
int  vswprintf_r( wchar_t* s, size_t s_size, const wchar_t* format, va_list va ); 
 
/*[vstprintf_r]*/
#if defined(_UNICODE) 
  #define  vstprintf_r  vswprintf_r
#else
  #define  vstprintf_r  vsprintf_r
#endif
 
int  stprintf_r( TCHAR* s, size_t s_size, const TCHAR* format, ... ); 
 
int  stcpy_part_r( TCHAR* s, size_t s_size, TCHAR* s_start, TCHAR** p_s_last, 
                   const TCHAR* src, const TCHAR* src_over );
int  stprintf_part_r( TCHAR* s, size_t s_size, TCHAR* s_start, TCHAR** p_s_last,
                      const TCHAR* format, ... );
 
#if  __cplusplus
 }    /* End of C Symbol */ 
#endif

 
/*=================================================================*/
/* <<< [Global0/Global0.h] >>> */ 
/*=================================================================*/
 
#if  __cplusplus
 extern "C" {  /* Start of C Symbol */ 
#endif



 
/***********************************************************************
  <<< [Globals_to_clib] >>> 
************************************************************************/
#define  USE_GLOBALS  1
void Globals_init_const_to_clib(void);
int  Globals_init_to_clib(void);
int  Globals_finish_to_clib( int e );

#if NDEBUG
  #define  get_InitedObject( m, isInited )  (m)
#else
  #define  get_InitedObject( m, isInited )  ( isInited( m ) ? (m) : (DebugBreak(), (m)) )
#endif

void Globals_init_const(void);
int  Globals_init(void);
int  Globals_finish( int e );
 
#if  __cplusplus
 }  /* End of C Symbol */ 
#endif
 
/*=================================================================*/
/* <<< [Globals_inc_redir_2/Globals_inc_redir_2.h] >>> */ 
/*=================================================================*/
 
#if ! DisableIncludeRedir_for_Globals
 #define  Redirect_from_Globals  1 
  #include  "redir/clib_redir.h"
 #undef   Redirect_from_Globals
#endif

 
#endif  // __CLIB_H 

#if  showIncludes
 #pragma message( "end of #include  \"" __FILE__ "\"" )
#endif
 
