/* The source file was composed by module mixer */ 

#include  "include_c.h"
#pragma hdrstop

 
/*=================================================================*/
/* <<< [Error4/Error4.c] >>> */ 
/*=================================================================*/
 
/***********************************************************************
  <<< [Err2_setBreakErrID] >>> 
************************************************************************/
#if ERR2_ENABLE_ERROR_BREAK

Err2  g_Err2;  /* lׂ͂ă[ */

void  Err2_setBreakErrID( int ID )
{
  Err2*  m = &g_Err2;

  m->BreakErrID = ID;
}


int  TryOnIfTrue_imp()
 // ԂĺAu[N邩ǂ
{
  //=== G[̒fiWvjĂƂ
  if ( g_Err2.IsErr )  return  0;


  //=== G[߂ċNƂ
  else {
    Err2*  m = &g_Err2;

    m->IsErr = 1;
    m->ErrID ++;

    #if ERR2_ENABLE_ERROR_LOG
      printf( "<ERRORLOG msg=\"raised\" err_id=\"%d\" g_err2=\"0x%08X\"/>\n", m->ErrID, m );
    #endif

    return  ( m->ErrID == m->BreakErrID );
  }
}


void  Err2_clear()
{
  Err2*  m = &g_Err2;

  #if ERR2_ENABLE_ERROR_LOG
  if ( m->IsErr != 0 )
    printf( "<ERRORLOG msg=\"cleared\" err_id=\"%d\" g_err2=\"0x%08X\"/>\n", m->ErrID, m );
  #endif

  m->IsErr = 0;
}


void  IfErrThenBreak()
{
  if ( g_Err2.IsErr && ( g_Err2.ErrID != g_Err2.BreakErrID || g_Err2.BreakErrID == 0 ) )  TestableDebugBreak();
    // EHb`ŁAg_Err2.ErrID ̒l(NƂ)mFāA
    // C֐ Err2_setBreakErrID( N ); ĂяoĂB
    // IĂȂ̂ɂŃu[NƂ́A
    // Err2_clear() YĂ\܂B
  Err2_clear();
}

#endif // ERR2_ENABLE_ERROR_BREAK

 
/***********************************************************************
  <<< [g_Error4_String] >>> 
************************************************************************/
TCHAR  g_Error4_String[4096];


 
/***********************************************************************
  <<< [Error4_printf] >>> 
************************************************************************/
void  Error4_printf( const TCHAR* format, ... )
{
  #define  _s  g_Error4_String
  va_list  va;
  va_start( va, format );
  vstprintf_r( _s, sizeof(_s), format, va );
  va_end( va );
  #undef  _s
}


 
/***********************************************************************
  <<< [Error4_getErrStr] >>> 
************************************************************************/
void  Error4_getErrStr( int err_num, TCHAR* msg, int msg_size )
{
  switch ( err_num ) {

    case  0:
      stprintf_r( msg, msg_size, _T("no error") );
      break;

    case  E_GetLastError:
      stprintf_r( msg, msg_size, _T("[ERROR] GetLastError = 0x%08X"), GetLastError() );
      break;

    default:
      if ( g_Error4_String[0] != '\0' )
        stprintf_r( msg, msg_size, _T("%s"), g_Error4_String );
      else
        stprintf_r( msg, msg_size, _T("[ERROR] %d"), err_num );
      break;
  }
}




 
/***********************************************************************
  <<< [Error4_showToStdErr] >>> 
************************************************************************/
void  Error4_showToStdErr( int err_num )
{
  TCHAR  msg[1024];
  #if _UNICODE
    char  msg2[1024];
  #endif

  if ( err_num == 0 )  return;

  Error4_getErrStr( err_num, msg, sizeof(msg) );
  #if _UNICODE
    setlocale( LC_ALL, ".OCP" );
    sprintf_s( msg2, sizeof(msg2), "%S", msg );
    fprintf( stderr, "%s\n", msg2 );  // _ftprintf_s ł͓{ꂪo܂
  #else
    fprintf( stderr, "%s\n", msg );
  #endif

  #if ERR2_ENABLE_ERROR_BREAK
    fprintf( stderr, "C֐ Err2_setBreakErrID( %d ); ĂяoĂB\n",
      g_Err2.ErrID );
  #else
    fprintf( stderr, "ERR2_ENABLE_ERROR_BREAK `čăRpCĂB\n" );
  #endif
}


 
/*=================================================================*/
/* <<< [DebugTools/DebugTools.c] >>> */ 
/*=================================================================*/
 
/***********************************************************************
  <<< [TestableDebugBreak] >>> 
************************************************************************/
int  g_bTestableDebugBreak_Disable;
int  g_DebugBreakCount;


 
/*=================================================================*/
/* <<< [SetX/SetX.c] >>> */ 
/*=================================================================*/
 
/***********************************************************************
  <<< [Set2_init] >>> 
************************************************************************/
int  Set2_init( Set2* m, int FirstSize )
{
  m->First = malloc( FirstSize );
  if ( m->First == NULL )  return  E_FewMemory;
  m->Next = m->First;
  m->Over = (char*)m->First + FirstSize;
  return  0;
}
 
/***********************************************************************
  <<< [Set2_finish] >>> 
************************************************************************/
int  Set2_finish( Set2* m, int e )
{
  if ( m->First != NULL )  free( m->First );
  return  e;
}

 
/***********************************************************************
  <<< [Set2_ref_imp] >>> 
************************************************************************/
int  Set2_ref_imp( Set2* m, int iElem, void* out_pElem, size_t ElemSize )
{
  int    e;
  char*  p;

  IF( iElem < 0 ) goto err_ns;
  p = (char*) m->First + ( (unsigned)iElem * ElemSize );
  IF( p >= (char*)m->Next ) goto err_ns;
  *(char**)out_pElem = p;

  e=0;
fin:
  return  e;

err_ns:  e = E_NotFoundSymbol;  goto fin;
}


 
/***********************************************************************
  <<< [Set2_alloc_imp] >>> 
************************************************************************/
int  Set2_alloc_imp( Set2* m, void* pp, size_t size )
{
  int  e;

  e= Set2_expandIfOverByAddr( m, (char*) m->Next + size ); IF(e)goto fin;
  *(void**)pp = m->Next;
  m->Next = (char*) m->Next + size;

  MEMSET_TO_NOT_INIT( *(void**)pp, size );

  e=0;
fin:
  return  e;
}


int  Set2_allocMulti_sub( Set2* m, void* out_pElem, size_t ElemsSize )
{
  int    e;
  char*  p;

  e= Set2_expandIfOverByAddr( m, (char*) m->Next + ElemsSize ); IF(e)goto fin;
  p = m->Next;
  m->Next = p + ElemsSize;
  *(char**)out_pElem = p;

  e=0;
fin:
  return  e;
}


 
/***********************************************************************
  <<< [Set2_expandIfOverByAddr_imp] >>> 
************************************************************************/
int  Set2_expandIfOverByAddr_imp( Set2* m, void* OverAddrBasedOnNowFirst )
{
  void*  p;
  unsigned  ofs;
  unsigned  ofs2;

  if ( OverAddrBasedOnNowFirst <= m->Over )  return  E_Others;

  ofs2 = (unsigned)( (char*)OverAddrBasedOnNowFirst - (char*)m->First );
  ofs = (unsigned)( ( (char*)m->Over - (char*)m->First ) ) * 2;
  IF_D( ofs2 >= 0x80000000 )  return  E_Others;
  while ( ofs < ofs2 )  ofs *= 2;
  if ( ofs >= 0x10000000 )  return  E_Others;

  p = realloc( m->First, ofs * 2 );
  if ( p == NULL )  return  E_FewMemory;

  m->Next = (char*) p + ( (char*)m->Next - (char*)m->First );
  m->Over = (char*) p + ofs;
  m->First = p;

  return  0;
}

 
/***********************************************************************
  <<< [Set2_separate] >>> 
************************************************************************/
int  Set2_separate( Set2* m, int NextSize, void** allocate_Array )
{
  int    e;
  void*  p = m->First;

  if ( NextSize == 0 ) {
    MEMSET_TO_NOT_INIT( m, sizeof(*m) );
    m->First = NULL;
  }
  else {
    e= Set2_init( m, NextSize ); IF(e)goto fin;
  }
  *allocate_Array = p;

  e=0;
fin:
  return  e;
}


 
/***********************************************************************
  <<< [Set2a_alloc_imp] >>> 
************************************************************************/
int  Set2a_alloc_imp( Set2a* m, void* ArrInStack, void* out_Pointer, size_t ElemSize )
{
  int  e;

  e= Set2a_expandIfOverByAddr_imp( m, ArrInStack, (char*)m->Next + ElemSize ); IF(e)goto fin;
  *(void**)out_Pointer = m->Next;
  m->Next = (char*) m->Next + ElemSize;

  e=0;
fin:
  return  e;
}



 
/***********************************************************************
  <<< [Set2a_expandIfOverByAddr_imp] >>> 
************************************************************************/
int  Set2a_expandIfOverByAddr_imp( Set2a* m, void* ArrInStack, void* OverAddrBasedOnNowFirst )
{
  void*  new_memory;
  unsigned  ofs;

  if ( m->First == ArrInStack ) {
    ofs = (char*)m->Over - (char*)m->First;
    new_memory = malloc( ofs * 2 );
    IF( new_memory == NULL ) return  E_FewMemory;

    memcpy( new_memory, m->First, ofs * 2 );

    m->First = new_memory;
    m->Over  = (char*)new_memory + ofs * 2;
    m->Next  = (char*)new_memory + ofs;
    return  0;
  }
  else {
    return  Set2_expandIfOverByAddr_imp( (Set2*) m, OverAddrBasedOnNowFirst );
  }
}


 
/*=================================================================*/
/* <<< [StrT/StrT.c] >>> */ 
/*=================================================================*/
 
/***********************************************************************
  <<< [StrT_cpy] >>> 
- _tcscpy is raising exception, if E_FewArray
************************************************************************/
int  StrT_cpy( TCHAR* Dst, size_t DstSize, const TCHAR* Src )
{
  size_t  size;

  size = ( _tcslen( Src ) + 1 ) * sizeof(TCHAR);
  if ( size <= DstSize ) {
    memcpy( Dst, Src, size );
    return  0;
  }
  else {
    memcpy( Dst, Src, DstSize - sizeof(TCHAR) );
    *(TCHAR*)( (char*) Dst + DstSize ) = _T('\0');
    return  E_FewArray;
  }
}

 
/***********************************************************************
  <<< [StrT_malloc_cpy] >>> 
************************************************************************/
TCHAR*  StrT_malloc_cpy( const TCHAR* Src )
{
  TCHAR*  p;
  size_t  size;

  size = ( _tcslen( Src ) + 1 ) * sizeof(TCHAR);
  p = (TCHAR*) malloc( size );  IF(p==NULL) return NULL;
  memcpy( p, Src, size );
  return  p;
}

 
/***********************************************************************
  <<< [StrT_malloc_cpy_from_char] >>> 
************************************************************************/
TCHAR*  StrT_malloc_cpy_from_char( const char* Src )
{
  #if _UNICODE
    TCHAR*  p = NULL;
    size_t  size;
    int     r;

    size = ( strlen( Src ) + 1 ) * sizeof(TCHAR);
    p = (TCHAR*) malloc( size );  IF(p==NULL) return NULL;

    r = MultiByteToWideChar( CP_OEMCP, MB_PRECOMPOSED, Src, -1, p, size / 2 );
    IF( r == 0 ) goto err;
    return  p;

  err:
    free( p );
    return  NULL;

  #else
    TCHAR*  p;
    size_t  size;

    size = ( _tcslen( Src ) + 1 ) * sizeof(TCHAR);
    p = (TCHAR*) malloc( size );  IF(p==NULL) return NULL;
    memcpy( p, Src, size );

    return  p;
  #endif
}

 
/***********************************************************************
  <<< [StrT_chrs] >>> 
************************************************************************/
TCHAR*  StrT_chrs( const TCHAR* s, const TCHAR* keys )
{
  if ( *keys == _T('\0') )  return  NULL;

  for ( ; *s != _T('\0'); s++ ) {
    if ( _tcschr( keys, *s ) != NULL )
      return  (TCHAR*) s;
  }
  return  NULL;
}


 
/***********************************************************************
  <<< [StrT_skip] >>> 
************************************************************************/
TCHAR*  StrT_skip( const TCHAR* s, const TCHAR* keys )
{
  if ( *keys == _T('\0') )  return  (TCHAR*) s;

  for ( ; *s != _T('\0'); s++ ) {
    if ( _tcschr( keys, *s ) == NULL )
      break;
  }
  return  (TCHAR*) s;
}


 
/***********************************************************************
  <<< [StrT_refFName] >>> 
************************************************************************/
TCHAR*  StrT_refFName( const TCHAR* s )
{
  const TCHAR*  p;
  TCHAR  c;

  p = _tcschr( s, _T('\0') );

  if ( p == s )  return  (TCHAR*) s;

  for ( p--; p>s; p-- ) {
    c = *p;
    if ( c == _T('\\') || c == _T('/') )  return  (TCHAR*) p+1;
  }
  if ( *p == _T('\\') || *p == _T('/') )  return  (TCHAR*) p+1;

  return  (TCHAR*) s;
}
 
/***********************************************************************
  <<< [StrT_refExt] >>> 
************************************************************************/
TCHAR*  StrT_refExt( const TCHAR* s )
{
  const TCHAR*  p;

  p = _tcschr( s, _T('\0') );

  if ( p == s )  return  (TCHAR*) s;

  for ( p--; p>s; p-- ) {
    if ( *p == '.' )  return  (TCHAR*) p+1;
  }
  if ( *p == '.' )  return  (TCHAR*) p+1;

  return  _tcschr( s, _T('\0') );
}


 
/***********************************************************************
  <<< [StrT_replace] >>> 
************************************************************************/
int  StrT_replace( TCHAR* Out, size_t OutSize, const TCHAR* In,
                   const TCHAR* FromStr, const TCHAR* ToStr, unsigned Opt )
{
  int  e;
  unsigned        from_size = _tcslen( FromStr ) * sizeof(TCHAR);
  unsigned        to_size   = _tcslen( ToStr )   * sizeof(TCHAR);
  const TCHAR*    p_in      = In;
        TCHAR*    p_out     = Out;
  const TCHAR*    p_in_from;
  size_t          copy_size;
  int             out_size  = OutSize - 1;


  //=== uďȂƂ́AE֑
  if ( to_size <= from_size ) {

    for (;;) {

      // In ̒ FromStr ̐擪ʒu p_in_from 
      p_in_from = _tcsstr( p_in, FromStr );
      if ( p_in_from == NULL ) break;

      // In ̒ FromStr ̑O܂ In  Out փRs[
      copy_size = (char*)p_in_from - (char*)p_in;
      out_size -= copy_size + to_size;
      IF( out_size < 0 ) goto err_fa;

      if ( p_out != p_in )
        memcpy( p_out, p_in, copy_size );
      p_in  = (TCHAR*)( (char*)p_in  + copy_size );
      p_out = (TCHAR*)( (char*)p_out + copy_size );

      // FromStr  ToStr ɒu
      memcpy( p_out, ToStr, to_size );
      p_in  = (TCHAR*)( (char*)p_in  + from_size );
      p_out = (TCHAR*)( (char*)p_out + to_size );
    }

    // c In  Out փRs[
    #pragma warning(push)
    #pragma warning(disable:4996)
      if ( p_out != p_in )
        _tcscpy( p_out, p_in );
      p_out = NULL;
    #pragma warning(pop)
  }


  //=== uđ傫ȂƂ́AE獶֑
  else {

    // In ̒ FromStr Ƃ͑SRs[
    p_in_from = _tcsstr( p_in, FromStr );
    if ( p_in_from == NULL ) {
      if ( p_out != p_in )
        StrT_cpy( Out, OutSize, In );
      p_out = NULL;
    }
    else {
      Set2a          froms;
      TCHAR*         froms_X[10];
      const TCHAR**  pp_froms;
      size_t         plus_from_to;

      Set2a_init_const( &froms, froms_X );
      e= Set2a_init( &froms, froms_X, sizeof(froms_X) ); IF(e)goto fin2;


      // In ̒ FromStr ̑O܂ŃRs[
      copy_size = (char*)p_in_from - (char*)p_in;
      out_size -= copy_size;
      IF( out_size < 0 ) goto err_fa2;

      memcpy( p_out, p_in, copy_size );
      // p_in  = (TCHAR*)( (char*)p_in  + copy_size );  // ŎgȂ
      p_out = (TCHAR*)( (char*)p_out + copy_size );


      // In ̒ FromStr ̈ʒu froms ֏W߂
      for (;;) {

        e= Set2a_expandIfOverByAddr( &froms, froms_X, (TCHAR**)froms.Next + 1 ); IF(e)goto fin2;
        pp_froms = (const TCHAR**)froms.Next;  froms.Next = (void*)( pp_froms + 1 );

        *pp_froms =  p_in_from;

        p_in = (const TCHAR*)( (char*)p_in_from + from_size );
        p_in_from = _tcsstr( p_in, FromStr );
        if ( p_in_from == NULL )  break;
      }

      plus_from_to = ( (TCHAR**)froms.Next - (TCHAR**)froms.First ) * (to_size - from_size);


      // In ̖ '\0' ̈ʒu froms 
      e= Set2a_expandIfOverByAddr( &froms, froms_X, (TCHAR**)froms.Next + 1 ); IF(e)goto fin2;
      pp_froms = (const TCHAR**)froms.Next;  froms.Next = (void*)( pp_froms + 1 );
      p_in = _tcschr( p_in, _T('\0') );
      *pp_froms = p_in;

      copy_size = ( (char*)p_in - (char*)In ) + plus_from_to;
      IF( copy_size >= OutSize ) goto err_fa2;
      p_out = (TCHAR*)( (char*)Out + copy_size );
      plus_from_to -= to_size - from_size;


      // E獶֑
      for ( pp_froms = (TCHAR**)froms.Next - 1;
            pp_froms > (TCHAR**)froms.First;
            pp_froms -- ) {

        const TCHAR*  p_in_from       = *(pp_froms - 1);
        const TCHAR*  p_in_other      = (const TCHAR*)( (char*)p_in_from + from_size );
        const TCHAR*  p_in_other_over = *pp_froms;
              TCHAR*  p_out_to        = (TCHAR*)( (char*)Out + ( (char*)p_in_from - (char*)In ) + plus_from_to );
              TCHAR*  p_out_other     = (TCHAR*)( (char*)p_out_to + to_size );

        memmove( p_out_other, p_in_other, (char*)p_in_other_over - (char*)p_in_other );
        memcpy( p_out_to, ToStr, to_size );

        plus_from_to -= to_size - from_size;
      }

      goto fin2;
    err_fa2:  e = E_FewArray;   goto fin2;
    fin2:
      e= Set2a_finish( &froms, froms_X, e );
      if ( e ) goto fin;
    }
  }

  e=0;
fin:
  if ( p_out != NULL )  *p_out = _T('\0');
  return  e;

err_fa:  e = E_FewArray;  goto fin;
}

 
/***********************************************************************
  <<< [StrT_trim] >>> 
************************************************************************/
int  StrT_trim( TCHAR* out_Str, size_t out_Str_Size, const TCHAR* in_Str )
{
  const TCHAR*  p1;
  const TCHAR*  p2;
  TCHAR   c;

  p1 = in_Str;  while ( *p1 == _T(' ') || *p1 == _T('\t') )  p1++;
  for ( p2 = _tcschr( p1, _T('\0') ) - 1;  p2 >= p1;  p2-- ) {
    c = *p2;
    if ( c != _T(' ') && c != _T('\t') && c != _T('\n') && c != _T('\r') )
      break;
  }
  return  stcpy_part_r( out_Str, out_Str_Size, out_Str, NULL, p1, p2+1 );
}

 
/**************************************************************************
  <<< [StrT_meltCSV] >>> 
*************************************************************************/
int  StrT_meltCSV( TCHAR* out_Str, size_t out_Str_Size, const TCHAR** pCSV )
{
  int  e = 0;
  TCHAR*  t;
  TCHAR*  t_last = (TCHAR*)( (char*)out_Str + out_Str_Size - sizeof(TCHAR) );
  const TCHAR*  s;
  TCHAR  dummy[2];
  TCHAR  c;

  t = out_Str;
  s = *pCSV;
  if ( out_Str_Size <= 1 )  { t = dummy;  t_last = dummy; }

  if ( s == NULL ) { *t = _T('\0');  return 0; }


  /* ̋󔒂 */
  while ( *s == _T(' ') || *s == _T('\t') )  s++;

  switch ( *s ) {

    /* "" ň͂܂Ăꍇ */
    case _T('"'):
      s++;
      c = *s;
      while ( c != _T('"') || *(s+1) == _T('"') ) {  /* " ܂ */
        if ( t == t_last ) { e = E_FewArray;  t = dummy;  t_last = dummy + 1; }
        if ( c == *(s+1) && c == _T('"') )  s++;  /* "  */
        if ( c == _T('\0') )  break;
        *t = c;  t++;  s++;  c = *s;
      }
      *t = _T('\0');

      s++;
      for (;;) {
        if ( *s == _T(',') )  { s = s+1;  break; }
        if ( *s == _T('\0') ) { s = NULL;  break; }
        s++;
      }
      *pCSV = s;
      return  e;

    /* ̍ڂ̏ꍇ */
    case ',':
      *t = _T('\0');
      *pCSV = s+1;
      return  0;

    case '\0':
      *t = _T('\0');
      *pCSV = NULL;
      return  0;

    /* "" ň͂܂ĂȂꍇ */
    default: {
      TCHAR*  sp = NULL;  /* Ō̘A󔒂̐擪 */

      c = *s;
      while ( c != _T(',') && c != _T('\0') && c != _T('\r') && c != _T('\n') ) {  /* , ܂ */

        /* sp ݒ肷 */
        if ( c == ' ' ) {
          if ( sp == NULL )  sp = t;
        }
        else  sp = NULL;

        if ( t == t_last ) { e = E_FewArray;  t = dummy;  t_last = dummy + 1; }

        /* Rs[ */
        *t = c;  t++;  s++;  c = *s;
      }

      /* Ԃl肷 */
      if ( c == _T(',') )  s = s + 1;
      else  s = NULL;

      /* ̋󔒂菜 */
      if ( sp != NULL )  *sp = '\0';
      else  *t = _T('\0');

      *pCSV = s;
      return  e;
    }
  }
}


 
/**************************************************************************
  <<< [StrT_changeToXmlAttr] >>> 
*************************************************************************/
int  StrT_changeToXmlAttr( TCHAR* out_Str, size_t StrSize, const TCHAR* InputStr )
{
  int  e;

  e= StrT_replace( out_Str, StrSize, InputStr, _T("&"),  _T("&amp;"),  0 ); IF(e)goto fin;
  e= StrT_replace( out_Str, StrSize, out_Str,  _T("\""), _T("&quot;"), 0 ); IF(e)goto fin;
  e= StrT_replace( out_Str, StrSize, out_Str,  _T("<"),  _T("&lt;"),   0 ); IF(e)goto fin;

fin:
  return  e;
}


 
/***********************************************************************
  <<< [StrT_getExistSymbols] >>> 
************************************************************************/
int  StrT_getExistSymbols( unsigned* out, bool bCase, const TCHAR* Str, const TCHAR* Symbols, ... )
{
  int  e, i;
  TCHAR** syms = NULL;
  bool*   syms_exists = NULL;
  bool    b_nosym = false;
  TCHAR*  sym = NULL;
  size_t  sym_size = ( _tcslen( Symbols ) + 1 ) * sizeof(TCHAR);
  int     n_sym = 0;
  const TCHAR*  p;


  sym = (TCHAR*) malloc( sym_size ); IF(sym==NULL)goto err_fm;


  //=== Get Symbols
  p = Symbols;
  do {
    e= StrT_meltCSV( sym, sym_size, &p ); IF(e)goto fin;
    if ( sym[0] != _T('\0') )  n_sym ++;
  } while ( p != NULL );

  syms = (TCHAR**) malloc( n_sym * sizeof(TCHAR*) ); IF(syms==NULL)goto err_fm;
  memset( syms, 0, n_sym * sizeof(TCHAR*) );
  syms_exists = (bool*) malloc( n_sym * sizeof(bool) ); IF(syms_exists==NULL)goto err_fm;
  memset( syms_exists, 0, n_sym * sizeof(bool) );

  p = Symbols;  i = 0;
  do {
    e= StrT_meltCSV( sym, sym_size, &p ); IF(e)goto fin;
    if ( sym[0] != _T('\0') ) {
      syms[i] = StrT_malloc_cpy( sym );
      IF( syms[i] == NULL )goto err_fm;
      i++;
    }
  } while ( p != NULL );


  //=== Check Str whether having Symbols
  p = Str;
  do {
    e= StrT_meltCSV( sym, sym_size, &p ); IF(e)goto fin;
    if ( sym[0] != _T('\0') ) {
      for ( i = 0; i < n_sym; i++ ) {
        if ( _tcscmp( sym, syms[i] ) == 0 )  { syms_exists[i] = true;  break; }
      }
      if ( i == n_sym )  b_nosym = true;
    }
  } while ( p != NULL );


  //=== Sum numbers
  {
    va_list   va;
    unsigned  num;

    va_start( va, Symbols );
    *out = 0;
    for ( i = 0; i < n_sym; i++ ) {
      num = va_arg( va, unsigned );
      if ( syms_exists[i] )  *out |= num;
    }
    va_end( va );
  }

  e = ( b_nosym ? E_NotFoundSymbol : 0 );
fin:
  if ( syms != NULL ) {
    for ( i = 0; i < n_sym; i++ ) {
      if ( syms[i] != NULL )  free( syms[i] );
    }
    free( syms );
  }
  if ( syms_exists != NULL )  free( syms_exists );
  if ( sym != NULL )  free( sym );
  return  e;
err_fm: e= E_FewMemory; goto fin;
}

 
/**************************************************************************
  <<< [StrT_meltCmdLine] >>> 
*************************************************************************/
int  StrT_meltCmdLine( TCHAR* out_Str, size_t out_Str_Size, const TCHAR** pLine )
{
  int  e = 0;
  TCHAR*  t;
  TCHAR*  t_last = (TCHAR*)( (char*)out_Str + out_Str_Size - sizeof(TCHAR) );
  const TCHAR*  s;
  TCHAR  dummy;
  TCHAR  c;

  t = out_Str;
  s = *pLine;
  if ( out_Str_Size <= 1 )  { t = &dummy;  t_last = &dummy; }

  if ( s == NULL ) { *t = _T('\0');  return 0; }


  /* ̋󔒂 */
  while ( *s == _T(' ') || *s == _T('\t') )  s++;

  switch ( *s ) {

    /* "" ň͂܂Ăꍇ */
    case _T('"'):
      s++;
      c = *s;
      while ( c != _T('"') || *(s+1) == _T('"') ) {  /* " ܂ */
        if ( t == t_last ) { e = E_FewArray;  t = &dummy;  t_last = &dummy + 1; }
        if ( c == *(s+1) && c == _T('"') )  s++;  /* "  */
        if ( c == _T('\0') )  break;
        *t = c;  t++;  s++;  c = *s;
      }
      *t = _T('\0');

      s++;
      for (;;) {
        if ( *s == _T(' ') )  { s = s+1;  break; }
        if ( *s == _T('\0') ) { s = NULL;  break; }
        s++;
      }
      *pLine = s;
      return  e;

    case '\0':
      *t = _T('\0');
      *pLine = NULL;
      return  0;

    /* "" ň͂܂ĂȂꍇ */
    default: {
      c = *s;
      while ( c != _T(' ') && c != _T('\0') && c != _T('\r') && c != _T('\n') ) {  /* 󔒕܂ */

        if ( t == t_last ) { e = E_FewArray;  t = &dummy;  t_last = &dummy + 1; }

        /* Rs[ */
        *t = c;  t++;  s++;  c = *s;
      }

      /* *pLine肷 */
      while ( *s == _T(' ') )  s = s + 1;
      if ( *s == _T('\0') )  s = NULL;

      /*  */
      *t = _T('\0');

      *pLine = s;
      return  e;
    }
  }
}


 
/***********************************************************************
  <<< [StrT_getAbsPath_part]:shlwapi >>> 
************************************************************************/
int  StrT_getAbsPath_part( TCHAR* Out, size_t OutSize, TCHAR* OutStart,
  TCHAR** out_OutLast, const TCHAR* StepPath, const TCHAR* BasePath )
{
  int     e;
  TCHAR*  p;
  TCHAR   base_path_x[512];

  IF_D( OutStart < Out ||  (char*) OutStart >= (char*)Out + OutSize )goto err;

  if ( StepPath[0] == _T('\0') ) {
    *OutStart = _T('\0');
    return  0;
  }
  if ( StrT_isAbsPath( StepPath ) ) {
    if ( Out == StepPath )
      return  0;
    else
      return  stcpy_part_r( Out, OutSize, OutStart, out_OutLast, StepPath, NULL );
  }

  if ( BasePath == NULL ) {
    p = _tgetcwd( base_path_x, _countof(base_path_x) ); IF( p == NULL )goto err;
    BasePath = base_path_x;
  }


  //=== ΃pXɂB ".." 
  IF( OutSize - ((char*)OutStart - (char*)Out) < MAX_PATH*sizeof(TCHAR) ) return E_FewArray;
  _tcscpy_s( OutStart, MAX_PATH, BasePath );
  PathAppend( OutStart, StepPath );  // PathAppend ̑1̃TCY MAX_PATH*sizeof(TCHAR) ȏ


  //===  \ Jbg
  p = _tcschr( OutStart, _T('\0') );
  if ( *(p-1) == _T('\\') && p > OutStart + 3 ) { p--;  *p = _T('\0'); }


  if ( out_OutLast != NULL )  *out_OutLast = p;

  e=0;
fin:
  return  e;

err:  e = E_Others;  goto fin;
}


 
/***********************************************************************
  <<< [StrT_getParentAbsPath_part] >>> 
************************************************************************/
int  StrT_getParentAbsPath_part( TCHAR* Str, size_t StrSize, TCHAR* StrStart,
  TCHAR** out_StrLast, const TCHAR* StepPath, const TCHAR* BasePath )
{
  int  e;
  TCHAR*  p;

  IF_D( StrStart < Str ||  (char*) StrStart >= (char*)Str + StrSize )goto err;

  if ( StepPath[0] == _T('\0') ) {
    *StrStart = _T('\0');
    return  0;
  }

  /* ΃pXɂ */
  e= StrT_getAbsPath( StrStart,
    StrSize - ( (char*)StrStart - (char*)Str ),
    StepPath, BasePath ); IF(e)goto fin;


  /* e */
  p = StrT_refFName( StrStart );
  if ( p > StrStart )  p--;
  *p = _T('\0');


  /* [gȂ \ t */
  if ( p == StrStart + 2 ) {
    *p = _T('\\');  p++;  *p = _T('\0');
  }

  if ( out_StrLast != NULL )  *out_StrLast = p;

  e=0;
fin:
  return  e;

err:  e = E_Others;  goto fin;
}


 
/***********************************************************************
  <<< [StrT_getBaseName_part] >>> 
************************************************************************/
int  StrT_getBaseName_part( TCHAR* Str, size_t StrSize, TCHAR* StrStart,
  TCHAR** out_StrLast, const TCHAR* SrcPath )
{
  const TCHAR*  p1;
  const TCHAR*  p2;
  const TCHAR*  p3;
  const TCHAR*  ps;

  p1 = StrT_refFName( SrcPath );


  //=== # ƂAŌ̃sIh̑O܂łABaseName
  ps = _tcschr( p1, _T('#') );
  if ( ps == NULL ) {
    p2 = _tcsrchr( p1, _T('.') );
    if ( p2 == NULL )  p2 = _tcsrchr( p1, _T('\0') );
  }

  //=== # ƂA# OŁAŌ̃sIh̑O܂łABaseName
  else {
    p2 = ps;

    p3 = p1;
    for (;;) {
      p3 = _tcschr( p3, _T('.') );
      if ( p3 == NULL || p3 > ps )  break;
      p2 = p3;
      p3 ++;
    }
  }

  return  stcpy_part_r( Str, StrSize, StrStart, out_StrLast, p1, p2 );
}

 
/***********************************************************************
  <<< [StrT_isAbsPath] >>> 
************************************************************************/
bool  StrT_isAbsPath( const TCHAR* s )
{
  const TCHAR*  bs = _tcschr( s, _T('\\') );
  const TCHAR*  sl = _tcschr( s, _T('/') );
  const TCHAR*  co = _tcschr( s, _T(':') );

  return  ( co != NULL  && ( bs == co+1  ||  sl == co+1 ) );
}

 
/***********************************************************************
  <<< [StrT_Mul_init] >>> 
************************************************************************/
enum { StrT_Mul_FirstSize = 0x0F00 };

int  StrT_Mul_init( StrT_Mul* m )
{
  TCHAR*  p;

  m->First = NULL;

  p = (TCHAR*) malloc( StrT_Mul_FirstSize );
  IF( p == NULL )  return  E_FewMemory;

  m->First = p;
  m->Size = StrT_Mul_FirstSize;
  m->Next = p;
  p[0] = _T('\0');  p[1] = _T('\0');

  #if ! NDEBUG
    m->BreakOffset = -1;
  #endif

  return  0;
}


/***********************************************************************
  <<< [StrT_Mul_toEmpty] >>>
************************************************************************/
int  StrT_Mul_toEmpty( StrT_Mul* m )
{
  free( m->First );
  return  StrT_Mul_init( m );
}


 
/***********************************************************************
  <<< [StrT_Mul_add] >>> 
************************************************************************/
int  StrT_Mul_add( StrT_Mul* m, const TCHAR* Str, const TCHAR** out_AllocStr )
{
  int  e;
  const TCHAR*  p1;
  const TCHAR*  p2;
  TCHAR*  p3;
  enum { plus = 0x1000 };

  p1 = Str;
  p2 = _tcschr( p1, _T('\0') );
  while ( (char*) m->Next + ( (char*) p2 - (char*) p1 + sizeof(TCHAR)*2 ) >
       (char*) m->First + m->Size ) {
    p3 = (TCHAR*) realloc( m->First, m->Size + plus );
    IF( p3 == NULL )goto err_fm;
    m->Next = p3 + ( m->Next - m->First );
    m->First = p3;
    m->Size += plus;
  }

  #if ! NDEBUG
    if ( ( (char*)m->Next - (char*)m->First ) == m->BreakOffset )  TestableDebugBreak();
  #endif

  memcpy( m->Next, Str, (char*) p2 - (char*) p1 + sizeof(TCHAR) );

  p3 = ( m->Next + ( (TCHAR*) p2 - (TCHAR*) p1 + 1 ) );
  *p3 = _T('\0');  // '\0'x2
  if ( out_AllocStr != NULL )  *out_AllocStr = m->Next;
  m->Next = p3;

  e=0;
fin:
  return  e;
err_fm: e= E_FewMemory; goto fin;
}


 
/***********************************************************************
  <<< [StrT_Mul_freeLast] >>> 
************************************************************************/
int  StrT_Mul_freeLast( StrT_Mul* m, TCHAR* AllocStr )
{
  int     e;
  TCHAR*  p;
  TCHAR*  prev_p;

  prev_p = NULL;
  for ( StrT_Mul_forEach( m, &p ) ) {
    prev_p = p;
  }
  IF( prev_p == NULL ) goto err;
  IF( AllocStr != prev_p ) goto err;

  *prev_p = _T('\0');  // '\0'x2
  m->Next = prev_p;

  e=0;
fin:
  return  e;

err:  e = E_Others;  goto fin;
}


 
/***********************************************************************
  <<< [StrT_Mul_expandSize] >>> 
************************************************************************/
int  StrT_Mul_expandSize( StrT_Mul* m, size_t FreeSize )
{
  size_t  filled_size = ((char*) m->Next) - ((char*) m->First);
  size_t  total_size = filled_size + FreeSize + 1;
  int     e;
  void*   p;

  if ( total_size <= m->Size )  return  0;

  p = realloc( m->First, total_size ); IF(p==NULL)goto err_fm;
  m->Next = (TCHAR*)( ((char*) p ) + filled_size );
  m->First = p;
  m->Size = total_size;

  e=0;
fin:
  return  e;

err_fm:  e = E_FewMemory;  goto fin;
}


int  StrT_Mul_commit( StrT_Mul* m )
{
  TCHAR*  p = _tcschr( m->Next, _T('\0') ) + 1;

  IF_D( (char*)p >= (char*)m->First + m->Size )  return  E_FewArray;

  m->Next = p;
  *p = _T('\0');
  return  0;
}


 
/***********************************************************************
  <<< [StrArr] >>> 
************************************************************************/
int  StrArr_init( StrArr* m )
{
  int  e;

  Set2_init_const( &m->Array );
  StrT_Mul_init_const( &m->Chars );

  e= Set2_init( &m->Array, 0x100 ); IF(e)goto cancel;
  e= StrT_Mul_init( &m->Chars ); IF(e)goto cancel;
  return  0;

cancel:  StrArr_finish( m, e );  return  e;
}


int  StrArr_finish( StrArr* m, int e )
{
  if ( ! Set2_isInited( &m->Array ) )  return  0;

  e= Set2_finish( &m->Array, e );
  e= StrT_Mul_finish( &m->Chars, e );
  return  e;
}


int  StrArr_add( StrArr* m, const TCHAR* Str, int* out_I )
{
  int  e;

  e= StrArr_expandCount( m, _tcslen( Str ) ); IF(e)goto fin;
  _tcscpy_s( StrArr_getFreeAddr( m ), StrArr_getFreeCount( m ), Str );
  e= StrArr_commit( m ); IF(e)goto fin;
  if ( out_I != NULL )  *out_I = Set2_getCount( &m->Array, TCHAR* );

  e=0;
fin:
  return  e;
}


int  StrArr_commit( StrArr* m )
{
  int        e;
  TCHAR*     p;
  TCHAR**    pp  = NULL;
  Set2*      arr = &m->Array;
  StrT_Mul*  ss  = &m->Chars;

  p = StrT_Mul_getFreeAddr( ss );
  e= Set2_alloc( arr, &pp, TCHAR* ); IF(e)goto fin;
  e= StrT_Mul_commit( ss ); IF(e)goto fin;
  *pp = p;

  e=0;
fin:
  if ( e &&  pp != NULL )  Set2_freeLast( arr, pp, TCHAR* );
  return  e;
}


int  StrArr_fillTo( StrArr* m, int n, const TCHAR* Str )
{
  int      e;
  TCHAR*   p;
  TCHAR**  pp;
  TCHAR**  pp_over;

  n -= Set2_getCount( &m->Array, TCHAR* );
  if ( n <= 0 ) return 0;

  if ( Str == NULL ) {
    p = NULL;
  }
  else {
    e= StrT_Mul_add( &m->Chars, Str, &p ); IF(e)goto fin;
  }

  e= Set2_allocMulti( &m->Array, &pp, TCHAR*, n ); IF(e)goto fin;
  pp_over = pp + n;
  for ( ;  pp < pp_over;  pp++ )
    *pp = p;

  e=0;
fin:
  return  e;
}


int  StrArr_toEmpty( StrArr* m )
{
  int  e, ee;

  e=0;
  ee= Set2_toEmpty( &m->Array ); IF(ee&&!e)e=ee;
  ee= StrT_Mul_toEmpty( &m->Chars ); IF(ee&&!e)e=ee;
  return  e;
}


 
/***********************************************************************
  <<< [StrArr_parseCSV] >>> 
************************************************************************/
int  StrArr_parseCSV( StrArr* m, const TCHAR* CSVLine )
{
  int           e;
  const TCHAR*  p = CSVLine;

  e= StrArr_toEmpty( m ); IF(e)goto fin;

  do {
    e= StrT_meltCSV( StrArr_getFreeAddr( m ), StrArr_getFreeSize( m ), &p );
    if ( e == E_FewArray ) {
      e= StrArr_expandSize( m, StrArr_getFreeSize( m ) * 2 ); IF(e)goto fin;
      continue;
    }
    IF(e)goto fin;

    e = StrArr_commit( m ); IF(e)goto fin;
  } while ( p != NULL );

  e=0;
fin:
  return  e;
}


 
/***********************************************************************
  <<< (StrMatchKey) >>> 
************************************************************************/
void  StrMatchKey_init_const( StrMatchKey* m )
{
  m->Keyword          = NULL;
  m->WildcardLeftStr  = NULL;
  m->WildcardRightStr = NULL;
}

int  StrMatchKey_init( StrMatchKey* m, const TCHAR* Keyword )
{
  int     e;
  TCHAR*  p;

  m->Keyword = StrT_malloc_cpy( Keyword ); IF(m->Keyword==NULL)goto err_fm;
  p = _tcschr( Keyword, _T('*') );
  if ( p == NULL ) {
    m->WildcardLeftStr = StrT_malloc_cpy( Keyword ); IF(m->WildcardLeftStr==NULL)goto err_fm;
    m->WildcardLeftLength = _tcslen( Keyword );

    m->WildcardRightLength = 0;
  }
  else {
    IF( _tcschr( p+1, _T('*') ) != NULL ) goto err_aa;

    m->WildcardLeftStr = StrT_malloc_cpy( Keyword ); IF(m->WildcardLeftStr==NULL)goto err_fm;
    m->WildcardLeftLength = p - Keyword;
    m->WildcardLeftStr[ m->WildcardLeftLength ] = _T('\0');

    m->WildcardRightStr = StrT_malloc_cpy( p+1 ); IF(m->WildcardRightStr==NULL)goto err_fm;
    m->WildcardRightLength = _tcslen( p+1 );
  }

  e=0;
fin:
  return  e;

err_fm: e= E_FewMemory; goto resume;
err_aa: e = E_Others;  Error4_printf( _T("<ERROR msg=\"* 𕡐w肷邱Ƃ͂ł܂\"/>") ); goto resume;
resume: StrMatchKey_finish( m, 0 ); goto fin;
}

int  StrMatchKey_finish( StrMatchKey* m, int e )
{
  if ( m->Keyword != NULL )  free( m->Keyword );
  if ( m->WildcardLeftStr  != NULL )  free( m->WildcardLeftStr );
  if ( m->WildcardRightStr != NULL )  free( m->WildcardRightStr );
  StrMatchKey_init_const( m );
  return  e;
}

bool  StrMatchKey_isMatch( StrMatchKey* m, const TCHAR* String )
{
  if ( _tcsnicmp( String, m->WildcardLeftStr, m->WildcardLeftLength ) != 0 )
    return  false;

  if ( _tcsnicmp( _tcschr( String + m->WildcardLeftLength, _T('\0') ) - m->WildcardRightLength,
       m->WildcardRightStr, m->WildcardRightLength ) != 0 )
    return  false;

  return  true;
}

 
/*=================================================================*/
/* <<< [IniFile2/IniFile2.c] >>> */ 
/*=================================================================*/
 
/***********************************************************************
  <<< [IniStr_isLeft] >>> 
************************************************************************/
bool  IniStr_isLeft( const TCHAR* line, const TCHAR* symbol )
{
  const TCHAR*  p;
  size_t  symbol_len = _tcslen( symbol );

  /* Skip spaces at the top of line */
  for ( p = line; *p == _T(' ') || *p == _T('\t'); p++ );

  /* Compare symbol */
  if ( _tcsnicmp( p, symbol, symbol_len ) != 0 )  return false;

  switch ( *(p + symbol_len) ) {
    case _T(' '):  case _T('\t'):  case _T('='):  return  true;
    default:  return  false;
  }
}



 
/***********************************************************************
  <<< [IniStr_refRight] >>> 
************************************************************************/
TCHAR*  IniStr_refRight( const TCHAR* line, bool bTrimRight )
{
  const TCHAR*  p;

  for ( p = line; *p != _T('\0') && *p != _T('='); p++ );
  if ( *p == _T('=') ) {

    //=== Skip spaces at the right of equal. Trim the left of value
    for ( p++ ; *p == _T(' ') || *p == _T('\t'); p++ );

    //=== Trim the right of value
    if ( bTrimRight ) {
      const TCHAR*  t;
      TCHAR  c;

      t = _tcschr( p, _T('\0') );
      if ( t != p ) {
        for ( t--; t>=p; t-- ) {
          c = *t;
          if ( c != ' ' && c != '\t' && c != '\n' && c != '\r' )
            { *(TCHAR*)(t+1) = _T('\0');  break; }
        }
      }
    }
  }
  return  (TCHAR*) p;
}


 
/*=================================================================*/
/* <<< [Locale/Locale.c] >>> */ 
/*=================================================================*/
 
/***********************************************************************
  <<< [g_LocaleSymbol] >>> 
************************************************************************/
char*  g_LocaleSymbol = "";


 
/***********************************************************************
  <<< [Locale_init] >>> 
************************************************************************/
int  Locale_init()
{
  g_LocaleSymbol = ".OCP";
  setlocale( LC_ALL, ".OCP" );
  return  0;
}

 
/***********************************************************************
  <<< [Locale_isInited] >>> 
************************************************************************/
int  Locale_isInited()
{
  return  ( g_LocaleSymbol[0] != '\0' );
   //  false ԂƂ̑Ώ@́ALocale_isInited ̃wvQƂĂB
}

 
/*=================================================================*/
/* <<< [FileT/FileT.c] >>> */ 
/*=================================================================*/
 
/***********************************************************************
  <<< [FileT_isExist] >>> 
************************************************************************/
bool  FileT_isExist( const TCHAR* path )
{
 #if ! FileT_isExistWildcard

  DWORD  r;

  if ( path[0] == _T('\0') )  return  false;
  r = GetFileAttributes( path );
  return  r != (DWORD)-1;

 #else

  HANDLE  find;
  WIN32_FIND_DATA  data;

  find = FindFirstFileEx( path, FindExInfoStandard, &data,
    FindExSearchNameMatch, NULL, 0 );

  if ( find == INVALID_HANDLE_VALUE ) {
    return  false;
  }
  else {
    FindClose( find );
    return  true;
  }

 #endif
}


 
/***********************************************************************
  <<< [FileT_isFile] >>> 
************************************************************************/
bool  FileT_isFile( const TCHAR* path )
{
  DWORD  r = GetFileAttributes( path );
  return  ( r & (FILE_ATTRIBUTE_DIRECTORY | 0x80000000) ) == 0;
    // 0x80000000 ́At@CtH_݂ȂƂ𔻒肷邽
}


 
/***********************************************************************
  <<< [FileT_isDir] >>> 
************************************************************************/
bool  FileT_isDir( const TCHAR* path )
{
  DWORD  r = GetFileAttributes( path );
  return  ( r & (FILE_ATTRIBUTE_DIRECTORY | 0x80000000) ) == FILE_ATTRIBUTE_DIRECTORY;
    // 0x80000000 ́At@CtH_݂ȂƂ𔻒肷邽
}


 
/***********************************************************************
  <<< [FileT_callByNestFind] TutH_܂߂Ċet@C̃pXn >>> 
************************************************************************/
typedef struct {
  /*--- inherit from FileT_CallByNestFindData */
  void*     CallerArgument;
  TCHAR*    AbsPath;  // abstruct path
  TCHAR*    StepPath;
  TCHAR*    FileName;
  DWORD     FileAttributes;

  /*---*/
  BitField  Flags;
  FuncType  CallbackFromNestFind;
  TCHAR     AbsPathMem[4096];
} FileT_CallByNestFindDataIn;

int  FileT_callByNestFind_sub( FileT_CallByNestFindDataIn* m );


int  FileT_callByNestFind( const TCHAR* Path, BitField Flags, void* Argument, FuncType Callback )
{
  int  e;
  FileT_CallByNestFindDataIn  data;

  {
    TCHAR*  p;

    e= StrT_cpy( data.AbsPathMem, sizeof(data.AbsPathMem), Path ); IF(e)goto fin;


    /* AbsPathMem ̍Ō \ Ȃǉ */
    p = _tcschr( data.AbsPathMem, _T('\0') );
    p--;
    if ( *p != _T('\\') ) {
      p++;
      IF( p >= data.AbsPathMem + (sizeof(data.AbsPathMem) / sizeof(TCHAR)) - 1 )goto err_fa;
      *p = _T('\\');
    }


    /* data  */
    data.CallerArgument = Argument;
    data.AbsPath = data.AbsPathMem;
    data.StepPath = p + 1;
    data.FileName = p + 1;
    data.Flags = Flags;
    data.CallbackFromNestFind = Callback;
  }

  /* ċNĂяo֐ */
  e= FileT_callByNestFind_sub( &data ); IF(e)goto fin;

  e=0;
fin:
  return  e;
err_fa: e= E_FewArray; goto fin;
}


int  FileT_callByNestFind_sub( FileT_CallByNestFindDataIn* m )
{
  int  e;
  HANDLE  find;
  WIN32_FIND_DATA  data;
  TCHAR*  p;
  int  done;


  /* Path Ɏw肵tH_ɑ΂ăR[obN */
  if ( m->Flags & FileT_FolderBeforeFiles ) {
    *( m->FileName - 1 ) = _T('\0');  // m->AbsPath ̍Ō \ ꎞIɃJbg
    *( m->FileName ) = _T('\0');  // m->FileName, m->StepPath  "" ɂ
    m->FileAttributes = FILE_ATTRIBUTE_DIRECTORY;

    if ( m->StepPath[0] == _T('\0') ) {
      TCHAR*  step_path = m->StepPath;
      TCHAR*  fname     = m->FileName;

      m->StepPath = _T(".");
      m->FileName = StrT_refFName( m->AbsPath );
      e= m->CallbackFromNestFind( m ); IF(e)goto fin;
      m->StepPath = step_path;
      m->FileName = fname;
    }
    else {
      e= m->CallbackFromNestFind( m ); IF(e)goto fin;
    }
    *( m->FileName - 1 ) = _T('\\');
  }


  /* * ǉ */
  p = m->FileName;
  IF( p >= m->AbsPathMem + (sizeof(m->AbsPathMem) / sizeof(TCHAR)) - 2 )goto err_fa;
  *p = _T('*');  *(p+1) = _T('\0');


  /* t@CtH_񋓂܂ */
  find = FindFirstFileEx( m->AbsPathMem, FindExInfoStandard, &data,
    FindExSearchNameMatch, NULL, 0 );
  done = ( find == INVALID_HANDLE_VALUE );

  while (!done)
  {
    if ( _tcscmp( data.cFileName, _T(".") ) == 0 ||
         _tcscmp( data.cFileName, _T("..") ) == 0 ) {
      done = ! FindNextFile( find, &data );
      continue;
    }

    StrT_cpy( m->FileName,
      sizeof(m->AbsPathMem) - ( (char*)m->FileName - (char*)m->AbsPathMem ),
      data.cFileName );
    m->FileAttributes = data.dwFileAttributes;

    if ( data.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY ) {
      TCHAR*  prev_fname = m->FileName;

      p = _tcschr( m->FileName, _T('\0') );

      IF( p >= m->AbsPathMem + (sizeof(m->AbsPathMem) / sizeof(TCHAR)) - 2 )goto err_fa;
      *p = _T('\\');  *(p+1) = _T('\0');
      m->FileName = p + 1;

      FileT_callByNestFind_sub( m );  /* ċNĂяo */

      m->FileName = prev_fname;
    }
    else {
      e= m->CallbackFromNestFind( m ); IF(e)goto fin;
    }

    done = ! FindNextFile( find, &data );
  }
  FindClose( find );


  /* Path Ɏw肵tH_ɑ΂ăR[obN */
  if ( m->Flags & FileT_FolderAfterFiles ) {
    *( m->FileName - 1 ) = _T('\0');
    m->FileAttributes = FILE_ATTRIBUTE_DIRECTORY;
    e= m->CallbackFromNestFind( m ); IF(e)goto fin;
  }

  e=0;
fin:
  return  e;
err_fa: e= E_FewArray; goto fin;
}


 
/***********************************************************************
  <<< [FileT_openForRead] >>> 
************************************************************************/
int  FileT_openForRead( FILE** out_pFile, const TCHAR* Path )
{
  errno_t  en;

  #ifndef NDEBUG
    assert( Locale_isInited() );
  #endif

  #if DEBUGTOOLS_USES
    { int e= Debug_onOpen( Path ); if(e) return e; }
  #endif

  en = _tfopen_s( out_pFile, Path, _T("r")_T(fopen_ccs) );
  if ( en == 2 ) {
    _tprintf( _T("not found \"%s\"\n"), Path );

    #ifndef UNDER_CE
    {
      TCHAR  cwd[512];

      if ( _tgetcwd( cwd, _countof(cwd) ) != NULL )
        _tprintf( _T("current = \"%s\"\n"), cwd );
    }
    #endif

    return  E_NotFoundSymbol;
  }
  IF(en)return  E_Others;

  return  0;
}


 
/***********************************************************************
  <<< [FileT_close] >>> 
************************************************************************/
int  FileT_close( FILE* File, int e )
{
  if ( File != NULL ) {
    int r = fclose( File );
    IF(r&&!e)e=E_Errno;
  }
  return e;
}



 
/*=================================================================*/
/* <<< [PlatformSDK_plus/PlatformSDK_plus.c] >>> */ 
/*=================================================================*/
 
/***********************************************************************
  <<< [GetCommandLineUnnamed] >>> 
************************************************************************/
int  GetCommandLineUnnamed( int Index1, TCHAR* out_AParam, size_t AParamSize )
{
  TCHAR*  line = GetCommandLine();
  int     index;
  TCHAR*  p;
  TCHAR*  p2;
  TCHAR   c;

  #if UNDER_CE
    Index1 --;
  #endif
  IF( Index1 < 0 ) goto err_nf;
  index = Index1;

  p = line;

  for (;;) {
    while ( *p == _T(' ') )  p++;

    c = *p;

    if ( c == _T('\0') )  goto err_nf;  // Here is not decided to error or not


    //=== Skip named option
    else if ( c == _T('/') ) {
      p++;
      for (;;) {
        c = *p;
        if ( c == _T('"') || c == _T(' ') || c == _T('\0') )  break;
        p++;
      }

      if ( c == _T('"') ) {
        p++;
        while ( *p != _T('"') && *p != _T('\0') )  p++;
        if ( *p == _T('"') )  p++;
      }
    }

    //=== Skip or Get unnamed parameter
    else {
      while ( *p == _T(' ') )  p++;

      c = *p;
      p2 = p + 1;

      if ( c == _T('"') ) {
        p ++;
        while ( *p2 != _T('"') && *p2 != _T('\0') )  p2++;
      }
      else {
        while ( *p2 != _T(' ') && *p2 != _T('\0') )  p2++;
      }

      if ( index == 0 ) {
        int  e;

        e= stcpy_part_r( out_AParam, AParamSize, out_AParam, NULL, p, p2 ); IF_D(e);
        return  e;
      }
      else {
        p = ( *p2 == _T('"') ) ? p2+1 : p2;
        index --;
      }
    }
  }

err_nf:
  if ( AParamSize >= sizeof(TCHAR) )  *out_AParam = _T('\0');
  IF ( Index1 >= 2 )  return  E_NotFoundSymbol;
  return  0;
}


 
/***********************************************************************
  <<< [GetCommandLineNamed] >>> 
************************************************************************/
int  GetCommandLineNamed( const TCHAR* Name, bool bCase, TCHAR* out_Value, size_t ValueSize )
{
  TCHAR*  line = GetCommandLine();
  TCHAR*  p;
  TCHAR*  p2;
  TCHAR   c;
  const size_t  name_len = _tcslen( Name );
  bool    bMatch;

  p = line;
  for (;;) {
    c = *p;

    //=== Compare option name
    if ( c == _T('/') ) {
      p++;
      p2 = p;
      for (;;) {
        c = *p2;
        if ( c == _T(':') || c == _T(' ') || c == _T('\0') )  break;
        p2++;
      }
      bMatch = ( p2-p == name_len && _tcsncmp( p, Name, p2-p ) == 0 );


      //=== Get the value
      if ( c == _T(':') ) {
        p = p2 + 1;
        if ( *p == _T('"') ) {
          p++;
          p2 = p;
          while ( *p2 != _T('"') && *p2 != _T('\0') )  p2++;
          if ( bMatch )
            return  stcpy_part_r( out_Value, ValueSize, out_Value, NULL, p, p2 );
          else
            p = p2+1;
        }
        else {
          p2 = p;
          while ( *p2 != _T(' ') && *p2 != _T('\0') )  p2++;
          if ( bMatch )
            return  stcpy_part_r( out_Value, ValueSize, out_Value, NULL, p, p2 );
          else
            p = p2;
        }
      }
      else {
        if ( bMatch ) {
          if ( ValueSize > 0 )  { out_Value[0] = _T('\0');  return  0; }
          else  return  E_FewArray;
        }
      }
    }

    else if ( c == _T('\0') )  break;

    //=== Skip
    else if ( c == _T('"') ) {
      p++;
      while ( *p != _T('"') && *p != _T('\0') )  p++;
      while ( *p != _T(' ') && *p != _T('\0') )  p++;
    }
    else {
      while ( *p != _T(' ') && *p != _T('\0') )  p++;
    }
    while ( *p == _T(' ') )  p++;
  }

  return  E_NotFoundSymbol;
}


 
/***********************************************************************
  <<< [GetCommandLineNamedI] >>> 
************************************************************************/
int  GetCommandLineNamedI( const TCHAR* Name, bool bCase, int* out_Value )
{
  int  e;
  TCHAR  s[20];

  e= GetCommandLineNamed( Name, bCase, s, sizeof(s) ); IF(e)goto fin;  //[out] s
  if ( s[0] == _T('0') && s[1] == _T('x') )
    *out_Value = _tcstoul( s, NULL, 16 );
  else
    *out_Value = _ttoi( s );
  //e=0;
fin:
  return  e;
}


 
/***********************************************************************
  <<< [GetCommandLineNamedC8] >>> 
************************************************************************/
#if  _UNICODE
int  GetCommandLineNamedC8( const TCHAR* Name, bool bCase, char* out_Value, size_t ValueSize )
{
  int     e;
  TCHAR*  s = NULL;

  s = malloc( ValueSize * sizeof(TCHAR) );
  e= GetCommandLineNamed( Name, bCase, (TCHAR*) s, ValueSize * sizeof(TCHAR) ); IF(e)goto fin;

  sprintf_s( out_Value, ValueSize, "%S", s );
fin:
  if ( s != NULL )  free( s );
  return  e;
}
#endif


 
/***********************************************************************
  <<< [GetCommandLineExist] >>> 
************************************************************************/
bool  GetCommandLineExist( const TCHAR* Name, bool bCase )
{
  int     e;
  TCHAR   v[1];

  e = GetCommandLineNamed( Name, bCase, v, sizeof(v) );
  IF_D( e != 0 && e != E_FewArray && e != E_NotFoundSymbol );
  return  e != E_NotFoundSymbol;
}


 
/*=================================================================*/
/* <<< [Print/Print2.c] >>> */ 
/*=================================================================*/
 
/***********************************************************************
  <<< [vsprintf_r] >>> 
************************************************************************/
int  vsprintf_r( char* s, size_t s_size, const char* format, va_list va )
{
 #pragma warning(push)
 #pragma warning(disable: 4996)
  int  r = _vsnprintf( s, s_size, format, va );
 #pragma warning(pop)
  if ( r == s_size || r == -1 ) { s[s_size-1] = '\0';  return E_FewArray; }
  else  return  0;
}
 
/***********************************************************************
  <<< [vswprintf_r] >>> 
************************************************************************/
int  vswprintf_r( wchar_t* s, size_t s_size, const wchar_t* format, va_list va )
{
  size_t  tsize = s_size / sizeof(wchar_t);
 #pragma warning(push)
 #pragma warning(disable: 4996)
  int  r = _vsnwprintf( s, tsize, format, va );
 #pragma warning(pop)
  if ( r == tsize || r == -1 ) { s[tsize-1] = '\0';  return E_FewArray; }
  else  return  0;
}
 
/***********************************************************************
  <<< [stprintf_r] >>> 
************************************************************************/
int  stprintf_r( TCHAR* s, size_t s_size, const TCHAR* format, ... )
  { int e;  va_list  va;  va_start( va, format );
    e = vstprintf_r( s, s_size, format, va ); va_end( va );  return e; }


 
/***********************************************************************
  <<< [stcpy_part_r] >>> 
************************************************************************/
int  stcpy_part_r( TCHAR* s, size_t s_size, TCHAR* s_start, TCHAR** p_s_last,
                   const TCHAR* src, const TCHAR* src_over )
{
  size_t  s_space = (char*)s + s_size - (char*)s_start;
  size_t  src_size;

  IF_D( s_start < s || (char*)s_start >= (char*)s + s_size ) return 1;

  if ( src_over == NULL )  src_over = _tcschr( src, _T('\0') );
  src_size = (char*)src_over - (char*)src;
  if ( src_size < s_space ) {
    memcpy( s_start, src, src_size + sizeof(TCHAR) );
    s_start = (TCHAR*)((char*)s_start + src_size);  *s_start = _T('\0');
    if ( p_s_last != NULL )  *p_s_last = s_start;
    return 0;
  }
  else {
    s_space -= sizeof(TCHAR);  memcpy( s, src, s_space );
    s_start = (TCHAR*)((char*)s_start + s_space );  *s_start = '\0';
    if ( p_s_last != NULL )  *p_s_last=s_start;
    return E_FewArray;
  }
}


 
/***********************************************************************
  <<< [stprintf_part_r] >>> 
************************************************************************/
int  stprintf_part_r( TCHAR* s, size_t s_size, TCHAR* s_start, TCHAR** p_s_last,
                      const TCHAR* format, ... )
{
  int e;  va_list  va;  va_start( va, format );

  IF_D( s_start < s || (char*)s_start >= (char*)s + s_size ) return 1;

  e = vstprintf_r( s_start, s_size - ( (char*)s - (char*)s_start), format, va );
  va_end( va );  if ( p_s_last != NULL )  *p_s_last = _tcschr( s_start, '\0' );
  return e;
}

 
/*=================================================================*/
/* <<< [Global0/Global0.c] >>> */ 
/*=================================================================*/
 
/***********************************************************************
  <<< [Globals_init_const_to_clib] >>> 
************************************************************************/
#define  DisableToRedirect_for_clib  1
 #include  "redir/clib_redir_dis.h"
#undef   DisableToRedirect_for_clib

void  Globals_init_const() {}
int   Globals_init() { return 0; }
int   Globals_finish( int e ) { return e; }



void  Globals_init_const_to_clib()
{

 
} // (end of Globals_init_const_to_clib) 
 
/***********************************************************************
  <<< [Globals_init_to_clib] >>> 
************************************************************************/
int  Globals_init_to_clib()
{
  int  e;

 
  e= Locale_init(); IF(e)goto fin; 
 
  e=0;
  goto fin;  // for avoid warning, if no implement in Global0_init
fin:
  return  e;
} // (end of Globals_init_to_clib) 
 
/***********************************************************************
  <<< [Globals_finish_to_clib] >>> 
************************************************************************/
int  Globals_finish_to_clib( int e )
{
 
  return  e; 
} // (end of Globals_finish_to_clib)


 
