/*
 *
 *      VBDOX - Visual Basic Documentation Generator
 *      Copyright (c) 2000 - 2003 Mihayl Stamenov <michael.stamenov@web.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
// Common functions

function unquote(s) {
	return s.replace(/"/g, "");
}

function loadReportManagers(list, props) {
	var mgrList = props.getProperty("report.manager.list").split(",");

	for (var j = 0; j < mgrList.length; ++j) {
		var opt = document.createElement("OPTION");
		opt.text = unquote(props.getProperty("report.manager." + mgrList[j] + ".name"));
		opt.value = mgrList[j];
		list.add(opt);
	}
}

function loadDocParsers(list, props) {
	var mgrList = props.getProperty("doc.parser.list").split(",");

	for (var j = 0; j < mgrList.length; ++j) {
		var opt = document.createElement("OPTION");
		opt.text = unquote(props.getProperty("doc.parser." + mgrList[j] + ".name"));
		opt.value = mgrList[j];
		list.add(opt);
	}
}

function loadLanguages(list, props) {
	var langList = props.getProperty("report.manager.languages").split(",");
	var langDescList = props.getProperty("report.manager.langDescriptions").split(",");

	for (var j = 0; j < langList.length; ++j) {
		var opt = document.createElement("OPTION");
		opt.text = unquote(langDescList[j]);
		opt.value = langList[j];
		list.add(opt);
	}
}

function loadDictionaries(list, props) {
	var dicList = props.getProperty("options.spellcheck.dic.list").split(",");

	for (var j = 0; j < dicList.length; ++j) {
		var opt = document.createElement("OPTION");
		opt.text = unquote(dicList[j]);
		opt.value = dicList[j];
		list.add(opt);
	}
}

/////////////////////////////////////////////////////////////////////////