package jp.sourceforge.masasa.architecture.framework.validation;

import java.util.ArrayList;
import java.util.List;

import jp.sourceforge.masasa.architecture.framework.validation.annotation.CheckByte;
import junit.framework.TestCase;

import org.apache.commons.validator.ValidatorException;
import org.junit.Test;

/**
 * @see org.apache.commons.validator.ByteTest
 */
public class CheckByteTest extends TestCase {

	/**
	 * Tests the byte validation.
	 */
	@Test
	public void testByte1() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new Data("0"));
		Validator validator = new Validator();
		validator.validate(list);
		assertTrue(validator.getErrors().isEmpty());
	}

	/**
	 * Tests the byte validation.
	 */
	@Test
	public void testByte2() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new DataVerifyWhenNull("0"));
		Validator validator = new Validator();
		validator.validate(list);
		assertTrue(validator.getErrors().isEmpty());
	}

	/**
	 * Tests the byte validation.
	 */
	@Test
	public void testByteMin1() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new Data(new Byte(Byte.MIN_VALUE).toString()));
		Validator validator = new Validator();
		validator.validate(list);
		assertTrue(validator.getErrors().isEmpty());
	}

	/**
	 * Tests the byte validation.
	 */
	@Test
	public void testByteMin2() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new DataVerifyWhenNull(new Byte(Byte.MIN_VALUE).toString()));
		Validator validator = new Validator();
		validator.validate(list);
		assertTrue(validator.getErrors().isEmpty());
	}

	/**
	 * Tests the byte validation.
	 */
	@Test
	public void testByteMax1() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new Data(new Byte(Byte.MAX_VALUE).toString()));
		Validator validator = new Validator();
		validator.validate(list);
		assertTrue(validator.getErrors().isEmpty());
	}

	/**
	 * Tests the byte validation.
	 */
	@Test
	public void testByteMax2() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new DataVerifyWhenNull(new Byte(Byte.MAX_VALUE).toString()));
		Validator validator = new Validator();
		validator.validate(list);
		assertTrue(validator.getErrors().isEmpty());
	}

	/**
	 * Tests the byte validation failure.
	 */
	@Test
	public void testByteFailure1() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new Data());
		Validator validator = new Validator();
		validator.validate(list);
		assertTrue(validator.getErrors().isEmpty());
	}

	/**
	 * Tests the byte validation failure.
	 */
	@Test
	public void testByteFailure2() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new DataVerifyWhenNull());
		Validator validator = new Validator();
		validator.validate(list);
		assertFalse(validator.getErrors().isEmpty());
	}

	/**
	 * Tests the byte validation failure.
	 */
	@Test
	public void testByteBeyondMin1() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new Data(Byte.MIN_VALUE + "1"));
		Validator validator = new Validator();
		validator.validate(list);
		assertFalse(validator.getErrors().isEmpty());
	}

	/**
	 * Tests the byte validation failure.
	 */
	@Test
	public void testByteBeyondMin2() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new DataVerifyWhenNull(Byte.MIN_VALUE + "1"));
		Validator validator = new Validator();
		validator.validate(list);
		assertFalse(validator.getErrors().isEmpty());
	}

	/**
	 * Tests the byte validation failure.
	 */
	@Test
	public void testByteBeyondMax1() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new Data(Byte.MAX_VALUE + "1"));
		Validator validator = new Validator();
		validator.validate(list);
		assertFalse(validator.getErrors().isEmpty());
	}

	/**
	 * Tests the byte validation failure.
	 */
	@Test
	public void testByteBeyondMax2() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new DataVerifyWhenNull(Byte.MAX_VALUE + "1"));
		Validator validator = new Validator();
		validator.validate(list);
		assertFalse(validator.getErrors().isEmpty());
	}

	public class  Data implements ITestData {
		private static final long serialVersionUID = -3826026660084218649L;
		@CheckByte
		private String data;

		public Data() {
		}

		public Data(String data) {
			this.data = data;
		}

		public String getData() {
			return data;
		}

		public void setData(String data) {
			this.data = data;
		}
	}

	public class  DataVerifyWhenNull implements ITestData {
		private static final long serialVersionUID = -4249622657013861086L;
		@CheckByte(verifyWhenNull = true)
		private String data;

		public DataVerifyWhenNull() {
		}

		public DataVerifyWhenNull(String data) {
			this.data = data;
		}

		public String getData() {
			return data;
		}

		public void setData(String data) {
			this.data = data;
		}
	}
}
