/**
 *
 */
package jp.sourceforge.masasa.architecture.framework;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import org.apache.commons.lang3.StringUtils;

/**
 * @author masasa.
 */
public class MethodAccessUtil {

	/**
	 * <code>field</code>の値を返却します.
	 *
	 * @param target
	 *            対象.
	 * @param fieldName
	 *            フィールド名.
	 * @return <code>field</code>の値.
	 */
	public static String doInvoke(Object target, String fieldName) {
		Method method = null;
		String capitalizedName = StringUtils.capitalize(fieldName);
		try {
			method = target.getClass().getMethod("get" + capitalizedName);
		} catch (Exception ex) {
			try {
				method = target.getClass().getMethod("is" + capitalizedName);
			} catch (NoSuchMethodException e) {
				e.printStackTrace();
			} catch (IllegalArgumentException e) {
				e.printStackTrace();
			}
		}
		Object rv = null;
		if (method != null) {
			try {
				rv = method.invoke(target, (Object[]) null);
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			} catch (InvocationTargetException e) {
				e.printStackTrace();
			}
		}
		return rv == null ? null : rv.toString();
	}

	public static void setInvoke(Object target, String fieldName, String value) {
		Method method = null;
		String capitalizedName = StringUtils.capitalize(fieldName);
		try {
			method = target.getClass().getMethod("set" + capitalizedName);
		} catch (Exception e) {
			e.printStackTrace();
		}
		try {
			method.invoke(target, value);
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		} catch (InvocationTargetException e) {
			e.printStackTrace();
		}
	}

	/**
	 * <code>field</code>の値を返却します.
	 *
	 * @param target
	 *            対象.
	 * @param field
	 *            フィールド.
	 * @return <code>field</code>の値.
	 */
	public static String doInvoke(Object target, Field field) {
		return doInvoke(target, field.getName());
	}
}
