package jp.sourceforge.masasa.architecture.framework.validation.validator;

import java.lang.annotation.Annotation;

import jp.sourceforge.masasa.architecture.framework.validation.annotation.CheckRequiredIf;
import jp.sourceforge.masasa.architecture.framework.validation.enumeration.FieldTestEnum;
import jp.sourceforge.masasa.architecture.framework.validation.util.MethodAccessUtil;

import org.apache.commons.validator.GenericValidator;

/**
 * Checks if the field isn't null based on the values of other fields.
 *
 * @author masasa.
 * @see org.apache.struts.validator.FieldChecks#validateRequiredIf(Object, org.apache.commons.validator.ValidatorAction,
 *      org.apache.commons.validator.Field, org.apache.struts.action.ActionMessages,
 *      org.apache.commons.validator.Validator, javax.servlet.http.HttpServletRequest)
 */
@SuppressWarnings("javadoc")
public class ValidateRequiredIf implements IValidator {

    /**
     * デフォルトのフィールド結合文字列.
     */
    private static final String DEFAULT_FIELD_JOIN = "AND"; //$NON-NLS-1$

    /**
     * Checks if the field isn't null based on the values of other fields.
     *
     * @param anno
     *            バリデーションに対応するアノテーション.
     * @param targetValue
     *            検証値.
     * @param lineObject
     *            Beanが所属するオブジェクト.
     * @return バリデーション結果.
     *         <ul>
     *         <li><code>true</code>:エラーなし.</li>
     *         <li><code>false</code>:エラーあり.</li>
     *         </ul>
     * @see jp.sourceforge.masasa.architecture.framework.validation.validator.IValidator #validate(java
     *      .lang.annotation.Annotation, java.lang.String, java.lang.Object)
     */
    @Override
    public boolean validate(final Annotation anno, final String targetValue, final Object lineObject) {
        CheckRequiredIf resolver = (CheckRequiredIf) anno;
        // if (!resolver.verifyWhenNull() && value == null) {
        // return true;
        // }
        boolean required = false;
        String fieldJoin = DEFAULT_FIELD_JOIN;
        if (!GenericValidator.isBlankOrNull(resolver.fieldJoin())) fieldJoin = resolver.fieldJoin();
        if (fieldJoin.equalsIgnoreCase(DEFAULT_FIELD_JOIN)) required = true;

        String dependProp;
        FieldTestEnum dependTest;
        String dependTestValue;
        String dependVal;
        for (int i = 0; i < resolver.field().length; i++) {
            dependProp = resolver.field()[i];
            dependTest = resolver.fieldTest()[i];
            dependTestValue = resolver.fieldValue()[i];

            dependVal = null;
            boolean thisRequired = false;
            dependVal = MethodAccessUtil.doInvoke(lineObject, dependProp);
            if (dependTest.equals(FieldTestEnum.FIELD_TEST_NULL))
                thisRequired = !((dependVal != null) && (dependVal.length() > 0));
            if (dependTest.equals(FieldTestEnum.FIELD_TEST_NOTNULL))
                thisRequired = (dependVal != null) && (dependVal.length() > 0);
            if (dependTest.equals(FieldTestEnum.FIELD_TEST_EQUAL))
                thisRequired = dependTestValue.equalsIgnoreCase(dependVal);
            required = fieldJoin.equalsIgnoreCase(DEFAULT_FIELD_JOIN) ? required && thisRequired : required
                    || thisRequired;
        }
        return required ? !GenericValidator.isBlankOrNull(targetValue) : true;
    }

}
