package jp.sourceforge.masasa.architecture.framework.validation.validator;

import java.lang.annotation.Annotation;

import jp.sourceforge.masasa.architecture.framework.validation.annotation.CheckDoubleRange;

import org.apache.commons.validator.GenericValidator;

/**
 * Checks if a fields value is within a range (min &amp; max specified in the vars attribute).
 *
 * @author masasa.
 * @see org.apache.struts.validator.FieldChecks#validateDoubleRange(Object,
 *      org.apache.commons.validator.ValidatorAction, org.apache.commons.validator.Field,
 *      org.apache.struts.action.ActionMessages, org.apache.commons.validator.Validator,
 *      javax.servlet.http.HttpServletRequest)
 */
@SuppressWarnings("javadoc")
public class ValidateDoubleRange implements IValidator {

    /**
     * Checks if a fields value is within a range (min &amp; max specified in the vars attribute).
     *
     * @param anno
     *            バリデーションに対応するアノテーション.
     * @param targetValue
     *            検証値.
     * @param lineObject
     *            Beanが所属するオブジェクト.
     * @return バリデーション結果.
     *         <ul>
     *         <li><code>true</code>:エラーなし.</li>
     *         <li><code>false</code>:エラーあり.</li>
     *         </ul>
     * @see jp.sourceforge.masasa.architecture.framework.validation.validator.IValidator #validate(java
     *      .lang.annotation.Annotation, java.lang.String, java.lang.Object)
     */
    @Override
    public boolean validate(final Annotation anno, final String targetValue, final Object lineObject) {
        CheckDoubleRange resolver = (CheckDoubleRange) anno;
        if (!resolver.verifyWhenNull() && targetValue == null) return true;
        double dblValue = 0;
        try {
            dblValue = Double.parseDouble(targetValue);
        } catch (NumberFormatException e) {
            return false;
        }
        return GenericValidator.isInRange(dblValue, resolver.min(), resolver.max());
    }

}
