package jp.sourceforge.masasa.architecture.framework.validation.validator;

import java.lang.annotation.Annotation;
import java.text.SimpleDateFormat;
import java.util.Date;

import jp.sourceforge.masasa.architecture.framework.validation.annotation.CheckDate;

import org.apache.commons.validator.GenericTypeValidator;

/**
 * Checks if the field is a valid date. If the field has a datePattern variable, that will be used to format
 * {@link SimpleDateFormat}. If the field has a datePatternStrict variable, that will be used to format
 * {@link SimpleDateFormat} and the length will be checked so '2/12/1999' will not pass validation with the format
 * 'MM/dd/yyyy' because the month isn't two digits. If no datePattern variable is specified, then the field gets the
 * DateFormat.SHORT format for the locale. The setLenient method is set to <code>false</code> for all variations.
 *
 * @author masasa.
 * @see org.apache.struts.validator.FieldChecks#validateDate(Object, org.apache.commons.validator.ValidatorAction,
 *      org.apache.commons.validator.Field, org.apache.struts.action.ActionMessages,
 *      org.apache.commons.validator.Validator, javax.servlet.http.HttpServletRequest)
 */
@SuppressWarnings("javadoc")
public class ValidateDate implements IValidator {

    /**
     * Checks if the field is a valid date. If the field has a datePattern variable, that will be used to format
     * {@link SimpleDateFormat}. If the field has a datePatternStrict variable, that will be used to format
     * {@link SimpleDateFormat} and the length will be checked so '2/12/1999' will not pass validation with the format
     * 'MM/dd/yyyy' because the month isn't two digits. If no datePattern variable is specified, then the field gets the
     * DateFormat.SHORT format for the locale. The setLenient method is set to <code>false</code> for all variations.
     *
     * @param anno
     *            バリデーションに対応するアノテーション.
     * @param targetValue
     *            検証値.
     * @param lineObject
     *            Beanが所属するオブジェクト.
     * @return バリデーション結果.
     *         <ul>
     *         <li><code>true</code>:エラーなし.</li>
     *         <li><code>false</code>:エラーあり.</li>
     *         </ul>
     * @see jp.sourceforge.masasa.architecture.framework.validation.validator.IValidator #validate(java
     *      .lang.annotation.Annotation, java.lang.String, java.lang.Object)
     */
    @Override
    public boolean validate(final Annotation anno, final String targetValue, final Object lineObject) {
        CheckDate resolver = (CheckDate) anno;
        if (!resolver.verifyWhenNull() && targetValue == null) return true;
        Date result = null;
        if (resolver.datePattern() != null && resolver.datePattern().length() > 0) {
            result = GenericTypeValidator.formatDate(targetValue, resolver.datePattern(), false);
        } else if (resolver.datePatternStrict() != null && resolver.datePatternStrict().length() > 0) {
            result = GenericTypeValidator.formatDate(targetValue, resolver.datePatternStrict(), true);
        }
        return result != null;
    }

}
