package jp.sourceforge.masasa.architecture.framework.validation.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import org.apache.commons.lang3.StringUtils;

/**
 * メソッドにアクセスするためのユーティリティクラス.
 * 
 * @author masasa.
 */
public final class MethodAccessUtil {

    /**
     * コンストラクタ. <br>
     * インスタンス生成不可.
     */
    private MethodAccessUtil() {
        // do nothing
    }

    /**
     * <code>field</code>の値を返却します.
     * 
     * @param target
     *            対象.
     * @param fieldName
     *            フィールド名.
     * @return <code>field</code>の値.
     */
    public static String doInvoke(final Object target, final String fieldName) {
        Method method = null;
        String capitalizedName = StringUtils.capitalize(fieldName);
        try {
            method = target.getClass().getMethod("get" //$NON-NLS-1$
                    + capitalizedName);
        } catch (Exception ex) {
            try {
                method = target.getClass().getMethod("is" //$NON-NLS-1$
                        + capitalizedName);
            } catch (NoSuchMethodException e) {
                // do nothing
            } catch (IllegalArgumentException e) {
                // do nothing
            }
        }
        Object rv = null;
        if (method != null) {
            method.setAccessible(true);
            try {
                rv = method.invoke(target, (Object[]) null);
            } catch (IllegalAccessException e) {
                // do nothing
            } catch (InvocationTargetException e) {
                // do nothing
            }
        }
        return rv == null ? null : rv.toString();
    }

    /**
     * <code>field</code>の値を返却します.
     * 
     * @param target
     *            対象.
     * @param field
     *            フィールド.
     * @return <code>field</code>の値.
     */
    public static String doInvoke(final Object target, final Field field) {
        return doInvoke(target, field.getName());
    }
}
