package jp.sourceforge.masasa.architecture.framework.validation.resource;

import java.text.MessageFormat;
import java.util.HashSet;

import jp.sourceforge.masasa.architecture.framework.validation.ValidateProperties;

/**
 * プロパティファイルを管理するクラス.
 *
 * @author masasa.
 */
public final class PropertyManager {

    /** 登録済みリソース名. */
    private static HashSet<String> resourceSet = new HashSet<String>();
    /** リソースユーティリティ. */
    private static ResourceUtils messages = null;

    /**
     * インスタンス化不可.
     */
    private PropertyManager() {
        // do nothing
    }

    /**
     * 登録されているプロパティファイルから、キーに該当する値を返却します.
     *
     * @param key
     *            メッセージキー.
     * @return メッセージ.
     */
    public static String getMessage(final String key) {
        if (messages == null) messages = getResourceUtils();
        return messages.getResourceString(key);
    }

    /**
     * 登録されているプロパティファイルから、キーに該当する値を返却します. <br>
     * {0},{1}形式で指定されているパラメータに可変文字をセットします.
     *
     * @param key
     *            メッセージキー.
     * @param arguments
     *            可変文字列.
     * @return メッセージ.
     */
    public static String getMessage(final String key, final Object... arguments) {
        return MessageFormat.format(getMessage(key), arguments);
    }

    /**
     * メッセージリソースを返却します.
     *
     * @return メッセージリソース.
     */
    public static synchronized ResourceUtils getResourceUtils() {
        if (messages == null) {
            messages = new ResourceUtils(ValidateProperties.RESOURCE_NAME, PropertyManager.class.getClassLoader());
            resourceSet.add(ValidateProperties.RESOURCE_NAME);
        }
        return messages;
    }

}
