/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.jersey.fastpack;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import net.osdn.util.jersey.fastpack.EOF;

public class ByteUnpacker {
    private static byte BYTE_STRING_EMPTY = 0;
    private static int MAX_STRING_LENGTH = 16383;
    private static int INT_LONG_0 = 192;
    private static byte BYTE_LONG_0 = (byte)-64;
    private static byte BYTE_LONG_1 = (byte)-63;
    private static byte BYTE_LONG_2 = (byte)-62;
    private static byte BYTE_LONG_3 = (byte)-61;
    private static byte BYTE_LONG_4 = (byte)-60;
    private static byte BYTE_LONG_5 = (byte)-59;
    private static byte BYTE_LONG_6 = (byte)-58;
    private static byte BYTE_LONG_7 = (byte)-57;
    private static byte BYTE_LONG_8 = (byte)-56;
    private static byte BYTE_LONG_9 = (byte)-55;
    private static byte BYTE_LONG_10 = (byte)-54;
    private static byte BYTE_LONG_11 = (byte)-53;
    private static byte BYTE_LONG_12 = (byte)-52;
    private static byte BYTE_LONG_13 = (byte)-51;
    private static byte BYTE_LONG_14 = (byte)-50;
    private static byte BYTE_LONG_15 = (byte)-49;
    private static byte BYTE_LONG_N1 = (byte)-48;
    private static byte BYTE_LONG_NEXT1 = (byte)-47;
    private static byte BYTE_LONG_NEXT2 = (byte)-46;
    private static byte BYTE_LONG_NEXT3 = (byte)-45;
    private static byte BYTE_LONG_NEXT4 = (byte)-44;
    private static byte BYTE_LONG_NEXT5 = (byte)-43;
    private static byte BYTE_LONG_NEXT6 = (byte)-42;
    private static byte BYTE_LONG_NEXT7 = (byte)-41;
    private static byte BYTE_LONG_NEXT8 = (byte)-40;
    private static byte BYTE_LONG_NEXT1_N = (byte)-39;
    private static byte BYTE_LONG_NEXT2_N = (byte)-38;
    private static byte BYTE_LONG_NEXT3_N = (byte)-37;
    private static byte BYTE_LONG_NEXT4_N = (byte)-36;
    private static byte BYTE_LONG_NEXT5_N = (byte)-35;
    private static byte BYTE_LONG_NEXT6_N = (byte)-34;
    private static byte BYTE_LONG_NEXT7_N = (byte)-33;
    private static int INT_LONG_NEXT7_N = 223;
    private static int INT_DOUBLE_0 = 224;
    private static byte BYTE_DOUBLE_0 = (byte)-32;
    private static byte BYTE_DOUBLE_1 = (byte)-31;
    private static byte BYTE_DOUBLE_2 = (byte)-30;
    private static byte BYTE_DOUBLE_3 = (byte)-29;
    private static byte BYTE_DOUBLE_4 = (byte)-28;
    private static byte BYTE_DOUBLE_5 = (byte)-27;
    private static byte BYTE_DOUBLE_6 = (byte)-26;
    private static byte BYTE_DOUBLE_7 = (byte)-25;
    private static byte BYTE_DOUBLE_8 = (byte)-24;
    private static byte BYTE_DOUBLE_9 = (byte)-23;
    private static byte BYTE_DOUBLE_10 = (byte)-22;
    private static byte BYTE_DOUBLE_11 = (byte)-21;
    private static byte BYTE_DOUBLE_12 = (byte)-20;
    private static byte BYTE_DOUBLE_13 = (byte)-19;
    private static byte BYTE_DOUBLE_14 = (byte)-18;
    private static byte BYTE_DOUBLE_15 = (byte)-17;
    private static byte BYTE_DOUBLE_N1 = (byte)-16;
    private static int INT_DOUBLE_N1 = 240;
    private static byte BYTE_DOUBLE_NEXT8 = (byte)-8;
    private static byte BYTE_NULL = (byte)-1;
    private static Charset UTF8 = Charset.forName("UTF-8");
    private InputStream in;
    private byte[] buf = new byte[MAX_STRING_LENGTH];
    private boolean wasNull;

    public ByteUnpacker(InputStream in) {
        this.in = in;
    }

    public boolean wasNull() {
        return this.wasNull;
    }

    public Object read() throws IOException {
        int i = this.in.read();
        if (i < 0) {
            return EOF.instance;
        }
        byte firstByte = (byte)i;
        boolean bl = this.wasNull = firstByte == BYTE_NULL;
        if (firstByte == BYTE_NULL) {
            return null;
        }
        if (firstByte == BYTE_STRING_EMPTY) {
            return "";
        }
        if (firstByte == BYTE_DOUBLE_NEXT8) {
            return this.readPrimitiveDouble(firstByte);
        }
        if ((firstByte & 0x80) == 0 || (firstByte & 0xC0) == 128) {
            return this.readString(firstByte);
        }
        i = firstByte & 0xFF;
        if (INT_LONG_0 <= i && i <= INT_LONG_NEXT7_N) {
            return this.readPrimitiveLong(firstByte);
        }
        if (INT_DOUBLE_0 <= i && i <= INT_DOUBLE_N1) {
            return this.readPrimitiveDouble(firstByte);
        }
        throw new IOException("not object");
    }

    public String readString() throws IOException {
        byte firstByte = ByteUnpacker.read(this.in);
        this.wasNull = firstByte == BYTE_NULL;
        if (this.wasNull) {
            return null;
        }
        return this.readString(firstByte);
    }

    public long readPrimitiveLong() throws IOException {
        byte firstByte = ByteUnpacker.read(this.in);
        this.wasNull = firstByte == BYTE_NULL;
        if (this.wasNull) {
            return 0L;
        }
        return this.readPrimitiveLong(firstByte);
    }

    public Long readLong() throws IOException {
        byte firstByte = ByteUnpacker.read(this.in);
        this.wasNull = firstByte == BYTE_NULL;
        if (this.wasNull) {
            return null;
        }
        return this.readPrimitiveLong(firstByte);
    }

    public double readPrimitiveDouble() throws IOException {
        byte firstByte = ByteUnpacker.read(this.in);
        this.wasNull = firstByte == BYTE_NULL;
        if (this.wasNull) {
            return 0.0;
        }
        return this.readPrimitiveDouble(firstByte);
    }

    public Double readDouble() throws IOException {
        byte firstByte = ByteUnpacker.read(this.in);
        this.wasNull = firstByte == BYTE_NULL;
        if (this.wasNull) {
            return null;
        }
        return this.readPrimitiveDouble(firstByte);
    }

    private String readString(byte firstByte) throws IOException {
        byte b = firstByte;
        if (b == BYTE_NULL) {
            return null;
        }
        if (b == BYTE_STRING_EMPTY) {
            return "";
        }
        if ((b & 0x80) == 0) {
            byte len = b;
            ByteUnpacker.read(this.in, this.buf, 0, len);
            return new String(this.buf, 0, (int)len, UTF8);
        }
        if ((b & 0xC0) == 128) {
            byte b2 = ByteUnpacker.read(this.in);
            int len = (b & 0x3F) << 8 | b2 & 0xFF;
            ByteUnpacker.read(this.in, this.buf, 0, len);
            return new String(this.buf, 0, len, UTF8);
        }
        throw new IOException("not string");
    }

    private long readPrimitiveLong(byte firstByte) throws IOException {
        byte b = firstByte;
        if (b == BYTE_LONG_0) {
            return 0L;
        }
        if (b == BYTE_LONG_1) {
            return 1L;
        }
        if (b == BYTE_LONG_2) {
            return 2L;
        }
        if (b == BYTE_LONG_3) {
            return 3L;
        }
        if (b == BYTE_LONG_4) {
            return 4L;
        }
        if (b == BYTE_LONG_5) {
            return 5L;
        }
        if (b == BYTE_LONG_6) {
            return 6L;
        }
        if (b == BYTE_LONG_7) {
            return 7L;
        }
        if (b == BYTE_LONG_8) {
            return 8L;
        }
        if (b == BYTE_LONG_9) {
            return 9L;
        }
        if (b == BYTE_LONG_10) {
            return 10L;
        }
        if (b == BYTE_LONG_11) {
            return 11L;
        }
        if (b == BYTE_LONG_12) {
            return 12L;
        }
        if (b == BYTE_LONG_13) {
            return 13L;
        }
        if (b == BYTE_LONG_14) {
            return 14L;
        }
        if (b == BYTE_LONG_15) {
            return 15L;
        }
        if (b == BYTE_LONG_N1) {
            return -1L;
        }
        this.buf[0] = 0;
        this.buf[1] = 0;
        this.buf[2] = 0;
        this.buf[3] = 0;
        this.buf[4] = 0;
        this.buf[5] = 0;
        this.buf[6] = 0;
        boolean isNegative = false;
        if (b == BYTE_LONG_NEXT1) {
            ByteUnpacker.read(this.in, this.buf, 7, 1);
        } else if (b == BYTE_LONG_NEXT2) {
            ByteUnpacker.read(this.in, this.buf, 6, 2);
        } else if (b == BYTE_LONG_NEXT3) {
            ByteUnpacker.read(this.in, this.buf, 5, 3);
        } else if (b == BYTE_LONG_NEXT4) {
            ByteUnpacker.read(this.in, this.buf, 4, 4);
        } else if (b == BYTE_LONG_NEXT5) {
            ByteUnpacker.read(this.in, this.buf, 3, 5);
        } else if (b == BYTE_LONG_NEXT6) {
            ByteUnpacker.read(this.in, this.buf, 2, 6);
        } else if (b == BYTE_LONG_NEXT7) {
            ByteUnpacker.read(this.in, this.buf, 1, 7);
        } else if (b == BYTE_LONG_NEXT8) {
            ByteUnpacker.read(this.in, this.buf, 0, 8);
        } else if (b == BYTE_LONG_NEXT1_N) {
            isNegative = true;
            ByteUnpacker.read(this.in, this.buf, 7, 1);
        } else if (b == BYTE_LONG_NEXT2_N) {
            isNegative = true;
            ByteUnpacker.read(this.in, this.buf, 6, 2);
        } else if (b == BYTE_LONG_NEXT3_N) {
            isNegative = true;
            ByteUnpacker.read(this.in, this.buf, 5, 3);
        } else if (b == BYTE_LONG_NEXT4_N) {
            isNegative = true;
            ByteUnpacker.read(this.in, this.buf, 4, 4);
        } else if (b == BYTE_LONG_NEXT5_N) {
            isNegative = true;
            ByteUnpacker.read(this.in, this.buf, 3, 5);
        } else if (b == BYTE_LONG_NEXT6_N) {
            isNegative = true;
            ByteUnpacker.read(this.in, this.buf, 2, 6);
        } else if (b == BYTE_LONG_NEXT7_N) {
            isNegative = true;
            ByteUnpacker.read(this.in, this.buf, 1, 7);
        } else {
            throw new IOException("not long");
        }
        long value = ((long)this.buf[0] & 0xFFL) << 56 | ((long)this.buf[1] & 0xFFL) << 48 | ((long)this.buf[2] & 0xFFL) << 40 | ((long)this.buf[3] & 0xFFL) << 32 | ((long)this.buf[4] & 0xFFL) << 24 | ((long)this.buf[5] & 0xFFL) << 16 | ((long)this.buf[6] & 0xFFL) << 8 | ((long)this.buf[7] & 0xFFL) << 0;
        if (isNegative) {
            value *= -1L;
        }
        return value;
    }

    private double readPrimitiveDouble(byte firstByte) throws IOException {
        byte b = firstByte;
        if (b == BYTE_DOUBLE_0) {
            return 0.0;
        }
        if (b == BYTE_DOUBLE_1) {
            return 1.0;
        }
        if (b == BYTE_DOUBLE_2) {
            return 2.0;
        }
        if (b == BYTE_DOUBLE_3) {
            return 3.0;
        }
        if (b == BYTE_DOUBLE_4) {
            return 4.0;
        }
        if (b == BYTE_DOUBLE_5) {
            return 5.0;
        }
        if (b == BYTE_DOUBLE_6) {
            return 6.0;
        }
        if (b == BYTE_DOUBLE_7) {
            return 7.0;
        }
        if (b == BYTE_DOUBLE_8) {
            return 8.0;
        }
        if (b == BYTE_DOUBLE_9) {
            return 9.0;
        }
        if (b == BYTE_DOUBLE_10) {
            return 10.0;
        }
        if (b == BYTE_DOUBLE_11) {
            return 11.0;
        }
        if (b == BYTE_DOUBLE_12) {
            return 12.0;
        }
        if (b == BYTE_DOUBLE_13) {
            return 13.0;
        }
        if (b == BYTE_DOUBLE_14) {
            return 14.0;
        }
        if (b == BYTE_DOUBLE_15) {
            return 15.0;
        }
        if (b == BYTE_DOUBLE_N1) {
            return -1.0;
        }
        if (b == BYTE_DOUBLE_NEXT8) {
            ByteUnpacker.read(this.in, this.buf, 0, 8);
            long v = ((long)this.buf[0] & 0xFFL) << 56 | ((long)this.buf[1] & 0xFFL) << 48 | ((long)this.buf[2] & 0xFFL) << 40 | ((long)this.buf[3] & 0xFFL) << 32 | ((long)this.buf[4] & 0xFFL) << 24 | ((long)this.buf[5] & 0xFFL) << 16 | ((long)this.buf[6] & 0xFFL) << 8 | ((long)this.buf[7] & 0xFFL) << 0;
            return Double.longBitsToDouble(v);
        }
        throw new IOException("not double");
    }

    private static byte read(InputStream in) throws IOException {
        int i = in.read();
        if (i == -1) {
            throw new EOFException();
        }
        return (byte)i;
    }

    private static void read(InputStream in, byte[] buf, int off, int len) throws IOException {
        while (len > 0) {
            int size = in.read(buf, off, len);
            if (size < 0) {
                throw new EOFException();
            }
            off += size;
            len -= size;
        }
    }
}

