/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.jersey.fastpack;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class BytePacker {
    private static byte[] BYTES_STRING_EMPTY = new byte[]{0};
    private static int MAX_STRING_LENGTH = 16383;
    private static byte[] BYTES_LONG_0 = new byte[]{-64};
    private static byte[] BYTES_LONG_1 = new byte[]{-63};
    private static byte[] BYTES_LONG_2 = new byte[]{-62};
    private static byte[] BYTES_LONG_3 = new byte[]{-61};
    private static byte[] BYTES_LONG_4 = new byte[]{-60};
    private static byte[] BYTES_LONG_5 = new byte[]{-59};
    private static byte[] BYTES_LONG_6 = new byte[]{-58};
    private static byte[] BYTES_LONG_7 = new byte[]{-57};
    private static byte[] BYTES_LONG_8 = new byte[]{-56};
    private static byte[] BYTES_LONG_9 = new byte[]{-55};
    private static byte[] BYTES_LONG_10 = new byte[]{-54};
    private static byte[] BYTES_LONG_11 = new byte[]{-53};
    private static byte[] BYTES_LONG_12 = new byte[]{-52};
    private static byte[] BYTES_LONG_13 = new byte[]{-51};
    private static byte[] BYTES_LONG_14 = new byte[]{-50};
    private static byte[] BYTES_LONG_15 = new byte[]{-49};
    private static byte[] BYTES_LONG_N1 = new byte[]{-48};
    private static byte[] BYTES_LONG_NEXT1 = new byte[]{-47};
    private static byte[] BYTES_LONG_NEXT2 = new byte[]{-46};
    private static byte[] BYTES_LONG_NEXT3 = new byte[]{-45};
    private static byte[] BYTES_LONG_NEXT4 = new byte[]{-44};
    private static byte[] BYTES_LONG_NEXT5 = new byte[]{-43};
    private static byte[] BYTES_LONG_NEXT6 = new byte[]{-42};
    private static byte[] BYTES_LONG_NEXT7 = new byte[]{-41};
    private static byte[] BYTES_LONG_NEXT8 = new byte[]{-40};
    private static byte[] BYTES_LONG_NEXT1_N = new byte[]{-39};
    private static byte[] BYTES_LONG_NEXT2_N = new byte[]{-38};
    private static byte[] BYTES_LONG_NEXT3_N = new byte[]{-37};
    private static byte[] BYTES_LONG_NEXT4_N = new byte[]{-36};
    private static byte[] BYTES_LONG_NEXT5_N = new byte[]{-35};
    private static byte[] BYTES_LONG_NEXT6_N = new byte[]{-34};
    private static byte[] BYTES_LONG_NEXT7_N = new byte[]{-33};
    private static long N7BYTES_MAX = -72057594037927935L;
    private static byte[] BYTES_DOUBLE_0 = new byte[]{-32};
    private static byte[] BYTES_DOUBLE_1 = new byte[]{-31};
    private static byte[] BYTES_DOUBLE_2 = new byte[]{-30};
    private static byte[] BYTES_DOUBLE_3 = new byte[]{-29};
    private static byte[] BYTES_DOUBLE_4 = new byte[]{-28};
    private static byte[] BYTES_DOUBLE_5 = new byte[]{-27};
    private static byte[] BYTES_DOUBLE_6 = new byte[]{-26};
    private static byte[] BYTES_DOUBLE_7 = new byte[]{-25};
    private static byte[] BYTES_DOUBLE_8 = new byte[]{-24};
    private static byte[] BYTES_DOUBLE_9 = new byte[]{-23};
    private static byte[] BYTES_DOUBLE_10 = new byte[]{-22};
    private static byte[] BYTES_DOUBLE_11 = new byte[]{-21};
    private static byte[] BYTES_DOUBLE_12 = new byte[]{-20};
    private static byte[] BYTES_DOUBLE_13 = new byte[]{-19};
    private static byte[] BYTES_DOUBLE_14 = new byte[]{-18};
    private static byte[] BYTES_DOUBLE_15 = new byte[]{-17};
    private static byte[] BYTES_DOUBLE_N1 = new byte[]{-16};
    private static byte[] BYTES_DOUBLE_NEXT8 = new byte[]{-8};
    private static byte[] BYTES_NULL = new byte[]{-1};
    private static Charset UTF8 = Charset.forName("UTF-8");
    private OutputStream out;
    private byte[] buf = new byte[8];

    public BytePacker(OutputStream out) {
        this.out = out;
    }

    public BytePacker writeNull() throws IOException {
        this.out.write(BYTES_NULL, 0, 1);
        return this;
    }

    public BytePacker writeString(String value) throws IOException {
        if (value == null) {
            this.out.write(BYTES_NULL, 0, 1);
        } else if (value.length() == 0) {
            this.out.write(BYTES_STRING_EMPTY, 0, 1);
        } else {
            byte[] data = value.getBytes(UTF8);
            if (data.length < 127) {
                this.out.write(data.length);
                this.out.write(data);
            } else if (data.length <= MAX_STRING_LENGTH) {
                this.buf[0] = (byte)(0x80 | data.length >> 8);
                this.buf[1] = (byte)data.length;
                this.out.write(this.buf, 0, 2);
                this.out.write(data);
            } else {
                throw new IOException("string too long.");
            }
        }
        return this;
    }

    public BytePacker writeLong(Long value) throws IOException {
        if (value == null) {
            this.out.write(BYTES_NULL, 0, 1);
        } else {
            this.writeLong((long)value);
        }
        return this;
    }

    public BytePacker writeLong(long value) throws IOException {
        if (value == 0L) {
            this.out.write(BYTES_LONG_0, 0, 1);
        } else if (value == 1L) {
            this.out.write(BYTES_LONG_1, 0, 1);
        } else if (value == 2L) {
            this.out.write(BYTES_LONG_2, 0, 1);
        } else if (value == 3L) {
            this.out.write(BYTES_LONG_3, 0, 1);
        } else if (value == 4L) {
            this.out.write(BYTES_LONG_4, 0, 1);
        } else if (value == 5L) {
            this.out.write(BYTES_LONG_5, 0, 1);
        } else if (value == 6L) {
            this.out.write(BYTES_LONG_6, 0, 1);
        } else if (value == 7L) {
            this.out.write(BYTES_LONG_7, 0, 1);
        } else if (value == 8L) {
            this.out.write(BYTES_LONG_8, 0, 1);
        } else if (value == 9L) {
            this.out.write(BYTES_LONG_9, 0, 1);
        } else if (value == 10L) {
            this.out.write(BYTES_LONG_10, 0, 1);
        } else if (value == 11L) {
            this.out.write(BYTES_LONG_11, 0, 1);
        } else if (value == 12L) {
            this.out.write(BYTES_LONG_12, 0, 1);
        } else if (value == 13L) {
            this.out.write(BYTES_LONG_13, 0, 1);
        } else if (value == 14L) {
            this.out.write(BYTES_LONG_14, 0, 1);
        } else if (value == 15L) {
            this.out.write(BYTES_LONG_15, 0, 1);
        } else if (value == -1L) {
            this.out.write(BYTES_LONG_N1, 0, 1);
        } else if (value > 0L) {
            int off = 0;
            this.buf[0] = (byte)(value >> 56);
            this.buf[1] = (byte)(value >> 48);
            this.buf[2] = (byte)(value >> 40);
            this.buf[3] = (byte)(value >> 32);
            this.buf[4] = (byte)(value >> 24);
            this.buf[5] = (byte)(value >> 16);
            this.buf[6] = (byte)(value >> 8);
            this.buf[7] = (byte)(value >> 0);
            if (this.buf[0] == 0) {
                ++off;
                if (this.buf[1] == 0) {
                    ++off;
                    if (this.buf[2] == 0) {
                        ++off;
                        if (this.buf[3] == 0) {
                            ++off;
                            if (this.buf[4] == 0) {
                                ++off;
                                if (this.buf[5] == 0) {
                                    ++off;
                                    if (this.buf[6] == 0) {
                                        ++off;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            int len = 8 - off;
            switch (len) {
                case 1: {
                    this.out.write(BYTES_LONG_NEXT1, 0, 1);
                    break;
                }
                case 2: {
                    this.out.write(BYTES_LONG_NEXT2, 0, 1);
                    break;
                }
                case 3: {
                    this.out.write(BYTES_LONG_NEXT3, 0, 1);
                    break;
                }
                case 4: {
                    this.out.write(BYTES_LONG_NEXT4, 0, 1);
                    break;
                }
                case 5: {
                    this.out.write(BYTES_LONG_NEXT5, 0, 1);
                    break;
                }
                case 6: {
                    this.out.write(BYTES_LONG_NEXT6, 0, 1);
                    break;
                }
                case 7: {
                    this.out.write(BYTES_LONG_NEXT7, 0, 1);
                    break;
                }
                case 8: {
                    this.out.write(BYTES_LONG_NEXT8, 0, 1);
                }
            }
            this.out.write(this.buf, off, len);
        } else if (value >= N7BYTES_MAX) {
            int off = 0;
            this.buf[0] = (byte)((value *= -1L) >> 56);
            this.buf[1] = (byte)(value >> 48);
            this.buf[2] = (byte)(value >> 40);
            this.buf[3] = (byte)(value >> 32);
            this.buf[4] = (byte)(value >> 24);
            this.buf[5] = (byte)(value >> 16);
            this.buf[6] = (byte)(value >> 8);
            this.buf[7] = (byte)(value >> 0);
            if (this.buf[0] == 0) {
                ++off;
                if (this.buf[1] == 0) {
                    ++off;
                    if (this.buf[2] == 0) {
                        ++off;
                        if (this.buf[3] == 0) {
                            ++off;
                            if (this.buf[4] == 0) {
                                ++off;
                                if (this.buf[5] == 0) {
                                    ++off;
                                    if (this.buf[6] == 0) {
                                        ++off;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            int len = 8 - off;
            switch (len) {
                case 1: {
                    this.out.write(BYTES_LONG_NEXT1_N, 0, 1);
                    break;
                }
                case 2: {
                    this.out.write(BYTES_LONG_NEXT2_N, 0, 1);
                    break;
                }
                case 3: {
                    this.out.write(BYTES_LONG_NEXT3_N, 0, 1);
                    break;
                }
                case 4: {
                    this.out.write(BYTES_LONG_NEXT4_N, 0, 1);
                    break;
                }
                case 5: {
                    this.out.write(BYTES_LONG_NEXT5_N, 0, 1);
                    break;
                }
                case 6: {
                    this.out.write(BYTES_LONG_NEXT6_N, 0, 1);
                    break;
                }
                case 7: {
                    this.out.write(BYTES_LONG_NEXT7_N, 0, 1);
                }
            }
            this.out.write(this.buf, off, len);
        } else {
            this.buf[0] = (byte)(value >> 56);
            this.buf[1] = (byte)(value >> 48);
            this.buf[2] = (byte)(value >> 40);
            this.buf[3] = (byte)(value >> 32);
            this.buf[4] = (byte)(value >> 24);
            this.buf[5] = (byte)(value >> 16);
            this.buf[6] = (byte)(value >> 8);
            this.buf[7] = (byte)(value >> 0);
            this.out.write(BYTES_LONG_NEXT8, 0, 1);
            this.out.write(this.buf, 0, 8);
        }
        return this;
    }

    public BytePacker writeDouble(Double value) throws IOException {
        if (value == null) {
            this.out.write(BYTES_NULL, 0, 1);
        } else {
            this.writeDouble((double)value);
        }
        return this;
    }

    public BytePacker writeDouble(double value) throws IOException {
        if (value == 0.0) {
            this.out.write(BYTES_DOUBLE_0, 0, 1);
        } else if (value == 1.0) {
            this.out.write(BYTES_DOUBLE_1, 0, 1);
        } else if (value == 2.0) {
            this.out.write(BYTES_DOUBLE_2, 0, 1);
        } else if (value == 3.0) {
            this.out.write(BYTES_DOUBLE_3, 0, 1);
        } else if (value == 4.0) {
            this.out.write(BYTES_DOUBLE_4, 0, 1);
        } else if (value == 5.0) {
            this.out.write(BYTES_DOUBLE_5, 0, 1);
        } else if (value == 6.0) {
            this.out.write(BYTES_DOUBLE_6, 0, 1);
        } else if (value == 7.0) {
            this.out.write(BYTES_DOUBLE_7, 0, 1);
        } else if (value == 8.0) {
            this.out.write(BYTES_DOUBLE_8, 0, 1);
        } else if (value == 9.0) {
            this.out.write(BYTES_DOUBLE_9, 0, 1);
        } else if (value == 10.0) {
            this.out.write(BYTES_DOUBLE_10, 0, 1);
        } else if (value == 11.0) {
            this.out.write(BYTES_DOUBLE_11, 0, 1);
        } else if (value == 12.0) {
            this.out.write(BYTES_DOUBLE_12, 0, 1);
        } else if (value == 13.0) {
            this.out.write(BYTES_DOUBLE_13, 0, 1);
        } else if (value == 14.0) {
            this.out.write(BYTES_DOUBLE_14, 0, 1);
        } else if (value == 15.0) {
            this.out.write(BYTES_DOUBLE_15, 0, 1);
        } else if (value == -1.0) {
            this.out.write(BYTES_DOUBLE_N1, 0, 1);
        } else {
            long v = Double.doubleToLongBits(value);
            this.buf[0] = (byte)(v >> 56);
            this.buf[1] = (byte)(v >> 48);
            this.buf[2] = (byte)(v >> 40);
            this.buf[3] = (byte)(v >> 32);
            this.buf[4] = (byte)(v >> 24);
            this.buf[5] = (byte)(v >> 16);
            this.buf[6] = (byte)(v >> 8);
            this.buf[7] = (byte)(v >> 0);
            this.out.write(BYTES_DOUBLE_NEXT8, 0, 1);
            this.out.write(this.buf, 0, 8);
        }
        return this;
    }
}

