package net.osdn.util.jersey;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility;

import net.osdn.util.jersey.aspect.AspectHandler;

import com.fasterxml.jackson.annotation.JsonProperty;

//https://tools.ietf.org/html/rfc7807

@JsonAutoDetect(fieldVisibility=Visibility.NONE, getterVisibility=Visibility.NONE, isGetterVisibility=Visibility.NONE)
public class ApplicationProblem extends RuntimeException implements AspectHandler.Ignore {
	private static final long serialVersionUID = 1L;
	
	private String  type     = "about:blank";
	private String  title    = "";
	private int     status   = 200;
	private String  detail   = "";
	private String  instance = "";
	
	public ApplicationProblem() {
	}
	
	@JsonProperty("type")
	public String getType() {
		return type;
	}
	
	@JsonProperty("type")
	public ApplicationProblem setType(String type) {
		this.type = type;
		return this;
	}
	
	@JsonProperty("title")
	public String getTitle() {
		return title;
	}
	
	@JsonProperty("title")
	public ApplicationProblem setTitle(String title) {
		this.title = title;
		return this;
	}
	
	@JsonProperty("status")
	public int getStatus() {
		return status;
	}
	
	@JsonProperty("status")
	public ApplicationProblem setStatus(int status) {
		this.status = status;
		return this;
	}
	
	@JsonProperty("detail")
	public String getDetail() {
		return detail;
	}
	
	@JsonProperty("detail")
	public ApplicationProblem setDetail(String detail) {
		this.detail = detail;
		return this;
	}
	
	@JsonProperty("instance")
	public String getInstance() {
		return instance;
	}
	
	@JsonProperty("instance")
	public ApplicationProblem setInstance(String instance) {
		this.instance = instance;
		return this;
	}
}
