/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.sql.hsqldb;

import java.lang.reflect.Field;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.osdn.util.sql.NamedParameterStatement;
import net.osdn.util.sql.StatementBuilder;

public class HsqldbStatementBuilder
extends StatementBuilder {
    @Override
    public boolean isAcceptable(DatabaseMetaData md) throws SQLException {
        String productName = md.getDatabaseProductName();
        return productName != null && productName.contains("HSQL");
    }

    @Override
    public NamedParameterStatement createMergeStatement(DatabaseMetaData md, Class<?> cls, String tableName) throws SQLException {
        StatementBuilder.Column column;
        int i;
        if (tableName == null) {
            tableName = this.getTableName(md, cls);
        }
        if (tableName == null) {
            throw new IllegalArgumentException();
        }
        HashSet<String> fieldNames = new HashSet<String>();
        Field[] fields = this.getFields(cls);
        for (int i2 = 0; i2 < fields.length; ++i2) {
            fieldNames.add(fields[i2].getName().toLowerCase());
        }
        List<StatementBuilder.Column> columns = this.getColumns(md, tableName, fieldNames);
        if (columns.size() == 0) {
            throw new IllegalStateException();
        }
        ArrayList<StatementBuilder.Column> sourceClauseColumns = new ArrayList<StatementBuilder.Column>();
        ArrayList<StatementBuilder.Column> setClauseColumns = new ArrayList<StatementBuilder.Column>();
        ArrayList<StatementBuilder.Column> whereClauseColumns = new ArrayList<StatementBuilder.Column>();
        ArrayList<StatementBuilder.Column> valuesClauseColumns = new ArrayList<StatementBuilder.Column>();
        for (StatementBuilder.Column column2 : columns) {
            if (!fieldNames.contains(column2.name.toLowerCase())) continue;
            sourceClauseColumns.add(column2);
            if (!(column2.isRowIdentifier || column2.isAutoincrement || column2.isRowVersion)) {
                setClauseColumns.add(column2);
            }
            if (column2.isRowIdentifier || column2.isRowVersion) {
                whereClauseColumns.add(column2);
            }
            if (column2.isAutoincrement || column2.isRowVersion) continue;
            valuesClauseColumns.add(column2);
        }
        if (setClauseColumns.size() == 0) {
            throw new IllegalArgumentException();
        }
        if (whereClauseColumns.size() == 0) {
            throw new IllegalArgumentException();
        }
        if (valuesClauseColumns.size() == 0) {
            throw new IllegalArgumentException();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("MERGE INTO \"");
        sb.append(tableName);
        sb.append("\" AS Target \r\n");
        sb.append("USING (VALUES( \r\n");
        for (i = 0; i < sourceClauseColumns.size(); ++i) {
            column = (StatementBuilder.Column)sourceClauseColumns.get(i);
            sb.append("  :");
            sb.append(column.name);
            if (i + 1 >= sourceClauseColumns.size()) continue;
            sb.append(", \r\n");
        }
        sb.append("\r\n)) AS Source (");
        for (i = 0; i < sourceClauseColumns.size(); ++i) {
            column = (StatementBuilder.Column)sourceClauseColumns.get(i);
            sb.append('\"');
            sb.append(column.name);
            sb.append('\"');
            if (i + 1 >= sourceClauseColumns.size()) continue;
            sb.append(", ");
        }
        sb.append(") \r\n");
        sb.append("ON (");
        for (i = 0; i < whereClauseColumns.size(); ++i) {
            column = (StatementBuilder.Column)whereClauseColumns.get(i);
            sb.append("Target.\"");
            sb.append(column.name);
            sb.append("\" = Source.\"");
            sb.append(column.name);
            sb.append('\"');
            if (i + 1 >= whereClauseColumns.size()) continue;
            sb.append(" AND ");
        }
        sb.append(") \r\n");
        sb.append("WHEN MATCHED THEN \r\n");
        sb.append("UPDATE SET \r\n");
        for (i = 0; i < setClauseColumns.size(); ++i) {
            column = (StatementBuilder.Column)setClauseColumns.get(i);
            sb.append("  \"");
            sb.append(column.name);
            sb.append("\" = Source.\"");
            sb.append(column.name);
            sb.append('\"');
            if (i + 1 >= setClauseColumns.size()) continue;
            sb.append(", \r\n");
        }
        sb.append(" \r\n");
        sb.append("WHEN NOT MATCHED THEN \r\n");
        sb.append("INSERT (");
        for (i = 0; i < valuesClauseColumns.size(); ++i) {
            column = (StatementBuilder.Column)valuesClauseColumns.get(i);
            sb.append('\"');
            sb.append(column.name);
            sb.append('\"');
            if (i + 1 >= valuesClauseColumns.size()) continue;
            sb.append(", ");
        }
        sb.append(") VALUES ( \r\n");
        for (i = 0; i < valuesClauseColumns.size(); ++i) {
            column = (StatementBuilder.Column)valuesClauseColumns.get(i);
            sb.append("  Source.\"");
            sb.append(column.name);
            sb.append('\"');
            if (i + 1 >= valuesClauseColumns.size()) continue;
            sb.append(", \r\n");
        }
        sb.append(" \r\n");
        sb.append(")\r\n");
        return new NamedParameterStatement(sb.toString());
    }
}

