/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.sql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import javax.sql.rowset.CachedRowSet;
import net.osdn.util.sql.DataSource;
import net.osdn.util.sql.NamedParameterStatement;
import net.osdn.util.sql.Sql;
import net.osdn.util.sql.SqlExecutionHandler;
import net.osdn.util.sql.Transaction;

public class SqlExecutionUtil {
    public static Sql createSql(String sql) {
        return new Sql(sql, null);
    }

    public static Sql createSql(String sql, Object[] parameters) {
        return new Sql(sql, parameters);
    }

    public static Sql createSql(NamedParameterStatement statement) {
        return new Sql(statement);
    }

    public static CachedRowSet executeQueryAndPopulate(Transaction transaction, Statement st, String sql, Sql dump) throws SQLException {
        DataSource.Instance datasource = transaction.getDataSource();
        SqlExecutionHandler handler = null;
        CachedRowSet rowSet = null;
        ResultSet rs = null;
        if (dump != null) {
            handler = datasource.getSqlExecutionHandler();
        }
        try {
            if (handler != null) {
                SqlExecutionUtil.fireBeforeExecution(handler, transaction, dump);
            }
            rs = st.executeQuery(sql);
            rowSet = datasource.populate(rs);
            if (handler != null) {
                SqlExecutionUtil.fireAfterReturning(handler, transaction, dump, rowSet);
                SqlExecutionUtil.fireAfterExecution(handler, transaction, dump);
            }
        }
        catch (Throwable e) {
            if (handler != null) {
                SqlExecutionUtil.fireAfterThrowing(handler, transaction, dump, e);
                SqlExecutionUtil.fireAfterExecution(handler, transaction, dump);
            }
            throw e;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        return rowSet;
    }

    public static CachedRowSet executeQueryAndPopulate(Transaction transaction, PreparedStatement st, Sql dump) throws SQLException {
        DataSource.Instance datasource = transaction.getDataSource();
        SqlExecutionHandler handler = null;
        CachedRowSet rowSet = null;
        ResultSet rs = null;
        if (dump != null) {
            handler = datasource.getSqlExecutionHandler();
        }
        try {
            if (handler != null) {
                SqlExecutionUtil.fireBeforeExecution(handler, transaction, dump);
            }
            rs = st.executeQuery();
            rowSet = datasource.populate(rs);
            if (handler != null) {
                SqlExecutionUtil.fireAfterReturning(handler, transaction, dump, rowSet);
                SqlExecutionUtil.fireAfterExecution(handler, transaction, dump);
            }
        }
        catch (Throwable e) {
            if (handler != null) {
                SqlExecutionUtil.fireAfterThrowing(handler, transaction, dump, e);
                SqlExecutionUtil.fireAfterExecution(handler, transaction, dump);
            }
            throw e;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        return rowSet;
    }

    public static int executeUpdate(Transaction transaction, PreparedStatement st, Sql dump) throws SQLException {
        int rowCount;
        DataSource.Instance datasource = transaction.getDataSource();
        SqlExecutionHandler handler = null;
        if (dump != null) {
            handler = datasource.getSqlExecutionHandler();
        }
        try {
            if (handler != null) {
                SqlExecutionUtil.fireBeforeExecution(handler, transaction, dump);
            }
            rowCount = st.executeUpdate();
            if (handler != null) {
                SqlExecutionUtil.fireAfterReturning(handler, transaction, dump, rowCount);
                SqlExecutionUtil.fireAfterExecution(handler, transaction, dump);
            }
        }
        catch (Throwable e) {
            if (handler != null) {
                SqlExecutionUtil.fireAfterThrowing(handler, transaction, dump, e);
                SqlExecutionUtil.fireAfterExecution(handler, transaction, dump);
            }
            throw e;
        }
        return rowCount;
    }

    public static int[] executeBatch(Transaction transaction, PreparedStatement st, List<Sql> dumps) throws SQLException {
        int[] rowCounts;
        DataSource.Instance datasource = transaction.getDataSource();
        SqlExecutionHandler handler = null;
        Sql[] _dumps = null;
        if (dumps != null && dumps.size() > 0) {
            handler = datasource.getSqlExecutionHandler();
            _dumps = dumps.toArray(new Sql[0]);
        }
        try {
            if (handler != null) {
                SqlExecutionUtil.fireBeforeExecution(handler, transaction, _dumps);
            }
            rowCounts = st.executeBatch();
            if (handler != null) {
                SqlExecutionUtil.fireAfterReturning(handler, transaction, _dumps, rowCounts);
                SqlExecutionUtil.fireAfterExecution(handler, transaction, _dumps);
            }
        }
        catch (Throwable e) {
            if (handler != null) {
                SqlExecutionUtil.fireAfterThrowing(handler, transaction, _dumps, e);
                SqlExecutionUtil.fireAfterExecution(handler, transaction, _dumps);
            }
            throw e;
        }
        return rowCounts;
    }

    private static void fireBeforeExecution(SqlExecutionHandler handler, Transaction transaction, Sql dump) {
        SqlExecutionUtil.fireBeforeExecution(handler, transaction, new Sql[]{dump});
    }

    private static void fireBeforeExecution(SqlExecutionHandler handler, Transaction transaction, Sql[] dumps) {
        try {
            handler.onBeforeExecution(transaction, dumps);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void fireAfterExecution(SqlExecutionHandler handler, Transaction transaction, Sql dump) {
        SqlExecutionUtil.fireAfterExecution(handler, transaction, new Sql[]{dump});
    }

    private static void fireAfterExecution(SqlExecutionHandler handler, Transaction transaction, Sql[] dumps) {
        try {
            handler.onAfterExecution(transaction, dumps);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void fireAfterReturning(SqlExecutionHandler handler, Transaction transaction, Sql dump, CachedRowSet rowSet) {
        try {
            dump.setResult(rowSet);
            dump.setAffectedRows(rowSet.size());
            handler.onAfterReturning(transaction, new Sql[]{dump});
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void fireAfterReturning(SqlExecutionHandler handler, Transaction transaction, Sql dump, int rowCount) {
        SqlExecutionUtil.fireAfterReturning(handler, transaction, new Sql[]{dump}, new int[]{rowCount});
    }

    private static void fireAfterReturning(SqlExecutionHandler handler, Transaction transaction, Sql[] dumps, int[] rowCounts) {
        try {
            for (int i = 0; i < dumps.length; ++i) {
                dumps[i].setAffectedRows(rowCounts[i]);
            }
            handler.onAfterReturning(transaction, dumps);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void fireAfterThrowing(SqlExecutionHandler handler, Transaction transaction, Sql dump, Throwable e) {
        SqlExecutionUtil.fireAfterThrowing(handler, transaction, new Sql[]{dump}, e);
    }

    private static void fireAfterThrowing(SqlExecutionHandler handler, Transaction transaction, Sql[] dumps, Throwable e) {
        try {
            handler.onAfterThrowing(transaction, dumps, e);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

