/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.sql;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.rowset.CachedRowSet;
import net.osdn.util.sql.DataSource;
import net.osdn.util.sql.NamedParameter;
import net.osdn.util.sql.NamedParameterStatement;
import net.osdn.util.sql.ObjectIterable;
import net.osdn.util.sql.ObjectIterator;
import net.osdn.util.sql.OptimisticConcurrencyException;
import net.osdn.util.sql.Sql;
import net.osdn.util.sql.SqlExecutionHandler;
import net.osdn.util.sql.SqlExecutionUtil;
import net.osdn.util.sql.StatementBuilder;
import net.osdn.util.sql.Table;
import net.osdn.util.sql.Transaction;

public class ORMapper {
    private static ConcurrentHashMap<Class<?>, String> cacheTableNames = new ConcurrentHashMap();
    private static ConcurrentHashMap<Class<?>, String> cacheSelectStatements = new ConcurrentHashMap();
    private static ConcurrentHashMap<Class<?>, String> cacheInsertStatements = new ConcurrentHashMap();
    private static ConcurrentHashMap<Class<?>, String> cacheUpdateStatements = new ConcurrentHashMap();
    private static ConcurrentHashMap<Class<?>, String> cacheDeleteStatements = new ConcurrentHashMap();
    private static ConcurrentHashMap<Class<?>, String> cacheMergeStatements = new ConcurrentHashMap();
    private ResultSet rs;
    private Class<?> cls;
    private Object obj;
    private NamedParameterStatement selectStatement;
    private NamedParameterStatement insertStatement;
    private NamedParameterStatement updateStatement;
    private NamedParameterStatement deleteStatement;
    private NamedParameterStatement mergeStatement;

    public ORMapper(ResultSet rs) {
        if (rs == null) {
            throw new IllegalArgumentException();
        }
        this.rs = rs;
    }

    public ORMapper(Class<?> cls) {
        if (cls == null) {
            throw new IllegalArgumentException();
        }
        this.cls = cls;
    }

    public ORMapper(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException();
        }
        this.obj = obj;
        this.cls = obj.getClass();
    }

    public <T> T get(Class<T> returnClass) throws SQLException, ParseException, ReflectiveOperationException {
        Object obj = null;
        Map<String, Field> fields = ORMapper.getFields(returnClass);
        String[] columnNames = ORMapper.getColumnNames(this.rs.getMetaData());
        int columnCount = this.rs.getMetaData().getColumnCount();
        if (this.rs.isBeforeFirst() && !this.rs.next()) {
            return null;
        }
        try {
            if (this.rs.getRow() == 0) {
                return null;
            }
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
        if (ORMapper.isScalar(returnClass)) {
            Object tmp;
            obj = tmp = ORMapper.getValue(this.rs, 1, returnClass);
        } else {
            obj = ORMapper.createInstance(returnClass);
            for (int i = 1; i <= columnCount; ++i) {
                Field field = fields.get(columnNames[i].toLowerCase());
                if (field == null) continue;
                Object value = ORMapper.getValue(this.rs, i, field);
                field.set(obj, value);
            }
        }
        return (T)obj;
    }

    public <T> List<T> getList(Class<T> returnClass) throws SQLException, ParseException, IllegalArgumentException, ReflectiveOperationException {
        ArrayList<Object> list = new ArrayList<Object>();
        if (ORMapper.isScalar(returnClass)) {
            if (this.rs.getMetaData().getColumnCount() != 1) {
                throw new IllegalArgumentException("To get as a list of scalar values, it must be a result set with a single column.");
            }
            while (this.rs.next()) {
                Object value = ORMapper.getValue(this.rs, 1, returnClass);
                if (this.rs.wasNull()) {
                    value = null;
                }
                list.add(value);
            }
        } else {
            Map<String, Field> fields = ORMapper.getFields(returnClass);
            String[] columnNames = ORMapper.getColumnNames(this.rs.getMetaData());
            int columnCount = this.rs.getMetaData().getColumnCount();
            while (this.rs.next()) {
                T obj = ORMapper.createInstance(returnClass);
                for (int i = 1; i <= columnCount; ++i) {
                    Field field = fields.get(columnNames[i].toLowerCase());
                    if (field == null) continue;
                    Object value = ORMapper.getValue(this.rs, i, field);
                    field.set(obj, value);
                }
                list.add(obj);
            }
        }
        return list;
    }

    public <T> ObjectIterable<T> getIterable(Class<T> returnClass) throws SQLException {
        ObjectIterator<T> iterator = new ObjectIterator<T>(returnClass, this.rs);
        ObjectIterable<T> iterable = new ObjectIterable<T>(iterator);
        return iterable;
    }

    public <T> ObjectIterator<T> getIterator(Class<T> returnClass) throws SQLException {
        ObjectIterator<T> iterator = new ObjectIterator<T>(returnClass, this.rs);
        return iterator;
    }

    public NamedParameterStatement getSelectStatement() throws SQLException, IllegalArgumentException, IllegalAccessException {
        try (Connection cn = DataSource.getConnection();){
            String tableName = ORMapper.getTableName(cn, this.cls);
            NamedParameterStatement namedParameterStatement = this.getSelectStatement(cn, tableName, this.obj);
            return namedParameterStatement;
        }
    }

    public NamedParameterStatement getSelectStatement(Object obj) throws SQLException, IllegalArgumentException, IllegalAccessException {
        try (Connection cn = DataSource.getConnection();){
            String tableName = ORMapper.getTableName(cn, this.cls);
            NamedParameterStatement namedParameterStatement = this.getSelectStatement(cn, tableName, obj);
            return namedParameterStatement;
        }
    }

    public NamedParameterStatement getSelectStatement(Connection cn) throws SQLException, IllegalArgumentException, IllegalAccessException {
        String tableName = ORMapper.getTableName(cn, this.cls);
        return this.getSelectStatement(cn, tableName, this.obj);
    }

    public NamedParameterStatement getSelectStatement(Connection cn, String tableName, Object obj) throws SQLException, IllegalArgumentException, IllegalAccessException {
        if (this.selectStatement == null) {
            String sql = cacheSelectStatements.get(this.cls);
            if (sql == null) {
                if (tableName == null) {
                    tableName = obj instanceof Table ? ((Table)obj).getTableName() : ORMapper.getTableName(cn, this.cls);
                }
                DatabaseMetaData md = cn.getMetaData();
                NamedParameterStatement npst = StatementBuilder.getInstance(md).createSelectStatement(md, this.cls, tableName, obj);
                sql = npst.getOriginalSql();
                cacheSelectStatements.put(this.cls, sql);
                this.selectStatement = npst;
            } else {
                this.selectStatement = new NamedParameterStatement(sql);
            }
        }
        this.selectStatement.clearParameters();
        if (obj != null) {
            if (!this.cls.isInstance(obj)) {
                throw new IllegalArgumentException();
            }
            Map<String, Field> fields = ORMapper.getFields(this.cls);
            for (String parameterName : this.selectStatement.getParameterNames()) {
                Field field = fields.get(parameterName.toLowerCase());
                if (field == null) continue;
                Object value = field.get(obj);
                this.selectStatement.setObject(parameterName, value);
            }
        }
        return this.selectStatement;
    }

    public NamedParameterStatement getInsertStatement() throws SQLException, IllegalArgumentException, IllegalAccessException {
        try (Connection cn = DataSource.getConnection();){
            NamedParameterStatement namedParameterStatement = this.getInsertStatement(cn, this.obj);
            return namedParameterStatement;
        }
    }

    public NamedParameterStatement getInsertStatement(Object obj) throws SQLException, IllegalArgumentException, IllegalAccessException {
        try (Connection cn = DataSource.getConnection();){
            NamedParameterStatement namedParameterStatement = this.getInsertStatement(cn, obj);
            return namedParameterStatement;
        }
    }

    public NamedParameterStatement getInsertStatement(Connection cn) throws SQLException, IllegalArgumentException, IllegalAccessException {
        return this.getInsertStatement(cn, this.obj);
    }

    public NamedParameterStatement getInsertStatement(Connection cn, Object obj) throws SQLException, IllegalArgumentException, IllegalAccessException {
        if (this.insertStatement == null) {
            String sql = cacheInsertStatements.get(this.cls);
            if (sql == null) {
                String tableName = null;
                if (obj instanceof Table) {
                    tableName = ((Table)obj).getTableName();
                }
                DatabaseMetaData md = cn.getMetaData();
                NamedParameterStatement npst = StatementBuilder.getInstance(md).createInsertStatement(md, this.cls, tableName);
                sql = npst.getOriginalSql();
                cacheInsertStatements.put(this.cls, sql);
                this.insertStatement = npst;
            } else {
                this.insertStatement = new NamedParameterStatement(sql);
            }
        }
        this.insertStatement.clearParameters();
        if (obj != null) {
            if (!this.cls.isInstance(obj)) {
                throw new IllegalArgumentException();
            }
            Map<String, Field> fields = ORMapper.getFields(this.cls);
            for (String parameterName : this.insertStatement.getParameterNames()) {
                Field field = fields.get(parameterName.toLowerCase());
                if (field == null) continue;
                Object value = field.get(obj);
                this.insertStatement.setObject(parameterName, value);
            }
        }
        return this.insertStatement;
    }

    public NamedParameterStatement getUpdateStatement() throws SQLException, IllegalArgumentException, IllegalAccessException {
        try (Connection cn = DataSource.getConnection();){
            NamedParameterStatement namedParameterStatement = this.getUpdateStatement(cn, this.obj);
            return namedParameterStatement;
        }
    }

    public NamedParameterStatement getUpdateStatement(Object obj) throws SQLException, IllegalArgumentException, IllegalAccessException {
        try (Connection cn = DataSource.getConnection();){
            NamedParameterStatement namedParameterStatement = this.getUpdateStatement(cn, obj);
            return namedParameterStatement;
        }
    }

    public NamedParameterStatement getUpdateStatement(Connection cn) throws SQLException, IllegalArgumentException, IllegalAccessException {
        return this.getUpdateStatement(cn, this.obj);
    }

    public NamedParameterStatement getUpdateStatement(Connection cn, Object obj) throws SQLException, IllegalArgumentException, IllegalAccessException {
        if (this.updateStatement == null) {
            String sql = cacheUpdateStatements.get(this.cls);
            if (sql == null) {
                String tableName = null;
                if (obj instanceof Table) {
                    tableName = ((Table)obj).getTableName();
                }
                DatabaseMetaData md = cn.getMetaData();
                NamedParameterStatement npst = StatementBuilder.getInstance(md).createUpdateStatement(md, this.cls, tableName);
                sql = npst.getOriginalSql();
                cacheUpdateStatements.put(this.cls, sql);
                this.updateStatement = npst;
            } else {
                this.updateStatement = new NamedParameterStatement(sql);
            }
        }
        this.updateStatement.clearParameters();
        if (obj != null) {
            if (!this.cls.isInstance(obj)) {
                throw new IllegalArgumentException();
            }
            Map<String, Field> fields = ORMapper.getFields(this.cls);
            for (String parameterName : this.updateStatement.getParameterNames()) {
                Field field = fields.get(parameterName.toLowerCase());
                if (field == null) continue;
                Object value = field.get(obj);
                this.updateStatement.setObject(parameterName, value);
            }
        }
        return this.updateStatement;
    }

    public NamedParameterStatement getDeleteStatement() throws SQLException, IllegalArgumentException, IllegalAccessException {
        try (Connection cn = DataSource.getConnection();){
            NamedParameterStatement namedParameterStatement = this.getDeleteStatement(cn, this.obj);
            return namedParameterStatement;
        }
    }

    public NamedParameterStatement getDeleteStatement(Object obj) throws SQLException, IllegalArgumentException, IllegalAccessException {
        try (Connection cn = DataSource.getConnection();){
            NamedParameterStatement namedParameterStatement = this.getDeleteStatement(cn, obj);
            return namedParameterStatement;
        }
    }

    public NamedParameterStatement getDeleteStatement(Connection cn) throws SQLException, IllegalArgumentException, IllegalAccessException {
        return this.getDeleteStatement(cn, this.obj);
    }

    public NamedParameterStatement getDeleteStatement(Connection cn, Object obj) throws SQLException, IllegalArgumentException, IllegalAccessException {
        if (this.deleteStatement == null) {
            String sql = cacheDeleteStatements.get(this.cls);
            if (sql == null) {
                String tableName = null;
                if (obj instanceof Table) {
                    tableName = ((Table)obj).getTableName();
                }
                DatabaseMetaData md = cn.getMetaData();
                NamedParameterStatement npst = StatementBuilder.getInstance(md).createDeleteStatement(md, this.cls, tableName);
                sql = npst.getOriginalSql();
                cacheDeleteStatements.put(this.cls, sql);
                this.deleteStatement = npst;
            } else {
                this.deleteStatement = new NamedParameterStatement(sql);
            }
        }
        this.deleteStatement.clearParameters();
        if (obj != null) {
            if (!this.cls.isInstance(obj)) {
                throw new IllegalArgumentException();
            }
            Map<String, Field> fields = ORMapper.getFields(this.cls);
            for (String parameterName : this.deleteStatement.getParameterNames()) {
                Field field = fields.get(parameterName.toLowerCase());
                if (field == null) continue;
                Object value = field.get(obj);
                this.deleteStatement.setObject(parameterName, value);
            }
        }
        return this.deleteStatement;
    }

    public NamedParameterStatement getMergeStatement() throws SQLException, IllegalArgumentException, IllegalAccessException {
        try (Connection cn = DataSource.getConnection();){
            NamedParameterStatement namedParameterStatement = this.getMergeStatement(cn, this.obj);
            return namedParameterStatement;
        }
    }

    public NamedParameterStatement getMergeStatement(Object obj) throws SQLException, IllegalArgumentException, IllegalAccessException {
        try (Connection cn = DataSource.getConnection();){
            NamedParameterStatement namedParameterStatement = this.getMergeStatement(cn, obj);
            return namedParameterStatement;
        }
    }

    public NamedParameterStatement getMergeStatement(Connection cn) throws SQLException, IllegalArgumentException, IllegalAccessException {
        return this.getMergeStatement(cn, this.obj);
    }

    public NamedParameterStatement getMergeStatement(Connection cn, Object obj) throws SQLException, IllegalArgumentException, IllegalAccessException {
        if (this.mergeStatement == null) {
            String sql = cacheMergeStatements.get(this.cls);
            if (sql == null) {
                String tableName = null;
                if (obj instanceof Table) {
                    tableName = ((Table)obj).getTableName();
                }
                DatabaseMetaData md = cn.getMetaData();
                NamedParameterStatement npst = StatementBuilder.getInstance(md).createMergeStatement(md, this.cls, tableName);
                sql = npst.getOriginalSql();
                cacheMergeStatements.put(this.cls, sql);
                this.mergeStatement = npst;
            } else {
                this.mergeStatement = new NamedParameterStatement(sql);
            }
        }
        this.mergeStatement.clearParameters();
        if (obj != null) {
            if (!this.cls.isInstance(obj)) {
                throw new IllegalArgumentException();
            }
            Map<String, Field> fields = ORMapper.getFields(this.cls);
            for (String parameterName : this.mergeStatement.getParameterNames()) {
                Field field = fields.get(parameterName.toLowerCase());
                if (field == null) continue;
                Object value = field.get(obj);
                this.mergeStatement.setObject(parameterName, value);
            }
        }
        return this.mergeStatement;
    }

    protected static CachedRowSet select(Transaction transaction, Connection cn, Class<?> cls) throws SQLException, IllegalArgumentException, IllegalAccessException {
        if (cls == null) {
            throw new IllegalArgumentException();
        }
        String tableName = ORMapper.getTableName(cn, cls);
        return ORMapper.select(transaction, cn, tableName, null);
    }

    protected static CachedRowSet select(Transaction transaction, Connection cn, Object obj) throws SQLException, IllegalArgumentException, IllegalAccessException {
        if (obj == null) {
            throw new IllegalArgumentException();
        }
        String tableName = ORMapper.getTableName(cn, obj.getClass());
        if (obj instanceof Table) {
            tableName = ((Table)obj).getTableName();
        }
        return ORMapper.select(transaction, cn, tableName, obj);
    }

    protected static CachedRowSet select(Transaction transaction, Connection cn, Class<?> cls, Object obj) throws SQLException, IllegalArgumentException, IllegalAccessException {
        if (cls == null) {
            throw new IllegalArgumentException();
        }
        String tableName = ORMapper.getTableName(cn, cls);
        return ORMapper.select(transaction, cn, tableName, obj);
    }

    protected static CachedRowSet select(Transaction transaction, Connection cn, String tableName, Object obj) throws SQLException, IllegalArgumentException, IllegalAccessException {
        if (tableName == null) {
            throw new IllegalArgumentException();
        }
        Class<?> cls = obj != null ? obj.getClass() : new Table(tableName){}.getClass();
        NamedParameterStatement npst = new ORMapper(cls).getSelectStatement(cn, tableName, obj);
        PreparedStatement st = cn.prepareStatement(npst.getSql());
        for (NamedParameter parameter : npst.getParameters()) {
            parameter.applyTo(st);
        }
        SqlExecutionHandler sqlExecutionHandler = transaction != null ? transaction.getDataSource().getSqlExecutionHandler() : null;
        Sql dump = sqlExecutionHandler != null ? SqlExecutionUtil.createSql(npst) : null;
        return SqlExecutionUtil.executeQueryAndPopulate(transaction, st, dump);
    }

    protected static int insert(Transaction transaction, Connection cn, Object obj) throws SQLException, IllegalArgumentException, IllegalAccessException {
        int[] r = ORMapper.insert(transaction, cn, new Object[]{obj});
        return r[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int[] insert(Transaction transaction, Connection cn, Object ... objects) throws SQLException, IllegalArgumentException, IllegalAccessException {
        int i;
        int[] r;
        if (objects == null) {
            throw new IllegalArgumentException();
        }
        Statement st = null;
        NamedParameterStatement nps = null;
        Class<?> prevClass = null;
        int batchCount = 0;
        ArrayList<Integer> results = new ArrayList<Integer>();
        SqlExecutionHandler sqlExecutionHandler = transaction != null ? transaction.getDataSource().getSqlExecutionHandler() : null;
        ArrayList<Sql> dumps = new ArrayList<Sql>();
        try {
            for (Object obj : objects) {
                if (obj == null) continue;
                if (batchCount > 0 && obj.getClass() != prevClass) {
                    int[] r2 = SqlExecutionUtil.executeBatch(transaction, (PreparedStatement)st, dumps);
                    st.close();
                    st = null;
                    for (int i2 = 0; i2 < r2.length; ++i2) {
                        results.add(r2[i2]);
                    }
                    dumps.clear();
                    batchCount = 0;
                }
                if (st == null) {
                    nps = new ORMapper(obj).getInsertStatement(cn);
                    st = cn.prepareStatement(nps.getSql());
                }
                nps.clearParameters();
                Map<String, Object> parameters = ORMapper.createParameters(obj, nps.getParameterNames());
                for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
                    nps.setObject(parameter.getKey(), parameter.getValue());
                }
                st.clearParameters();
                for (NamedParameter parameter : nps.getParameters()) {
                    parameter.applyTo((PreparedStatement)st);
                }
                st.addBatch();
                if (sqlExecutionHandler != null) {
                    dumps.add(SqlExecutionUtil.createSql(nps));
                }
                ++batchCount;
                prevClass = obj.getClass();
            }
            if (batchCount > 0) {
                r = SqlExecutionUtil.executeBatch(transaction, (PreparedStatement)st, dumps);
                for (i = 0; i < r.length; ++i) {
                    results.add(r[i]);
                }
            }
        }
        finally {
            if (st != null) {
                st.close();
            }
        }
        r = new int[results.size()];
        for (i = 0; i < results.size(); ++i) {
            r[i] = (Integer)results.get(i);
        }
        return r;
    }

    protected static int[] insert(Transaction transaction, Connection cn, Collection<?> objects) throws SQLException, IllegalArgumentException, IllegalAccessException {
        return ORMapper.insert(transaction, cn, objects.toArray());
    }

    protected static int update(Transaction transaction, Connection cn, Object obj) throws OptimisticConcurrencyException, SQLException, IllegalArgumentException, IllegalAccessException {
        int[] r = ORMapper.update(transaction, cn, new Object[]{obj});
        return r[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int[] update(Transaction transaction, Connection cn, Object ... objects) throws OptimisticConcurrencyException, SQLException, IllegalArgumentException, IllegalAccessException {
        if (objects == null) {
            throw new IllegalArgumentException();
        }
        Statement st = null;
        NamedParameterStatement nps = null;
        Class<?> prevClass = null;
        int batchCount = 0;
        ArrayList<Integer> results = new ArrayList<Integer>();
        SqlExecutionHandler sqlExecutionHandler = transaction != null ? transaction.getDataSource().getSqlExecutionHandler() : null;
        ArrayList<Sql> dumps = new ArrayList<Sql>();
        try {
            boolean[] hasRowVersion = new boolean[objects.length];
            for (Object obj : objects) {
                if (obj == null) continue;
                if (batchCount > 0 && obj.getClass() != prevClass) {
                    int[] r = SqlExecutionUtil.executeBatch(transaction, (PreparedStatement)st, dumps);
                    st.close();
                    st = null;
                    for (int i = 0; i < r.length; ++i) {
                        if (hasRowVersion[i] && r[i] == 0) {
                            throw new OptimisticConcurrencyException(OptimisticConcurrencyException.Op.Update);
                        }
                        results.add(r[i]);
                    }
                    dumps.clear();
                    batchCount = 0;
                    hasRowVersion = new boolean[objects.length];
                }
                if (st == null) {
                    nps = new ORMapper(obj).getUpdateStatement(cn);
                    st = cn.prepareStatement(nps.getSql());
                }
                nps.clearParameters();
                Map<String, Object> parameters = ORMapper.createParameters(obj, nps.getParameterNames());
                for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
                    nps.setObject(parameter.getKey(), parameter.getValue());
                }
                st.clearParameters();
                for (NamedParameter parameter : nps.getParameters()) {
                    parameter.applyTo((PreparedStatement)st);
                }
                st.addBatch();
                if (sqlExecutionHandler != null) {
                    dumps.add(SqlExecutionUtil.createSql(nps));
                }
                hasRowVersion[batchCount] = nps.hasRowVersionColumn;
                ++batchCount;
                prevClass = obj.getClass();
            }
            if (batchCount > 0) {
                int[] r = SqlExecutionUtil.executeBatch(transaction, (PreparedStatement)st, dumps);
                for (int i = 0; i < r.length; ++i) {
                    if (hasRowVersion[i] && r[i] == 0) {
                        throw new OptimisticConcurrencyException(OptimisticConcurrencyException.Op.Update);
                    }
                    results.add(r[i]);
                }
            }
        }
        finally {
            if (st != null) {
                st.close();
            }
        }
        int[] r = new int[results.size()];
        for (int i = 0; i < results.size(); ++i) {
            r[i] = (Integer)results.get(i);
        }
        return r;
    }

    protected static int[] update(Transaction transaction, Connection cn, Collection<?> objects) throws OptimisticConcurrencyException, SQLException, IllegalArgumentException, IllegalAccessException {
        return ORMapper.update(transaction, cn, objects.toArray());
    }

    protected static int delete(Transaction transaction, Connection cn, Object obj) throws OptimisticConcurrencyException, SQLException, IllegalArgumentException, IllegalAccessException {
        int[] r = ORMapper.delete(transaction, cn, new Object[]{obj});
        return r[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int[] delete(Transaction transaction, Connection cn, Object ... objects) throws OptimisticConcurrencyException, SQLException, IllegalArgumentException, IllegalAccessException {
        if (objects == null) {
            throw new IllegalArgumentException();
        }
        Statement st = null;
        NamedParameterStatement nps = null;
        Class<?> prevClass = null;
        int batchCount = 0;
        ArrayList<Integer> results = new ArrayList<Integer>();
        SqlExecutionHandler sqlExecutionHandler = transaction != null ? transaction.getDataSource().getSqlExecutionHandler() : null;
        ArrayList<Sql> dumps = new ArrayList<Sql>();
        try {
            boolean[] hasRowVersion = new boolean[objects.length];
            for (Object obj : objects) {
                if (obj == null) continue;
                if (batchCount > 0 && obj.getClass() != prevClass) {
                    int[] r = SqlExecutionUtil.executeBatch(transaction, (PreparedStatement)st, dumps);
                    st.close();
                    st = null;
                    for (int i = 0; i < r.length; ++i) {
                        if (hasRowVersion[i] && r[i] == 0) {
                            throw new OptimisticConcurrencyException(OptimisticConcurrencyException.Op.Delete);
                        }
                        results.add(r[i]);
                    }
                    dumps.clear();
                    batchCount = 0;
                    hasRowVersion = new boolean[objects.length];
                }
                if (st == null) {
                    nps = new ORMapper(obj).getDeleteStatement(cn);
                    st = cn.prepareStatement(nps.getSql());
                }
                nps.clearParameters();
                Map<String, Object> parameters = ORMapper.createParameters(obj, nps.getParameterNames());
                for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
                    nps.setObject(parameter.getKey(), parameter.getValue());
                }
                st.clearParameters();
                for (NamedParameter parameter : nps.getParameters()) {
                    parameter.applyTo((PreparedStatement)st);
                }
                st.addBatch();
                if (sqlExecutionHandler != null) {
                    dumps.add(SqlExecutionUtil.createSql(nps));
                }
                hasRowVersion[batchCount] = nps.hasRowVersionColumn;
                ++batchCount;
                prevClass = obj.getClass();
            }
            if (batchCount > 0) {
                int[] r = SqlExecutionUtil.executeBatch(transaction, (PreparedStatement)st, dumps);
                for (int i = 0; i < r.length; ++i) {
                    if (hasRowVersion[i] && r[i] == 0) {
                        throw new OptimisticConcurrencyException(OptimisticConcurrencyException.Op.Delete);
                    }
                    results.add(r[i]);
                }
            }
        }
        finally {
            if (st != null) {
                st.close();
            }
        }
        int[] r = new int[results.size()];
        for (int i = 0; i < results.size(); ++i) {
            r[i] = (Integer)results.get(i);
        }
        return r;
    }

    protected static int[] delete(Transaction transaction, Connection cn, Collection<?> objects) throws OptimisticConcurrencyException, SQLException, IllegalArgumentException, IllegalAccessException {
        return ORMapper.delete(transaction, cn, objects.toArray());
    }

    protected static int merge(Transaction transaction, Connection cn, Object obj) throws OptimisticConcurrencyException, SQLException, IllegalArgumentException, IllegalAccessException {
        int[] r = ORMapper.merge(transaction, cn, new Object[]{obj});
        return r[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int[] merge(Transaction transaction, Connection cn, Object ... objects) throws OptimisticConcurrencyException, SQLException, IllegalArgumentException, IllegalAccessException {
        if (objects == null) {
            throw new IllegalArgumentException();
        }
        Statement st = null;
        NamedParameterStatement nps = null;
        Class<?> prevClass = null;
        int batchCount = 0;
        ArrayList<Integer> results = new ArrayList<Integer>();
        SqlExecutionHandler sqlExecutionHandler = transaction != null ? transaction.getDataSource().getSqlExecutionHandler() : null;
        ArrayList<Sql> dumps = new ArrayList<Sql>();
        try {
            boolean[] hasRowVersion = new boolean[objects.length];
            for (Object obj : objects) {
                if (obj == null) continue;
                if (batchCount > 0 && obj.getClass() != prevClass) {
                    int[] r = SqlExecutionUtil.executeBatch(transaction, (PreparedStatement)st, dumps);
                    st.close();
                    st = null;
                    for (int i = 0; i < r.length; ++i) {
                        if (hasRowVersion[i] && r[i] == 0) {
                            throw new OptimisticConcurrencyException(OptimisticConcurrencyException.Op.Update);
                        }
                        results.add(r[i]);
                    }
                    dumps.clear();
                    batchCount = 0;
                    hasRowVersion = new boolean[objects.length];
                }
                if (st == null) {
                    nps = new ORMapper(obj).getMergeStatement(cn);
                    st = cn.prepareStatement(nps.getSql());
                }
                nps.clearParameters();
                Map<String, Object> parameters = ORMapper.createParameters(obj, nps.getParameterNames());
                for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
                    nps.setObject(parameter.getKey(), parameter.getValue());
                }
                st.clearParameters();
                for (NamedParameter parameter : nps.getParameters()) {
                    parameter.applyTo((PreparedStatement)st);
                }
                st.addBatch();
                if (sqlExecutionHandler != null) {
                    dumps.add(SqlExecutionUtil.createSql(nps));
                }
                hasRowVersion[batchCount] = nps.hasRowVersionColumn;
                ++batchCount;
                prevClass = obj.getClass();
            }
            if (batchCount > 0) {
                int[] r = SqlExecutionUtil.executeBatch(transaction, (PreparedStatement)st, dumps);
                for (int i = 0; i < r.length; ++i) {
                    if (hasRowVersion[i] && r[i] == 0) {
                        throw new OptimisticConcurrencyException(OptimisticConcurrencyException.Op.Update);
                    }
                    results.add(r[i]);
                }
            }
        }
        finally {
            if (st != null) {
                st.close();
            }
        }
        int[] r = new int[results.size()];
        for (int i = 0; i < results.size(); ++i) {
            r[i] = (Integer)results.get(i);
        }
        return r;
    }

    protected static int[] merge(Transaction transaction, Connection cn, Collection<?> objects) throws OptimisticConcurrencyException, SQLException, IllegalArgumentException, IllegalAccessException {
        return ORMapper.merge(transaction, cn, objects.toArray());
    }

    protected static Map<String, Object> createParameters(Object obj, Set<String> parameterNames) throws IllegalArgumentException, IllegalAccessException {
        if (obj == null) {
            throw new IllegalArgumentException();
        }
        LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>();
        Map<String, Field> fields = ORMapper.getFields(obj.getClass());
        for (String parameterName : parameterNames) {
            Field field = fields.get(parameterName.toLowerCase());
            if (field == null) continue;
            Object value = field.get(obj);
            parameters.put(parameterName, value);
        }
        return parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getTableName(Connection cn, Class<?> cls) throws SQLException {
        String tableName = cacheTableNames.get(cls);
        if (tableName == null) {
            HashMap<String, String> tableNames = new HashMap<String, String>();
            try (ResultSet rs = null;){
                rs = cn.getMetaData().getTables(null, null, null, new String[]{"TABLE"});
                while (rs.next()) {
                    String s = rs.getString("TABLE_NAME");
                    tableNames.put(s.toLowerCase(), s);
                }
            }
            for (Class<?> c = cls; c != null; c = c.getSuperclass()) {
                String s = c.getSimpleName().toLowerCase();
                if (!tableNames.containsKey(s)) continue;
                tableName = (String)tableNames.get(s);
                break;
            }
            cacheTableNames.put(cls, tableName);
        }
        return tableName;
    }

    protected static String[] getColumnNames(ResultSetMetaData md) throws SQLException {
        ArrayList<String> names = new ArrayList<String>();
        names.add("");
        int columnCount = md.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            String name = md.getColumnLabel(i);
            if (name == null || name.length() == 0) {
                name = md.getColumnName(i);
            }
            if (name == null || name.length() == 0) {
                name = "";
            }
            names.add(name);
        }
        return names.toArray(new String[0]);
    }

    protected static Map<String, Field> getFields(Class<?> cls) {
        HashMap<String, Field> map = new HashMap<String, Field>();
        for (Field field : cls.getDeclaredFields()) {
            field.setAccessible(true);
            map.put(field.getName().toLowerCase(), field);
        }
        return map;
    }

    protected static Object getValue(ResultSet rs, int columnIndex, Field target) throws SQLException, ParseException {
        return ORMapper.getValue(rs, columnIndex, target.getType());
    }

    protected static Object getValue(ResultSet rs, int columnIndex, Class<?> type) throws SQLException, ParseException {
        Object value = null;
        if (type.equals(Byte.TYPE)) {
            value = rs.getByte(columnIndex);
            if (rs.wasNull()) {
                value = (byte)0;
            }
        } else if (type.equals(Byte.class)) {
            value = rs.getByte(columnIndex);
            if (rs.wasNull()) {
                value = null;
            }
        } else if (type.equals(Short.TYPE)) {
            value = rs.getShort(columnIndex);
            if (rs.wasNull()) {
                value = (short)0;
            }
        } else if (type.equals(Short.class)) {
            value = rs.getShort(columnIndex);
            if (rs.wasNull()) {
                value = null;
            }
        } else if (type.equals(Integer.TYPE)) {
            value = rs.getInt(columnIndex);
            if (rs.wasNull()) {
                value = 0;
            }
        } else if (type.equals(Integer.class)) {
            value = rs.getInt(columnIndex);
            if (rs.wasNull()) {
                value = null;
            }
        } else if (type.equals(Long.TYPE)) {
            value = rs.getLong(columnIndex);
            if (rs.wasNull()) {
                value = 0L;
            }
        } else if (type.equals(Long.class)) {
            value = rs.getLong(columnIndex);
            if (rs.wasNull()) {
                value = null;
            }
        } else if (type.equals(Float.TYPE)) {
            value = Float.valueOf(rs.getFloat(columnIndex));
            if (rs.wasNull()) {
                value = Float.valueOf(0.0f);
            }
        } else if (type.equals(Float.class)) {
            value = Float.valueOf(rs.getFloat(columnIndex));
            if (rs.wasNull()) {
                value = null;
            }
        } else if (type.equals(Double.TYPE)) {
            value = rs.getDouble(columnIndex);
            if (rs.wasNull()) {
                value = 0.0;
            }
        } else if (type.equals(Double.class)) {
            value = rs.getDouble(columnIndex);
            if (rs.wasNull()) {
                value = null;
            }
        } else if (type.equals(BigDecimal.class)) {
            value = rs.getBigDecimal(columnIndex);
            if (rs.wasNull()) {
                value = null;
            }
        } else if (type.equals(Boolean.TYPE)) {
            value = rs.getBoolean(columnIndex);
            if (rs.wasNull()) {
                value = false;
            }
        } else if (type.equals(Boolean.class)) {
            value = rs.getBoolean(columnIndex);
            if (rs.wasNull()) {
                value = null;
            }
        } else if (type.equals(String.class)) {
            value = rs.getString(columnIndex);
            if (rs.wasNull()) {
                value = null;
            }
        } else if (type.isArray() && type.getComponentType().equals(Byte.TYPE)) {
            value = rs.getBytes(columnIndex);
            if (rs.wasNull()) {
                value = null;
            }
        } else if (type.equals(java.util.Date.class)) {
            Timestamp ts = rs.getTimestamp(columnIndex);
            value = rs.wasNull() ? null : new java.util.Date(ts.getTime());
        } else if (type.equals(Date.class)) {
            value = rs.getDate(columnIndex);
            if (rs.wasNull()) {
                value = null;
            }
        } else if (type.equals(Time.class)) {
            value = rs.getTime(columnIndex);
            if (rs.wasNull()) {
                value = null;
            }
        } else if (type.equals(Timestamp.class)) {
            value = rs.getTimestamp(columnIndex);
            if (rs.wasNull()) {
                value = null;
            }
        } else if (type.equals(LocalDateTime.class)) {
            value = rs.getTimestamp(columnIndex);
            value = rs.wasNull() ? null : ((Timestamp)value).toLocalDateTime();
        } else if (type.equals(LocalDate.class)) {
            value = rs.getDate(columnIndex);
            value = rs.wasNull() ? null : ((Date)value).toLocalDate();
        } else if (type.equals(LocalTime.class)) {
            value = rs.getDate(columnIndex);
            value = rs.wasNull() ? null : ((Time)value).toLocalTime();
        } else if (type.equals(OffsetDateTime.class)) {
            String s = rs.getString(columnIndex);
            value = rs.wasNull() ? null : DateTimeParser.parseOffsetDateTime(s);
        } else if (type.equals(OffsetTime.class)) {
            String s = rs.getString(columnIndex);
            value = rs.wasNull() ? null : DateTimeParser.parseOffsetTime(s);
        } else if (type.equals(YearMonth.class)) {
            Date d = rs.getDate(columnIndex);
            if (rs.wasNull()) {
                value = null;
            } else {
                LocalDate ld = d.toLocalDate();
                value = YearMonth.of(ld.getYear(), ld.getMonth());
            }
        } else if (type.isEnum()) {
            String s = rs.getString(columnIndex);
            if (rs.wasNull()) {
                value = null;
            } else {
                Class<Enum> cls = type.asSubclass(Enum.class);
                Enum e = Enum.valueOf(cls, s);
                value = e;
            }
        } else {
            value = rs.getObject(columnIndex);
            if (rs.wasNull()) {
                value = null;
            }
        }
        return value;
    }

    static <T> T createInstance(Class<T> cls) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException {
        Constructor<?> enclosingConstructor;
        Method enclosingMethod;
        if (!(!cls.isLocalClass() || (enclosingMethod = cls.getEnclosingMethod()) != null && Modifier.isStatic(enclosingMethod.getModifiers()) || (enclosingConstructor = cls.getEnclosingConstructor()) != null && Modifier.isStatic(enclosingConstructor.getModifiers()))) {
            Class<?> enclosingClass = cls.getEnclosingClass();
            Constructor<T> constructor = cls.getDeclaredConstructor(enclosingClass);
            constructor.setAccessible(true);
            T obj = constructor.newInstance(new Object[]{null});
            return obj;
        }
        Constructor<T> constructor = cls.getDeclaredConstructor(new Class[0]);
        constructor.setAccessible(true);
        T obj = constructor.newInstance(new Object[0]);
        return obj;
    }

    static boolean isScalar(Class<?> type) {
        if (type.isPrimitive()) {
            return true;
        }
        if (type.equals(String.class)) {
            return true;
        }
        if (Number.class.isAssignableFrom(type)) {
            return true;
        }
        if (java.util.Date.class.isAssignableFrom(type)) {
            return true;
        }
        if (Temporal.class.isAssignableFrom(type)) {
            return true;
        }
        return type.isArray() && type.getComponentType().equals(Byte.TYPE);
    }

    protected static class DateTimeParser {
        private static final ZoneOffset DEFAULT_OFFSET = ZoneOffset.ofTotalSeconds(TimeZone.getDefault().getRawOffset() / 1000);
        private static final Pattern DATETIME = Pattern.compile("(?:|(\\d{1,4})[-/](\\d{1,2})(?:|[-/](\\d{1,2})))(?:|(?:(?:^|[ T])(\\d{1,2}):(\\d{1,2})(?:|(?::(\\d{1,2})))(?:|(?:\\.(\\d{1,3})))(?:|(?:([^:\\.].*)))))");

        protected DateTimeParser() {
        }

        public static OffsetDateTime parseOffsetDateTime(String string) throws ParseException {
            int hour = 0;
            int minute = 0;
            int second = 0;
            int nanoOfSecond = 0;
            ZoneOffset offset = DEFAULT_OFFSET;
            ParseResult result = DateTimeParser.parse(string);
            if (result.year == null) {
                throw new ParseException(string, 0);
            }
            int year = result.year;
            if (result.month == null) {
                throw new ParseException(string, 0);
            }
            int month = result.month;
            if (result.dayOfMonth == null) {
                throw new ParseException(string, 0);
            }
            int dayOfMonth = result.dayOfMonth;
            if (result.hour != null) {
                hour = result.hour;
                if (result.minute != null) {
                    minute = result.minute;
                } else {
                    throw new ParseException(string, 0);
                }
            }
            if (result.second != null) {
                second = result.second;
            }
            if (result.nanoOfSecond != null) {
                nanoOfSecond = result.nanoOfSecond;
            }
            if (result.offset != null) {
                offset = result.offset;
            }
            OffsetDateTime datetime = OffsetDateTime.of(year, month, dayOfMonth, hour, minute, second, nanoOfSecond, offset);
            return datetime;
        }

        public static OffsetTime parseOffsetTime(String string) throws ParseException {
            int year = 1970;
            int month = 1;
            int dayOfMonth = 1;
            int hour = 0;
            int minute = 0;
            int second = 0;
            int nanoOfSecond = 0;
            ZoneOffset offset = DEFAULT_OFFSET;
            ParseResult result = DateTimeParser.parse(string);
            if (result.year != null) {
                year = result.year;
            }
            if (result.month != null) {
                month = result.month;
            }
            if (result.dayOfMonth != null) {
                dayOfMonth = result.dayOfMonth;
            }
            if (result.hour != null) {
                hour = result.hour;
                if (result.minute == null) {
                    throw new ParseException(string, 0);
                }
            } else {
                throw new ParseException(string, 0);
            }
            minute = result.minute;
            if (result.second != null) {
                second = result.second;
            }
            if (result.nanoOfSecond != null) {
                nanoOfSecond = result.nanoOfSecond;
            }
            if (result.offset != null) {
                offset = result.offset;
            }
            OffsetDateTime datetime = OffsetDateTime.of(year, month, dayOfMonth, hour, minute, second, nanoOfSecond, offset);
            return datetime.toOffsetTime();
        }

        public static ParseResult parse(String string) throws ParseException {
            ParseResult result = new ParseResult();
            Matcher m = DATETIME.matcher(string);
            if (m.matches()) {
                if (m.group(1) != null) {
                    result.year = Integer.parseInt(m.group(1));
                }
                if (m.group(2) != null) {
                    result.month = Integer.parseInt(m.group(2));
                }
                if (m.group(3) != null) {
                    result.dayOfMonth = Integer.parseInt(m.group(3));
                }
                if (m.group(4) != null) {
                    result.hour = Integer.parseInt(m.group(4));
                    result.minute = Integer.parseInt(m.group(5));
                }
                if (m.group(6) != null) {
                    result.second = Integer.parseInt(m.group(6));
                }
                if (m.group(7) != null) {
                    result.nanoOfSecond = Integer.parseInt((m.group(7) + "000000000").substring(0, 9));
                }
                if (m.group(8) != null) {
                    String tz = m.group(8);
                    if (tz.charAt(0) == ' ') {
                        tz = "+" + tz.substring(1);
                    }
                    result.offset = ZoneOffset.of(tz);
                }
                return result;
            }
            throw new ParseException(string, 0);
        }
    }

    protected static class ParseResult {
        public Integer year;
        public Integer month;
        public Integer dayOfMonth;
        public Integer hour;
        public Integer minute;
        public Integer second;
        public Integer nanoOfSecond;
        public ZoneOffset offset;

        protected ParseResult() {
        }
    }
}

