/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public class ConnectionPool
implements ConnectionEventListener {
    private ConnectionPoolDataSource datasource;
    private String username;
    private String password;
    private ConcurrentLinkedQueue<PooledConnection> pool;

    public ConnectionPool(ConnectionPoolDataSource datasource) {
        this(datasource, null, null);
    }

    public ConnectionPool(ConnectionPoolDataSource datasource, String username, String password) {
        this.datasource = datasource;
        this.username = username;
        this.password = password;
        this.pool = new ConcurrentLinkedQueue();
    }

    public Connection getConnection() throws SQLException {
        if (this.datasource == null) {
            throw new IllegalStateException();
        }
        PooledConnection pooledConnection = this.pool.poll();
        if (pooledConnection == null) {
            pooledConnection = this.username != null || this.password != null ? this.datasource.getPooledConnection() : this.datasource.getPooledConnection(this.username, this.password);
            pooledConnection.addConnectionEventListener(this);
        }
        return pooledConnection.getConnection();
    }

    public void close() {
        PooledConnection pooledConnection;
        this.datasource = null;
        while ((pooledConnection = this.pool.poll()) != null) {
            this.close(pooledConnection);
        }
    }

    private void close(PooledConnection pooledConnection) {
        pooledConnection.removeConnectionEventListener(this);
        try {
            pooledConnection.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void connectionClosed(ConnectionEvent event) {
        PooledConnection pooledConnection = (PooledConnection)event.getSource();
        if (this.datasource == null) {
            this.close(pooledConnection);
        } else {
            boolean isSucceeded = this.pool.offer(pooledConnection);
            if (!isSucceeded) {
                this.close(pooledConnection);
            }
        }
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent event) {
        PooledConnection pooledConnection = (PooledConnection)event.getSource();
        pooledConnection.removeConnectionEventListener(this);
    }
}

