package net.osdn.util.jersey;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
public class StackTraceExceptionMapper implements ExceptionMapper<Throwable> {

	@Override
	public Response toResponse(Throwable e) {
		if(e instanceof WebApplicationException) {
			Response response = ((WebApplicationException)e).getResponse();
			if(response.getStatus() != 500) {
				return response;
			}
		}
		
		StringBuilder content = new StringBuilder();
		content.append("500 Internal Server Error\n\n");

		/* 実装を推測される可能性もあるため、レスポンスにスタックトレースを含めるべきではない。
		while(e.getCause() != null) {
			e = e.getCause();
		}

		content.append(e.getClass().getName() + ": " + e.getMessage() + "\n");
		
		StackTraceElement[] stes = e.getStackTrace();
		int count = stes.length;
		for(int i = stes.length - 2; i >= 0; i--) {
			if(stes[i].getClassName().startsWith("org.eclipse.jetty.")
			|| stes[i].getClassName().startsWith("org.glassfish.jersey.")
			|| stes[i].getClassName().startsWith("java.lang.reflect.")
			|| stes[i].getClassName().startsWith("sun.reflect.")) {
				continue;
			}
			if(i < stes.length -2) {
				count = i + 1;
			}
			break;
		}
		for(int i = 0; i < count; i++) {
			StackTraceElement ste = stes[i];
			content.append(String.format("  at %s.%s(%s:%s)\n",
					ste.getClassName(),
					ste.getMethodName(),
					ste.getFileName(),
					ste.getLineNumber()));
		}
		*/
		
		return Response
				.status(Response.Status.INTERNAL_SERVER_ERROR)
				.type(MediaType.TEXT_PLAIN_TYPE)
				.entity(content.toString())
				.build();
	}
}
