package net.osdn.util.jersey;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;

public class ResultSetStreamingOutput implements StreamingOutput {
	
	private ResultSet rs;
	
	public ResultSetStreamingOutput(ResultSet rs) {
		this.rs = rs;
	}

	@Override
	public void write(OutputStream out) throws IOException, WebApplicationException {
		BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, "UTF-8"));
		try {
			ResultSetMetaData meta = rs.getMetaData();
			int columnCount = meta.getColumnCount();
			String[] columnNames = new String[columnCount + 1];
			for(int i = 1; i <= columnCount; i++) {
				columnNames[i] = meta.getColumnLabel(i);
			}
			writer.write("[\n");
			boolean isNotFirst = false;
			while(rs.next()) {
				if(isNotFirst) {
					writer.write(",\n");
				} else {
					isNotFirst = true;
				}
				writer.write("{ ");
				for(int i = 1; i <= columnCount; i++) {
					writer.write('"');
					writer.write(columnNames[i]);
					writer.write("\":\"");
					writer.write(getString(rs, i));
					writer.write("\"");
					if(i + 1 <= columnCount) {
						writer.write(", ");
					}
				}
				writer.write(" }");
			}
			writer.write("\n]");
			writer.close();
		} catch (SQLException e) {
			e.printStackTrace();
		}
	}
	
	public String getString(ResultSet rs, int columnIndex) throws SQLException {
		//TODO: 日付や真偽値を正しく文字列に変換すべし。
		return rs.getString(columnIndex);
	}
}
