package net.osdn.util.jersey;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

import org.glassfish.jersey.server.ResourceConfig;

import net.osdn.util.jersey.aspect.AspectHandler;

public class RestApplication extends ResourceConfig implements AspectHandler {
	
	public RestApplication() {
		packages("net.osdn.util.jersey");
		
		boolean isJerseyLoggerRegistered = false;
		
		//jersey-logger
		try {
			if(exists("net.osdn.util.jersey.log.RequestLogger")) {
				System.out.println("LOAD: net.osdn.util.jersey.log");
				packages("net.osdn.util.jersey.log");
				
				try {
					Class<?> invocationLoggerBinderClass = Class.forName("net.osdn.util.jersey.log.InvocationLoggerBinder");
					Object component = null;
					try {
						Constructor<?> constructor = invocationLoggerBinderClass.getConstructor(AspectHandler.class);
						component = constructor.newInstance(this);
					} catch(Exception e) {
						// ignore
					}
					if(component == null) {
						Constructor<?> constructor = invocationLoggerBinderClass.getConstructor();
						component = constructor.newInstance();
					}
					register(component);
					isJerseyLoggerRegistered = true;
				} catch(Exception e) {
					e.printStackTrace();
				}
			}
		} catch(Exception e) {
			e.printStackTrace();
		}
		
		if(!isJerseyLoggerRegistered) {
			register(new InvocationHandlerBinder(this));
		}

		//jersey-freemarker
		try {
			if(exists("freemarker.template.Configuration")) {
				if(exists("net.osdn.util.jersey.ext.freemarker.FreeMarkerMessageBodyWriter")) {
					System.out.println("LOAD: net.osdn.util.jersey.ext.freemarker");
					packages("net.osdn.util.jersey.ext.freemarker");
				}
			}
		} catch(Exception e) {
			e.printStackTrace();
		}
		
		//jersey-cors-filter
		try {
			if(exists("net.osdn.util.jersey.ext.cors.CrossOriginResourceSharingFilter")) {
				System.out.println("LOAD: net.osdn.util.jersey.ext.cors");
				packages("net.osdn.util.jersey.ext.cors");
			}
		} catch(Exception e) {
			e.printStackTrace();
		}
		
		packages(getClass().getPackage().getName());
	}

	private boolean exists(String className) {
		try {
			Class.forName(className);
			return true;
		} catch (ClassNotFoundException e) {
			return false;
		}
	}

	/** リソース・メソッドの実行前に呼び出されます。
	 * 
	 * @param obj メソッドが呼び出されるリソースクラスのインスタンス。
	 * @param method 呼び出されるインターフェースメソッドに対応するインスタンス。
	 * @param args メソッド呼び出し時に渡される引数値を格納するオブジェクト配列。インタフェースメソッドが引数をとらない場合、null となる。プリミティブ型引数は java.lang.Integer または java.lang.Boolean のような適切なプリミティブ型ラッパークラスのインスタンスにラップされる。
	 */
	@Override
	public void onBeforeExecution(Object obj, Method method, Object[] args) {
	}
	
	/** リソースメソッドの実行後に呼び出されます。
	 * メソッドが例外がスローされた場合も、この onAfterExecution は呼び出されます。
	 * 
	 * @param obj メソッドが呼び出されるリソースクラスのインスタンス。
	 * @param method 呼び出されるインターフェースメソッドに対応するインスタンス。
	 * @param args メソッド呼び出し時に渡される引数値を格納するオブジェクト配列。インタフェースメソッドが引数をとらない場合、null となる。プリミティブ型引数は java.lang.Integer または java.lang.Boolean のような適切なプリミティブ型ラッパークラスのインスタンスにラップされる。
	 */
	@Override
	public void onAfterExecution(Object obj, Method method, Object[] args) {
	}

	/** リソースメソッドの実行から復帰した後に呼び出されます。
	 * リソースメソッドが例外をスローした場合、この onAfterReturning は呼び出されません。
	 * 
	 * @param obj メソッドが呼び出されるリソースクラスのインスタンス。
	 * @param method 呼び出されるインターフェースメソッドに対応するインスタンス。
	 * @param args メソッド呼び出し時に渡される引数値を格納するオブジェクト配列。インタフェースメソッドが引数をとらない場合、null となる。プリミティブ型引数は java.lang.Integer または java.lang.Boolean のような適切なプリミティブ型ラッパークラスのインスタンスにラップされる。
	 * @param value リソースメソッドの戻り値。
	 */
	@Override
	public void onAfterReturning(Object obj, Method method, Object[] args, Object value) {
	}

	/** リソースメソッドの実行で例外がスローされた後に呼び出されます。
	 * 
	 * @param obj メソッドが呼び出されるリソースクラスのインスタンス。
	 * @param method 呼び出されるインターフェースメソッドに対応するインスタンス。
	 * @param args メソッド呼び出し時に渡される引数値を格納するオブジェクト配列。インタフェースメソッドが引数をとらない場合、null となる。プリミティブ型引数は java.lang.Integer または java.lang.Boolean のような適切なプリミティブ型ラッパークラスのインスタンスにラップされる。
	 * @param e リソースメソッドがスローした例外のインスタンス。
	 */
	@Override
	public void onAfterThrowing(Object obj, Method method, Object[] args, Throwable e) {
	}
}
