/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.sql;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.osdn.util.sql.DefaultStatementBuilder;
import net.osdn.util.sql.NamedParameterStatement;
import net.osdn.util.sql.h2.H2StatementBuilder;
import net.osdn.util.sql.mssql.MssqlStatementBuilder;

public abstract class StatementBuilder {
    private static StatementBuilder defaultBuilder = new DefaultStatementBuilder();
    private static Set<StatementBuilder> builders = new HashSet<StatementBuilder>();

    public static void add(StatementBuilder builder) {
        builders.add(builder);
    }

    public static StatementBuilder getInstance(DatabaseMetaData md) {
        for (StatementBuilder builder : builders) {
            try {
                if (!builder.isAcceptable(md)) continue;
                return builder;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return defaultBuilder;
    }

    public abstract boolean isAcceptable(DatabaseMetaData var1) throws Exception;

    public NamedParameterStatement createSelectStatement(DatabaseMetaData md, Class<?> cls, String tableName, Object obj) throws SQLException {
        List<Column> columns;
        if (tableName == null) {
            tableName = this.getTableName(md, cls);
        }
        if (tableName == null) {
            throw new IllegalArgumentException();
        }
        HashSet<String> fieldNames = new HashSet<String>();
        if (obj != null) {
            Field[] fields = this.getFields(obj.getClass());
            for (int i = 0; i < fields.length; ++i) {
                fieldNames.add(fields[i].getName().toLowerCase());
            }
        }
        if ((columns = this.getColumns(md, tableName, fieldNames)).size() == 0) {
            throw new IllegalStateException();
        }
        boolean hasRowVersionColumn = false;
        ArrayList<Column> whereClauseColumns = new ArrayList<Column>();
        for (Column column : columns) {
            if (!fieldNames.contains(column.name.toLowerCase())) continue;
            if (column.isRowVersion) {
                hasRowVersionColumn = true;
            }
            whereClauseColumns.add(column);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT * FROM \"");
        sb.append(tableName);
        sb.append("\"");
        if (whereClauseColumns.size() >= 1) {
            sb.append(" WHERE ");
            for (int i = 0; i < whereClauseColumns.size(); ++i) {
                Column column = (Column)whereClauseColumns.get(i);
                if (column.isNullable) {
                    sb.append("(\"");
                    sb.append(column.name);
                    sb.append("\" = :");
                    sb.append(column.name);
                    sb.append(" OR (\"");
                    sb.append(column.name);
                    sb.append("\" IS NULL AND :");
                    sb.append(column.name);
                    sb.append(" IS NULL))");
                } else {
                    sb.append('\"');
                    sb.append(column.name);
                    sb.append("\" = :");
                    sb.append(column.name);
                }
                if (i + 1 >= whereClauseColumns.size()) continue;
                sb.append(" AND ");
            }
        }
        NamedParameterStatement npst = new NamedParameterStatement(sb.toString());
        npst.hasRowVersionColumn = hasRowVersionColumn;
        return npst;
    }

    public NamedParameterStatement createInsertStatement(DatabaseMetaData md, Class<?> cls, String tableName) throws SQLException {
        Column column;
        int i;
        if (tableName == null) {
            tableName = this.getTableName(md, cls);
        }
        if (tableName == null) {
            throw new IllegalArgumentException();
        }
        HashSet<String> fieldNames = new HashSet<String>();
        Field[] fields = this.getFields(cls);
        for (int i2 = 0; i2 < fields.length; ++i2) {
            fieldNames.add(fields[i2].getName().toLowerCase());
        }
        List<Column> columns = this.getColumns(md, tableName, fieldNames);
        if (columns.size() == 0) {
            throw new IllegalStateException();
        }
        ArrayList<Column> valuesClauseColumns = new ArrayList<Column>();
        for (Column column2 : columns) {
            if (!fieldNames.contains(column2.name.toLowerCase()) || column2.isAutoincrement || column2.isRowVersion) continue;
            valuesClauseColumns.add(column2);
        }
        if (valuesClauseColumns.size() == 0) {
            throw new IllegalArgumentException();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO \"");
        sb.append(tableName);
        sb.append("\"(");
        for (i = 0; i < valuesClauseColumns.size(); ++i) {
            column = (Column)valuesClauseColumns.get(i);
            sb.append('\"');
            sb.append(column.name);
            sb.append('\"');
            if (i + 1 >= valuesClauseColumns.size()) continue;
            sb.append(", ");
        }
        sb.append(") VALUES(");
        for (i = 0; i < valuesClauseColumns.size(); ++i) {
            column = (Column)valuesClauseColumns.get(i);
            sb.append(':');
            sb.append(column.name);
            if (i + 1 >= valuesClauseColumns.size()) continue;
            sb.append(", ");
        }
        sb.append(')');
        return new NamedParameterStatement(sb.toString());
    }

    public NamedParameterStatement createUpdateStatement(DatabaseMetaData md, Class<?> cls, String tableName) throws SQLException {
        Column column;
        int i;
        if (tableName == null) {
            tableName = this.getTableName(md, cls);
        }
        if (tableName == null) {
            throw new IllegalArgumentException();
        }
        HashSet<String> fieldNames = new HashSet<String>();
        Field[] fields = this.getFields(cls);
        for (int i2 = 0; i2 < fields.length; ++i2) {
            fieldNames.add(fields[i2].getName().toLowerCase());
        }
        List<Column> columns = this.getColumns(md, tableName, fieldNames);
        if (columns.size() == 0) {
            throw new IllegalStateException();
        }
        boolean hasRowVersionColumn = false;
        ArrayList<Column> setClauseColumns = new ArrayList<Column>();
        ArrayList<Column> whereClauseColumns = new ArrayList<Column>();
        for (Column column2 : columns) {
            if (!fieldNames.contains(column2.name.toLowerCase())) continue;
            if (column2.isRowVersion) {
                hasRowVersionColumn = true;
            }
            if (!(column2.isRowIdentifier || column2.isAutoincrement || column2.isRowVersion)) {
                setClauseColumns.add(column2);
            }
            if (!column2.isRowIdentifier && !column2.isRowVersion) continue;
            whereClauseColumns.add(column2);
        }
        if (setClauseColumns.size() == 0) {
            throw new IllegalArgumentException();
        }
        if (whereClauseColumns.size() == 0) {
            throw new IllegalArgumentException();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE \"");
        sb.append(tableName);
        sb.append("\" SET ");
        for (i = 0; i < setClauseColumns.size(); ++i) {
            column = (Column)setClauseColumns.get(i);
            sb.append('\"');
            sb.append(column.name);
            sb.append("\" = :");
            sb.append(column.name);
            if (i + 1 >= setClauseColumns.size()) continue;
            sb.append(", ");
        }
        sb.append(" WHERE ");
        for (i = 0; i < whereClauseColumns.size(); ++i) {
            column = (Column)whereClauseColumns.get(i);
            if (column.isNullable) {
                sb.append("(\"");
                sb.append(column.name);
                sb.append("\" = :");
                sb.append(column.name);
                sb.append(" OR (\"");
                sb.append(column.name);
                sb.append("\" IS NULL AND :");
                sb.append(column.name);
                sb.append(" IS NULL))");
            } else {
                sb.append('\"');
                sb.append(column.name);
                sb.append("\" = :");
                sb.append(column.name);
            }
            if (i + 1 >= whereClauseColumns.size()) continue;
            sb.append(" AND ");
        }
        NamedParameterStatement npst = new NamedParameterStatement(sb.toString());
        npst.hasRowVersionColumn = hasRowVersionColumn;
        return npst;
    }

    public NamedParameterStatement createDeleteStatement(DatabaseMetaData md, Class<?> cls, String tableName) throws SQLException {
        if (tableName == null) {
            tableName = this.getTableName(md, cls);
        }
        if (tableName == null) {
            throw new IllegalArgumentException();
        }
        HashSet<String> fieldNames = new HashSet<String>();
        Field[] fields = this.getFields(cls);
        for (int i = 0; i < fields.length; ++i) {
            fieldNames.add(fields[i].getName().toLowerCase());
        }
        List<Column> columns = this.getColumns(md, tableName, fieldNames);
        if (columns.size() == 0) {
            throw new IllegalStateException();
        }
        boolean hasRowVersionColumn = false;
        ArrayList<Column> whereClauseColumns = new ArrayList<Column>();
        for (Column column : columns) {
            if (!fieldNames.contains(column.name.toLowerCase())) continue;
            if (column.isRowVersion) {
                hasRowVersionColumn = true;
            }
            if (!column.isRowIdentifier && !column.isRowVersion) continue;
            whereClauseColumns.add(column);
        }
        if (whereClauseColumns.size() == 0) {
            throw new IllegalArgumentException();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM \"");
        sb.append(tableName);
        sb.append("\" WHERE ");
        for (int i = 0; i < whereClauseColumns.size(); ++i) {
            Column column = (Column)whereClauseColumns.get(i);
            if (column.isNullable) {
                sb.append("(\"");
                sb.append(column.name);
                sb.append("\" = :");
                sb.append(column.name);
                sb.append(" OR (\"");
                sb.append(column.name);
                sb.append("\" IS NULL AND :");
                sb.append(column.name);
                sb.append(" IS NULL))");
            } else {
                sb.append('\"');
                sb.append(column.name);
                sb.append("\" = :");
                sb.append(column.name);
            }
            if (i + 1 >= whereClauseColumns.size()) continue;
            sb.append(" AND ");
        }
        NamedParameterStatement npst = new NamedParameterStatement(sb.toString());
        npst.hasRowVersionColumn = hasRowVersionColumn;
        return npst;
    }

    public NamedParameterStatement createMergeStatement(DatabaseMetaData md, Class<?> cls, String tableName) throws SQLException {
        Column column;
        int i;
        if (tableName == null) {
            tableName = this.getTableName(md, cls);
        }
        if (tableName == null) {
            throw new IllegalArgumentException();
        }
        HashSet<String> fieldNames = new HashSet<String>();
        Field[] fields = this.getFields(cls);
        for (int i2 = 0; i2 < fields.length; ++i2) {
            fieldNames.add(fields[i2].getName().toLowerCase());
        }
        List<Column> columns = this.getColumns(md, tableName, fieldNames);
        if (columns.size() == 0) {
            throw new IllegalStateException();
        }
        ArrayList<Column> selectClauseColumns = new ArrayList<Column>();
        ArrayList<Column> setClauseColumns = new ArrayList<Column>();
        ArrayList<Column> whereClauseColumns = new ArrayList<Column>();
        ArrayList<Column> valuesClauseColumns = new ArrayList<Column>();
        for (Column column2 : columns) {
            if (!fieldNames.contains(column2.name.toLowerCase())) continue;
            selectClauseColumns.add(column2);
            if (!(column2.isRowIdentifier || column2.isAutoincrement || column2.isRowVersion)) {
                setClauseColumns.add(column2);
            }
            if (column2.isRowIdentifier || column2.isRowVersion) {
                whereClauseColumns.add(column2);
            }
            if (column2.isAutoincrement || column2.isRowVersion) continue;
            valuesClauseColumns.add(column2);
        }
        if (selectClauseColumns.size() == 0) {
            throw new IllegalArgumentException();
        }
        if (setClauseColumns.size() == 0) {
            throw new IllegalArgumentException();
        }
        if (whereClauseColumns.size() == 0) {
            throw new IllegalArgumentException();
        }
        if (valuesClauseColumns.size() == 0) {
            throw new IllegalArgumentException();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("MERGE INTO \"");
        sb.append(tableName);
        sb.append("\" AS Target \r\n");
        sb.append("USING ( \r\n");
        sb.append("  SELECT \r\n");
        for (i = 0; i < selectClauseColumns.size(); ++i) {
            column = (Column)selectClauseColumns.get(i);
            sb.append("    \"");
            sb.append(column.name);
            sb.append("\" = :");
            sb.append(column.name);
            if (i + 1 >= selectClauseColumns.size()) continue;
            sb.append(", \r\n");
        }
        sb.append("\r\n) AS Source \r\n");
        sb.append("ON (");
        for (i = 0; i < whereClauseColumns.size(); ++i) {
            column = (Column)whereClauseColumns.get(i);
            sb.append("Target.\"");
            sb.append(column.name);
            sb.append("\" = Source.\"");
            sb.append(column.name);
            sb.append('\"');
            if (i + 1 >= whereClauseColumns.size()) continue;
            sb.append(" AND ");
        }
        sb.append(") \r\n");
        sb.append("WHEN MATCHED THEN \r\n");
        sb.append("UPDATE SET \r\n");
        for (i = 0; i < setClauseColumns.size(); ++i) {
            column = (Column)setClauseColumns.get(i);
            sb.append("  \"");
            sb.append(column.name);
            sb.append("\" = Source.\"");
            sb.append(column.name);
            sb.append('\"');
            if (i + 1 >= setClauseColumns.size()) continue;
            sb.append(", \r\n");
        }
        sb.append(" \r\n");
        sb.append("WHEN NOT MATCHED THEN \r\n");
        sb.append("INSERT (");
        for (i = 0; i < valuesClauseColumns.size(); ++i) {
            column = (Column)valuesClauseColumns.get(i);
            sb.append('\"');
            sb.append(column.name);
            sb.append('\"');
            if (i + 1 >= valuesClauseColumns.size()) continue;
            sb.append(", ");
        }
        sb.append(") VALUES ( \r\n");
        for (i = 0; i < valuesClauseColumns.size(); ++i) {
            column = (Column)valuesClauseColumns.get(i);
            sb.append("  Source.\"");
            sb.append(column.name);
            sb.append('\"');
            if (i + 1 >= valuesClauseColumns.size()) continue;
            sb.append(", \r\n");
        }
        sb.append(" \r\n");
        sb.append(");\r\n");
        return new NamedParameterStatement(sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getTableName(DatabaseMetaData md, Class<?> cls) throws SQLException {
        String s;
        HashSet<String> tableNames = new HashSet<String>();
        try (ResultSet rs = null;){
            rs = md.getTables(null, null, null, new String[]{"TABLE"});
            while (rs.next()) {
                s = rs.getString("TABLE_NAME");
                tableNames.add(s.toLowerCase());
            }
        }
        while (cls != null) {
            s = cls.getSimpleName().toLowerCase();
            if (tableNames.contains(s)) {
                return s;
            }
            cls = cls.getSuperclass();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Column> getColumns(DatabaseMetaData md, String tableName, Set<String> fieldNames) throws SQLException {
        ArrayList<Column> columns = new ArrayList<Column>();
        Set<String> primaryKeys = this.getPrimaryKeys(md, tableName);
        Set<String> rowVersionColumns = this.getVersionColumns(md, tableName);
        Set<String> rowIdentifiers = null;
        if (fieldNames.containsAll(primaryKeys)) {
            rowIdentifiers = primaryKeys;
        } else {
            Map<String, Set<String>> uniqueIndexes = this.getUniqueIndexes(md, tableName);
            for (Map.Entry<String, Set<String>> entry : uniqueIndexes.entrySet()) {
                Set<String> uniqueKeys = entry.getValue();
                if (!fieldNames.containsAll(uniqueKeys)) continue;
                rowIdentifiers = uniqueKeys;
                break;
            }
        }
        try (ResultSet rs = null;){
            rs = md.getColumns(null, null, tableName, null);
            while (rs.next()) {
                String columnName = rs.getString("COLUMN_NAME");
                String isNullable = rs.getString("IS_NULLABLE");
                String isAutoincrement = rs.getString("IS_AUTOINCREMENT");
                Column column = new Column();
                column.name = columnName;
                column.isPrimaryKey = primaryKeys.contains(columnName.toLowerCase());
                column.isRowIdentifier = rowIdentifiers != null && rowIdentifiers.contains(columnName.toLowerCase());
                column.isAutoincrement = !isAutoincrement.equals("NO");
                column.isRowVersion = rowVersionColumns.contains(columnName.toLowerCase());
                column.isNullable = !isNullable.equals("NO");
                columns.add(column);
            }
        }
        return columns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> getPrimaryKeys(DatabaseMetaData md, String tableName) throws SQLException {
        LinkedHashSet<String> columns = new LinkedHashSet<String>();
        try (ResultSet rs = null;){
            rs = md.getPrimaryKeys(null, null, tableName);
            while (rs.next()) {
                String s = rs.getString("COLUMN_NAME");
                columns.add(s.toLowerCase());
            }
        }
        return columns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Set<String>> getUniqueIndexes(DatabaseMetaData md, String tableName) throws SQLException {
        LinkedHashMap<String, Set<String>> uniqueIndexes = new LinkedHashMap<String, Set<String>>();
        try (ResultSet rs = null;){
            rs = md.getIndexInfo(null, null, tableName, true, false);
            while (rs.next()) {
                boolean isUnique;
                String columnName;
                String indexName = rs.getString("INDEX_NAME");
                if (indexName == null || (columnName = rs.getString("COLUMN_NAME")) == null) continue;
                boolean bl = isUnique = rs.getShort("NON_UNIQUE") == 0;
                if (rs.wasNull() || !isUnique) continue;
                LinkedHashSet<String> columnNames = (LinkedHashSet<String>)uniqueIndexes.get(indexName);
                if (columnNames == null) {
                    columnNames = new LinkedHashSet<String>();
                    uniqueIndexes.put(indexName, columnNames);
                }
                columnNames.add(columnName.toLowerCase());
            }
        }
        return uniqueIndexes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> getVersionColumns(DatabaseMetaData md, String tableName) throws SQLException {
        LinkedHashSet<String> columns = new LinkedHashSet<String>();
        try (ResultSet rs = null;){
            rs = md.getVersionColumns(null, null, tableName);
            while (rs.next()) {
                String s = rs.getString("COLUMN_NAME");
                columns.add(s.toLowerCase());
            }
        }
        return columns;
    }

    protected Field[] getFields(Class<?> cls) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : cls.getDeclaredFields()) {
            int mod = field.getModifiers();
            if (Modifier.isStatic(mod) || Modifier.isPrivate(mod)) continue;
            fields.add(field);
        }
        return fields.toArray(new Field[0]);
    }

    static {
        StatementBuilder.add(new MssqlStatementBuilder());
        StatementBuilder.add(new H2StatementBuilder());
    }

    protected static class Column {
        public String name;
        public boolean isPrimaryKey;
        public boolean isRowIdentifier;
        public boolean isAutoincrement;
        public boolean isRowVersion;
        public boolean isNullable;

        protected Column() {
        }
    }
}

