/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.jersey;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.ws.rs.Produces;

public class InvocationHandler
implements java.lang.reflect.InvocationHandler {
    private static final NullObject NULL = new NullObject();

    @Override
    public Object invoke(Object obj, Method method, Object[] args) throws Throwable {
        Object result = method.invoke(obj, args);
        if (result == null) {
            try {
                if (InvocationHandler.isProduceMediaTypeJson(method)) {
                    result = NULL;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private static boolean isProduceMediaTypeJson(Method method) {
        Annotation[] annotations = method.getAnnotations();
        if (annotations != null) {
            for (int i = 0; i < annotations.length; ++i) {
                Annotation annotation = annotations[i];
                if (!(annotation instanceof Produces)) continue;
                Produces produces = (Produces)annotation;
                for (String s : produces.value()) {
                    if (!"application/json".equals(s)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static class NullObjectSerializer
    extends JsonSerializer<NullObject> {
        public void serialize(NullObject value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
            gen.writeNull();
        }
    }

    @JsonSerialize(using=NullObjectSerializer.class)
    public static class NullObject {
    }
}

