/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.jersey.log;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.nio.file.StandardOpenOption;
import net.osdn.util.jersey.log.FileManager;
import net.osdn.util.jersey.log.ProcessIdentifier;
import net.osdn.util.jersey.log.UniqueDatetime;

public class LogWriter
extends PrintWriter {
    public LogWriter(int requestContextHashCode) {
        super(new WriterImpl(requestContextHashCode));
    }

    private static class WriterImpl
    extends Writer {
        private File file;
        private boolean isInitialized;

        public WriterImpl(int requestContextHashCode) {
            String base = UniqueDatetime.get() + "-" + ProcessIdentifier.getId() + String.format("-%08x", requestContextHashCode);
            this.file = new File(FileManager.TMP_DIR, base + ".log");
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            if (!this.isInitialized) {
                FileManager.append(this.file);
                this.isInitialized = true;
            }
            if (off >= 0 && off <= cbuf.length && len >= 0 && off + len <= cbuf.length && off + len >= 0 && len == 0) {
                return;
            }
            try (FileChannel fc = FileChannel.open(this.file.toPath(), StandardOpenOption.CREATE, StandardOpenOption.APPEND, StandardOpenOption.WRITE);){
                long start = System.currentTimeMillis();
                while (System.currentTimeMillis() - start < 3000L) {
                    block32: {
                        try (FileLock lock = fc.tryLock();){
                            if (lock == null) break block32;
                            fc.write(StandardCharsets.UTF_8.encode(CharBuffer.wrap(cbuf, off, len)));
                            break;
                        }
                    }
                    Thread.sleep(10L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

