/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.jersey.log;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Queue;

public class FileManager {
    public static final int MAX_LOG_SIZE = 1000;
    public static final File TMP_DIR;
    private static final Queue<File> queue;
    private static int logSize;

    public static synchronized void append(File file) {
        try {
            if (file != null && file.exists()) {
                if (file.getName().endsWith("-req.hdr")) {
                    ++logSize;
                }
                queue.offer(file);
            }
            FileManager.truncateLogs();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static synchronized void truncateLogs() {
        try {
            File file;
            while (logSize > 1000 && (file = queue.poll()) != null) {
                if (file.getName().endsWith("-req.hdr")) {
                    if (!file.delete()) continue;
                    --logSize;
                    continue;
                }
                file.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        queue = new LinkedList<File>();
        logSize = 0;
        TMP_DIR = new File(new File(System.getProperty("java.io.tmpdir")), "jersey-logger");
        if (!TMP_DIR.exists()) {
            TMP_DIR.mkdirs();
        }
        Class<FileManager> clazz = FileManager.class;
        synchronized (FileManager.class) {
            File[] files = TMP_DIR.listFiles();
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (File file : files) {
                if (file.getName().endsWith("-req.hdr")) {
                    ++logSize;
                }
                queue.offer(file);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

