/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.ssdp.server;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.DatagramPacket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.osdn.util.ssdp.Device;
import net.osdn.util.ssdp.server.NanoHTTPD;

public class SsdpServer
extends NanoHTTPD {
    public static boolean DEBUG = false;
    private static final int PORT = 1980;
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private Device device;
    private String server;
    private volatile boolean isRunning;
    private Thread ssdpThread;
    private MulticastSocket ssdpSocket;

    public SsdpServer(Device device) {
        this(device, null);
    }

    public SsdpServer(Device device, String server) {
        super(1980);
        this.device = device;
        this.server = server != null ? server : "UPnP/1.0 UPnP-Device-Host/1.0";
    }

    @Override
    public void start(int timeout, boolean daemon) throws IOException {
        super.start(timeout, daemon);
        this.ssdpThread = new Thread(new Runnable(){

            @Override
            public void run() {
                SsdpServer.this.isRunning = true;
                while (SsdpServer.this.isRunning) {
                    try {
                        SsdpServer.this.ssdpRun();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.ssdpThread.setDaemon(true);
        this.ssdpThread.setName("SSDP Listener");
        this.ssdpThread.start();
    }

    @Override
    public void stop() {
        if (this.isRunning) {
            this.isRunning = false;
            if (this.ssdpSocket != null) {
                try {
                    this.ssdpSocket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.ssdpThread != null) {
                this.ssdpThread.interrupt();
                try {
                    this.ssdpThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.ssdpThread = null;
            this.ssdpSocket = null;
        }
        super.stop();
    }

    @Override
    public NanoHTTPD.Response serve(NanoHTTPD.IHTTPSession session) {
        String xml = "<?xml version=\"1.0\"?>\r\n<root xmlns=\"urn:schemas-upnp-org:device-1-0\">\r\n\t<specVersion>\r\n\t\t<major>1</major>\r\n\t\t<minor>0</minor>\r\n\t</specVersion>\r\n\t<device>\r\n\t\t<UDN>${UDN}</UDN>\r\n\t\t<friendlyName>${friendlyName}</friendlyName>\r\n\t\t<deviceType>${deviceType}</deviceType>\r\n\t\t<manufacturer>${manufacturer}</manufacturer>\r\n\t\t<modelName>${modelName}</modelName>\r\n\t\t<modelNumber>${modelNumber}</modelNumber>\r\n\t\t<serialNumber>${serialNumber}</serialNumber>\r\n\t\t<iconList>\r\n\t\t</iconList>\r\n\t\t<serviceList>\r\n\t\t</serviceList>\r\n\t</device>\r\n</root>\r\n";
        String udn = this.device.getUdn();
        String friendlyName = this.device.getFriendlyName();
        String deviceType = this.device.getDeviceType();
        String manufacturer = this.device.getManufacturer();
        String modelName = this.device.getModelName();
        String modelNumber = this.device.getModelNumber();
        String serialNumber = this.device.getSerialNumber();
        if (udn == null) {
            udn = "Unknown";
        }
        if (friendlyName == null || friendlyName.length() == 0) {
            friendlyName = "Unknown";
        }
        if (deviceType == null || deviceType.length() == 0) {
            deviceType = "Unknown";
        }
        if (manufacturer == null || manufacturer.length() == 0) {
            manufacturer = "Unknown";
        }
        if (modelName == null || modelName.length() == 0) {
            modelName = "Unknown";
        }
        if (modelNumber == null || modelNumber.length() == 0) {
            modelNumber = "Unknown";
        }
        if (serialNumber == null || serialNumber.length() == 0) {
            serialNumber = "Unknown";
        }
        xml = xml.replace("${UDN}", udn).replace("${friendlyName}", friendlyName).replace("${deviceType}", deviceType).replace("${manufacturer}", manufacturer).replace("${modelName}", modelName).replace("${modelNumber}", modelNumber).replace("${serialNumber}", serialNumber);
        return SsdpServer.newFixedLengthResponse(NanoHTTPD.Response.Status.OK, "text/xml", xml);
    }

    protected void ssdpRun() throws IOException {
        String strIpv4mcastaddr = "239.255.255.250";
        String strIpv6mcastaddr = "FF02::C";
        int port = 1900;
        String response = "HTTP/1.1 200 OK\r\nST:upnp:rootdevice\r\nUSN:${USN}\r\nLocation:${Location}\r\nOPT:\"http://schemas.upnp.org/upnp/1/0/\"; ns=01\r\nServer:${Server}\r\n\r\n";
        InetSocketAddress ipv4mcastaddr = null;
        try {
            ipv4mcastaddr = new InetSocketAddress(InetAddress.getByName(strIpv4mcastaddr), port);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        InetSocketAddress ipv6mcastaddr = null;
        try {
            ipv6mcastaddr = new InetSocketAddress(InetAddress.getByName(strIpv6mcastaddr), port);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.ssdpSocket = new MulticastSocket(port);
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface netIf = interfaces.nextElement();
            for (InterfaceAddress ifAddr : netIf.getInterfaceAddresses()) {
                InetAddress addr;
                InetAddress inetAddress = addr = ifAddr != null ? ifAddr.getAddress() : null;
                if (ipv4mcastaddr != null && addr instanceof Inet4Address) {
                    this.ssdpSocket.joinGroup(ipv4mcastaddr, netIf);
                }
                if (!(addr instanceof Inet6Address)) continue;
                this.ssdpSocket.joinGroup(ipv6mcastaddr, netIf);
            }
        }
        byte[] buf = new byte[1024];
        DatagramPacket request = new DatagramPacket(buf, buf.length);
        while (true) {
            String host;
            String st;
            String man;
            this.ssdpSocket.receive(request);
            Map<String, String> searchHeaders = this.parseSearchHeaders(request);
            if (searchHeaders == null || !(man = searchHeaders.get("MAN")).equalsIgnoreCase("\"ssdp:discover\"") || (st = searchHeaders.get("ST")) == null || !st.equalsIgnoreCase("upnp:rootdevice") && !st.equalsIgnoreCase("ssdp:all") || (host = searchHeaders.get("HOST")) == null) continue;
            int i = host.lastIndexOf(58);
            String hostAddr = i < 0 ? host : host.substring(0, i);
            if (hostAddr.startsWith("[") && hostAddr.endsWith("]")) {
                hostAddr = hostAddr.substring(1, hostAddr.length() - 1);
            }
            String usn = this.device.getUdn() + "::upnp:rootdevice";
            String location = null;
            InetAddress localAddr = this.getLocalAddress(request.getAddress());
            if (localAddr instanceof Inet4Address) {
                location = "http://" + localAddr.getHostAddress() + ":" + 1980 + "/";
            } else if (localAddr instanceof Inet6Address) {
                String a = localAddr.getHostAddress();
                int j = a.lastIndexOf(37);
                if (j > 0) {
                    a = a.substring(0, j);
                }
                location = "http://[" + a + "]:" + 1980 + "/";
            }
            if (location == null) continue;
            byte[] data = response.replace("${USN}", usn).replace("${Location}", location).replace("${Server}", this.server).getBytes();
            InetAddress remoteAddr = InetAddress.getByAddress(request.getAddress().getAddress());
            DatagramPacket packet = new DatagramPacket(data, data.length, remoteAddr, request.getPort());
            try {
                this.ssdpSocket.send(packet);
                if (!DEBUG) continue;
                String ipv = localAddr instanceof InetAddress ? "IPv4" : "IPv6";
                System.out.println("# SSDP: send: " + ipv + ": OK, addr=" + remoteAddr + ", port=" + request.getPort() + ", data.length=" + data.length);
                continue;
            }
            catch (SocketException e) {
                String ipv = localAddr instanceof InetAddress ? "IPv4" : "IPv6";
                System.err.println("# SSDP: send: " + ipv + ": ERROR, addr=" + remoteAddr + ", port=" + request.getPort() + ", data.length=" + data.length);
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, String> parseSearchHeaders(DatagramPacket packet) throws IOException {
        try (BufferedReader r = null;){
            r = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(packet.getData(), packet.getOffset(), packet.getLength()), UTF_8));
            String header = r.readLine();
            if (header.toUpperCase().startsWith("M-SEARCH")) {
                String line;
                HashMap<String, String> headers = new HashMap<String, String>();
                while ((line = r.readLine()) != null) {
                    int i = line.indexOf(58);
                    if (i <= 0) continue;
                    String key = line.substring(0, i);
                    String value = line.substring(i + 1).trim();
                    headers.put(key.toUpperCase(), value);
                }
                HashMap<String, String> hashMap = headers;
                return hashMap;
            }
            Map<String, String> map = null;
            return map;
        }
    }

    private InetAddress getLocalAddress(InetAddress remoteAddr) throws SocketException {
        block18: {
            block17: {
                if (!(remoteAddr instanceof Inet4Address)) break block17;
                for (InterfaceAddress ifAddr : SsdpServer.getInterfaceAddresses()) {
                    byte[] b2;
                    long a2;
                    int mask;
                    byte[] b1;
                    long a1;
                    InetAddress localAddr = ifAddr.getAddress();
                    short networkPrefixLength = ifAddr.getNetworkPrefixLength();
                    if (!(ifAddr.getAddress() instanceof Inet4Address) || ((a1 = (long)((b1 = remoteAddr.getAddress())[0] & 0xFF) << 24 | (long)((b1[1] & 0xFF) << 16) | (long)((b1[2] & 0xFF) << 8) | (long)(b1[3] & 0xFF)) & (long)(mask = -1 << 32 - networkPrefixLength)) != ((a2 = (long)((b2 = localAddr.getAddress())[0] & 0xFF) << 24 | (long)((b2[1] & 0xFF) << 16) | (long)((b2[2] & 0xFF) << 8) | (long)(b2[3] & 0xFF)) & (long)mask)) continue;
                    return localAddr;
                }
                break block18;
            }
            if (!(remoteAddr instanceof Inet6Address)) break block18;
            for (InterfaceAddress ifAddr : SsdpServer.getInterfaceAddresses()) {
                int i;
                InetAddress localAddr = ifAddr.getAddress();
                int networkPrefixLength = ifAddr.getNetworkPrefixLength();
                if (!(ifAddr.getAddress() instanceof Inet6Address)) continue;
                byte[] b1 = remoteAddr.getAddress();
                byte[] b2 = localAddr.getAddress();
                int bits = 0;
                for (i = 0; i < 16 && b1[i] == b2[i]; ++i) {
                    bits += 8;
                }
                if (i < 15) {
                    if ((b1[i] & 0xFE) == (b2[i] & 0xFE)) {
                        bits += 7;
                    } else if ((b1[i] & 0xFC) == (b2[i] & 0xFC)) {
                        bits += 6;
                    } else if ((b1[i] & 0xF8) == (b2[i] & 0xF8)) {
                        bits += 5;
                    } else if ((b1[i] & 0xF0) == (b2[i] & 0xF0)) {
                        bits += 4;
                    } else if ((b1[i] & 0xE0) == (b2[i] & 0xE0)) {
                        bits += 3;
                    } else if ((b1[i] & 0xC0) == (b2[i] & 0xC0)) {
                        bits += 2;
                    } else if ((b1[i] & 0x80) == (b2[i] & 0x80)) {
                        ++bits;
                    }
                }
                if (bits < networkPrefixLength) continue;
                return localAddr;
            }
        }
        return null;
    }

    public static List<InterfaceAddress> getInterfaceAddresses() throws SocketException {
        ArrayList<InterfaceAddress> list = new ArrayList<InterfaceAddress>();
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface network = interfaces.nextElement();
            for (InterfaceAddress ifAddr : network.getInterfaceAddresses()) {
                list.add(ifAddr);
            }
        }
        return list;
    }
}

