﻿' table/Range.vb
'
' Copyright (c) 2008-2011, SystemBase Co.,Ltd.
' All rights reserved.
'
' Redistribution and use in source and binary forms, with or without
' modification, are permitted provided that the following conditions are met:
'
'    1. Redistributions of source code must retain the above copyright
'       notice, this list of conditions and the following disclaimer.
'    2. Redistributions in binary form must reproduce the above copyright
'       notice, this list of conditions and the following disclaimer in the
'       documentation and/or other materials provided with the distribution.
'
' THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
' IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
' ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
' LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
' CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
' SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
' INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
' CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
' ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
' POSSIBILITY OF SUCH DAMAGE.
Imports System.Drawing

Partial Class UTable

    Private _SelectRange As CRange = Nothing

    Public Property SelectRange() As CRange
        Get
            Return Me._SelectRange
        End Get
        Set(ByVal value As CRange)
            Using Me.RenderBlock
                Me._SelectRange = value
            End Using
        End Set
    End Property

    Public Class CRange
        Public TopContent As CContent
        Public StartCol As Integer
        Public StartRow As Integer
        Public EndCol As Integer
        Public EndRow As Integer

        Public Sub New(ByVal topContent As CContent, _
                       ByVal startRow As Integer, _
                       ByVal startCol As Integer, _
                       ByVal endRow As Integer, _
                       ByVal endCol As Integer)
            Me.TopContent = topContent
            Me.StartCol = startCol
            Me.StartRow = startRow
            Me.EndCol = endCol
            Me.EndRow = endRow
        End Sub

        Public Function LeftCol() As Integer
            If Me.StartCol < Me.EndCol Then
                Return Me.StartCol
            Else
                Return Me.EndCol
            End If
        End Function

        Public Function RightCol() As Integer
            If Me.StartCol > Me.EndCol Then
                Return Me.StartCol
            Else
                Return Me.EndCol
            End If
        End Function

        Public Function TopRow() As Integer
            If Me.StartRow < Me.EndRow Then
                Return Me.StartRow
            Else
                Return Me.EndRow
            End If
        End Function

        Public Function BottomRow() As Integer
            If Me.StartRow > Me.EndRow Then
                Return Me.StartRow
            Else
                Return Me.EndRow
            End If
        End Function

        Public Function Cols() As Integer
            Return Math.Abs(Me.EndCol - Me.StartCol) + 1
        End Function

        Public Function Rows() As Integer
            Return Math.Abs(Me.EndRow - Me.StartRow) + 1
        End Function

        Public Function IsInclude(ByVal field As CField) As Boolean
            If field.TopLevelContent IsNot Me.TopContent OrElse _
               field.Desc.Layout Is Nothing Then
                Return False
            End If
            Dim c As Integer = field.Table.LayoutCache.SelectableColsRev(field.Desc.Layout.Col)
            If c < Me.LeftCol Or c > Me.RightCol Then
                Return False
            End If
            Dim r As Integer = field.Record.LayoutCache.SelectableRowsRev(field.Desc.Layout.Row)
            If r < Me.TopRow Or r > Me.BottomRow Then
                Return False
            End If
            Return True
        End Function

        Private _FieldMatrix As List(Of List(Of CField)) = Nothing
        Public Function FieldMatrix() As List(Of List(Of CField))
            If _FieldMatrix Is Nothing Then
                Me._FieldMatrix = New List(Of List(Of CField))
                For i As Integer = Me.TopRow To Me.BottomRow
                    Dim l As New List(Of CField)
                    For j As Integer = Me.LeftCol To Me.RightCol
                        l.Add(Nothing)
                    Next
                    With Me.TopContent.LayoutCache.SelectableRows(i)
                        Dim r As Integer = .Index
                        For Each f As CField In .Record.Fields.Values
                            If f.Desc.Layout IsNot Nothing AndAlso f.TopRow.Index = r Then
                                If Me.TopContent.Table.Cols(f.Desc.Layout.Col).Visible Then
                                    Dim c As Integer = Me.TopContent.Table.LayoutCache.SelectableColsRev(f.LeftCol.Index) - Me.LeftCol
                                    If c >= 0 And c < l.Count Then
                                        l(c) = f
                                    End If
                                End If
                            End If
                        Next
                    End With
                    Me._FieldMatrix.Add(l)
                Next
            End If
            Return Me._FieldMatrix
        End Function

        Public Function EndRect() As System.Drawing.Rectangle
            Dim l As Integer
            Dim t As Integer
            Dim w As Integer
            Dim h As Integer
            With Me.TopContent.Table.LayoutCache
                l = .SelectableColsPos(Me.EndCol)
                w = .SelectableCols(Me.EndCol).Size
            End With
            With Me.TopContent.LayoutCache
                t = .SelectableRowsPos(Me.EndRow)
                h = .SelectableRows(Me.EndRow).Size
            End With
            Return New Rectangle(l - w, t - h, w, h)
        End Function

        Public Sub ScrollToEnd()
            If Me.TopContent Is Me.TopContent.Table.Content Then
                Me.TopContent.Table.ScrollTo(Me.EndRect)
            End If
        End Sub

        Public Sub FieldsClear()
            Using Me.TopContent.Table.RenderBlock
                Using Me.TopContent.Table.EditBlock
                    For Each l As List(Of UTable.CField) In Me.FieldMatrix
                        For Each f As UTable.CField In l
                            If f IsNot Nothing Then
                                If f.Focusable AndAlso f.Editable.Equals(EAllow.ALLOW) Then
                                    f.Clear()
                                End If
                            End If
                        Next
                    Next
                End Using
            End Using
        End Sub

        Public Sub ClipboardCopy()
            Dim s As New System.Text.StringBuilder
            For Each l As List(Of UTable.CField) In Me.FieldMatrix
                Dim flg As Boolean = False
                For Each f As UTable.CField In l
                    If flg Then
                        s.Append(vbTab)
                    End If
                    If f IsNot Nothing Then
                        s.Append(_SanitizeClipboard(f.Desc.Provider.Clipboard(f)))
                    End If
                    flg = True
                Next
                s.Append(vbCrLf)
            Next
            Dim t As String = s.ToString
            If String.IsNullOrEmpty(t) Then
                Clipboard.Clear()
            Else
                Clipboard.SetText(t)
            End If
        End Sub

    End Class

    Public Function CreateRange(ByVal topContent As CContent, _
                                ByVal startRow As Integer, _
                                ByVal startCol As Integer, _
                                ByVal endRow As Integer, _
                                ByVal endCol As Integer)
        If startRow >= 0 And startCol >= 0 And endRow >= 0 And endCol >= 0 Then
            Return New CRange(topContent, startRow, startCol, endRow, endCol)
        Else
            Return Nothing
        End If
    End Function

    Public Function CreateRange(ByVal startField As CField, _
                                ByVal endRow As Integer, _
                                ByVal endCol As Integer) As CRange
        Return Me.CreateRange(startField.TopLevelContent, _
                              startField.Record.LayoutCache.SelectableRowsRev(startField.TopRow.Index), _
                              startField.Table.LayoutCache.SelectableColsRev(startField.LeftCol.Index), _
                              endRow, _
                              endCol)
    End Function

    Public Function CreateRange(ByVal startField As CField, _
                                ByVal endField As CField) As CRange
        Return Me.CreateRange(startField, _
                              endField.Record.LayoutCache.SelectableRowsRev(endField.TopRow.Index), _
                              endField.Table.LayoutCache.SelectableColsRev(endField.LeftCol.Index))
    End Function

    Public Function CreateRange(ByVal topContent As CContent)
        Return Me.CreateRange(topContent, 0, 0, _
                              topContent.LayoutCache.SelectableRows.Count - 1, _
                              topContent.Table.LayoutCache.SelectableCols.Count - 1)
    End Function

    Public Function CreateRange(ByVal record As CRecord)
        Dim t As Integer
        Dim b As Integer
        For i As Integer = 0 To record.Rows.Count - 1
            If record.Rows(i).Visible Then
                t = record.LayoutCache.SelectableRowsRev(i)
                Exit For
            End If
        Next
        For i As Integer = record.Rows.Count - 1 To 0 Step -1
            If record.Rows(i).Visible Then
                b = record.LayoutCache.SelectableRowsRev(i)
                Exit For
            End If
        Next
        Return Me.CreateRange(record.TopLevelContent, t, 0, b, _
                              record.Table.LayoutCache.SelectableCols.Count - 1)
    End Function

    Public Function CreateRange(ByVal record1 As CRecord, ByVal record2 As CRecord)
        Dim t1 As Integer
        Dim b1 As Integer
        Dim t2 As Integer
        Dim b2 As Integer
        For i As Integer = 0 To record1.Rows.Count - 1
            If record1.Rows(i).Visible Then
                t1 = record1.LayoutCache.SelectableRowsRev(i)
                Exit For
            End If
        Next
        For i As Integer = record1.Rows.Count - 1 To 0 Step -1
            If record1.Rows(i).Visible Then
                b1 = record1.LayoutCache.SelectableRowsRev(i)
                Exit For
            End If
        Next
        For i As Integer = 0 To record2.Rows.Count - 1
            If record2.Rows(i).Visible Then
                t2 = record2.LayoutCache.SelectableRowsRev(i)
                Exit For
            End If
        Next
        For i As Integer = record2.Rows.Count - 1 To 0 Step -1
            If record2.Rows(i).Visible Then
                b2 = record2.LayoutCache.SelectableRowsRev(i)
                Exit For
            End If
        Next
        Return Me.CreateRange(record1.TopLevelContent, Math.Min(t1, t2), 0, Math.Max(b1, b2), _
                              record1.Table.LayoutCache.SelectableCols.Count - 1)
    End Function

    Public Function CreateRange(ByVal topContent As CContent, ByVal col As Integer)
        Return Me.CreateRange(topContent, 0, col, _
                      topContent.LayoutCache.SelectableRows.Count - 1, col)
    End Function

    Public Function CreateRange(ByVal field As CField)
        Return Me.CreateRange(field, field)
    End Function

    Private _RangeDragging As Boolean = False
    Private Function range_MouseMove(ByVal e As MouseEventArgs) As Boolean
        If Me.FocusField IsNot Nothing And Me._RangeDragging Then
            If Me.SelectRange Is Nothing Then
                Me.SelectRange = Me.CreateRange(Me.FocusField)
            End If
            If Me.SelectRange IsNot Nothing Then
                Dim row As Integer = -1
                Dim col As Integer = -1
                Dim x As Integer = e.Location.X
                Dim y As Integer = e.Location.Y

                If Me.SelectRange.TopContent Is Me.Content Then
                    y -= Me.HeaderContent.LayoutCache.RowsSize - Me.VScrollBar.Value
                ElseIf Me.SelectRange.TopContent Is Me.FooterContent Then
                    y -= Me.Height - Me.FooterContent.LayoutCache.RowsSize
                    If Me.HScrollBar.Visible Then
                        y += Me.HScrollBar.Height
                    End If
                End If

                For i As Integer = 0 To Me.LayoutCache.SelectableColsPos.Count - 1
                    If Me.LayoutCache.SelectableCols(i).Index < Me.FixedCols Then
                        If x < Me.LayoutCache.SelectableColsPos(i) Then
                            col = i
                            Exit For
                        End If
                    Else
                        If x < Me.LayoutCache.SelectableColsPos(i) - Me.HScrollBar.Value Then
                            col = i
                            Exit For
                        End If
                    End If
                Next
                For i As Integer = 0 To Me.SelectRange.TopContent.LayoutCache.SelectableRowsPos.Count - 1
                    If y < Me.SelectRange.TopContent.LayoutCache.SelectableRowsPos(i) Then
                        row = i
                        Exit For
                    End If
                Next
                If row >= 0 And col >= 0 Then
                    Using Me.RenderBlock
                        Select Case Me.FocusField.Table.Setting.UserRangeSelectUnit
                            Case ERangeUnit.FIELD
                                Me.SelectRange = Me.CreateRange(Me.FocusField, row, col)
                            Case ERangeUnit.RECORD
                                Me.SelectRange = Me.CreateRange( _
                                  Me.FocusField.Record, _
                                  Me.FocusField.TopLevelContent.LayoutCache.SelectableRows(row).Record)
                        End Select
                    End Using
                End If
            End If
        End If
        Return False
    End Function

    Private Sub range_LostFocus(ByVal e As System.EventArgs)
        Me._RangeDragging = False
    End Sub

    Private Function range_MouseUp(ByVal e As System.Windows.Forms.MouseEventArgs) As Boolean
        Me._RangeDragging = False
        Return False
    End Function

    Private Function range_DraggingOverflow(ByVal dx As Integer, ByVal dy As Integer) As Boolean
        If Me.SelectRange IsNot Nothing AndAlso Me._RangeDragging Then
            If Me.SelectRange.TopContent Is Me.Content AndAlso dy <> 0 Then
                Me.SetVScrollValue(Me.VScrollBar.Value + (Me.VScrollBar.SmallChange * dy))
            End If
            If dx <> 0 Then
                Me.SetHScrollValue(Me.HScrollBar.Value + (Me.HScrollBar.SmallChange * dx))
            End If
        End If
        Return False
    End Function

    Public Sub ClipboardCopy()
        If Me.SelectRange IsNot Nothing Then
            Me.SelectRange.ClipboardCopy()
        ElseIf Me.FocusField IsNot Nothing Then
            Me.FocusField.ClipboardCopy()
        End If
    End Sub

    Public Sub ClipboardPaste()
        Me.ClipboardPaste(False)
    End Sub

    Public Sub ClipboardPaste(ByVal addRecord As Boolean)
        If Clipboard.ContainsText AndAlso Me.FocusField IsNot Nothing Then
            Using Me.RenderBlock
                Using Me.EditBlock
                    Dim v As List(Of List(Of String)) = _ParseClipboard(Clipboard.GetText)
                    If Me.SelectRange IsNot Nothing AndAlso _
                       Me.SelectRange.Rows Mod v.Count = 0 AndAlso _
                       Me.SelectRange.Cols Mod v(0).Count = 0 Then
                        Me._ClipboardPaste_toRangeRepeat(v)
                    ElseIf v.Count = 1 AndAlso v(0).Count = 1 Then
                        Me._ClipboardPaste_toField(Me.FocusField, v(0)(0))
                    Else
                        Me._ClipboardPaste_toRange(v, addRecord)
                    End If
                End Using
            End Using
        End If
    End Sub

    Private Sub _ClipboardPaste_toField(ByVal field As CField, ByVal v As String)
        If field IsNot Nothing AndAlso _
           field.Focusable AndAlso _
           field.Editable.Equals(EAllow.ALLOW) Then
            field.Desc.Provider.Clipboard(field) = v
        End If
    End Sub

    Private Sub _ClipboardPaste_toRange(ByVal v As List(Of List(Of String)), ByVal addRecord As Boolean)
        If addRecord Then
            Me._ClipboardPaste_AddRecord(v.Count)
        End If
        Dim range As CRange = Me.CreateRange(Me.FocusField, _
                                             Me.FocusField.TopLevelContent.LayoutCache.SelectableRows.Count - 1, _
                                             Me.LayoutCache.SelectableCols.Count - 1)
        If range IsNot Nothing Then
            For i As Integer = 0 To v.Count - 1
                If i >= range.FieldMatrix.Count Then
                    Exit For
                End If
                For j As Integer = 0 To v(i).Count - 1
                    If j >= range.FieldMatrix(i).Count Then
                        Exit For
                    End If
                    Me._ClipboardPaste_toField(range.FieldMatrix(i)(j), v(i)(j))
                Next
            Next
        End If
    End Sub

    Private Sub _ClipboardPaste_toRangeRepeat(ByVal v As List(Of List(Of String)))
        Dim rows As Integer = v.Count
        Dim cols As Integer = v(0).Count
        Dim range As CRange = Me.SelectRange
        For i As Integer = 0 To range.FieldMatrix.Count - 1
            Dim _i As Integer = i Mod rows
            For j As Integer = 0 To range.FieldMatrix(i).Count - 1
                Dim _j As Integer = j Mod cols
                Me._ClipboardPaste_toField(range.FieldMatrix(i)(j), v(_i)(_j))
            Next
        Next
    End Sub

    Private Sub _ClipboardPaste_AddRecord(ByVal count As Integer)
        Dim l As Integer = Me.FocusField.TopLevelContent.LayoutCache.SelectableRows.Count - _
                           Me.FocusField.Record.LayoutCache.SelectableRowsRev(Me.FocusField.TopRow.Index)
        Dim c As CContent
        With Me.FocusField.TopLevelContent.LayoutCache.SelectableRows
            c = .Item(.Count - 1).Record.Content
        End With
        If c.RecordProvider Is Nothing Then
            Exit Sub
        End If
        Do While l < count
            Dim r As CRecord = c.AddRecord()
            If r Is Nothing Then
                Exit Do
            End If
            For Each g As CGrid In r.Rows
                If g.Visible Then
                    l += 1
                End If
            Next
        Loop
        Me.UpdateLayout()
    End Sub

End Class