﻿' table/FieldProvider/CaptionFieldProvider.vb
'
' Copyright (c) 2008-2011, SystemBase Co.,Ltd.
' All rights reserved.
'
' Redistribution and use in source and binary forms, with or without
' modification, are permitted provided that the following conditions are met:
'
'    1. Redistributions of source code must retain the above copyright
'       notice, this list of conditions and the following disclaimer.
'    2. Redistributions in binary form must reproduce the above copyright
'       notice, this list of conditions and the following disclaimer in the
'       documentation and/or other materials provided with the distribution.
'
' THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
' IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
' ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
' LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
' CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
' SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
' INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
' CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
' ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
' POSSIBILITY OF SUCH DAMAGE.

Imports System.Drawing

Public Class CCaptionFieldProvider
    Inherits CFieldProvider

    Private _Setting As UTable.CSetting = Nothing
    Private _Draggable As Boolean

    Public UserSortable As UTable.EAllow = UTable.EAllow.DEFAULT

    Public Class CCaptionField
        Inherits UTable.CField
        Public Overrides Sub Clear()
        End Sub
        Public Function UserSortable() As UTable.EAllow
            Dim ret As UTable.EAllow = Me.Table.Setting.UserSortable
            With CType(Me.Desc.Provider, CCaptionFieldProvider)
                If .UserSortable <> UTable.EAllow.DEFAULT Then
                    ret = .UserSortable
                End If
            End With
            Return ret
        End Function
        Private Sub CCaptionField_DoubleClick(
          ByVal field As UTable.CField,
          ByVal location As Point,
          ByVal e As MouseEventArgs) Handles Me.DoubleClick
            If Me.TopLevelContent Is Me.Table.HeaderContent Then
                If Me.UserSortable = UTable.EAllow.ALLOW Then
                    Using Me.Table.RenderBlock
                        Dim _order As UTable.CSortState.EOrder = UTable.CSortState.EOrder.ASCEND
                        If Me.Table.SortState.Field Is Me And Me.Table.SortState.Order = UTable.CSortState.EOrder.ASCEND Then
                            _order = UTable.CSortState.EOrder.DESCEND
                        End If
                        Dim key As Object = Me.Key
                        If TypeOf key Is UTable.CCaptionKey Then
                            key = CType(key, UTable.CCaptionKey).key
                        End If
                        Me.Table.Content.Sort(key, _order)
                        With Me.Table.SortState
                            .Field = Me
                            .Order = _order
                        End With
                    End Using
                End If
            End If
        End Sub
        Private Sub CCaptionField_MouseDown(
          ByVal field As UTable.CField,
          ByVal location As Point,
          ByVal e As MouseEventArgs) Handles Me.MouseDown
            Using Me.Table.RenderBlock
                If Me.TopLevelContent Is Me.Table.Content Then
                    If Me.Table.Setting.RecordSelectableByCaptionClick AndAlso
                       Me.Table.Setting.UserRangeSelectable Then
                        Dim f As UTable.CField = Me.Record.DefaultField
                        If f IsNot Nothing Then
                            Me.Table.FocusField = f
                            Me.Table.SelectRange = Me.Table.CreateRange(Me.Record)
                        End If
                    ElseIf Me.Table.Setting.DefaultFieldSelectableByCaptionClick Then
                        Dim f As UTable.CField = Me.Record.DefaultField
                        If f IsNot Nothing Then
                            Me.Table.FocusField = f
                        End If
                    End If
                ElseIf Me.TopLevelContent Is Me.Table.HeaderContent Then
                    If Me.Table.Setting.UserRangeSelectable Then
                        Dim r As UTable.CRecord = Me.Table.Content.LayoutCache.TopRecord
                        If r IsNot Nothing Then
                            Dim k As Object = Me.Key
                            If TypeOf k Is UTable.CCaptionKey Then
                                k = CType(k, UTable.CCaptionKey).key
                            End If
                            If r.Fields.ContainsKey(k) Then
                                Dim f As UTable.CField = r.Fields(k)
                                Dim i As Integer = Me.Table.LayoutCache.SelectableColsRev(Me.LeftCol.Index)
                                If i >= 0 Then
                                    If Me.Table.Setting.ColSelectableByCaptionClick Then
                                        If f.Focusable Then
                                            If Not Me.Table.Setting.PreserveFocusByCaptionClick OrElse
                                               Me.Table.FocusField Is Nothing OrElse
                                               Not Me.Table.FocusField.Key.Equals(k) Then
                                                Me.Table.FocusField = f
                                            End If
                                            Me.Table.SelectRange =
                                              Me.Table.CreateRange(Me.Table.Content, i)
                                        End If
                                    End If
                                Else
                                    If Me.Table.Setting.AllSelectableByCaptionClick Then
                                        Me.Table.SelectRange = Me.Table.CreateRange(Me.Table.Content)
                                    End If
                                End If
                            End If
                        End If
                    End If
                End If
            End Using
        End Sub
    End Class

    Public Sub New()
        Me.New(Nothing, False)
    End Sub

    Public Sub New(ByVal caption As String)
        Me.New(caption, False)
    End Sub

    Public Sub New(ByVal caption As String, ByVal draggable As Boolean)
        MyBase.New(caption)
        Me._Draggable = draggable
    End Sub

    Public Shared Function FromDesc(fieldDesc As UTable.CFieldDesc) As IFieldProvider
        Return New CCaptionFieldProvider(fieldDesc)
    End Function

    Private Sub New(ByVal fieldDesc As UTable.CFieldDesc)
        Me.New(fieldDesc.Provider.Caption)
        Me.UserSortable = fieldDesc.UserSortable
        If TypeOf fieldDesc.Provider Is CFieldProvider Then
            Me.BorderLine = CType(fieldDesc.Provider, CFieldProvider).BorderLine
        End If
        If fieldDesc.HasSetting Then
            Me._Setting = fieldDesc.Setting.Clone
        End If
    End Sub

    Public Overrides Function CreateField() As UTable.CField
        Return New CCaptionField
    End Function

    Public Overrides Function Setting() As UTable.CSetting
        Return Me._Setting
    End Function

    Public Overrides Sub FieldInitialize(ByVal field As UTable.CField)
        field.Value = Me.Caption
    End Sub

    Public Overrides Function CreateEditor() As IEditor
        Return Nothing
    End Function

    Protected Overrides Sub renderBackground(ByVal g As Graphics, ByVal field As UTable.CField, ByVal s As UTable.CDynamicSetting, ByVal rect As System.Drawing.Rectangle, ByVal alter As Boolean)
        Dim drag As Boolean = field.Record Is field.Table.DraggingRecord
        RenderCaptionBackgroudRect(g, rect, CaptionBackColor(field, s, drag), s.CaptionStyle)
    End Sub

    Protected Overrides Sub renderForeground(ByVal g As Graphics, ByVal field As UTable.CField, ByVal s As UTable.CDynamicSetting, ByVal rect As System.Drawing.Rectangle, ByVal alter As Boolean)
        Dim drag As Boolean = field.Record Is field.Table.DraggingRecord
        RenderCaptionValue(g, field, field.Table.SortState, CreateValueRect(rect, s, field.TopLevelContent.RenderingRect), _
                           formatValue(field.Value), CaptionForeColor(field, s, drag), s.CaptionFont, _
                           Me.GetBoundedStringFormat(g, field, s, rect))
    End Sub

    Public Overrides Sub SetBorder(ByVal field As UTable.CField, ByVal border As UTable.CBorder, ByVal merged As Boolean)
        SetCaptionBorder(field, border, merged, Me.BorderLine)
    End Sub

    Public Overrides Function Focusable() As Boolean
        Return False
    End Function

    Public Overrides Function UndoEnabled() As Boolean
        Return False
    End Function

    Public Overrides Function GetAdjustSize(ByVal g As Graphics, ByVal field As UTable.CField, ByVal colFix As Boolean) As Size
        With field.DynamicSetting
            Dim ret As Size = g.MeasureString(Me.formatValue(field.Value), .CaptionFont, 100000, .GetStringFormat).ToSize
            If CType(field, CCaptionField).UserSortable = UTable.EAllow.ALLOW Then
                ret = New Size(ret.Width + 15, ret.Height)
            End If
            Return ret
        End With
    End Function

    Public Overrides Function Draggable() As Boolean
        Return Me._Draggable
    End Function

End Class