﻿Partial Class UTable

    Public DraggingRecord As UTable.CRecord = Nothing
    Private draggingEditBlock As CEditBlock = Nothing

    Private Sub recordDrag_MouseDown( _
      ByVal field As UTable.CField, _
      ByVal location As System.Drawing.Point, _
      ByVal e As MouseEventArgs)
        If field.TopLevelContent Is field.Table.Content AndAlso _
          field.Desc.Provider.Draggable AndAlso _
          e.Button = MouseButtons.Left Then
            Dim cancel As Boolean = False
            RaiseEvent RecordDragStarting(field.Record, cancel)
            If Not cancel Then
                Me.DraggingRecord = field.Record
                Me.draggingEditBlock = Me.EditBlock()
                field.Table.Render()
            End If
        End If
    End Sub

    Private Sub recordDrag_MouseMove(ByVal e As MouseEventArgs)
        If Me.DraggingRecord IsNot Nothing Then
            Dim f As UTable.CRenderCache.CField = Me.RenderCache.FindField(e.Location)
            If f IsNot Nothing Then
                Me.recordDragMove(f.Field)
            End If
        End If
    End Sub

    Private Sub recordDrag_MouseUp(ByVal e As MouseEventArgs)
        If e.Button = Windows.Forms.MouseButtons.Left Then
            If Me.DraggingRecord IsNot Nothing Then
                RaiseEvent RecordDragFinished(Me.DraggingRecord)
                Me.DraggingRecord = Nothing
                If Me.draggingEditBlock IsNot Nothing Then
                    Me.draggingEditBlock.Dispose()
                    Me.draggingEditBlock = Nothing
                End If
                Me.Render()
            End If
        End If
    End Sub

    Private Sub recordDrag_DraggingOverflow(ByVal dx As Integer, ByVal dy As Integer)
        If Me.DraggingRecord IsNot Nothing Then
            If dy <> 0 Then
                Me.SetVScrollValue(Me.VScrollBar.Value + (Me.VScrollBar.SmallChange * dy))
            End If
        End If
    End Sub

    Private Sub recordDragMove(ByVal field As UTable.CField)
        If Me.DraggingRecord.Content Is field.Content AndAlso Me.DraggingRecord IsNot field.Record Then
            Using Me.RenderBlock
                With Me.DraggingRecord.Content
                    Dim i1 As Integer = .Records.IndexOf(Me.DraggingRecord)
                    Dim i2 As Integer = .Records.IndexOf(field.Record)
                    If i2 >= 0 AndAlso i1 <> i2 Then
                        Dim cancel As Boolean = False
                        RaiseEvent RecordDragging(Me.DraggingRecord, i2, cancel)
                        If Not cancel Then
                            .MoveRecord(Me.DraggingRecord, i2)
                        End If
                    End If
                End With
            End Using
        End If
    End Sub

End Class
