' table/Setting.vb
'
' Copyright (c) 2008-2011, SystemBase Co.,Ltd.
' All rights reserved.
'
' Redistribution and use in source and binary forms, with or without
' modification, are permitted provided that the following conditions are met:
'
'    1. Redistributions of source code must retain the above copyright
'       notice, this list of conditions and the following disclaimer.
'    2. Redistributions in binary form must reproduce the above copyright
'       notice, this list of conditions and the following disclaimer in the
'       documentation and/or other materials provided with the distribution.
'
' THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
' IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
' ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
' LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
' CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
' SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
' INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
' CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
' ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
' POSSIBILITY OF SUCH DAMAGE.

Imports System.Drawing

Partial Class UTable

    Public Enum EVAlign
        [DEFAULT]
        TOP
        MIDDLE
        BOTTOM
    End Enum

    Public Enum EHAlign
        [DEFAULT]
        LEFT
        MIDDLE
        RIGHT
    End Enum

    Public Enum EAllow
        [DEFAULT]
        ALLOW
        DISABLE
    End Enum

    Public Enum ETabStop
        [DEFAULT]
        [STOP]
        NOTSTOP
    End Enum

    Public Enum ETextWrap
        [DEFAULT]
        WRAP
        NOWRAP
    End Enum

    Public Enum EScrollUnit
        FIELD
        RECORD
    End Enum

    Public Enum ERangeUnit
        FIELD
        RECORD
    End Enum

    Public Enum ECaptionStyle
        [DEFAULT]
        METALLIC
        GRADIENT
        FLAT
    End Enum

    Public Enum EStay
        [DEFAULT]
        NOT_STAY
        STAY
    End Enum

    Public Enum EBound
        [DEFAULT]
        NOT_BOUND
        BOUND
    End Enum

    Public Enum EBorderStyle
        [DEFAULT]
        SOLID
        BOLD
        DOT
        DASH
        DASHDOT
        DASHDOTDOT
    End Enum

    Public Class CSetting
        Implements ICloneable

        Public Font As Font = Nothing
        Public CaptionFont As Font = Nothing
        Public ForeColor As Color = Color.Empty
        Public BackColor As Color = Color.Empty
        Public AlterBackColor As Color = Color.Empty
        Public CaptionForeColor As Color = Color.Empty
        Public CaptionBackColor As Color = Color.Empty
        Public FocusForeColor As Color = Color.Empty
        Public FocusBackColor As Color = Color.Empty
        Public FocusRecordForeColor As Color = Color.Empty
        Public FocusRecordBackColor As Color = Color.Empty
        Public FocusCaptionForeColor As Color = Color.Empty
        Public FocusCaptionBackColor As Color = Color.Empty
        Public FocusRecordCaptionForeColor As Color = Color.Empty
        Public FocusRecordCaptionBackColor As Color = Color.Empty
        Public RangedForeColor As Color = Color.Empty
        Public RangedBackColor As Color = Color.Empty
        Public DraggingForeColor As Color = Color.Empty
        Public DraggingBackColor As Color = Color.Empty
        Public ButtonBackColor As Color = Color.Empty
        Public HorizontalAlignment As EHAlign = EHAlign.DEFAULT
        Public VerticalAlignment As EVAlign = EVAlign.DEFAULT
        Public LeftBound As EBound = EBound.DEFAULT
        Public TopBound As EBound = EBound.DEFAULT
        Public Editable As EAllow = EAllow.DEFAULT
        Public TabStop As ETabStop = ETabStop.DEFAULT
        Public TextWrap As ETextWrap = ETextWrap.DEFAULT
        Public CaptionStyle As ECaptionStyle = ECaptionStyle.DEFAULT
        Public StayVertical As EStay = EStay.DEFAULT
        Public StayHorizontal As EStay = EStay.DEFAULT
        Public StringFormatFlags As StringFormatFlags = 0

        Public Function Clone() As Object Implements System.ICloneable.Clone
            Dim s As New CSetting
            s.Font = Me.Font
            s.CaptionFont = Me.CaptionFont
            s.ForeColor = Me.ForeColor
            s.BackColor = Me.BackColor
            s.AlterBackColor = Me.AlterBackColor
            s.CaptionForeColor = Me.CaptionForeColor
            s.CaptionBackColor = Me.CaptionBackColor
            s.FocusForeColor = Me.FocusForeColor
            s.FocusBackColor = Me.FocusBackColor
            s.FocusRecordForeColor = Me.FocusRecordForeColor
            s.FocusRecordBackColor = Me.FocusRecordBackColor
            s.FocusCaptionForeColor = Me.FocusCaptionForeColor
            s.FocusCaptionBackColor = Me.FocusCaptionBackColor
            s.FocusRecordCaptionForeColor = Me.FocusRecordCaptionForeColor
            s.FocusRecordCaptionBackColor = Me.FocusRecordCaptionBackColor
            s.RangedForeColor = Me.RangedForeColor
            s.RangedBackColor = Me.RangedBackColor
            s.ButtonBackColor = Me.ButtonBackColor
            s.HorizontalAlignment = Me.HorizontalAlignment
            s.VerticalAlignment = Me.VerticalAlignment
            s.LeftBound = Me.LeftBound
            s.TopBound = Me.TopBound
            s.Editable = Me.Editable
            s.TabStop = Me.TabStop
            s.TextWrap = Me.TextWrap
            s.StayVertical = Me.StayVertical
            s.StayHorizontal = Me.StayHorizontal
            s.CaptionStyle = Me.CaptionStyle
            s.StringFormatFlags = Me.StringFormatFlags
            Return s
        End Function

    End Class

    Public Class CBorderSetting
        Public BorderColor As Color = Color.Empty
        Public BorderStyle As EBorderStyle = EBorderStyle.DEFAULT
        Public CaptionBorderColor As Color = Color.Empty
        Public CaptionBorderStyle As EBorderStyle = EBorderStyle.DEFAULT
        Public RecordBorderColor As Color = Color.Empty
        Public RecordBorderStyle As EBorderStyle = EBorderStyle.DEFAULT
    End Class

    Public Class CGlobalSetting
        Public HeaderContentBackColor As Color = Color.DarkGray
        Public FooterContentBackColor As Color = Color.DarkGray
        Public ContentBackColor As Color = Color.DimGray
        Public ResizingLineColor As Color = Color.DarkGreen
        Public Font As Font = SystemFonts.DefaultFont
        Public CaptionFont As Font = SystemFonts.DefaultFont
        Public ForeColor As Color = Color.Black
        Public BackColor As Color = Color.White
        Public AlterBackColor As Color = Color.Beige
        Public FocusForeColor As Color = Color.Transparent
        Public FocusBackColor As Color = Color.LightCyan
        Public FocusRecordForeColor As Color = Color.Transparent
        Public FocusRecordBackColor As Color = Color.PeachPuff
        Public CaptionForeColor As Color = Color.Black
        Public CaptionBackColor As Color = Color.Silver
        Public FocusCaptionForeColor As Color = Color.Transparent
        Public FocusCaptionBackColor As Color = Color.CornflowerBlue
        Public FocusRecordCaptionForeColor As Color = Color.Transparent
        Public FocusRecordCaptionBackColor As Color = Color.CornflowerBlue
        Public RangedForeColor As Color = Color.Transparent
        Public RangedBackColor As Color = Color.LightGreen
        Public DraggingForeColor As Color = Color.Transparent
        Public DraggingBackColor As Color = Color.LightGreen
        Public ButtonBackColor As Color = Color.LightGray
        Public BorderColor As Color = Color.Gray
        Public BorderStyle As EBorderStyle = EBorderStyle.DOT
        Public CaptionBorderColor As Color = Color.Gray
        Public CaptionBorderStyle As EBorderStyle = EBorderStyle.SOLID
        Public RecordBorderColor As Color = Color.Gray
        Public RecordBorderStyle As EBorderStyle = EBorderStyle.SOLID
        Public FixedColBorderColor As Color = Color.DimGray
        Public FixedColBorderStyle As EBorderStyle = EBorderStyle.BOLD
        Public HorizontalAlignment As EHAlign = EHAlign.LEFT
        Public VerticalAlignment As EVAlign = EVAlign.MIDDLE
        Public LeftBound As EBound = EBound.NOT_BOUND
        Public TopBound As EBound = EBound.NOT_BOUND
        Public Editable As EAllow = EAllow.ALLOW
        Public UserColAdjustable As EAllow = EAllow.ALLOW
        Public UserColResizable As EAllow = EAllow.ALLOW
        Public UserSortable As EAllow = EAllow.DISABLE
        Public UserRangeSelectable As Boolean = False
        Public UserRangeSelectUnit As ERangeUnit = ERangeUnit.FIELD
        Public DefaultFieldSelectableByCaptionClick As Boolean = True
        Public RecordSelectableByCaptionClick As Boolean = True
        Public ColSelectableByCaptionClick As Boolean = True
        Public AllSelectableByCaptionClick As Boolean = True
        Public RangeToggleValue As Boolean = True
        Public TextWrap As ETextWrap = ETextWrap.NOWRAP
        Public CaptionStyle As ECaptionStyle = ECaptionStyle.METALLIC
        Public ScrollUnit As EScrollUnit = EScrollUnit.FIELD
        Public StayVertical As EStay = EStay.NOT_STAY
        Public StayHorizontal As EStay = EStay.NOT_STAY
        Public EnterContent As CContent
        Public FocusColorAlways As Boolean = True
        Public AlterConsistent As Boolean = False
        Public VScrollBarAlways As Boolean = False
        Public HScrollBarAlways As Boolean = False
        Public ScrollToEdge As Boolean = False
        Public MouseWheelScrollRows As Integer = 1
        Public StringFormatFlags As StringFormatFlags = 0
    End Class

    Public Class CDynamicSetting
        Public GlobalSetting As CGlobalSetting
        Public Settings As New List(Of UTable.CSetting)

        Public Sub New(ByVal field As CField)
            If field.HasSetting Then
                Settings.Add(field.Setting)
            End If
            If field.Desc.HasSetting2 Then
                Settings.Add(field.Desc.Setting2)
            End If
            If field.Record.HasSetting Then
                Settings.Add(field.Record.Setting)
            End If
            If field.Desc.HasSetting Then
                Settings.Add(field.Desc.Setting)
            End If
            If field.Content.HasSetting Then
                Settings.Add(field.Content.Setting)
            End If
            If field.Content.RecordProvider IsNot Nothing AndAlso _
               field.Content.RecordProvider.HasSetting Then
                Settings.Add(field.Content.RecordProvider.Setting)
            End If
            Me.GlobalSetting = field.Table.Setting
        End Sub

        Public Sub New(ByVal base As CDynamicSetting, ByVal s As CSetting)
            Me.GlobalSetting = base.GlobalSetting
            Me.Settings.AddRange(base.Settings)
            Me.Settings.Add(s)
        End Sub

        Public Function Font() As Font
            For Each s As CSetting In Me.Settings
                If s.Font IsNot Nothing Then
                    Return s.Font
                End If
            Next
            Return Me.GlobalSetting.Font
        End Function

        Public Function CaptionFont() As Font
            For Each s As CSetting In Me.Settings
                If s.CaptionFont IsNot Nothing Then
                    Return s.CaptionFont
                End If
            Next
            Return Me.GlobalSetting.CaptionFont
        End Function

        Public Function ForeColor() As Color
            For Each s As CSetting In Me.Settings
                If s.ForeColor <> Color.Empty Then
                    Return s.ForeColor
                End If
            Next
            Return Me.GlobalSetting.ForeColor
        End Function

        Public Function BackColor() As Color
            For Each s As CSetting In Me.Settings
                If s.BackColor <> Color.Empty Then
                    Return s.BackColor
                End If
            Next
            Return Me.GlobalSetting.BackColor
        End Function

        Public Function AlterBackColor() As Color
            For Each s As CSetting In Me.Settings
                If s.AlterBackColor <> Color.Empty Then
                    Return s.AlterBackColor
                End If
            Next
            Return Me.GlobalSetting.AlterBackColor
        End Function

        Public Function CaptionForeColor() As Color
            For Each s As CSetting In Me.Settings
                If s.CaptionForeColor <> Color.Empty Then
                    Return s.CaptionForeColor
                End If
            Next
            Return Me.GlobalSetting.CaptionForeColor
        End Function

        Public Function CaptionBackColor() As Color
            For Each s As CSetting In Me.Settings
                If s.CaptionBackColor <> Color.Empty Then
                    Return s.CaptionBackColor
                End If
            Next
            Return Me.GlobalSetting.CaptionBackColor
        End Function

        Public Function FocusForeColor() As Color
            For Each s As CSetting In Me.Settings
                If s.FocusForeColor <> Color.Empty Then
                    Return s.FocusForeColor
                End If
            Next
            Return Me.GlobalSetting.FocusForeColor
        End Function

        Public Function FocusBackColor() As Color
            For Each s As CSetting In Me.Settings
                If s.FocusBackColor <> Color.Empty Then
                    Return s.FocusBackColor
                End If
            Next
            Return Me.GlobalSetting.FocusBackColor
        End Function

        Public Function FocusRecordForeColor() As Color
            For Each s As CSetting In Me.Settings
                If s.FocusRecordForeColor <> Color.Empty Then
                    Return s.FocusRecordForeColor
                End If
            Next
            Return Me.GlobalSetting.FocusRecordForeColor
        End Function

        Public Function FocusRecordBackColor() As Color
            For Each s As CSetting In Me.Settings
                If s.FocusRecordBackColor <> Color.Empty Then
                    Return s.FocusRecordBackColor
                End If
            Next
            Return Me.GlobalSetting.FocusRecordBackColor
        End Function

        Public Function FocusCaptionForeColor() As Color
            For Each s As CSetting In Me.Settings
                If s.FocusCaptionForeColor <> Color.Empty Then
                    Return s.FocusCaptionForeColor
                End If
            Next
            Return Me.GlobalSetting.FocusCaptionForeColor
        End Function

        Public Function FocusCaptionBackColor() As Color
            For Each s As CSetting In Me.Settings
                If s.FocusCaptionBackColor <> Color.Empty Then
                    Return s.FocusCaptionBackColor
                End If
            Next
            Return Me.GlobalSetting.FocusCaptionBackColor
        End Function

        Public Function FocusRecordCaptionForeColor() As Color
            For Each s As CSetting In Me.Settings
                If s.FocusRecordCaptionForeColor <> Color.Empty Then
                    Return s.FocusRecordCaptionForeColor
                End If
            Next
            Return Me.GlobalSetting.FocusRecordCaptionForeColor
        End Function

        Public Function FocusRecordCaptionBackColor() As Color
            For Each s As CSetting In Me.Settings
                If s.FocusRecordCaptionBackColor <> Color.Empty Then
                    Return s.FocusRecordCaptionBackColor
                End If
            Next
            Return Me.GlobalSetting.FocusRecordCaptionBackColor
        End Function

        Public Function RangedForeColor() As Color
            For Each s As CSetting In Me.Settings
                If s.RangedForeColor <> Color.Empty Then
                    Return s.RangedForeColor
                End If
            Next
            Return Me.GlobalSetting.RangedForeColor
        End Function

        Public Function RangedBackColor() As Color
            For Each s As CSetting In Me.Settings
                If s.RangedBackColor <> Color.Empty Then
                    Return s.RangedBackColor
                End If
            Next
            Return Me.GlobalSetting.RangedBackColor
        End Function

        Public Function DraggingForeColor() As Color
            For Each s As CSetting In Me.Settings
                If s.DraggingForeColor <> Color.Empty Then
                    Return s.DraggingForeColor
                End If
            Next
            Return Me.GlobalSetting.DraggingForeColor
        End Function

        Public Function DraggingBackColor() As Color
            For Each s As CSetting In Me.Settings
                If s.DraggingBackColor <> Color.Empty Then
                    Return s.DraggingBackColor
                End If
            Next
            Return Me.GlobalSetting.DraggingBackColor
        End Function

        Public Function ButtonBackColor() As Color
            For Each s As CSetting In Me.Settings
                If s.ButtonBackColor <> Color.Empty Then
                    Return s.ButtonBackColor
                End If
            Next
            Return Me.GlobalSetting.ButtonBackColor
        End Function

        Public Function HorizontalAlignment() As EHAlign
            For Each s As CSetting In Me.Settings
                If s.HorizontalAlignment <> EHAlign.DEFAULT Then
                    Return s.HorizontalAlignment
                End If
            Next
            Return Me.GlobalSetting.HorizontalAlignment
        End Function

        Public Function VerticalAlignment() As EVAlign
            For Each s As CSetting In Me.Settings
                If s.VerticalAlignment <> EVAlign.DEFAULT Then
                    Return s.VerticalAlignment
                End If
            Next
            Return Me.GlobalSetting.VerticalAlignment
        End Function

        Public Function LeftBound() As EBound
            For Each s As CSetting In Me.Settings
                If s.LeftBound <> EBound.DEFAULT Then
                    Return s.LeftBound
                End If
            Next
            Return Me.GlobalSetting.LeftBound
        End Function

        Public Function TopBound() As EBound
            For Each s As CSetting In Me.Settings
                If s.TopBound <> EBound.DEFAULT Then
                    Return s.TopBound
                End If
            Next
            Return Me.GlobalSetting.TopBound
        End Function

        Public Function Editable() As EAllow
            For Each s As CSetting In Me.Settings
                If s.Editable <> EAllow.DEFAULT Then
                    Return s.Editable
                End If
            Next
            Return Me.GlobalSetting.Editable
        End Function

        Public Function TabStop() As ETabStop
            For Each s As CSetting In Me.Settings
                If s.TabStop <> ETabStop.DEFAULT Then
                    Return s.TabStop
                End If
            Next
            Return ETabStop.STOP
        End Function

        Public Function TextWrap() As ETextWrap
            For Each s As CSetting In Me.Settings
                If s.TextWrap <> ETextWrap.DEFAULT Then
                    Return s.TextWrap
                End If
            Next
            Return Me.GlobalSetting.TextWrap
        End Function

        Public Function StayVertical() As EStay
            For Each s As CSetting In Me.Settings
                If s.StayVertical <> EStay.DEFAULT Then
                    Return s.StayVertical
                End If
            Next
            Return Me.GlobalSetting.StayVertical
        End Function

        Public Function StayHorizontal() As EStay
            For Each s As CSetting In Me.Settings
                If s.StayHorizontal <> EStay.DEFAULT Then
                    Return s.StayHorizontal
                End If
            Next
            Return Me.GlobalSetting.StayHorizontal
        End Function

        Public Function CaptionStyle() As ECaptionStyle
            For Each s As CSetting In Me.Settings
                If s.CaptionStyle <> ECaptionStyle.DEFAULT Then
                    Return s.CaptionStyle
                End If
            Next
            Return Me.GlobalSetting.CaptionStyle
        End Function

        Public Function GetStringFormat() As StringFormat
            Dim format As New StringFormat
            If Me.TextWrap = ETextWrap.NOWRAP Then
                format.FormatFlags = StringFormatFlags.NoWrap
            End If
            Select Case Me.HorizontalAlignment
                Case EHAlign.LEFT
                    format.Alignment = StringAlignment.Near
                Case EHAlign.MIDDLE
                    format.Alignment = StringAlignment.Center
                Case EHAlign.RIGHT
                    format.Alignment = StringAlignment.Far
            End Select
            Select Case Me.VerticalAlignment
                Case EVAlign.TOP
                    format.LineAlignment = StringAlignment.Near
                Case EVAlign.MIDDLE
                    format.LineAlignment = StringAlignment.Center
                Case EVAlign.BOTTOM
                    format.LineAlignment = StringAlignment.Far
            End Select
            format.FormatFlags = format.FormatFlags Or Me.GlobalSetting.StringFormatFlags
            For Each s As CSetting In Me.Settings
                format.FormatFlags = format.FormatFlags Or s.StringFormatFlags
            Next
            Return format
        End Function

    End Class

    Public Class CDynamicBorderSetting
        Public GlobalSetting As CGlobalSetting
        Public Settings As New List(Of UTable.CBorderSetting)

        Public Sub New(ByVal record As CRecord)
            If record.HasBorderSetting Then
                Settings.Add(record.BorderSetting)
            End If
            If record.Content.HasBorderSetting Then
                Settings.Add(record.Content.BorderSetting)
            End If
            If record.Content.RecordProvider IsNot Nothing AndAlso _
               record.Content.RecordProvider.HasBorderSetting Then
                Settings.Add(record.Content.RecordProvider.BorderSetting)
            End If
            Me.GlobalSetting = record.Table.Setting
        End Sub

        Public Function BorderColor() As Color
            For Each s As CBorderSetting In Me.Settings
                If s.BorderColor <> Color.Empty Then
                    Return s.BorderColor
                End If
            Next
            Return Me.GlobalSetting.BorderColor
        End Function

        Public Function BorderStyle() As EBorderStyle
            For Each s As CBorderSetting In Me.Settings
                If s.BorderStyle <> EBorderStyle.DEFAULT Then
                    Return s.BorderStyle
                End If
            Next
            Return Me.GlobalSetting.BorderStyle
        End Function

        Public Function CaptionBorderColor() As Color
            For Each s As CBorderSetting In Me.Settings
                If s.CaptionBorderColor <> Color.Empty Then
                    Return s.CaptionBorderColor
                End If
            Next
            Return Me.GlobalSetting.CaptionBorderColor
        End Function

        Public Function CaptionBorderStyle() As EBorderStyle
            For Each s As CBorderSetting In Me.Settings
                If s.CaptionBorderStyle <> EBorderStyle.DEFAULT Then
                    Return s.CaptionBorderStyle
                End If
            Next
            Return Me.GlobalSetting.CaptionBorderStyle
        End Function

        Public Function RecordBorderColor() As Color
            For Each s As CBorderSetting In Me.Settings
                If s.RecordBorderColor <> Color.Empty Then
                    Return s.RecordBorderColor
                End If
            Next
            Return Me.GlobalSetting.RecordBorderColor
        End Function

        Public Function RecordBorderStyle() As EBorderStyle
            For Each s As CBorderSetting In Me.Settings
                If s.RecordBorderStyle <> EBorderStyle.DEFAULT Then
                    Return s.RecordBorderStyle
                End If
            Next
            Return Me.GlobalSetting.RecordBorderStyle
        End Function

    End Class

End Class
