' table/Edit.vb
'
' Copyright (c) 2008-2011, SystemBase Co.,Ltd.
' All rights reserved.
'
' Redistribution and use in source and binary forms, with or without
' modification, are permitted provided that the following conditions are met:
'
'    1. Redistributions of source code must retain the above copyright
'       notice, this list of conditions and the following disclaimer.
'    2. Redistributions in binary form must reproduce the above copyright
'       notice, this list of conditions and the following disclaimer in the
'       documentation and/or other materials provided with the distribution.
'
' THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
' IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
' ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
' LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
' CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
' SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
' INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
' CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
' ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
' POSSIBILITY OF SUCH DAMAGE.

Imports System.Drawing

Partial Class UTable

    Private _EditorContainer As CEditorContainer = Nothing

    Private Function edit_KeyPress(ByVal e As System.Windows.Forms.KeyPressEventArgs) As Boolean        
        If Not Char.IsControl(e.KeyChar) Then
            Me._StartEdit(e.KeyChar, False)
        End If
        Return (Me.Editor IsNot Nothing)
    End Function

    Private Function edit_KeyDown(ByVal e As System.Windows.Forms.KeyEventArgs) As Boolean
        If e.KeyCode = Keys.ProcessKey Then
            Me.ScrollTo(Me.FocusField)
            Me._StartEdit(Nothing, True)
            Return True
        End If
        Return False
    End Function

    Private Function edit_MouseDoubleClick(ByVal e As System.Windows.Forms.MouseEventArgs) As Boolean
        If Me.RenderCache.FocusField IsNot Nothing AndAlso _
           Me.RenderCache.FocusField.Rect.Contains(e.Location) Then
            Dim handled As Boolean = False
            If Me.FocusField IsNot Nothing Then
                Me.RaiseFieldSelected(Me.FocusField, handled)
            End If
            If handled Then
                Return True
            Else
                Return Me.StartEdit() IsNot Nothing
            End If
        End If
        Return False
    End Function

    Public Function StartEdit() As IEditor
        Return Me._StartEdit(Nothing, False)
    End Function

    Private Function _StartEdit(ByVal key As Char, ByVal clear As Boolean) As IEditor
        If Me.Editor IsNot Nothing Then
            Return Me.Editor
        End If
        If Not Me.Focused Then
            Return Nothing
        End If
        If Me.DraggingRecord IsNot Nothing Then
            Return Nothing
        End If
        If Me.FocusField IsNot Nothing Then
            Using Me.RenderBlock
                Dim editable As EAllow = Me.FocusField.Editable
                If editable = EAllow.ALLOW Then
                    Me.ScrollTo(Me.FocusField)
                    Me.Render()
                    If Me.RenderCache.FocusField IsNot Nothing Then
                        Dim editor As IEditor = Me.FocusField.Desc.Provider.CreateEditor
                        If editor IsNot Nothing Then
                            Me.SelectRange = Nothing
                            editor.Initialize(Me.FocusField)
                            Me.FocusField.Desc.Provider.EditorInitialize(Me.FocusField, editor)
                            RaiseEvent InitializeEditor(Me.FocusField, editor)
                            With Me.RenderCache.FocusField.Rect
                                editor.Control.Size = New Size(.Width - 1, .Height - 1)
                                Dim dy As Integer = .Height - editor.Control.Size.Height
                                Dim y As Integer = 0
                                Select Case Me.FocusField.DynamicSetting.VerticalAlignment
                                    Case EVAlign.TOP
                                        y = .Top
                                    Case EVAlign.MIDDLE
                                        y = .Top + (dy / 2)
                                    Case EVAlign.BOTTOM
                                        y = .Top + dy
                                End Select
                                If y = .Top Then
                                    y += 1
                                End If
                                editor.Control.Location = New Point(.Left + 1, y)
                            End With
                            Me.Controls.Add(editor)
                            If Not clear Then
                                editor.Value = Me.FocusField.CommittedValue
                            End If
                            Me._EditorContainer = New CEditorContainer(Me, editor)
                            Me.VScrollBar.Enabled = False
                            Me.HScrollBar.Enabled = False
                            Me.raiseEditStart(Me.FocusField, Me.Editor)
                        End If
                    End If
                End If
            End Using
            If Me.Editor IsNot Nothing Then
                Me.Editor.Control.Focus()
                Me.Editor.EditEnter(key)
            End If
        End If
        Return Me.Editor
    End Function

    Public Sub FinishEdit()
        Me.FinishEdit(False)
    End Sub

    Private finishEdit_flg As Boolean = False
    Public Sub FinishEdit(ByVal valueCommit As Boolean)
        Try
            If Me.finishEdit_flg Then
                Exit Sub
            End If
            Me.finishEdit_flg = True
            Using Me.RenderBlock
                If Me.Editor IsNot Nothing Then
                    Dim fieldModify As CFieldModify = Me._EditorContainer.FieldModify
                    Dim v As Object = Me.Editor.Value
                    Me.Controls.Remove(Me.Editor)
                    Me._EditorContainer = Nothing
                    If valueCommit Then
                        Me.FocusField.ValueCommit(Me.FocusField.Desc.Provider.ValueRegularize(v, Nothing), fieldModify)
                    End If
                    If Me.VScrollBar.Maximum > Me.VScrollBar.Minimum Then
                        Me.VScrollBar.Enabled = True
                    End If
                    If Me.HScrollBar.Maximum > Me.HScrollBar.Minimum Then
                        Me.HScrollBar.Enabled = True
                    End If
                    Me.raiseEditFinished(Me.FocusField)
                End If
            End Using
        Finally
            Me.finishEdit_flg = False
        End Try
    End Sub

    Public Function LeaveEdit() As Boolean
        Return Me.LeaveEdit(Nothing)
    End Function

    Public Function LeaveEdit(ByVal direction As String) As Boolean
        Dim cancel As Boolean = False
        RaiseEvent EditLeaving(Me.FocusField, direction, cancel)
        If cancel Then
            Return False
        End If
        Using Me.RenderBlock
            Using Me.EditBlock
                If Me.Editor IsNot Nothing Then
                    Me.Editor.EditLeave()
                    Me.Focus()
                    If Me.Focused Then
                        If direction IsNot Nothing Then
                            Me.KeyboardOperation.LeaveEdit(direction, Me)
                        End If
                    End If
                End If
            End Using
        End Using
        Return (Me.Editor Is Nothing)
    End Function

    Public Function Editor() As IEditor
        If Me._EditorContainer IsNot Nothing Then
            Return Me._EditorContainer.Editor
        Else
            Return Nothing
        End If
    End Function

    Class CEditorContainer
        Public Table As UTable
        Public FieldModify As CFieldModify
        Public WithEvents Editor As IEditor
        Public WithEvents Control As Control

        Public Sub New(ByVal table As UTable, ByVal editor As IEditor)
            Me.Table = table
            Me.Editor = editor
            Me.Control = editor.Control
            Me.FieldModify = table.FocusField.Desc.Provider.CreateModifyField(table.FocusField)
            Me.FieldModify.SetUp(table.FocusField)
        End Sub

        Private Sub Editor_Leave(ByVal sender As Object, ByVal direction As String) Handles Editor.Leave
            Me.Table.LeaveEdit(direction)
        End Sub

        Private Sub _Editor_ValueChanged(ByVal sender As Object) Handles Editor.ValueChanged
            Me.Table.raiseEditorValueChanged(Me.Table.FocusField)
        End Sub

        Private editor_validating_flg As Boolean = False

        Private Sub Editor_Validating(ByVal sender As Object, ByVal e As System.ComponentModel.CancelEventArgs) Handles Control.Validating
            If Me.Table.finishEdit_flg Then
                Exit Sub
            End If
            Try
                If Me.editor_validating_flg Then
                    Exit Sub
                End If
                Me.editor_validating_flg = True
                If Me.Table.Editor Is Me.Editor Then
                    Me.Table.raiseFieldValidating(Me.Table.FocusField, e)
                End If
            Finally
                Me.editor_validating_flg = False
            End Try
        End Sub

        Private editor_validated_flg As Boolean = False
        Private Sub Editor_Validated(ByVal sender As Object, ByVal e As System.EventArgs) Handles Control.Validated
            Try
                If Me.editor_validated_flg Then
                    Exit Sub
                End If
                Me.editor_validated_flg = True
                If Me.Table.Editor Is Me.Editor Then
                    Me.Table.raiseFieldValidated(Me.Table.FocusField)
                    Me.Table.FinishEdit(True)
                End If
            Finally
                Me.editor_validated_flg = False
            End Try
        End Sub

    End Class

End Class
