﻿' table/Content.vb
'
' Copyright (c) 2008-2011, SystemBase Co.,Ltd.
' All rights reserved.
'
' Redistribution and use in source and binary forms, with or without
' modification, are permitted provided that the following conditions are met:
'
'    1. Redistributions of source code must retain the above copyright
'       notice, this list of conditions and the following disclaimer.
'    2. Redistributions in binary form must reproduce the above copyright
'       notice, this list of conditions and the following disclaimer in the
'       documentation and/or other materials provided with the distribution.
'
' THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
' IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
' ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
' LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
' CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
' SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
' INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
' CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
' ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
' POSSIBILITY OF SUCH DAMAGE.

Partial Class UTable

    Public Interface IUndo
        Sub Undo(ByVal content As UTable.CContent)
        Sub Redo(ByVal content As UTable.CContent)
    End Interface

    Public Class CChildUndo
        Implements IUndo

        Public RecordIndex As Integer
        Public ChildUndo As IUndo

        Public Sub New(ByVal record As CRecord, ByVal childUndo As IUndo)
            Me.RecordIndex = record.Index
            Me.ChildUndo = childUndo
        End Sub

        Public Sub Redo(ByVal content As CContent) Implements IUndo.Redo
            Me.ChildUndo.Redo(content.Records(Me.RecordIndex).Child)
        End Sub

        Public Sub Undo(ByVal content As CContent) Implements IUndo.Undo
            Me.ChildUndo.Undo(content.Records(Me.RecordIndex).Child)
        End Sub

    End Class

    Public Class CFieldModifyUndo
        Implements IUndo

        Public RecordIndex As Integer
        Public Key As Object
        Public Value As Object
        Public BakValue As Object

        Public Sub New(ByVal field As CField, ByVal bakValue As Object)
            Me.RecordIndex = field.Record.Index
            Me.Key = field.Key
            Me.BakValue = BakValue
            Me.Value = field.Desc.Provider.UndoBuffer(field)
        End Sub

        Public Sub Redo(ByVal content As CContent) Implements IUndo.Redo
            Dim f As CField = getField(content)
            If f IsNot Nothing Then
                f.Desc.Provider.UndoBuffer(f) = Me.Value
            End If
        End Sub

        Public Sub Undo(ByVal content As CContent) Implements IUndo.Undo
            Dim f As CField = getField(content)
            If f IsNot Nothing Then
                f.Desc.Provider.UndoBuffer(f) = Me.BakValue
            End If
        End Sub

        Private Function getField(ByVal content As CContent) As CField
            If Me.RecordIndex >= content.Records.Count Then
                Return Nothing
            End If
            Dim r As CRecord = content.Records(Me.RecordIndex)
            If Not r.Fields.ContainsKey(Me.Key) Then
                Return Nothing
            End If
            Return r.Fields(Me.Key)
        End Function

    End Class

    Public Class CRecordAddUndo
        Implements IUndo

        Public RecordIndex As Integer

        Public Sub New(ByVal recordIndex As Integer)
            Me.RecordIndex = recordIndex
        End Sub

        Public Sub Redo(ByVal content As CContent) Implements IUndo.Redo
            If Me.RecordIndex <= content.Records.Count Then
                content.Records.Insert(Me.RecordIndex, content.CreateRecord)
                content.TopLevelContent.LayoutCacheInvalid = True
            End If
        End Sub

        Public Sub Undo(ByVal content As CContent) Implements IUndo.Undo
            If Me.RecordIndex < content.Records.Count Then
                content.Records.RemoveAt(Me.RecordIndex)
                content.TopLevelContent.LayoutCacheInvalid = True
            End If
        End Sub

    End Class

    Public Class CRecordRemoveUndo
        Implements IUndo

        Public RecordIndex As Integer
        Public Values As New Dictionary(Of Object, Object)

        Public Sub New(ByVal record As CRecord)
            Me.RecordIndex = record.Index
            For Each k As Object In record.Fields.Keys
                Dim f As CField = record.Fields(k)
                Me.Values.Add(k, f.Desc.Provider.UndoBuffer(f))
            Next
        End Sub

        Public Sub Redo(ByVal content As CContent) Implements IUndo.Redo
            If Me.RecordIndex < content.Records.Count Then
                content.Records.RemoveAt(Me.RecordIndex)
                content.TopLevelContent.LayoutCacheInvalid = True
            End If
        End Sub

        Public Sub Undo(ByVal content As CContent) Implements IUndo.Undo
            If Me.RecordIndex <= content.Records.Count Then
                Dim r As CRecord = content.CreateRecord
                For Each k As Object In Me.Values.Keys
                    If r.Fields.ContainsKey(k) Then
                        Dim f As CField = r.Fields(k)
                        f.Desc.Provider.UndoBuffer(f) = Me.Values(k)
                    End If
                Next
                content.Records.Insert(Me.RecordIndex, r)
                content.TopLevelContent.LayoutCacheInvalid = True
            End If
        End Sub

    End Class

    Public Class CRecordMoveUndo
        Implements IUndo

        Public RecordIndex As Integer
        Public BakRecordIndex As Integer

        Public Sub New(ByVal record As CRecord, ByVal recordIndex As Integer)
            Me.BakRecordIndex = record.Index
            Me.RecordIndex = recordIndex
        End Sub

        Public Sub Redo(ByVal content As CContent) Implements IUndo.Redo
            If Me.RecordIndex < content.Records.Count AndAlso _
               Me.BakRecordIndex < content.Records.Count Then
                Dim r As CRecord = content.Records(Me.BakRecordIndex)
                content.Records.RemoveAt(Me.BakRecordIndex)
                content.Records.Insert(Me.RecordIndex, r)
                content.TopLevelContent.LayoutCacheInvalid = True
            End If
        End Sub

        Public Sub Undo(ByVal content As CContent) Implements IUndo.Undo
            If Me.RecordIndex < content.Records.Count AndAlso _
               Me.BakRecordIndex < content.Records.Count Then
                Dim r As CRecord = content.Records(Me.RecordIndex)
                content.Records.RemoveAt(Me.RecordIndex)
                content.Records.Insert(Me.BakRecordIndex, r)
                content.TopLevelContent.LayoutCacheInvalid = True
            End If
        End Sub

    End Class

    Public Class CRecordClearUndo
        Implements IUndo

        Public Values As New List(Of Dictionary(Of Object, Object))

        Public Sub New(ByVal content As CContent)
            For Each r As CRecord In content.Records
                Dim v As New Dictionary(Of Object, Object)
                For Each k As Object In r.Fields.Keys
                    Dim f As CField = r.Fields(k)
                    If f.Desc.Provider.UndoEnabled Then
                        v.Add(k, f.Desc.Provider.UndoBuffer(f))
                    End If
                Next
                Me.Values.Add(v)
            Next
        End Sub

        Public Sub Redo(ByVal content As CContent) Implements IUndo.Redo
            content.ClearRecord()
        End Sub

        Public Sub Undo(ByVal content As CContent) Implements IUndo.Undo
            For Each v As Dictionary(Of Object, Object) In Me.Values
                Dim r As CRecord = content.CreateRecord
                For Each k As Object In v.Keys
                    If r.Fields.ContainsKey(k) Then
                        Dim f As CField = r.Fields(k)
                        f.Desc.Provider.UndoBuffer(f) = v(k)
                    End If
                Next
                content.Records.Add(r)
            Next
            content.TopLevelContent.LayoutCacheInvalid = True
        End Sub

    End Class

    Public Class CSortUndo
        Implements IUndo

        Public RecordIndexss As List(Of Integer)

        Public Sub New(ByVal recordIndexes As List(Of Integer))
            Me.RecordIndexss = recordIndexes
        End Sub

        Public Sub Redo(ByVal content As CContent) Implements IUndo.Redo
            If Me.RecordIndexss.Count = content.Records.Count Then
                Dim bak As List(Of CRecord) = content.Records
                content.Records = New List(Of CRecord)
                For Each i As Integer In Me.RecordIndexss
                    content.Records.Add(bak(i))
                Next
                content.Table.SortState.Field = Nothing
                content.TopLevelContent.LayoutCacheInvalid = True
            End If
        End Sub

        Public Sub Undo(ByVal content As CContent) Implements IUndo.Undo
            If Me.RecordIndexss.Count = content.Records.Count Then
                Dim rev As New Dictionary(Of Integer, Integer)
                For i As Integer = 0 To Me.RecordIndexss.Count - 1
                    rev.Add(Me.RecordIndexss(i), i)
                Next
                Dim bak As List(Of CRecord) = content.Records
                content.Records = New List(Of CRecord)
                For i As Integer = 0 To Me.RecordIndexss.Count - 1
                    content.Records.Add(bak(rev(i)))
                Next
                content.Table.SortState.Field = Nothing
                content.TopLevelContent.LayoutCacheInvalid = True
            End If
        End Sub

    End Class

    Public Class CUndoContainer
        Public Content As CContent
        Public Undo As IUndo
        Public Sub New(ByVal content As CContent, ByVal undo As IUndo)
            Me.Content = content
            Me.Undo = undo
        End Sub
    End Class

    Private _ignoreUndoBufferEnabled As Boolean = False

    Public Sub ClearUndoBuffer()
        If Me.UndoBuffer IsNot Nothing Then
            Me.UndoBuffer.Clear()
        End If
        If Me.RedoBuffer IsNot Nothing Then
            Me.RedoBuffer.Clear()
        End If
    End Sub

    Public Property UndoBufferEnabled() As Boolean
        Get
            Return Me._UndoBufferEnabled
        End Get
        Set(ByVal value As Boolean)
            Me._UndoBufferEnabled = value
            If Me.UndoBufferEnabled Then
                If Me.UndoBuffer Is Nothing Then
                    Me.UndoBuffer = New List(Of List(Of CUndoContainer))
                End If
                If Me.RedoBuffer Is Nothing Then
                    Me.RedoBuffer = New List(Of List(Of CUndoContainer))
                End If
            Else
                Me.UndoBuffer = Nothing
                Me.RedoBuffer = Nothing
            End If
        End Set
    End Property

    Friend Sub addUndo(ByVal content As CContent, ByVal undo As IUndo)
        If Me._ignoreUndoBufferEnabled Or Me.UndoBuffer Is Nothing Then
            Exit Sub
        End If
        If Me._EditBlock IsNot Nothing Then
            Me._EditBlock.UndoContainers.Add(New CUndoContainer(content, undo))
        Else
            Dim l As New List(Of CUndoContainer)
            l.Add(New CUndoContainer(content, undo))
            Me.addUndo(l)
        End If
    End Sub

    Friend Sub addUndo(ByVal undoContainers As List(Of CUndoContainer))
        If Me._ignoreUndoBufferEnabled Or Me.UndoBuffer Is Nothing Then
            Exit Sub
        End If
        Me.UndoBuffer.Add(undoContainers)
        Me.RedoBuffer.Clear()
        If Me.UndoBuffer.Count > Me.UndoBufferMax Then
            Me.UndoBuffer.RemoveRange(0, Me.UndoBuffer.Count - Me.UndoBufferMax)
        End If
    End Sub

    Public Sub Undo()
        If Me.UndoBuffer Is Nothing OrElse Me.UndoBuffer.Count = 0 Then
            Exit Sub
        End If
        Me._ignoreUndoBufferEnabled = True
        Try
            Dim i As Integer = Me.UndoBuffer.Count - 1
            Dim ucs As List(Of CUndoContainer) = Me.UndoBuffer(i)
            Using Me.RenderBlock
                For j As Integer = ucs.Count - 1 To 0 Step -1
                    Dim uc As CUndoContainer = ucs(j)
                    uc.Undo.Undo(uc.Content)
                Next
                Me.RedoBuffer.Add(ucs)
                Me.UndoBuffer.RemoveAt(i)
            End Using
            RaiseEvent UndoFinished(Me, ucs)
        Finally
            Me._ignoreUndoBufferEnabled = False
        End Try
    End Sub

    Public Sub Redo()
        If Me.RedoBuffer Is Nothing OrElse Me.RedoBuffer.Count = 0 Then
            Exit Sub
        End If
        Me._ignoreUndoBufferEnabled = True
        Try
            Dim i As Integer = Me.RedoBuffer.Count - 1
            Dim ucs As List(Of CUndoContainer) = Me.RedoBuffer(i)
            Using Me.RenderBlock
                For j As Integer = ucs.Count - 1 To 0 Step -1
                    Dim uc As CUndoContainer = ucs(j)
                    uc.Undo.Redo(uc.Content)
                Next
                Me.UndoBuffer.Add(ucs)
                Me.RedoBuffer.RemoveAt(i)
            End Using
            RaiseEvent RedoFinished(Me, ucs)
        Finally
            Me._ignoreUndoBufferEnabled = False
        End Try
    End Sub

End Class