﻿' table/Ime.vb
'
' Copyright (c) 2008-2011, SystemBase Co.,Ltd.
' All rights reserved.
'
' Redistribution and use in source and binary forms, with or without
' modification, are permitted provided that the following conditions are met:
'
'    1. Redistributions of source code must retain the above copyright
'       notice, this list of conditions and the following disclaimer.
'    2. Redistributions in binary form must reproduce the above copyright
'       notice, this list of conditions and the following disclaimer in the
'       documentation and/or other materials provided with the distribution.
'
' THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
' IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
' ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
' LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
' CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
' SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
' INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
' CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
' ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
' POSSIBILITY OF SUCH DAMAGE.

Partial Public Class UTable

    Private hIMC As Integer = 0

    Private Sub setUpImeMode(ByVal field As CField)
        If field Is Nothing Then
            Exit Sub
        End If
        Dim m As ImeMode = field.Desc.Provider.ImeMode
        If field.DynamicSetting.Editable <> EAllow.ALLOW Then
            m = Windows.Forms.ImeMode.Disable
        End If
        If m = Windows.Forms.ImeMode.Disable Then
            Dim h As Integer = MAPI.ImmAssociateContext(Me.Handle, 0)
            If h <> 0 Then
                Me.hIMC = h
            End If
        Else
            If Me.hIMC <> 0 Then
                MAPI.ImmAssociateContext(Me.Handle, Me.hIMC)
                Me.hIMC = 0
            End If
            Dim h As Integer = MAPI.ImmGetContext(Me.Handle)
            If h <> 0 Then
                Try
                    MAPI.ImmSetCompositionString(h, &H9, 0, 0, 0, 0)
                    Select Case m
                        Case Windows.Forms.ImeMode.On, Windows.Forms.ImeMode.Hiragana, Windows.Forms.ImeMode.HangulFull
                            MAPI.ImmSetOpenStatus(h, 1)
                            MAPI.ImmSetConversionStatus(h, &H19, &H8)
                        Case Windows.Forms.ImeMode.Katakana
                            MAPI.ImmSetOpenStatus(h, 1)
                            MAPI.ImmSetConversionStatus(h, &H1B, &H8)
                        Case Windows.Forms.ImeMode.KatakanaHalf
                            MAPI.ImmSetOpenStatus(h, 1)
                            MAPI.ImmSetConversionStatus(h, &H13, &H8)
                        Case Windows.Forms.ImeMode.AlphaFull
                            MAPI.ImmSetOpenStatus(h, 1)
                            MAPI.ImmSetConversionStatus(h, &H18, &H8)
                        Case Windows.Forms.ImeMode.Alpha
                            MAPI.ImmSetOpenStatus(h, 1)
                            MAPI.ImmSetConversionStatus(h, &H10, &H8)
                        Case Windows.Forms.ImeMode.Hangul
                            MAPI.ImmSetOpenStatus(h, 1)
                            MAPI.ImmSetConversionStatus(h, &H11, &H8)
                        Case Else
                            MAPI.ImmSetOpenStatus(h, 0)
                            MAPI.ImmSetConversionStatus(h, &H19, &H8)
                    End Select
                Finally
                    MAPI.ImmReleaseContext(Me.Handle, h)
                End Try
            End If
        End If
    End Sub

    Private Sub associateImeContext(ByVal control As Control)
        control.ImeMode = Windows.Forms.ImeMode.NoControl
        Dim h As Integer = MAPI.ImmGetContext(Me.Handle)
        If h = 0 Then
            MAPI.ImmAssociateContext(control.Handle, 0)
        Else
            Try
                Dim lfc As New LOGFONTC
                Dim lf As New LOGFONT
                control.Font.ToLogFont(lfc)
                lf.lfCharSet = lfc.lfCharSet
                lf.lfClipPrecision = lfc.lfClipPrecision
                lf.lfEscapement = lfc.lfEscapement
                lf.lfFaceName = lfc.lfFaceName
                lf.lfHeight = lfc.lfHeight
                lf.lfItalic = lfc.lfItalic
                lf.lfOrientation = lfc.lfOrientation
                lf.lfOutPrecision = lfc.lfOutPrecision
                lf.lfPitchAndFamily = lfc.lfPitchAndFamily
                lf.lfQuality = lfc.lfQuality
                lf.lfStrikeOut = lfc.lfStrikeOut
                lf.lfUnderline = lfc.lfUnderline
                lf.lfWeight = lfc.lfWeight
                lf.lfWidth = lfc.lfWidth
                MAPI.ImmSetCompositionFont(h, lf)
                MAPI.ImmAssociateContext(control.Handle, h)
            Finally
                MAPI.ImmReleaseContext(Me.Handle, h)
            End Try
        End If
    End Sub

End Class
