﻿' table/FieldProvider/ConstFieldProvider.vb
'
' Copyright (c) 2008-2009, SystemBase Co.,Ltd.
' All rights reserved.
'
' Redistribution and use in source and binary forms, with or without
' modification, are permitted provided that the following conditions are met:
'
'    1. Redistributions of source code must retain the above copyright
'       notice, this list of conditions and the following disclaimer.
'    2. Redistributions in binary form must reproduce the above copyright
'       notice, this list of conditions and the following disclaimer in the
'       documentation and/or other materials provided with the distribution.
'
' THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
' IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
' ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
' LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
' CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
' SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
' INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
' CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
' ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
' POSSIBILITY OF SUCH DAMAGE.

Public Class CConstFieldProvider
    Inherits CFieldProvider

    Public Value As Object

    Public Sub New(ByVal value As String)
        Me.New(Nothing, value)
    End Sub

    Public Sub New(ByVal caption As String, ByVal value As Object)
        MyBase.New(caption)
        Me.Value = value
    End Sub

    Public Overrides Function UndoEnabled() As Boolean
        Return False
    End Function

    Public Overrides Function CreateField() As UTable.CField
        Return New CConstField()
    End Function

    Public Class CConstField
        Inherits UTable.CField
        Public Overrides Property Value() As Object
            Get
                Return CType(Me.Desc.Provider, CConstFieldProvider).Value
            End Get
            Set(ByVal value As Object)
            End Set
        End Property
        Public Overrides Sub Clear()
        End Sub
    End Class

End Class