﻿' table/FieldProvider/ButtonFieldProvider.vb
'
' Copyright (c) 2008-2009, SystemBase Co.,Ltd.
' All rights reserved.
'
' Redistribution and use in source and binary forms, with or without
' modification, are permitted provided that the following conditions are met:
'
'    1. Redistributions of source code must retain the above copyright
'       notice, this list of conditions and the following disclaimer.
'    2. Redistributions in binary form must reproduce the above copyright
'       notice, this list of conditions and the following disclaimer in the
'       documentation and/or other materials provided with the distribution.
'
' THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
' IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
' ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
' LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
' CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
' SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
' INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
' CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
' ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
' POSSIBILITY OF SUCH DAMAGE.

Imports System.Drawing

Public Class CButtonFieldProvider
    Inherits CFieldProvider

    Public DefaultValue As Object

    Public Sub New()
        Me.New(Nothing, Nothing)
    End Sub

    Public Sub New(ByVal defaultValue As Object)
        Me.New(Nothing, defaultValue)
    End Sub

    Public Sub New(ByVal caption As String, ByVal defaultValue As Object)
        MyBase.New(caption)
        Me.DefaultValue = defaultValue
    End Sub

    Public Overrides Function CreateField() As UTable.CField
        Return New CButtonField()
    End Function

    Public Overrides Sub FieldInitialize(ByVal field As UTable.CField)
        field.Value = Me.DefaultValue
    End Sub

    Public Overrides Function Setting() As UTable.CSetting
        Dim s As New UTable.CSetting
        s.HorizontalAlignment = UTable.EHAlign.MIDDLE
        Return s
    End Function

    Protected Overrides Sub renderForeGround(ByVal g As Graphics, ByVal field As UTable.CField, ByVal s As UTable.CDynamicSetting, ByVal rect As System.Drawing.Rectangle, ByVal alter As Boolean)
        renderButton(g, CType(field, CButtonField).Down, Me.formatValue(field.Value), s, rect)
    End Sub

    Public Overrides Function UndoEnabled() As Boolean
        Return False
    End Function

    Public Overrides Function GetAdjustSize(ByVal g As Graphics, ByVal field As UTable.CField) As Size
        With MyBase.GetAdjustSize(g, field)
            Return New Size(.Width + 6, .Height)
        End With
    End Function

    Public Overrides Property Clipboard(ByVal field As UTable.CField) As String
        Get
            Return ""
        End Get
        Set(ByVal value As String)
        End Set
    End Property

    Public Class CButtonField
        Inherits UTable.CField
        Public Down As Boolean = False
        Private Sub CButtonField_Leave(ByVal field As UTable.CField) Handles Me.Leave
            Me.Down = False
        End Sub
        Private Sub CButtonField_KeyDown(ByVal field As UTable.CField, ByVal e As System.Windows.Forms.KeyEventArgs) Handles Me.KeyDown
            If e.KeyCode = Keys.Space AndAlso Me.DynamicSetting.Editable = UTable.EAllow.ALLOW Then
                Me.Down = True
                Me.Table.Render()
            End If
        End Sub
        Private Sub CButtonField_KeyUp(ByVal field As UTable.CField, ByVal e As System.Windows.Forms.KeyEventArgs) Handles Me.KeyUp
            If e.KeyCode = Keys.Space AndAlso Me.Down Then
                Me.Down = False
                Me.Table.Render()
                Me.Table.raiseFieldButtonClick(Me)
            End If
        End Sub
        Private Sub CButtonField_MouseDown(ByVal field As UTable.CField, ByVal location As Point, ByVal e As System.Windows.Forms.MouseEventArgs) Handles Me.MouseDown
            If e.Button = MouseButtons.Left AndAlso Me.DynamicSetting.Editable = UTable.EAllow.ALLOW Then
                Me.Down = True
                Me.Table.Render()
            End If
        End Sub
        Private Sub CButtonField_MouseUp(ByVal field As UTable.CField, ByVal location As Point, ByVal e As System.Windows.Forms.MouseEventArgs) Handles Me.MouseUp
            If Me.Down Then
                Me.Down = False
                Me.Table.Render()
                If location.X >= 0 And location.Y >= 0 Then
                    Me.Table.raiseFieldButtonClick(Me)
                End If
            End If
        End Sub
        Public Overrides Sub Clear()
        End Sub
    End Class

End Class
