' table/Render.vb
'
' Copyright (c) 2008-2009, SystemBase Co.,Ltd.
' All rights reserved.
'
' Redistribution and use in source and binary forms, with or without
' modification, are permitted provided that the following conditions are met:
'
'    1. Redistributions of source code must retain the above copyright
'       notice, this list of conditions and the following disclaimer.
'    2. Redistributions in binary form must reproduce the above copyright
'       notice, this list of conditions and the following disclaimer in the
'       documentation and/or other materials provided with the distribution.
'
' THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
' IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
' ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
' LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
' CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
' SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
' INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
' CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
' ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
' POSSIBILITY OF SUCH DAMAGE.

Imports System.Drawing

Partial Class UTable

    Public Class CRenderCache
        Public Class CCol
            Public [From] As Integer
            Public [To] As Integer
            Public Appeared As Boolean
        End Class
        Public Class CField
            Public Rect As Rectangle
            Public Field As UTable.CField
        End Class
        Public FocusField As CField
        Public Cols As New List(Of CCol)
        Public Fields As New List(Of CField)
        Public Function FindField(ByVal location As Point) As UTable.CRenderCache.CField
            Dim t As CField = Nothing
            For Each f As CField In Me.Fields
                If f.Rect.Contains(location) Then
                    If f.Field.Content Is f.Field.Table.HeaderContent Or _
                       f.Field.Content Is f.Field.Table.FooterContent Then
                        Return f
                    Else
                        t = f
                    End If
                End If
            Next
            Return t
        End Function
        Public Function FindField(ByVal field As UTable.CField) As UTable.CRenderCache.CField
            For Each f As CField In Me.Fields
                If f.Field Is field Then
                    Return f
                End If
            Next
            Return Nothing
        End Function
    End Class

    Protected _RenderBlock As CRenderBlock = Nothing

    Public Sub UpdateLayout()
        RaiseEvent LayoutUpdating(Me)
        Me.updateScrollBars(Me.updateLayoutCaches)
    End Sub

    Private render_flg As Boolean = False
    Public Sub Render()
        If Me.render_flg Then
            Exit Sub
        End If

        Try
            Me.render_flg = True

            If Me.BackBuffer Is Nothing Then
                Exit Sub
            End If

            Me.UpdateLayout()

            Me.BackBuffer.Graphics.ResetClip()
            Using brush As New SolidBrush(Me.Setting.ContentBackColor)
                Me.BackBuffer.Graphics.FillRectangle(brush, Me.ClientRectangle)
            End Using

            Dim top_row As Integer = Me.HeaderContent.LayoutCache.RowsSize - Me.VScrollBar.Value

            Me.updateRenderCache(-Me.HScrollBar.Value)

            Me.BackBuffer.Graphics.Clip = New System.Drawing.Region( _
                                           New Rectangle(Me.LayoutCache.FixedColsSize, _
                                                         Me.HeaderContent.LayoutCache.RowsSize, _
                                                         Me.Width - Me.LayoutCache.FixedColsSize, _
                                                         Me.Height - (Me.HeaderContent.LayoutCache.RowsSize + Me.FooterContent.LayoutCache.RowsSize)))
            Me.Content.render(Me.BackBuffer.Graphics, top_row, -Me.HScrollBar.Value, Me.Height, False)
            Me.RenderContent()

            Me.BackBuffer.Graphics.ResetClip()
            Me.Content.render(Me.BackBuffer.Graphics, top_row, 0, Me.Height, True)
            Me.RenderFixedContent()

            Using brush As New SolidBrush(Me.Setting.HeaderContentBackColor)
                Me.BackBuffer.Graphics.FillRectangle(brush, New Rectangle(0, 0, Me.Width, Me.HeaderContent.LayoutCache.RowsSize + 1))
            End Using
            Me.BackBuffer.Graphics.Clip = New System.Drawing.Region( _
                                           New Rectangle(Me.LayoutCache.FixedColsSize, _
                                                         0, _
                                                         Me.Width - Me.LayoutCache.FixedColsSize, _
                                                         Me.HeaderContent.LayoutCache.RowsSize + 1))
            Me.HeaderContent.render(Me.BackBuffer.Graphics, 0, -Me.HScrollBar.Value, Me.Height, False)
            Me.RenderHeaderContent()

            Me.BackBuffer.Graphics.ResetClip()
            Me.HeaderContent.render(Me.BackBuffer.Graphics, 0, 0, Me.Height, True)
            Me.RenderFixedHeaderContent()

            Dim footer_top As Integer = Me.Height - (Me.FooterContent.LayoutCache.RowsSize)
            If Me.HScrollBar.Visible Then
                footer_top -= Me.HScrollBar.Height
            End If
            Using brush As New SolidBrush(Me.Setting.FooterContentBackColor)
                Me.BackBuffer.Graphics.FillRectangle(brush, New Rectangle(0, footer_top, Me.Width, Me.FooterContent.LayoutCache.RowsSize + 1))
            End Using
            Me.BackBuffer.Graphics.Clip = New System.Drawing.Region( _
                                           New Rectangle(Me.LayoutCache.FixedColsSize, _
                                                         footer_top, _
                                                         Me.Width - Me.LayoutCache.FixedColsSize, _
                                                         Me.FooterContent.LayoutCache.RowsSize + 1))
            Me.FooterContent.render(Me.BackBuffer.Graphics, footer_top, -Me.HScrollBar.Value, Me.Height, False)
            Me.RenderFooterContent()

            Me.BackBuffer.Graphics.ResetClip()
            Me.FooterContent.render(Me.BackBuffer.Graphics, footer_top, 0, Me.Height, True)
            Me.RenderFixedFooterContent()

            If Me.FixedCols > 0 AndAlso Not Me.Setting.FixedColBorderColor.Equals(Color.Transparent) Then
                Using pen As New Pen(Me.Setting.FixedColBorderColor)
                    pen.DashStyle = Me.Setting.FixedColBorderStyle
                    Me.BackBuffer.Graphics.DrawLine(pen, Me.LayoutCache.FixedColsSize, 0, _
                                                         Me.LayoutCache.FixedColsSize, Me.Height)
                End Using
            End If

            If Me.resizing IsNot Nothing Then
                Me.BackBuffer.Graphics.ResetClip()
                Using brush As New SolidBrush(Me.Setting.ResizingLineColor)
                    With Me.resizing
                        Me.BackBuffer.Graphics.FillRectangle(brush, Me.RenderCache.Cols(.Col).From + .Size - 1, 0, 2, Me.Height)
                    End With
                End Using
            End If

            Me.RenderFin()

            Me.Refresh()

        Finally
            Me.render_flg = False
        End Try
    End Sub

    Protected Overridable Sub RenderContent()
    End Sub

    Protected Overridable Sub RenderFixedContent()
    End Sub

    Protected Overridable Sub RenderHeaderContent()
    End Sub

    Protected Overridable Sub RenderFixedHeaderContent()
    End Sub

    Protected Overridable Sub RenderFooterContent()
    End Sub

    Protected Overridable Sub RenderFixedFooterContent()
    End Sub

    Protected Overridable Sub RenderFin()
    End Sub

    Private Function updateLayoutCaches() As Boolean
        Dim ret As Boolean = False

        If Me.LayoutCacheInvalid Then
            Me.updateLayoutCache()
            Me.LayoutCacheInvalid = False
            ret = True
        End If

        If Me.HeaderContent.LayoutCacheInvalid Then
            Me.HeaderContent.updateLayoutCache()
            Me.HeaderContent.LayoutCacheInvalid = False
            ret = True
        End If

        If Me.FooterContent.LayoutCacheInvalid Then
            Me.FooterContent.updateLayoutCache()
            Me.FooterContent.LayoutCacheInvalid = False
            ret = True
        End If

        If Me.Content.LayoutCacheInvalid Then
            Me.Content.updateLayoutCache()
            Me.Content.LayoutCacheInvalid = False
            ret = True
        End If

        If ret Then
            Me.SelectRange = Nothing
        End If

        Return ret
    End Function

    Private Sub updateRenderCache(ByVal top_col As Integer)
        Dim from As Integer = 0
        Me.RenderCache.FocusField = Nothing
        Me.RenderCache.Cols.Clear()
        Me.RenderCache.Fields.Clear()

        For i As Integer = 0 To Me.FixedCols - 1
            Dim c As New CRenderCache.CCol
            c.From = from
            c.To = c.From + Me.Cols.GetSize(i, 1)
            c.Appeared = Me.Cols(i).Visible
            Me.RenderCache.Cols.Add(c)
            from = c.To
        Next

        from += top_col

        For i As Integer = Me.FixedCols To Me.Cols.Count - 1
            Dim c As New CRenderCache.CCol
            c.From = from
            c.To = c.From + Me.Cols.GetSize(i, 1)
            If Me.Cols(i).Visible And Me.LayoutCache.FixedColsSize < c.To Then
                c.Appeared = True
            Else
                c.Appeared = False
            End If
            Me.RenderCache.Cols.Add(c)
            from = c.To
        Next
    End Sub

    Private Sub UTable_Resize(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Resize
        Dim context As BufferedGraphicsContext = BufferedGraphicsManager.Current
        Try
            Using Me.RenderBlock
                Me.FinishEdit()
                Me.BackBuffer = context.Allocate(Me.CreateGraphics, Me.ClientRectangle)
                Me.LayoutCacheInvalid = True
            End Using
        Catch ex As Exception
        End Try
    End Sub

    Private Sub UTable_Paint(ByVal sender As Object, ByVal e As System.Windows.Forms.PaintEventArgs) Handles Me.Paint
        If Not Me.DesignMode And Me.BackBuffer IsNot Nothing Then
            Me.BackBuffer.Render(e.Graphics)
        End If
    End Sub

    Public Class CRenderBlock
        Implements IDisposable

        Public table As UTable

        Public Sub New(ByVal table As UTable)
            Me.table = table            
        End Sub

        Private disposedValue As Boolean = False
        Protected Overridable Sub Dispose(ByVal disposing As Boolean)
            If Not Me.disposedValue Then
                Me.table._RenderBlock = Nothing
                Me.table.Render()
            End If
            Me.disposedValue = True
        End Sub

#Region " IDisposable Support "
        ' ̃R[h́Aj\ȃp^[𐳂ł悤 Visual Basic ɂĒǉ܂B
        Public Sub Dispose() Implements IDisposable.Dispose
            ' ̃R[hύXȂłBN[Abv R[h Dispose(ByVal disposing As Boolean) ɋLq܂B
            Dispose(True)
            GC.SuppressFinalize(Me)
        End Sub
#End Region

    End Class

    Public Function RenderBlock() As CRenderBlock
        If Me._RenderBlock Is Nothing Then
            Dim ret As CRenderBlock = Me.createRenderBlock
            Me._RenderBlock = ret
            Return ret
        Else
            Return Nothing
        End If
    End Function

    Protected Overridable Function createRenderBlock() As CRenderBlock
        Return New CRenderBlock(Me)
    End Function

End Class