﻿' table/Border.vb
'
' Copyright (c) 2008-2009, SystemBase Co.,Ltd.
' All rights reserved.
'
' Redistribution and use in source and binary forms, with or without 
' modification, are permitted provided that the following conditions are met:
'
'    1. Redistributions of source code must retain the above copyright
'       notice, this list of conditions and the following disclaimer.
'    2. Redistributions in binary form must reproduce the above copyright
'       notice, this list of conditions and the following disclaimer in the
'       documentation and/or other materials provided with the distribution.
'
' THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
' IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
' ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
' LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
' CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
' SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
' INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
' CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
' ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
' POSSIBILITY OF SUCH DAMAGE.

Imports System.Drawing

Partial Class UTable

    Public Class CBorder
        Public VisibleCols As New List(Of Integer)
        Public VisibleRows As New List(Of Integer)
        Public VisibleColsMap As New List(Of Integer)
        Public VisibleRowsMap As New List(Of Integer)
        Public VerticalMap As New List(Of Integer)
        Public HorizontalMap As New List(Of Integer)
        Public Vertical As New List(Of List(Of EBorderType))
        Public Horizontal As New List(Of List(Of EBorderType))
        Public RowCount As Integer

        Public Const _T As Integer = 1
        Public Const _B As Integer = 2
        Public Const _L As Integer = 4
        Public Const _R As Integer = 8

        Public Enum EBorderType
            [DEFAULT]
            FIELD
            RECORD
            CAPTION
            NONE
        End Enum

        Public Sub New(ByVal record As CRecord, ByVal previousBorder As CBorder)
            If record.Table.Cols.Count > 0 Then
                Dim i As Integer = 0
                Dim colIndex As Integer = -1
                Dim verticalIndex As Integer = -1
                For Each g As CGrid In record.Table.Cols
                    If verticalIndex = -1 And g.Visible Then
                        verticalIndex = 0
                    End If
                    Me.VerticalMap.Add(verticalIndex)
                    If g.Visible Then
                        colIndex += 1
                        verticalIndex += 1
                        Me.VisibleCols.Add(i)
                    End If
                    Me.VisibleColsMap.Add(colIndex)
                    i += 1
                Next
                Me.VerticalMap.Add(verticalIndex)
            End If
            If record.Rows.Count > 0 Then
                Dim i As Integer = 0
                Dim rowIndex As Integer = -1
                Dim horizontalIndex As Integer = -1
                For Each g As CGrid In record.Rows
                    If horizontalIndex = -1 And g.Visible Then
                        horizontalIndex = 0
                    End If
                    Me.HorizontalMap.Add(horizontalIndex)
                    If g.Visible Then
                        rowIndex += 1
                        horizontalIndex += 1
                        Me.VisibleRows.Add(i)
                    End If
                    Me.VisibleRowsMap.Add(rowIndex)
                    i += 1
                Next
                Me.HorizontalMap.Add(horizontalIndex)
            End If
            Me.RowCount = record.Rows.Count
            For i = 0 To Me.VisibleRows.Count - 1
                Dim l As New List(Of EBorderType)
                For j = 0 To Me.VisibleCols.Count
                    l.Add(EBorderType.DEFAULT)
                Next
                Me.Vertical.Add(l)
            Next
            For i = 0 To Me.VisibleRows.Count
                Dim l As New List(Of EBorderType)
                For j = 0 To Me.VisibleCols.Count - 1
                    l.Add(EBorderType.DEFAULT)
                Next
                Me.Horizontal.Add(l)
            Next
            For i = 0 To Me.VisibleCols.Count - 1
                If previousBorder IsNot Nothing AndAlso _
                   previousBorder.Horizontal(previousBorder.RowCount)(i) > EBorderType.RECORD Then
                    Me.Horizontal(0)(i) = previousBorder.Horizontal(previousBorder.RowCount)(i)
                Else
                    Me.Horizontal(0)(i) = EBorderType.RECORD
                End If
                Me.Horizontal(Me.Horizontal.Count - 1)(i) = EBorderType.RECORD
            Next
        End Sub

        Public Sub SetVertical(ByVal row As Integer, ByVal col As Integer, ByVal type As EBorderType)
            Dim r As Integer = Me.VisibleRowsMap(row)
            Dim c As Integer = Me.VerticalMap(col)
            If r >= 0 AndAlso c >= 0 AndAlso Me.Vertical(r)(c) < type Then
                Me.Vertical(r)(c) = type
            End If
        End Sub

        Public Sub SetHorizontal(ByVal row As Integer, ByVal col As Integer, ByVal type As EBorderType)
            Dim r As Integer = Me.HorizontalMap(row)
            Dim c As Integer = Me.VisibleColsMap(col)
            If r >= 0 AndAlso c >= 0 AndAlso Me.Horizontal(r)(c) < type Then
                Me.Horizontal(r)(c) = type
            End If
        End Sub

        Public Sub Fill(ByVal layout As CGrid.CRegion, ByVal type As EBorderType, ByVal borderLine As Integer)
            Dim t As EBorderType
            If borderLine And _T Then
                t = type
            Else
                t = EBorderType.NONE
            End If
            For c As Integer = 0 To layout.Cols - 1
                Me.SetHorizontal(layout.Row, layout.Col + c, t)
            Next
            If borderLine And _B Then
                t = type
            Else
                t = EBorderType.NONE
            End If
            For c As Integer = 0 To layout.Cols - 1
                Me.SetHorizontal(layout.Row + layout.Rows, layout.Col + c, t)
            Next
            If borderLine And _L Then
                t = type
            Else
                t = EBorderType.NONE
            End If
            For r As Integer = 0 To layout.Rows - 1
                Me.SetVertical(layout.Row + r, layout.Col, t)
            Next
            If borderLine And _R Then
                t = type
            Else
                t = EBorderType.NONE
            End If
            For r As Integer = 0 To layout.Rows - 1
                Me.SetVertical(layout.Row + r, layout.Col + layout.Cols, t)
            Next
        End Sub

        Public Sub Render(ByVal record As CRecord, _
                          ByVal g As Graphics, _
                          ByVal top_row As Integer, _
                          ByVal top_col As Integer, _
                          ByVal fixed As Boolean)
            Dim pens As New Dictionary(Of EBorderType, Pen)
            Try
                With record.Table.Setting
                    If .BorderColor <> Color.Transparent Then
                        Dim p As New Pen(.BorderColor)
                        p.DashStyle = .BorderStyle
                        pens.Add(EBorderType.FIELD, p)
                    End If
                    If .CaptionBorderColor <> Color.Transparent Then
                        Dim p As New Pen(.CaptionBorderColor)
                        p.DashStyle = .CaptionBorderStyle
                        pens.Add(EBorderType.CAPTION, p)
                    End If
                    If .RecordBorderColor <> Color.Transparent Then
                        Dim p As New Pen(.RecordBorderColor)
                        p.DashStyle = .RecordBorderStyle
                        pens.Add(EBorderType.RECORD, p)
                    End If
                End With
                Dim x As Integer
                Dim y As Integer
                x = top_col
                For i As Integer = 0 To Me.VisibleCols.Count
                    If fixed AndAlso _
                       i < Me.VisibleCols.Count AndAlso _
                       Me.VisibleCols(i) > record.Table.FixedCols Then
                        Exit For
                    End If
                    y = top_row + record.LayoutCache.Top
                    For j As Integer = 0 To Me.VisibleRows.Count - 1
                        Dim t As EBorderType = Me.Vertical(j)(i)
                        Dim y2 As Integer = y + record.Rows(Me.VisibleRows(j)).Size
                        If pens.ContainsKey(t) Then
                            g.DrawLine(pens(t), x, y, x, y2)
                        End If
                        y = y2
                    Next
                    If i < Me.VisibleCols.Count Then
                        x += record.Table.Cols(Me.VisibleCols(i)).Size
                    End If
                Next
                y = top_row + record.LayoutCache.Top
                For i As Integer = 0 To Me.VisibleRows.Count
                    x = top_col
                    For j As Integer = 0 To Me.VisibleCols.Count - 1
                        If fixed AndAlso _
                           Me.VisibleCols(j) >= record.Table.FixedCols Then
                            Exit For
                        End If
                        Dim t As EBorderType = Me.Horizontal(i)(j)
                        Dim x2 As Integer = x + record.Table.Cols(Me.VisibleCols(j)).Size
                        If pens.ContainsKey(t) Then
                            g.DrawLine(pens(t), x, y, x2, y)
                        End If
                        x = x2
                    Next
                    If i < Me.VisibleRows.Count Then
                        y += record.Rows(Me.VisibleRows(i)).Size
                    End If
                Next
            Finally
                For Each p As Pen In pens.Values
                    p.Dispose()
                Next
            End Try
        End Sub

    End Class

End Class