' table/Table.vb
'
' Copyright (c) 2008-2009, SystemBase Co.,Ltd.
' All rights reserved.
'
' Redistribution and use in source and binary forms, with or without
' modification, are permitted provided that the following conditions are met:
'
'    1. Redistributions of source code must retain the above copyright
'       notice, this list of conditions and the following disclaimer.
'    2. Redistributions in binary form must reproduce the above copyright
'       notice, this list of conditions and the following disclaimer in the
'       documentation and/or other materials provided with the distribution.
'
' THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
' IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
' ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
' LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
' CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
' SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
' INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
' CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
' ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
' POSSIBILITY OF SUCH DAMAGE.

Imports System.Drawing

Public Class UTable
    Inherits ContainerControl

    Public Class CSortState
        Public Enum EOrder
            ASCEND
            DESCEND
        End Enum
        Public Field As CField = Nothing
        Public Order As EOrder = EOrder.ASCEND
    End Class

    Public Class CLayoutCache
        Public ColsSize As Integer
        Public FixedColsSize As Integer
        Public VisibleCols As List(Of CGrid)
        Public VisibleColsPos As List(Of Integer)
        Public VisibleColsRev As List(Of Integer)
    End Class

    Public Class CAutoExtend
        Public Row As Boolean
        Public Col As Boolean
    End Class

    Public Event RecordAdded(ByVal record As CRecord)
    Public Event RecordMoved(ByVal record As CRecord)
    Public Event RecordRemoved(ByVal record As CRecord)
    Public Event RecordEnter(ByVal record As CRecord)
    Public Event FieldValidating(ByVal field As CField, ByVal e As System.ComponentModel.CancelEventArgs)
    Public Event FieldValidated(ByVal field As CField)
    Public Event FieldValueChanged(ByVal field As CField)
    Public Event FieldEntering(ByVal field As CField, ByRef cancel As Boolean)
    Public Event FieldEnter(ByVal field As CField)
    Public Event FieldLeave(ByVal field As CField)
    Public Event FieldMouseDown(ByVal field As CField, ByVal location As Point, ByVal e As System.Windows.Forms.MouseEventArgs)
    Public Event FieldMouseUp(ByVal field As CField, ByVal location As Point, ByVal e As System.Windows.Forms.MouseEventArgs)
    Public Event FieldMouseMove(ByVal field As CField, ByVal location As Point, ByVal e As System.Windows.Forms.MouseEventArgs)
    Public Event FieldClick(ByVal field As CField, ByVal location As Point, ByVal e As System.Windows.Forms.MouseEventArgs)
    Public Event FieldDoubleClick(ByVal field As CField, ByVal location As Point, ByVal e As System.Windows.Forms.MouseEventArgs)
    Public Event FieldKeyDown(ByVal field As CField, ByVal e As System.Windows.Forms.KeyEventArgs)
    Public Event FieldKeyPress(ByVal field As CField, ByVal e As System.Windows.Forms.KeyPressEventArgs)
    Public Event FieldKeyUp(ByVal field As CField, ByVal e As System.Windows.Forms.KeyEventArgs)
    Public Event FieldSelected(ByVal field As CField, ByRef handled As Boolean)
    Public Event FieldButtonClick(ByVal field As CField)
    Public Event ContentValidated(ByVal content As CContent, ByVal key As Object)
    Public Event EditStarting(ByVal field As CField, ByRef editable As EAllow)
    Public Event EditStart(ByVal field As CField, ByRef editor As IEditor)
    Public Event EditFinished(ByVal field As CField)
    Public Event EditorValueChanged(ByVal field As CField)
    Public Event Sorted(ByVal content As CContent, ByVal key As Object)
    Public Event InitializeEditor(ByVal field As CField, ByVal editor As IEditor)
    Public Event LayoutUpdating(ByVal table As UTable)
    Public Event DecideScrollRect(ByVal field As CField, ByRef rect As Rectangle)
    Public Event FocusNextField(ByVal field As CField, ByVal forward As Boolean, ByRef handled As Boolean)
    Public Event FocusNextControl(ByVal field As CField, ByVal forward As Boolean, ByRef handled As Boolean)
    Public Event CreatingCaption(ByVal key As Object, ByVal captionDesc As CRecordProvider.CFieldDesc, ByRef cancel As Boolean)
    Public Event DraggingOverflow(ByVal table As UTable, ByVal dx As Integer, ByVal dy As Integer)

    Public Cols As CGrids
    Public HeaderContent As CContent
    Public FooterContent As CContent
    Public Content As CContent
    Public Setting As New CGlobalSetting
    Public DefaultGridSize As New CGrid.CSize
    Public LayoutCacheInvalid As Boolean = False
    Public LayoutCache As CLayoutCache
    Public RenderCache As CRenderCache
    Public BackBuffer As BufferedGraphics = Nothing
    Public AutoExtend As New CAutoExtend
    Public KeyboardOperation As CKeyboardOperation
    Public WithEvents VScrollBar As ScrollBar = New CVScrollBar
    Public WithEvents HScrollBar As ScrollBar = New CHScrollBar
    Public SortState As New CSortState
    Public Comparer As CComparer = New CComparer
    Public FocusFieldDecorator As IFieldDecorator = New CFocusDecorator
    Public StrictMouseLocation As Boolean = True

    Private _FixedCols As Integer = 0
    Private _NotSelectableCols As Integer = 0
    Private scrollPlaceHolderPanel As New Panel

    Public Sub New()
        Me.New(New CKeyboardOperation)
    End Sub

    Public Sub New(ByVal keyboardOperation As CKeyboardOperation)
        Me.ResetAll()
        Me.DefaultGridSize.Row = 20
        Me.DefaultGridSize.Col = 100
        Me.AutoExtend.Row = False
        Me.AutoExtend.Col = False
        Me.BackColor = Color.Black
        Me.KeyboardOperation = keyboardOperation
        Me.VScrollBar.TabStop = False
        Me.HScrollBar.TabStop = False
        Me.scrollPlaceHolderPanel.Visible = False
        Me.Controls.Add(Me.VScrollBar)
        Me.Controls.Add(Me.HScrollBar)
        Me.Controls.Add(Me.scrollPlaceHolderPanel)
        Me.DoubleBuffered = True
        Me.Setting.EnterContent = Me.Content
        Me.draggingOverflowTimer = New CDraggingOverflowTimer(Me)
    End Sub

    Private Sub UTable_Disposed(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Disposed
        Me.ime_ReleaseContext()
    End Sub

    Public Sub ResetAll()
        Using Me.RenderBlock
            Me.FixedCols = 0
            Me.HeaderContent = New CContent
            Me.HeaderContent.Table = Me
            Me.FooterContent = New CContent
            Me.FooterContent.Table = Me
            Me.Content = New CContent
            Me.Content.Table = Me
            Me.Cols = New CGrids
            Me.LayoutCache = New CLayoutCache
            Me.RenderCache = New CRenderCache
            Me.VScrollBar.Visible = False
            Me.HScrollBar.Visible = False
        End Using
    End Sub

    Private Sub updateLayoutCache()
        Me.LayoutCache.ColsSize = 0
        Me.LayoutCache.FixedColsSize = 0
        Me.LayoutCache.VisibleCols = New List(Of CGrid)
        Me.LayoutCache.VisibleColsPos = New List(Of Integer)
        Me.LayoutCache.VisibleColsRev = New List(Of Integer)
        Dim w As Integer = 0
        For i As Integer = 0 To Me.Cols.Count - 1
            If Me.Cols(i).Visible Then
                If i < Me.FixedCols Then
                    Me.LayoutCache.FixedColsSize += Me.Cols(i).Size
                End If
                w += Me.Cols(i).Size
                Me.LayoutCache.ColsSize += Me.Cols(i).Size
                If i >= Me.NotSelectableCols Then
                    Me.LayoutCache.VisibleCols.Add(Me.Cols(i))
                    Me.LayoutCache.VisibleColsPos.Add(w)
                End If
            End If
            Me.LayoutCache.VisibleColsRev.Add(Me.LayoutCache.VisibleCols.Count - 1)
        Next
    End Sub

    Public Sub CreateCaption()
        Me.CreateCaption(EHAlign.DEFAULT)
    End Sub

    Public Sub CreateCaption(ByVal halign As EHAlign)
        Dim rpList As New List(Of CRecordProvider)
        Dim recordProvider As CRecordProvider = Me.Content.RecordProvider
        Do While recordProvider IsNot Nothing
            rpList.Add(recordProvider)
            recordProvider = recordProvider.ChildRecordProvider
        Loop
        Me.CreateCaption(halign, rpList.ToArray)
    End Sub

    Public Sub CreateCaption(ByVal halign As EHAlign, ByVal ParamArray recordProviders() As CRecordProvider)
        Using Me.RenderBlock
            Dim c As CContent = Me.HeaderContent
            For i As Integer = 0 To recordProviders.Length - 1
                Me.createCaption_aux(c, recordProviders(i), halign)
                c = c.Records(0).CreateChild
            Next
            Me.HeaderContent.LayoutCacheInvalid = True
        End Using
    End Sub

    Private Sub createCaption_aux(ByVal caption_content As CContent, ByVal recordProvider As CRecordProvider, ByVal halign As EHAlign)
        Dim record As CRecord = caption_content.AddRecord()
        For Each key As Object In recordProvider.FieldDescs.Keys
            If recordProvider.FieldDescs(key).CreateCaption Then
                Dim f As CRecordProvider.CFieldDesc
                Dim l As CGrid.CRegion
                If recordProvider.FieldDescs(key).MergeCaption Is Nothing Then
                    l = recordProvider.Layout(key)
                Else
                    l = recordProvider.Layout(key, recordProvider.FieldDescs(key).MergeCaption)
                End If
                If l IsNot Nothing Then
                    l = l.Clone
                End If
                f = New CRecordProvider.CFieldDesc(New CCaptionFieldProvider(recordProvider.FieldDescs(key)), l)
                If Not halign = EHAlign.DEFAULT Then
                    f.Setting.HorizontalAlignment = halign
                End If
                Dim cancel As Boolean = False
                RaiseEvent CreatingCaption(key, f, cancel)
                If Not cancel Then
                    record.AddField(CaptionKey(key), f)
                End If
            End If
        Next
    End Sub

    Public Shared Function CaptionKey(ByVal key As Object)
        Return New CCaptionKey(key)
    End Function

    Public Class CCaptionKey
        Public key As Object
        Public Sub New(ByVal key)
            Me.key = key
        End Sub
        Public Overrides Function Equals(ByVal obj As Object) As Boolean
            If obj Is Me Then
                Return True
            ElseIf Not TypeOf obj Is CCaptionKey Then
                Return False
            Else
                Return Me.key.Equals(CType(obj, CCaptionKey).key)
            End If
        End Function
        Public Overrides Function GetHashCode() As Integer
            Return Me.key.GetHashCode
        End Function
    End Class

    Public Sub Clear()
        Me.Clear(True)
    End Sub

    Public Sub Clear(ByVal recursive As Boolean)
        Using Me.RenderBlock
            Me.HeaderContent.Clear(recursive)
            Me.Content.Clear(recursive)
            Me.FooterContent.Clear(recursive)
        End Using
    End Sub

    Public Function CaptionRecord() As CRecord
        If Me.HeaderContent.Records.Count = 0 Then
            Me.HeaderContent.AddRecord()
        End If
        Return Me.HeaderContent.Records(0)
    End Function

    Public Sub RaiseFieldSelected(ByVal field As CField, Optional ByRef handled As Boolean = False)
        field.raiseSelected(handled)
        RaiseEvent FieldSelected(field, handled)
    End Sub

    Friend Sub raiseFieldValidating(ByVal field As CField, ByVal e As System.ComponentModel.CancelEventArgs)
        field.raiseValidating(e)
        RaiseEvent FieldValidating(field, e)
    End Sub

    Friend Sub raiseFieldValidated(ByVal field As CField)
        field.raiseValidated()
        RaiseEvent FieldValidated(field)
        If Me._EditBlock IsNot Nothing Then
            Me._EditBlock.Regist(field)
        Else
            Me.raiseContentValidated(field.Content, field.Key)
        End If
    End Sub

    Friend Sub raiseFieldValueChanged(ByVal field As CField)
        field.raiseValueChanged()
        RaiseEvent FieldValueChanged(field)
    End Sub

    Friend Sub raiseEditorValueChanged(ByVal field As CField)
        field.raiseEditorValueChanged()
        RaiseEvent EditorValueChanged(field)
    End Sub

    Friend Sub raiseFieldButtonClick(ByVal field As CField)
        RaiseEvent FieldButtonClick(field)
    End Sub

    Friend Sub raiseSorted(ByVal content As CContent, ByVal key As Object)
        RaiseEvent Sorted(content, key)
    End Sub

    Friend Sub raiseRecordAdded(ByVal record As CRecord)
        RaiseEvent RecordAdded(record)
    End Sub

    Friend Sub raiseRecordMoved(ByVal record As CRecord)
        RaiseEvent RecordMoved(record)
    End Sub

    Friend Sub raiseRecordRemoved(ByVal record As CRecord)
        RaiseEvent RecordRemoved(record)
    End Sub

    Friend Sub raiseFocusNextField(ByVal field As CField, ByVal forward As Boolean, ByRef handled As Boolean)
        RaiseEvent FocusNextField(field, forward, handled)
    End Sub

    Friend Sub raiseFocusNextControl(ByVal field As CField, ByVal forward As Boolean, ByRef handled As Boolean)
        RaiseEvent FocusNextControl(field, forward, handled)
    End Sub

    Friend Sub raiseContentValidated(ByVal content As CContent, ByVal key As Object)
        RaiseEvent ContentValidated(content, key)
    End Sub

    Protected _EditBlock As CEditBlock = Nothing
    Public Class CEditBlock
        Implements IDisposable

        Public Table As UTable
        Public Entry As New Dictionary(Of CContent, Dictionary(Of Object, Boolean))

        Public Sub New(ByVal table As UTable)
            Me.Table = table
        End Sub

        Public Sub Regist(ByVal field As CField)
            If Not Me.Entry.ContainsKey(field.Content) Then
                Me.Entry.Add(field.Content, New Dictionary(Of Object, Boolean))
            End If
            With Me.Entry(field.Content)
                If Not .ContainsKey(field.Key) Then
                    .Add(field.Key, True)
                End If
            End With
        End Sub

        Protected Overridable Sub onDispose()
        End Sub

        Private disposedValue As Boolean = False
        Protected Overridable Sub Dispose(ByVal disposing As Boolean)
            If Not Me.disposedValue Then
                Me.Table._EditBlock = Nothing
                For Each c As CContent In Me.Entry.Keys
                    For Each k As Object In Me.Entry(c).Keys
                        Me.Table.raiseContentValidated(c, k)
                    Next
                Next
                Me.onDispose()
            End If
            Me.disposedValue = True
        End Sub

#Region " IDisposable Support "
        ' ̃R[h́Aj\ȃp^[𐳂ł悤 Visual Basic ɂĒǉ܂B
        Public Sub Dispose() Implements IDisposable.Dispose
            ' ̃R[hύXȂłBN[Abv R[h Dispose(ByVal disposing As Boolean) ɋLq܂B
            Dispose(True)
            GC.SuppressFinalize(Me)
        End Sub
#End Region

    End Class

    Public Function EditBlock() As CEditBlock
        If Me._EditBlock Is Nothing Then
            Dim ret As CEditBlock = Me.createEditBlock
            Me._EditBlock = ret
            Return ret
        Else
            Return Nothing
        End If
    End Function

    Protected Overridable Function createEditBlock() As CEditBlock
        Return New CEditBlock(Me)
    End Function

End Class