' table/Scroll.vb
'
' Copyright (c) 2008-2009, SystemBase Co.,Ltd.
' All rights reserved.
'
' Redistribution and use in source and binary forms, with or without
' modification, are permitted provided that the following conditions are met:
'
'    1. Redistributions of source code must retain the above copyright
'       notice, this list of conditions and the following disclaimer.
'    2. Redistributions in binary form must reproduce the above copyright
'       notice, this list of conditions and the following disclaimer in the
'       documentation and/or other materials provided with the distribution.
'
' THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
' IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
' ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
' LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
' CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
' SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
' INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
' CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
' ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
' POSSIBILITY OF SUCH DAMAGE.

Imports System.Drawing

Partial Class UTable

    Public ScrollBarWidth As Integer = 16

    Private Sub updateScrollBars(ByVal needUpdate As Boolean)

        If needUpdate Then
            Dim m As Integer = 0
            Dim fixed_h As Integer = Me.HeaderContent.LayoutCache.RowsSize + Me.FooterContent.LayoutCache.RowsSize
            Me.showScrollBar(Me.VScrollBar, _
                             Me.Content.LayoutCache.RowsSize, _
                             Me.Height - fixed_h)
            If Me.VScrollBar.Visible Then
                m = ScrollBarWidth
            Else
                m = 0
            End If
            Me.showScrollBar(Me.HScrollBar, _
                             Me.LayoutCache.ColsSize, _
                             Me.Width - m)
            If Me.HScrollBar.Visible Then
                Me.showScrollBar(Me.VScrollBar, _
                                 Me.Content.LayoutCache.RowsSize, _
                                 Me.Height - fixed_h - ScrollBarWidth)
            End If
            If m = 0 And Me.VScrollBar.Visible Then
                Me.showScrollBar(Me.HScrollBar, _
                                 Me.LayoutCache.ColsSize, _
                                 Me.Width - ScrollBarWidth)
            End If
        End If

        Me._updateScrollbars()

    End Sub

    Private Sub UTable_VisibleChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.VisibleChanged
        Me.updateScrollBars(True)
    End Sub

    Private Sub _updateScrollbars()
        If Me.VScrollBar.Visible And Me.HScrollBar.Visible Then
            Me.VScrollBar.Size = New Size(ScrollBarWidth, Me.Height - ScrollBarWidth)
            Me.VScrollBar.Location = New Point(Me.Width - ScrollBarWidth, 0)
            Me.HScrollBar.Size = New Size(Me.Width - ScrollBarWidth, ScrollBarWidth)
            Me.HScrollBar.Location = New Point(0, Me.Height - ScrollBarWidth)
            Me.scrollPlaceHolderPanel.Size = New Size(ScrollBarWidth, ScrollBarWidth)
            Me.scrollPlaceHolderPanel.Location = New Point(Me.Width - ScrollBarWidth, Me.Height - ScrollBarWidth)
            Me.scrollPlaceHolderPanel.Visible = True
            Me.scrollPlaceHolderPanel.BackColor = SystemColors.Control
        ElseIf Me.VScrollBar.Visible Then
            Me.VScrollBar.Size = New Size(ScrollBarWidth, Me.Height)
            Me.VScrollBar.Location = New Point(Me.Width - ScrollBarWidth, 0)
            Me.scrollPlaceHolderPanel.Visible = False
        ElseIf Me.HScrollBar.Visible Then
            Me.HScrollBar.Size = New Size(Me.Width, ScrollBarWidth)
            Me.HScrollBar.Location = New Point(0, Me.Height - ScrollBarWidth)
            Me.scrollPlaceHolderPanel.Visible = False
        Else
            Me.scrollPlaceHolderPanel.Visible = False
        End If
    End Sub

    Private Sub showScrollBar(ByVal scrollBar As ScrollBar, ByVal entireSize As Integer, ByVal displaySize As Integer)
        If entireSize > displaySize And displaySize > 0 Then
            Dim v As Integer = 0
            With scrollBar
                If .Visible Then
                    v = .Value
                End If
                .Minimum = 0
                .Maximum = entireSize
                .LargeChange = displaySize
                .SmallChange = Me.DefaultGridSize.Row
                .Visible = True
                Me.setScrollValue(scrollBar, v)
            End With
        Else
            scrollBar.Value = scrollBar.Minimum
            scrollBar.Visible = False
        End If
    End Sub

    Private Sub VScrollBar_ValueChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles VScrollBar.ValueChanged
        If Me._RenderBlock Is Nothing Then
            Me.Render()
        End If
    End Sub

    Private Sub ScrollBar_MouseEnter(ByVal sender As Object, ByVal e As System.EventArgs) Handles HScrollBar.MouseEnter, VScrollBar.MouseEnter
        Me.Cursor = Cursors.Default
    End Sub

    Private Sub HScrollBar_ValueChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles HScrollBar.ValueChanged
        If Me._RenderBlock Is Nothing Then
            Me.Render()
        End If
    End Sub

    Private Sub UTable_MouseWheel(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles Me.MouseWheel
        If Me.VScrollBar.Visible And Me.VScrollBar.Enabled Then
            Me.wheelScroll(Me.VScrollBar, e.Delta)
        ElseIf Me.HScrollBar.Visible And Me.HScrollBar.Enabled Then
            Me.wheelScroll(Me.HScrollBar, e.Delta)
        End If
    End Sub

    Private Sub wheelScroll(ByVal scrollBar As ScrollBar, ByVal delta As Integer)
        Dim t As Integer = scrollBar.Value
        If delta > 0 Then
            t -= scrollBar.SmallChange
        Else
            t += scrollBar.SmallChange
        End If
        Me.setScrollValue(scrollBar, t)
    End Sub

    Private Function contentRowSize() As Integer
        Dim t As Integer = 0
        If Me.HScrollBar.Visible Then
            t = Me.HScrollBar.Height
        End If
        Return Me.Height - (Me.HeaderContent.LayoutCache.RowsSize + Me.FooterContent.LayoutCache.RowsSize) - t
    End Function

    Private Function contentColSize() As Integer
        Dim t As Integer = 0
        If Me.VScrollBar.Visible Then
            t = Me.VScrollBar.Width
        End If
        Return Me.Width - t
    End Function

    Public Sub SetVScrollValue(ByVal scrollValue As Integer)
        Me.setScrollValue(Me.VScrollBar, scrollValue)
    End Sub

    Public Sub SetHScrollValue(ByVal scrollValue As Integer)
        Me.setScrollValue(Me.HScrollBar, scrollValue)
    End Sub

    Private Sub setScrollValue(ByVal scrollBar As ScrollBar, ByVal scrollValue As Integer)
        If scrollBar.Visible And scrollBar.Enabled Then
            If scrollValue < scrollBar.Minimum Then
                scrollBar.Value = scrollBar.Minimum
            ElseIf scrollValue > scrollBar.Maximum - scrollBar.LargeChange Then
                scrollBar.Value = scrollBar.Maximum - scrollBar.LargeChange
            Else
                scrollBar.Value = scrollValue
            End If
        End If
    End Sub

    Private Class CHScrollBar
        Inherits HScrollBar
        Public Sub New()
            Me.SetStyle(ControlStyles.Selectable, False)
        End Sub
    End Class

    Private Class CVScrollBar
        Inherits VScrollBar
        Public Sub New()
            Me.SetStyle(ControlStyles.Selectable, False)
        End Sub
    End Class

    Public Sub ScrollTo(ByVal field As CField)
        If field IsNot Nothing Then
            Dim rect As Rectangle = field.GetRectangle
            If Me.Setting.ScrollUnit = EScrollUnit.RECORD Then
                With field.Record.GetRectangle
                    rect.Y = .Y
                    rect.Height = .Height
                End With
            End If
            RaiseEvent DecideScrollRect(field, rect)
            If field.TopLevelContent IsNot Me.Content Then
                Me.HScrollTo(rect)
            Else
                Me.ScrollTo(rect)
            End If
        End If
    End Sub

    Public Sub HScrollTo(ByVal rect As Rectangle)
        If rect.Left >= Me.LayoutCache.FixedColsSize Then
            If (rect.Left - Me.LayoutCache.FixedColsSize) - Me.HScrollBar.Value < 0 Then
                Me.setScrollValue(Me.HScrollBar, (rect.Left - Me.LayoutCache.FixedColsSize))
            ElseIf rect.Right - Me.HScrollBar.Value > Me.contentColSize Then
                If Me.contentColSize >= rect.Width Then
                    Me.setScrollValue(Me.HScrollBar, rect.Right - Me.contentColSize + 1)
                Else
                    Me.setScrollValue(Me.HScrollBar, rect.Left)
                End If
            End If
        End If
    End Sub

    Public Sub ScrollTo(ByVal rect As Rectangle)
        If rect.Top < Me.VScrollBar.Value Then
            Me.setScrollValue(Me.VScrollBar, rect.Top)
        ElseIf rect.Bottom - Me.VScrollBar.Value > Me.contentRowSize Then
            If Me.contentRowSize >= rect.Height Then
                Me.setScrollValue(Me.VScrollBar, rect.Bottom - Me.contentRowSize + 1)
            Else
                Me.setScrollValue(Me.VScrollBar, rect.Top)
            End If
        End If
        Me.HScrollTo(rect)
    End Sub

End Class
