﻿Imports systembase.table

Public Class Sample6

    Private Sub Sample6_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Dim rp As New UTable.CRecordProvider
        With New CLayoutBuilder
            rp.AddField("check", New CCheckFieldProvider("check"), .Next)
            rp.AddField("name", New CTextFieldProvider("name"), .Next).Comparer = New CSampleComparer
        End With
        Me.Table.Content.SetRecordProvider(rp)
        Me.Table.CreateCaption()
        Me.Table.Setting.UserSortable = UTable.EAllow.ALLOW
        Using Me.Table.RenderBlock
            For i As Integer = 1 To 6
                Me.Table.Content.AddRecord()
            Next
        End Using
    End Sub

    Class CSampleComparer
        Inherits UTable.CComparer
        Public Overrides Function Compare(ByVal x As Integer, ByVal y As Integer) As Integer
            Dim checkX As Object = Me.records(x).Fields("check").Value
            Dim checkY As Object = Me.records(y).Fields("check").Value
            If checkX <> checkY Then
                Select Case Me.order
                    Case UTable.CSortState.EOrder.ASCEND
                        Return checkX < checkY
                    Case UTable.CSortState.EOrder.DESCEND
                        Return checkX > checkY
                End Select
            Else
                Return MyBase.Compare(x, y)
            End If
        End Function
    End Class

End Class