Imports systembase.table

Public Class Fieldprovider4

    Private Sub Fieldprovider4_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Dim rp As New UTable.CRecordProvider
        With New CFieldBuilder
            rp.AddField(0, New CComboFieldProvider(New String() {"AAA", "BBB", "CCC"}), .Next)
        End With
        Me.Table.Content.SetRecordProvider(rp)
        Me.Table.CreateCaption()

        Using Me.Table.UpdateBufferBlock
            For i As Integer = 0 To 10
                Me.Table.Content.AddRecord()
            Next
        End Using

    End Sub

    Class CComboFieldProvider
        Inherits CFieldProvider

        Public DataSource As Object

        Public Sub New(ByVal dataSource As Object)
            MyBase.New()
            Me.DataSource = dataSource
        End Sub

        Public Overrides Function Editor() As systembase.table.IEditor
            Return New CComboEditor
        End Function

        Public Overrides Sub EditorInitialize(ByVal field As systembase.table.UTable.CField, ByVal editor As systembase.table.IEditor)
            With CType(editor, ComboBox)
                .DataSource = Me.DataSource
            End With
        End Sub

    End Class

    Class CComboEditor
        Inherits ComboBox
        Implements IEditor

        Public Event _Leave(ByVal sender As Object, ByVal direction As String) Implements IEditor.Leave
        Public Event _Changed(ByVal sender As Object) Implements IEditor.ValueChanged
        Public Event _ProcessDialogKey(ByVal sender As Object, ByVal keyData As System.Windows.Forms.Keys, ByRef handled As Boolean) Implements IEditor.ProcessDialogKey

        Public Sub Initialize(ByVal field As UTable.CField) Implements IEditor.Initialize
            With field.DynamicSetting
                Me.Font = .Font
            End With
        End Sub

        Public Sub _Enter(ByVal key As Char, ByVal hIMC As Integer, ByVal clear As Boolean) Implements IEditor.Enter
            If clear Then
                Me.Text = Nothing
            End If
            Me.Focus()
            If key <> Nothing Then
                Me.Text = key
                Me.SelectionStart = 1
            End If
        End Sub

        Public Property _Value() As Object Implements IEditor.Value
            Get
                Return Me.Text
            End Get
            Set(ByVal value As Object)
                Me.Text = value
            End Set
        End Property

        Protected Overrides Function IsInputKey(ByVal keyData As System.Windows.Forms.Keys) As Boolean
            Select Case keyData
                Case Keys.Left
                    If Me.SelectionLength = 0 And Me.SelectionStart = 0 Then
                        RaiseEvent _Leave(Me, "LEFT")
                        Return True
                    End If
                Case Keys.Right
                    If Me.SelectionLength = 0 And Me.SelectionStart = Me.Text.Length Then
                        RaiseEvent _Leave(Me, "RIGHT")
                        Return True
                    End If
            End Select
            Return MyBase.IsInputKey(keyData)
        End Function

        Protected Overrides Function ProcessDialogKey(ByVal keyData As System.Windows.Forms.Keys) As Boolean
            Dim handled As Boolean = False
            RaiseEvent _ProcessDialogKey(Me, keyData, handled)
            If handled Then
                Return True
            Else
                Return MyBase.ProcessDialogKey(keyData)
            End If
        End Function

        Public Function RaiseValidate() As Boolean Implements IEditor.RaiseValidate
            Dim e As New System.ComponentModel.CancelEventArgs
            Me.OnValidating(e)
            If Not e.Cancel Then
                Me.OnValidated(System.EventArgs.Empty)
                Return True
            End If
            Return False
        End Function

        Private Sub CComboEditor_TextChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.TextChanged
            RaiseEvent _Changed(Me)
        End Sub

        Public Function Control() As System.Windows.Forms.Control Implements systembase.table.IEditor.Control
            Return Me
        End Function

    End Class
End Class