Imports System.Drawing

Public Class UTable
    Inherits ContainerControl

    Public Class CSortState
        Public Enum EOrder
            ASCEND
            DESCEND
        End Enum
        Public Field As CField = Nothing
        Public Order As EOrder = EOrder.ASCEND
    End Class

    Public Class CLayoutCache
        Public ColsSize As Integer
        Public FixedColsSize As Integer
    End Class

    Public Class CAutoAdjust
        Public Row As Boolean
        Public Col As Boolean
    End Class

    Public Event RecordAdded(ByVal record As CRecord)
    Public Event RecordMoved(ByVal record As CRecord)
    Public Event RecordRemoved(ByVal record As CRecord)
    Public Event FieldValidating(ByVal field As CField, ByVal e As System.ComponentModel.CancelEventArgs)
    Public Event EditorValueChanged(ByVal field As CField)
    Public Event RecordEnter(ByVal record As CRecord)
    Public Event FieldEntering(ByVal field As CField, ByRef cancel As Boolean)
    Public Event FieldEnter(ByVal field As CField)
    Public Event EditStarting(ByVal field As CField, ByRef editable As CSetting.EEditable)
    Public Event EditFinished(ByVal field As CField)
    Public Event FieldMouseDown(ByVal field As CField, ByVal location As Point, ByVal e As System.Windows.Forms.MouseEventArgs)
    Public Event FieldMouseUp(ByVal field As CField, ByVal location As Point, ByVal e As System.Windows.Forms.MouseEventArgs)
    Public Event FieldMouseMove(ByVal field As CField, ByVal location As Point, ByVal e As System.Windows.Forms.MouseEventArgs)
    Public Event FieldClick(ByVal field As CField, ByVal location As Point, ByVal e As System.Windows.Forms.MouseEventArgs)
    Public Event FieldDoubleClick(ByVal field As CField, ByVal location As Point, ByVal e As System.Windows.Forms.MouseEventArgs)
    Public Event FieldKeyDown(ByVal field As CField, ByVal e As System.Windows.Forms.KeyEventArgs)
    Public Event FieldKeyUp(ByVal field As CField, ByVal e As System.Windows.Forms.KeyEventArgs)
    Public Event FieldSelected(ByVal field As CField, ByRef handled As Boolean)
    Public Event FieldButtonClick(ByVal field As CField)
    Public Event Sorted(ByVal content As CContent, ByVal key As Object)
    Public Event InitializeEditor(ByVal field As CField, ByVal editor As IEditor)
    Public Event BufferUpdating(ByVal table As UTable)
    Public Cols As CGrids
    Public HeaderContent As CContent
    Public FooterContent As CContent
    Public Content As CContent
    Public Setting As New CGlobalSetting
    Public DefaultGridSize As New CGrid.CSize
    Public NeetUpdateCache As Boolean = False
    Public LayoutCache As CLayoutCache
    Public RenderCache As CRenderCache
    Public BackBuffer As BufferedGraphics = Nothing
    Public AutoAdjust As New CAutoAdjust
    Public KeyboardOperation As IKeyboardOperation
    Public WithEvents VScrollBar As ScrollBar = New CVScrollBar
    Public WithEvents HScrollBar As ScrollBar = New CHScrollBar
    Public SortState As New CSortState

    Private _FixedCols As Integer = 0
    Private scrollPlaceHolderPanel As New Panel

    Public Sub New()
        Me.New(New CDefaultKeyboardOperation)
    End Sub

    Public Sub New(ByVal keyboardOperation As IKeyboardOperation)
        Me.ResetAll()
        Me.DefaultGridSize.Row = 20
        Me.DefaultGridSize.Col = 100
        Me.Setting.HeaderContentBackColor = Color.DarkGray
        Me.Setting.FooterContentBackColor = Color.DarkGray
        Me.Setting.ContentBackColor = Color.DimGray
        Me.Setting.ResizingLineColor = Color.DarkGreen
        Me.Setting.Font = New Font("lr SVbN", 11, FontStyle.Regular)
        Me.Setting.CaptionFont = New Font("lr SVbN", 11, FontStyle.Regular)
        Me.Setting.ForeColor = Color.Black
        Me.Setting.BackColor = Color.White
        Me.Setting.AlterBackColor = Color.Beige
        Me.Setting.ButtonBackColor = Color.LightGray
        Me.Setting.BorderColor = Color.Gray
        Me.Setting.CaptionForeColor = Color.Black
        Me.Setting.CaptionBackColor = Color.Silver
        Me.Setting.DraggingBackColor = Color.CornflowerBlue
        Me.Setting.CaptionBorderColor = Color.Gray
        Me.Setting.FocusColor = Color.LightCyan
        Me.Setting.FocusRecordColor = Color.PeachPuff
        Me.Setting.HorizontalAlignment = CSetting.EHAlign.LEFT
        Me.Setting.VerticalAlignment = CSetting.EVAlign.MIDDLE
        Me.Setting.Editable = CSetting.EEditable.ALLOW
        Me.Setting.UserSortable = CGlobalSetting.ESortable.DISABLE
        Me.Setting.FocusColorEnable = CSetting.EEnable.ENABLE
        Me.Setting.FocusRecordColorEnable = CSetting.EEnable.ENABLE
        Me.AutoAdjust.Row = False
        Me.AutoAdjust.Col = False
        Me.BackColor = Color.Black
        Me.KeyboardOperation = keyboardOperation
        Me.VScrollBar.TabStop = False
        Me.HScrollBar.TabStop = False
        Me.scrollPlaceHolderPanel.Visible = False
        Me.Controls.Add(Me.VScrollBar)
        Me.Controls.Add(Me.HScrollBar)
        Me.Controls.Add(Me.scrollPlaceHolderPanel)
        Me.DoubleBuffered = True
    End Sub

    Private Sub UTable_Disposed(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Disposed
        Me.ime_ReleaseContext()
    End Sub

    Public Sub ResetAll()
        Using Me.UpdateBufferBlock
            Me.FixedCols = 0
            Me.HeaderContent = New CContent
            Me.HeaderContent.Table = Me
            Me.FooterContent = New CContent
            Me.FooterContent.Table = Me
            Me.Content = New CContent
            Me.Content.Table = Me
            Me.Cols = New CGrids
            Me.LayoutCache = New CLayoutCache
            Me.RenderCache = New CRenderCache
            Me.VScrollBar.Visible = False
            Me.HScrollBar.Visible = False
        End Using
    End Sub

    Public Sub UpdateCache()
        Me.LayoutCache.ColsSize = 0
        Me.LayoutCache.FixedColsSize = 0
        For i As Integer = 0 To Me.Cols.Count - 1
            If Me.Cols(i).Visible Then
                If i < Me.FixedCols Then
                    Me.LayoutCache.FixedColsSize += Me.Cols(i).Size
                End If
                Me.LayoutCache.ColsSize += Me.Cols(i).Size
            End If
        Next
    End Sub

    Public Sub CreateCaption(Optional ByVal halign As CSetting.EHAlign = CSetting.EHAlign.DEFAULT)
        Dim rpList As New List(Of CRecordProvider)
        Dim recordProvider As CRecordProvider = Me.Content.RecordProvider
        Do While recordProvider IsNot Nothing
            rpList.Add(recordProvider)
            recordProvider = recordProvider.ChildRecordProvider
        Loop
        Me.CreateCaption(halign, rpList.ToArray)
    End Sub

    Public Sub CreateCaption(ByVal halign As CSetting.EHAlign, ByVal ParamArray recordProviders() As CRecordProvider)
        Using Me.UpdateBufferBlock
            Dim c As CContent = Me.HeaderContent
            For i As Integer = 0 To recordProviders.Length - 1
                Me.createCaption_aux(c, recordProviders(i), halign)
                c = c.Records(0).CreateChild
            Next
            Me.HeaderContent.NeedUpdateCache = True
        End Using
    End Sub

    Private Sub createCaption_aux(ByVal caption_content As CContent, ByVal recordProvider As CRecordProvider, ByVal halign As CSetting.EHAlign)
        Dim record As CRecord = caption_content.AddRecord()
        For Each key As Object In recordProvider.FieldDescs.Keys
            If recordProvider.FieldDescs(key).CreateCaption Then
                Dim f As CRecordProvider.CFieldDesc
                If recordProvider.FieldDescs(key).MergeCaption Is Nothing Then
                    f = New CRecordProvider.CFieldDesc(New CCaptionFieldProvider(recordProvider.FieldDescs(key)), recordProvider.Layout(key))
                Else
                    f = New CRecordProvider.CFieldDesc(New CCaptionFieldProvider(recordProvider.FieldDescs(key)), recordProvider.Layout(key, recordProvider.FieldDescs(key).MergeCaption))
                End If
                If Not halign = CSetting.EHAlign.DEFAULT Then
                    f.Setting.HorizontalAlignment = halign
                End If
                record.AddField(key, f)
            End If
        Next
    End Sub

    Public Function CaptionRecord() As CRecord
        If Me.HeaderContent.Records.Count = 0 Then
            Me.HeaderContent.AddRecord()
        End If
        Return Me.HeaderContent.Records(0)
    End Function

    Public Sub RaiseFieldValidating(ByVal field As CField, ByVal e As System.ComponentModel.CancelEventArgs)
        field.RaiseValidating(e)
        RaiseEvent FieldValidating(field, e)
    End Sub

    Public Sub RaiseEditorValueChanged(ByVal field As CField)
        field.RaiseEditorValueChanged()
        RaiseEvent EditorValueChanged(field)
    End Sub

    Public Sub RaiseFieldSelected(ByVal field As CField, ByRef handled As Boolean)
        RaiseEvent FieldSelected(field, handled)
    End Sub

    Public Sub RaiseFieldButtonClick(ByVal field As CField)
        RaiseEvent FieldButtonClick(field)
    End Sub

    Public Sub RaiseSorted(ByVal content As CContent, ByVal key As Object)
        RaiseEvent Sorted(content, key)
    End Sub

    Public Sub RaiseRecordAdded(ByVal record As CRecord)
        RaiseEvent RecordAdded(record)
    End Sub

    Public Sub RaiseRecordMoved(ByVal record As CRecord)
        RaiseEvent RecordMoved(record)
    End Sub

    Public Sub RaiseRecordRemoved(ByVal record As CRecord)
        RaiseEvent RecordRemoved(record)
    End Sub

End Class