Imports System.Drawing

Partial Class UTable

    Public Class CSetting
        Implements ICloneable

        Public Enum EVAlign
            [DEFAULT]
            TOP
            MIDDLE
            BOTTOM
        End Enum

        Public Enum EHAlign
            [DEFAULT]
            LEFT
            MIDDLE
            RIGHT
        End Enum

        Public Enum EEditable
            [DEFAULT]
            ALLOW
            DISABLE
        End Enum

        Public Enum EFocusStop
            [DEFAULT]
            [STOP]
            NOTSTOP
        End Enum

        Public Enum ETextWrap
            [DEFAULT]
            WRAP
            NOWRAP
        End Enum

        Public Enum EEnable
            [DEFAULT]
            ENABLE
            DISABLE
        End Enum

        Public Font As Font = Nothing
        Public CaptionFont As Font = Nothing
        Public ForeColor As Color = Color.Empty
        Public CaptionForeColor As Color = Color.Empty
        Public BackColor As Color = Color.Empty
        Public AlterBackColor As Color = Color.Empty
        Public ButtonBackColor As Color = Color.Empty
        Public CaptionBackColor As Color = Color.Empty
        Public DraggingColor As Color = Color.Empty
        Public BorderColor As Color = Color.Empty
        Public CaptionBorderColor As Color = Color.Empty
        Public FocusColor As Color = Color.Empty
        Public FocusRecordColor As Color = Color.Empty
        Public HorizontalAlignment As EHAlign = EHAlign.DEFAULT
        Public VerticalAlignment As EVAlign = EVAlign.DEFAULT
        Public Editable As EEditable = EEditable.DEFAULT
        Public FocusStop As EFocusStop = EFocusStop.DEFAULT
        Public TextWrap As ETextWrap = ETextWrap.DEFAULT
        Public FocusColorEnable As CSetting.EEnable = CSetting.EEnable.DEFAULT
        Public FocusRecordColorEnable As CSetting.EEnable = CSetting.EEnable.DEFAULT

        Public Function Clone() As Object Implements System.ICloneable.Clone
            Dim s As New CSetting
            s.Font = Me.Font
            s.CaptionFont = Me.CaptionFont
            s.ForeColor = Me.ForeColor
            s.CaptionForeColor = Me.CaptionForeColor
            s.BackColor = Me.BackColor
            s.AlterBackColor = Me.AlterBackColor
            s.CaptionBackColor = Me.CaptionBackColor
            s.BorderColor = Me.BorderColor
            s.CaptionBorderColor = Me.CaptionBorderColor
            s.FocusColor = Me.FocusColor
            s.FocusRecordColor = Me.FocusRecordColor
            s.HorizontalAlignment = Me.HorizontalAlignment
            s.VerticalAlignment = Me.VerticalAlignment
            s.Editable = Me.Editable
            s.FocusStop = Me.FocusStop
            Return s
        End Function

        Public WriteOnly Property BackColorBoth() As Color
            Set(ByVal value As Color)
                Me.BackColor = value
                Me.AlterBackColor = value
            End Set
        End Property

    End Class

    Public Class CGlobalSetting

        Public Enum ESortable
            [DEFAULT]
            ALLOW
            DISABLE
        End Enum

        Public HeaderContentBackColor As Color = Color.Empty
        Public FooterContentBackColor As Color = Color.Empty
        Public ContentBackColor As Color = Color.Empty
        Public ResizingLineColor As Color = Color.Empty
        Public UserColAdjustable As Boolean = True
        Public UserColResizable As Boolean = True
        Public UserSortable As ESortable = ESortable.DEFAULT
        Public Font As Font = Nothing
        Public CaptionFont As Font = Nothing
        Public ForeColor As Color = Color.Empty
        Public BackColor As Color = Color.Empty
        Public AlterBackColor As Color = Color.Empty
        Public ButtonBackColor As Color = Color.Empty
        Public BorderColor As Color = Color.Empty
        Public CaptionForeColor As Color = Color.Empty
        Public CaptionBackColor As Color = Color.Empty
        Public DraggingBackColor As Color = Color.Empty
        Public CaptionBorderColor As Color = Color.Empty
        Public FocusColor As Color = Color.Empty
        Public FocusRecordColor As Color = Color.Empty
        Public HorizontalAlignment As CSetting.EHAlign = CSetting.EHAlign.DEFAULT
        Public VerticalAlignment As CSetting.EVAlign = CSetting.EVAlign.DEFAULT
        Public Editable As CSetting.EEditable = CSetting.EEditable.DEFAULT
        Public TextWrap As CSetting.ETextWrap = CSetting.ETextWrap.NOWRAP
        Public AutoEntryFocus As Boolean = True
        Public EntryFocusKey As Object = Nothing
        Public VBorderLineDot As Boolean = True
        Public FocusColorEnable As CSetting.EEnable = CSetting.EEnable.DEFAULT
        Public FocusRecordColorEnable As CSetting.EEnable = CSetting.EEnable.DEFAULT

        Public WriteOnly Property BackColorBoth() As Color
            Set(ByVal value As Color)
                Me.BackColor = value
                Me.AlterBackColor = value
            End Set
        End Property

    End Class

    Public Class CDynamicSetting
        Public GlobalSetting As CGlobalSetting
        Public Settings As New List(Of UTable.CSetting)

        Public Sub New(ByVal field As CField)
            If field.HasSetting Then
                Settings.Add(field.Setting)
            End If
            If field.Record.HasSetting Then
                Settings.Add(field.Record.Setting)
            End If
            If field.Desc.HasSetting Then
                Settings.Add(field.Desc.Setting)
            End If
            If field.Content.HasSetting Then
                Settings.Add(field.Content.Setting)
            End If
            If field.Content.RecordProvider IsNot Nothing AndAlso _
               field.Content.RecordProvider.HasSetting Then
                Settings.Add(field.Content.RecordProvider.Setting)
            End If
            Me.GlobalSetting = field.Table.Setting
        End Sub

        Public Function Font() As Font
            For Each s As CSetting In Me.Settings
                If s.Font IsNot Nothing Then
                    Return s.Font
                End If
            Next
            Return Me.GlobalSetting.Font
        End Function

        Public Function CaptionFont() As Font
            For Each s As CSetting In Me.Settings
                If s.CaptionFont IsNot Nothing Then
                    Return s.CaptionFont
                End If
            Next
            Return Me.GlobalSetting.CaptionFont
        End Function

        Public Function ForeColor() As Color
            For Each s As CSetting In Me.Settings
                If s.ForeColor <> Color.Empty Then
                    Return s.ForeColor
                End If
            Next
            Return Me.GlobalSetting.ForeColor
        End Function

        Public Function CaptionForeColor() As Color
            For Each s As CSetting In Me.Settings
                If s.CaptionForeColor <> Color.Empty Then
                    Return s.CaptionForeColor
                End If
            Next
            Return Me.GlobalSetting.CaptionForeColor
        End Function

        Public Function BackColor() As Color
            For Each s As CSetting In Me.Settings
                If s.BackColor <> Color.Empty Then
                    Return s.BackColor
                End If
            Next
            Return Me.GlobalSetting.BackColor
        End Function

        Public Function AlterBackColor() As Color
            For Each s As CSetting In Me.Settings
                If s.AlterBackColor <> Color.Empty Then
                    Return s.AlterBackColor
                End If
            Next
            Return Me.GlobalSetting.AlterBackColor
        End Function

        Public Function ButtonBackColor() As Color
            For Each s As CSetting In Me.Settings
                If s.ButtonBackColor <> Color.Empty Then
                    Return s.ButtonBackColor
                End If
            Next
            Return Me.GlobalSetting.ButtonBackColor
        End Function

        Public Function CaptionBackColor() As Color
            For Each s As CSetting In Me.Settings
                If s.CaptionBackColor <> Color.Empty Then
                    Return s.CaptionBackColor
                End If
            Next
            Return Me.GlobalSetting.CaptionBackColor
        End Function

        Public Function DraggingColor() As Color
            For Each s As CSetting In Me.Settings
                If s.DraggingColor <> Color.Empty Then
                    Return s.DraggingColor
                End If
            Next
            Return Me.GlobalSetting.DraggingBackColor
        End Function

        Public Function BorderColor() As Color
            For Each s As CSetting In Me.Settings
                If s.BorderColor <> Color.Empty Then
                    Return s.BorderColor
                End If
            Next
            Return Me.GlobalSetting.BorderColor
        End Function

        Public Function CaptionBorderColor() As Color
            For Each s As CSetting In Me.Settings
                If s.CaptionBorderColor <> Color.Empty Then
                    Return s.CaptionBorderColor
                End If
            Next
            Return Me.GlobalSetting.CaptionBorderColor
        End Function

        Public Function FocusColor() As Color
            For Each s As CSetting In Me.Settings
                If s.FocusColor <> Color.Empty Then
                    Return s.FocusColor
                End If
            Next
            Return Me.GlobalSetting.FocusColor
        End Function

        Public Function FocusRecordColor() As Color
            For Each s As CSetting In Me.Settings
                If s.FocusRecordColor <> Color.Empty Then
                    Return s.FocusRecordColor
                End If
            Next
            Return Me.GlobalSetting.FocusRecordColor
        End Function

        Public Function HorizontalAlignment() As CSetting.EHAlign
            For Each s As CSetting In Me.Settings
                If s.HorizontalAlignment <> CSetting.EHAlign.DEFAULT Then
                    Return s.HorizontalAlignment
                End If
            Next
            Return Me.GlobalSetting.HorizontalAlignment
        End Function

        Public Function VerticalAlignment() As CSetting.EVAlign
            For Each s As CSetting In Me.Settings
                If s.VerticalAlignment <> CSetting.EVAlign.DEFAULT Then
                    Return s.VerticalAlignment
                End If
            Next
            Return Me.GlobalSetting.VerticalAlignment
        End Function

        Public Function Editable() As CSetting.EEditable
            For Each s As CSetting In Me.Settings
                If s.Editable <> CSetting.EEditable.DEFAULT Then
                    Return s.Editable
                End If
            Next
            Return Me.GlobalSetting.Editable
        End Function

        Public Function FocusStop() As CSetting.EFocusStop
            For Each s As CSetting In Me.Settings
                If s.FocusStop <> CSetting.EFocusStop.DEFAULT Then
                    Return s.FocusStop
                End If
            Next
            Return CSetting.EFocusStop.STOP
        End Function

        Public Function TextWrap() As CSetting.ETextWrap
            For Each s As CSetting In Me.Settings
                If s.TextWrap <> CSetting.ETextWrap.DEFAULT Then
                    Return s.TextWrap
                End If
            Next
            Return Me.GlobalSetting.TextWrap
        End Function

        Public Function FocusColorEnable() As CSetting.EEnable
            For Each s As CSetting In Me.Settings
                If s.FocusColorEnable <> CSetting.EEnable.DEFAULT Then
                    Return s.FocusColorEnable
                End If
            Next
            Return Me.GlobalSetting.FocusColorEnable
        End Function

        Public Function FocusRecordColorEnable() As CSetting.EEnable
            For Each s As CSetting In Me.Settings
                If s.FocusRecordColorEnable <> CSetting.EEnable.DEFAULT Then
                    Return s.FocusRecordColorEnable
                End If
            Next
            Return Me.GlobalSetting.FocusRecordColorEnable
        End Function

        Public Function GetStringFormat() As StringFormat
            Dim format As New StringFormat
            If Me.TextWrap = CSetting.ETextWrap.NOWRAP Then
                format.FormatFlags = StringFormatFlags.NoWrap
            End If
            Select Case Me.HorizontalAlignment
                Case UTable.CSetting.EHAlign.LEFT
                    format.Alignment = StringAlignment.Near
                Case UTable.CSetting.EHAlign.MIDDLE
                    format.Alignment = StringAlignment.Center
                Case UTable.CSetting.EHAlign.RIGHT
                    format.Alignment = StringAlignment.Far
            End Select
            Select Case Me.VerticalAlignment
                Case UTable.CSetting.EVAlign.TOP
                    format.LineAlignment = StringAlignment.Near
                Case UTable.CSetting.EVAlign.MIDDLE
                    format.LineAlignment = StringAlignment.Center
                Case UTable.CSetting.EVAlign.BOTTOM
                    format.LineAlignment = StringAlignment.Far
            End Select
            Return format
        End Function

    End Class

End Class