Imports System.Drawing

Partial Class UTable

    Public Class CRecord

        Public Class CLayoutCache
            Public Visible As Boolean
            Public Top As Integer
            Public RowsSize As Integer
            Public EntireRowsSize As Integer
            Public PrevRecord As CRecord
            Public NextRecord As CRecord
        End Class

        Public Rows As New CGrids
        Public Fields As New Dictionary(Of Object, CField)
        Public Content As CContent
        Public Child As CContent
        Public LayoutCache As New CLayoutCache

        Private _Setting As UTable.CSetting = Nothing

        Public Sub Initialize(ByVal content As CContent)
            Using content.Table.UpdateBufferBlock
                Me.Content = content
                If Me.Content.RecordProvider IsNot Nothing Then
                    With Me.Content.RecordProvider
                        Me.Rows.AddRange(New CGrids(.Rows, Me.Content.TopLevelContent))
                        For Each key As Object In .FieldDescs.Keys
                            Me._addField(key, .FieldDescs(key))
                        Next
                        For Each key As Object In .FieldDescs.Keys
                            Me.Fields(key).Desc.Provider.FieldInitialize(Me.Fields(key))
                        Next
                        If .ChildRecordProvider IsNot Nothing Then
                            Me.CreateChild(.ChildRecordProvider)
                        End If
                    End With
                End If
            End Using
        End Sub

        Public Function HasSetting() As Boolean
            Return Me._Setting IsNot Nothing
        End Function

        Public Sub ClearSetting()
            Me.Setting = Nothing
        End Sub

        Public Property Setting() As UTable.CSetting
            Get
                If Me._Setting Is Nothing Then
                    Me._Setting = New UTable.CSetting
                End If
                Return Me._Setting
            End Get
            Set(ByVal value As UTable.CSetting)
                Me._Setting = value
            End Set
        End Property

        Public Sub Render(ByVal g As Graphics, _
                          ByVal top_row As Integer, _
                          ByVal top_col As Integer, _
                          ByVal max_row As Integer, _
                          ByVal alter As Boolean, _
                          ByVal fixed As Boolean)
            For Each field As CField In Me.Fields.Values
                If field.Desc.Layout IsNot Nothing AndAlso _
                   ((fixed And field.Desc.Layout.Col < Me.Table.FixedCols) Or _
                    (Not fixed And field.Desc.Layout.Col + field.Desc.Layout.Cols > Me.Table.FixedCols)) Then
                    Dim rect As Rectangle = CGrid.GetRectangle(Me.Table.Cols, _
                                                               Me.Rows, _
                                                               field.Desc.Layout, _
                                                               top_row, _
                                                               top_col)
                    If rect.Height > 0 And _
                       rect.Width > 0 And _
                       rect.Left < Me.Table.Width And _
                       rect.Top < Me.Table.Height And _
                       rect.Right >= 0 And _
                       rect.Bottom >= 0 Then
                        field.Desc.Provider.Render(g, field, rect, alter)
                        Dim fieldCache As New CRenderCache.CField
                        fieldCache.Rect = rect
                        fieldCache.Field = field
                        Me.Table.RenderCache.Fields.Add(fieldCache)
                        If field Is Me.Table.FocusField Then
                            Me.Table.RenderCache.FocusField = fieldCache
                        End If
                    End If
                End If
            Next
            top_row += Me.LayoutCache.RowsSize
            If Child IsNot Nothing Then
                Child.Render(g, top_row, top_col, max_row, fixed)
            End If
        End Sub

        Public Function CreateChild(Optional ByVal recordProvider As CRecordProvider = Nothing) As CContent
            Me.Child = New CContent
            Me.Child.ParentRecord = Me
            Me.Child.Table = Me.Child.ParentRecord.Content.Table
            If recordProvider IsNot Nothing Then
                Me.Child.SetRecordProvider(recordProvider)
            End If
            Return Me.Child
        End Function

        Public Sub PrepareRows(ByVal rows_count As Integer)
            Do While Me.Rows.Count < rows_count
                Using Me.Table.UpdateBufferBlock
                    Me.Rows.Add(New CGrid(Me.Content))
                    Me.Content.TopLevelContent.NeedUpdateCache = True
                End Using
            Loop
        End Sub

        Public Function AddField(ByVal key As Object, ByVal fieldProvider As IFieldProvider, Optional ByVal layout As CGrid.CRegion = Nothing) As CField
            Return AddField(key, New CRecordProvider.CFieldDesc(fieldProvider, layout))
        End Function

        Public Function AddField(ByVal key As Object, ByVal fieldDesc As CRecordProvider.CFieldDesc) As CField
            Using Me.Table.UpdateBufferBlock
                fieldDesc.Provider.ApplyTable(Me.Table)
                Dim f As CField = Me._addField(key, fieldDesc)
                If f IsNot Nothing Then
                    f.Desc.Provider.FieldInitialize(f)
                End If
                Return f
            End Using
        End Function

        Private Function _addField(ByVal key As Object, ByVal fieldDesc As CRecordProvider.CFieldDesc) As CField
            If fieldDesc.Layout IsNot Nothing Then
                Me.Table.PrepareCols(fieldDesc.Layout.Col + fieldDesc.Layout.Cols)
                Me.PrepareRows(fieldDesc.Layout.Row + fieldDesc.Layout.Rows)
            End If
            Dim field As CField = fieldDesc.Provider.CreateField(key, Me, fieldDesc)
            If field IsNot Nothing Then
                Me.Fields.Add(key, field)
            End If
            Return field
        End Function

        Public Function UpdateCache(ByRef top As Integer, ByVal prevRecord As CRecord, ByVal visible As Boolean) As CRecord
            Me.LayoutCache.Visible = visible
            Me.LayoutCache.Top = top
            Me.LayoutCache.RowsSize = 0
            Me.LayoutCache.EntireRowsSize = 0
            Me.LayoutCache.PrevRecord = Nothing
            Me.LayoutCache.NextRecord = Nothing
            If prevRecord IsNot Nothing Then
                Me.LayoutCache.PrevRecord = prevRecord
                prevRecord.LayoutCache.NextRecord = Me
            End If
            If visible Then
                Dim t As Integer = Me.Rows.GetSize(0, Me.Rows.Count)
                top += t
                Me.LayoutCache.RowsSize = t
                Me.LayoutCache.EntireRowsSize = Me.LayoutCache.RowsSize
            End If
            Dim ret As CRecord
            If Me.Child IsNot Nothing Then
                ret = Me.Child.UpdateCache(top, Me, visible)
                Me.LayoutCache.EntireRowsSize += Me.Child.LayoutCache.RowsSize
            Else
                ret = Me
            End If
            Return ret
        End Function

        Public Function IsChild(ByVal field As CField) As Boolean
            Return Me.IsChild(field.Record)
        End Function

        Public Function IsChild(ByVal content As CContent) As Boolean
            If content.ParentRecord Is Me Then
                Return True
            Else
                Return Me.IsChild(content.ParentRecord)
            End If
        End Function

        Public Function IsChild(ByVal record As CRecord) As Boolean
            Dim parent As CRecord = record.Content.ParentRecord
            Do While parent IsNot Nothing
                If parent Is Me Then
                    Return True
                End If
                parent = parent.Content.ParentRecord
            Loop
            Return False
        End Function

        Public Function Row(ByVal key As Object) As CGrid
            Return Me.Rows(Me.Fields(key).Desc.Layout.EndRow)
        End Function

        Public Function Col(ByVal key As Object) As CGrid
            Return Me.Table.Cols(Me.Fields(key).Desc.Layout.EndCol)
        End Function

        Public Function FindField(ByVal point As CGrid.CPoint) As CField
            For Each field As UTable.CField In Me.Fields.Values
                If field.Desc.Layout IsNot Nothing Then
                    If field.Desc.Layout.Contains(point) Then
                        Return field
                    End If
                End If
            Next
            Return Nothing
        End Function

        Public Function Table() As UTable
            Return Me.Content.Table
        End Function

        Public Function TopLevelContent() As CContent
            Return Me.Content.TopLevelContent
        End Function

        Public Function TopLevelRecord() As CRecord
            Return Me.Content.TopLevelRecord
        End Function

        Public Sub FlatBorder(ByVal key1 As Object, ByVal key2 As Object)
            Dim l As New Dictionary(Of Object, UTable.CRecordProvider.CFieldDesc)
            For Each k As Object In Me.Fields.Keys
                l.Add(k, Me.Fields(k).Desc)
            Next
            CFieldProvider.FlatBorder(l, key1, key2)
        End Sub

    End Class

End Class
